// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.eks.inputs;

import com.pulumi.aws.eks.inputs.ClusterOutpostConfigControlPlanePlacementArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterOutpostConfigArgs extends com.pulumi.resources.ResourceArgs {

    public static final ClusterOutpostConfigArgs Empty = new ClusterOutpostConfigArgs();

    /**
     * The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can&#39;t be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
     * 
     * * 1–20 nodes, then we recommend specifying a large instance type.
     * 
     * * 21–100 nodes, then we recommend specifying an xlarge instance type.
     * 
     * * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
     * 
     * For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
     * 
     */
    @Import(name="controlPlaneInstanceType", required=true)
    private Output<String> controlPlaneInstanceType;

    /**
     * @return The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can&#39;t be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
     * 
     * * 1–20 nodes, then we recommend specifying a large instance type.
     * 
     * * 21–100 nodes, then we recommend specifying an xlarge instance type.
     * 
     * * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
     * 
     * For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
     * 
     */
    public Output<String> controlPlaneInstanceType() {
        return this.controlPlaneInstanceType;
    }

    /**
     * An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
     * The `control_plane_placement` configuration block supports the following arguments:
     * 
     */
    @Import(name="controlPlanePlacement")
    private @Nullable Output<ClusterOutpostConfigControlPlanePlacementArgs> controlPlanePlacement;

    /**
     * @return An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
     * The `control_plane_placement` configuration block supports the following arguments:
     * 
     */
    public Optional<Output<ClusterOutpostConfigControlPlanePlacementArgs>> controlPlanePlacement() {
        return Optional.ofNullable(this.controlPlanePlacement);
    }

    /**
     * The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
     * 
     */
    @Import(name="outpostArns", required=true)
    private Output<List<String>> outpostArns;

    /**
     * @return The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
     * 
     */
    public Output<List<String>> outpostArns() {
        return this.outpostArns;
    }

    private ClusterOutpostConfigArgs() {}

    private ClusterOutpostConfigArgs(ClusterOutpostConfigArgs $) {
        this.controlPlaneInstanceType = $.controlPlaneInstanceType;
        this.controlPlanePlacement = $.controlPlanePlacement;
        this.outpostArns = $.outpostArns;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterOutpostConfigArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterOutpostConfigArgs $;

        public Builder() {
            $ = new ClusterOutpostConfigArgs();
        }

        public Builder(ClusterOutpostConfigArgs defaults) {
            $ = new ClusterOutpostConfigArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param controlPlaneInstanceType The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can&#39;t be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
         * 
         * * 1–20 nodes, then we recommend specifying a large instance type.
         * 
         * * 21–100 nodes, then we recommend specifying an xlarge instance type.
         * 
         * * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
         * 
         * For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
         * 
         * @return builder
         * 
         */
        public Builder controlPlaneInstanceType(Output<String> controlPlaneInstanceType) {
            $.controlPlaneInstanceType = controlPlaneInstanceType;
            return this;
        }

        /**
         * @param controlPlaneInstanceType The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can&#39;t be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
         * 
         * * 1–20 nodes, then we recommend specifying a large instance type.
         * 
         * * 21–100 nodes, then we recommend specifying an xlarge instance type.
         * 
         * * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
         * 
         * For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
         * 
         * @return builder
         * 
         */
        public Builder controlPlaneInstanceType(String controlPlaneInstanceType) {
            return controlPlaneInstanceType(Output.of(controlPlaneInstanceType));
        }

        /**
         * @param controlPlanePlacement An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
         * The `control_plane_placement` configuration block supports the following arguments:
         * 
         * @return builder
         * 
         */
        public Builder controlPlanePlacement(@Nullable Output<ClusterOutpostConfigControlPlanePlacementArgs> controlPlanePlacement) {
            $.controlPlanePlacement = controlPlanePlacement;
            return this;
        }

        /**
         * @param controlPlanePlacement An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
         * The `control_plane_placement` configuration block supports the following arguments:
         * 
         * @return builder
         * 
         */
        public Builder controlPlanePlacement(ClusterOutpostConfigControlPlanePlacementArgs controlPlanePlacement) {
            return controlPlanePlacement(Output.of(controlPlanePlacement));
        }

        /**
         * @param outpostArns The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
         * 
         * @return builder
         * 
         */
        public Builder outpostArns(Output<List<String>> outpostArns) {
            $.outpostArns = outpostArns;
            return this;
        }

        /**
         * @param outpostArns The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
         * 
         * @return builder
         * 
         */
        public Builder outpostArns(List<String> outpostArns) {
            return outpostArns(Output.of(outpostArns));
        }

        /**
         * @param outpostArns The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
         * 
         * @return builder
         * 
         */
        public Builder outpostArns(String... outpostArns) {
            return outpostArns(List.of(outpostArns));
        }

        public ClusterOutpostConfigArgs build() {
            $.controlPlaneInstanceType = Objects.requireNonNull($.controlPlaneInstanceType, "expected parameter 'controlPlaneInstanceType' to be non-null");
            $.outpostArns = Objects.requireNonNull($.outpostArns, "expected parameter 'outpostArns' to be non-null");
            return $;
        }
    }

}
