// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.eks;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.eks.IdentityProviderConfigArgs;
import com.pulumi.aws.eks.inputs.IdentityProviderConfigState;
import com.pulumi.aws.eks.outputs.IdentityProviderConfigOidc;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an EKS Identity Provider Configuration.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.IdentityProviderConfig;
 * import com.pulumi.aws.eks.IdentityProviderConfigArgs;
 * import com.pulumi.aws.eks.inputs.IdentityProviderConfigOidcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new IdentityProviderConfig(&#34;example&#34;, IdentityProviderConfigArgs.builder()        
 *             .clusterName(aws_eks_cluster.example().name())
 *             .oidc(IdentityProviderConfigOidcArgs.builder()
 *                 .clientId(&#34;your client_id&#34;)
 *                 .identityProviderConfigName(&#34;example&#34;)
 *                 .issuerUrl(&#34;your issuer_url&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import EKS Identity Provider Configurations using the `cluster_name` and `identity_provider_config_name` separated by a colon (`:`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:eks/identityProviderConfig:IdentityProviderConfig my_identity_provider_config my_cluster:my_identity_provider_config
 * ```
 * 
 */
@ResourceType(type="aws:eks/identityProviderConfig:IdentityProviderConfig")
public class IdentityProviderConfig extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of the EKS Identity Provider Configuration.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the EKS Identity Provider Configuration.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Name of the EKS Cluster.
     * 
     */
    @Export(name="clusterName", refs={String.class}, tree="[0]")
    private Output<String> clusterName;

    /**
     * @return Name of the EKS Cluster.
     * 
     */
    public Output<String> clusterName() {
        return this.clusterName;
    }
    /**
     * Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
     * 
     */
    @Export(name="oidc", refs={IdentityProviderConfigOidc.class}, tree="[0]")
    private Output<IdentityProviderConfigOidc> oidc;

    /**
     * @return Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
     * 
     */
    public Output<IdentityProviderConfigOidc> oidc() {
        return this.oidc;
    }
    /**
     * Status of the EKS Identity Provider Configuration.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return Status of the EKS Identity Provider Configuration.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public IdentityProviderConfig(String name) {
        this(name, IdentityProviderConfigArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public IdentityProviderConfig(String name, IdentityProviderConfigArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public IdentityProviderConfig(String name, IdentityProviderConfigArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:eks/identityProviderConfig:IdentityProviderConfig", name, args == null ? IdentityProviderConfigArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private IdentityProviderConfig(String name, Output<String> id, @Nullable IdentityProviderConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:eks/identityProviderConfig:IdentityProviderConfig", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static IdentityProviderConfig get(String name, Output<String> id, @Nullable IdentityProviderConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new IdentityProviderConfig(name, id, state, options);
    }
}
