// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.eks;

import com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class FargateProfileArgs extends com.pulumi.resources.ResourceArgs {

    public static final FargateProfileArgs Empty = new FargateProfileArgs();

    /**
     * Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     * 
     */
    @Import(name="clusterName", required=true)
    private Output<String> clusterName;

    /**
     * @return Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     * 
     */
    public Output<String> clusterName() {
        return this.clusterName;
    }

    /**
     * Name of the EKS Fargate Profile.
     * 
     */
    @Import(name="fargateProfileName")
    private @Nullable Output<String> fargateProfileName;

    /**
     * @return Name of the EKS Fargate Profile.
     * 
     */
    public Optional<Output<String>> fargateProfileName() {
        return Optional.ofNullable(this.fargateProfileName);
    }

    /**
     * Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
     * 
     */
    @Import(name="podExecutionRoleArn", required=true)
    private Output<String> podExecutionRoleArn;

    /**
     * @return Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
     * 
     */
    public Output<String> podExecutionRoleArn() {
        return this.podExecutionRoleArn;
    }

    /**
     * Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     * 
     */
    @Import(name="selectors", required=true)
    private Output<List<FargateProfileSelectorArgs>> selectors;

    /**
     * @return Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     * 
     */
    public Output<List<FargateProfileSelectorArgs>> selectors() {
        return this.selectors;
    }

    /**
     * Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="subnetIds")
    private @Nullable Output<List<String>> subnetIds;

    /**
     * @return Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * 
     * The following arguments are optional:
     * 
     */
    public Optional<Output<List<String>>> subnetIds() {
        return Optional.ofNullable(this.subnetIds);
    }

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private FargateProfileArgs() {}

    private FargateProfileArgs(FargateProfileArgs $) {
        this.clusterName = $.clusterName;
        this.fargateProfileName = $.fargateProfileName;
        this.podExecutionRoleArn = $.podExecutionRoleArn;
        this.selectors = $.selectors;
        this.subnetIds = $.subnetIds;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(FargateProfileArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FargateProfileArgs $;

        public Builder() {
            $ = new FargateProfileArgs();
        }

        public Builder(FargateProfileArgs defaults) {
            $ = new FargateProfileArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param clusterName Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
         * 
         * @return builder
         * 
         */
        public Builder clusterName(Output<String> clusterName) {
            $.clusterName = clusterName;
            return this;
        }

        /**
         * @param clusterName Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
         * 
         * @return builder
         * 
         */
        public Builder clusterName(String clusterName) {
            return clusterName(Output.of(clusterName));
        }

        /**
         * @param fargateProfileName Name of the EKS Fargate Profile.
         * 
         * @return builder
         * 
         */
        public Builder fargateProfileName(@Nullable Output<String> fargateProfileName) {
            $.fargateProfileName = fargateProfileName;
            return this;
        }

        /**
         * @param fargateProfileName Name of the EKS Fargate Profile.
         * 
         * @return builder
         * 
         */
        public Builder fargateProfileName(String fargateProfileName) {
            return fargateProfileName(Output.of(fargateProfileName));
        }

        /**
         * @param podExecutionRoleArn Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
         * 
         * @return builder
         * 
         */
        public Builder podExecutionRoleArn(Output<String> podExecutionRoleArn) {
            $.podExecutionRoleArn = podExecutionRoleArn;
            return this;
        }

        /**
         * @param podExecutionRoleArn Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
         * 
         * @return builder
         * 
         */
        public Builder podExecutionRoleArn(String podExecutionRoleArn) {
            return podExecutionRoleArn(Output.of(podExecutionRoleArn));
        }

        /**
         * @param selectors Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder selectors(Output<List<FargateProfileSelectorArgs>> selectors) {
            $.selectors = selectors;
            return this;
        }

        /**
         * @param selectors Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder selectors(List<FargateProfileSelectorArgs> selectors) {
            return selectors(Output.of(selectors));
        }

        /**
         * @param selectors Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder selectors(FargateProfileSelectorArgs... selectors) {
            return selectors(List.of(selectors));
        }

        /**
         * @param subnetIds Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(@Nullable Output<List<String>> subnetIds) {
            $.subnetIds = subnetIds;
            return this;
        }

        /**
         * @param subnetIds Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(List<String> subnetIds) {
            return subnetIds(Output.of(subnetIds));
        }

        /**
         * @param subnetIds Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(String... subnetIds) {
            return subnetIds(List.of(subnetIds));
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public FargateProfileArgs build() {
            $.clusterName = Objects.requireNonNull($.clusterName, "expected parameter 'clusterName' to be non-null");
            $.podExecutionRoleArn = Objects.requireNonNull($.podExecutionRoleArn, "expected parameter 'podExecutionRoleArn' to be non-null");
            $.selectors = Objects.requireNonNull($.selectors, "expected parameter 'selectors' to be non-null");
            return $;
        }
    }

}
