// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.eks;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.eks.inputs.GetAddonArgs;
import com.pulumi.aws.eks.inputs.GetAddonPlainArgs;
import com.pulumi.aws.eks.inputs.GetAddonVersionArgs;
import com.pulumi.aws.eks.inputs.GetAddonVersionPlainArgs;
import com.pulumi.aws.eks.inputs.GetClusterArgs;
import com.pulumi.aws.eks.inputs.GetClusterAuthArgs;
import com.pulumi.aws.eks.inputs.GetClusterAuthPlainArgs;
import com.pulumi.aws.eks.inputs.GetClusterPlainArgs;
import com.pulumi.aws.eks.inputs.GetNodeGroupArgs;
import com.pulumi.aws.eks.inputs.GetNodeGroupPlainArgs;
import com.pulumi.aws.eks.inputs.GetNodeGroupsArgs;
import com.pulumi.aws.eks.inputs.GetNodeGroupsPlainArgs;
import com.pulumi.aws.eks.outputs.GetAddonResult;
import com.pulumi.aws.eks.outputs.GetAddonVersionResult;
import com.pulumi.aws.eks.outputs.GetClusterAuthResult;
import com.pulumi.aws.eks.outputs.GetClusterResult;
import com.pulumi.aws.eks.outputs.GetClustersResult;
import com.pulumi.aws.eks.outputs.GetNodeGroupResult;
import com.pulumi.aws.eks.outputs.GetNodeGroupsResult;
import com.pulumi.core.Output;
import com.pulumi.core.TypeShape;
import com.pulumi.deployment.Deployment;
import com.pulumi.deployment.InvokeOptions;
import com.pulumi.resources.InvokeArgs;
import java.util.concurrent.CompletableFuture;

public final class EksFunctions {
    /**
     * Retrieve information about an EKS add-on.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getAddon(GetAddonArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .clusterName(aws_eks_cluster.example().name())
     *             .build());
     * 
     *         ctx.export(&#34;eksAddonOutputs&#34;, aws_eks_addon.example());
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetAddonResult> getAddon(GetAddonArgs args) {
        return getAddon(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve information about an EKS add-on.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getAddon(GetAddonArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .clusterName(aws_eks_cluster.example().name())
     *             .build());
     * 
     *         ctx.export(&#34;eksAddonOutputs&#34;, aws_eks_addon.example());
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetAddonResult> getAddonPlain(GetAddonPlainArgs args) {
        return getAddonPlain(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve information about an EKS add-on.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getAddon(GetAddonArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .clusterName(aws_eks_cluster.example().name())
     *             .build());
     * 
     *         ctx.export(&#34;eksAddonOutputs&#34;, aws_eks_addon.example());
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetAddonResult> getAddon(GetAddonArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:eks/getAddon:getAddon", TypeShape.of(GetAddonResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve information about an EKS add-on.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getAddon(GetAddonArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .clusterName(aws_eks_cluster.example().name())
     *             .build());
     * 
     *         ctx.export(&#34;eksAddonOutputs&#34;, aws_eks_addon.example());
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetAddonResult> getAddonPlain(GetAddonPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:eks/getAddon:getAddon", TypeShape.of(GetAddonResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve information about a specific EKS add-on version compatible with an EKS cluster version.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonVersionArgs;
     * import com.pulumi.aws.eks.Addon;
     * import com.pulumi.aws.eks.AddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var defaultAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .build());
     * 
     *         final var latestAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .mostRecent(true)
     *             .build());
     * 
     *         var vpcCni = new Addon(&#34;vpcCni&#34;, AddonArgs.builder()        
     *             .clusterName(aws_eks_cluster.example().name())
     *             .addonName(&#34;vpc-cni&#34;)
     *             .addonVersion(latestAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()))
     *             .build());
     * 
     *         ctx.export(&#34;default&#34;, defaultAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()));
     *         ctx.export(&#34;latest&#34;, latestAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()));
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetAddonVersionResult> getAddonVersion(GetAddonVersionArgs args) {
        return getAddonVersion(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve information about a specific EKS add-on version compatible with an EKS cluster version.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonVersionArgs;
     * import com.pulumi.aws.eks.Addon;
     * import com.pulumi.aws.eks.AddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var defaultAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .build());
     * 
     *         final var latestAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .mostRecent(true)
     *             .build());
     * 
     *         var vpcCni = new Addon(&#34;vpcCni&#34;, AddonArgs.builder()        
     *             .clusterName(aws_eks_cluster.example().name())
     *             .addonName(&#34;vpc-cni&#34;)
     *             .addonVersion(latestAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()))
     *             .build());
     * 
     *         ctx.export(&#34;default&#34;, defaultAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()));
     *         ctx.export(&#34;latest&#34;, latestAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()));
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetAddonVersionResult> getAddonVersionPlain(GetAddonVersionPlainArgs args) {
        return getAddonVersionPlain(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve information about a specific EKS add-on version compatible with an EKS cluster version.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonVersionArgs;
     * import com.pulumi.aws.eks.Addon;
     * import com.pulumi.aws.eks.AddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var defaultAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .build());
     * 
     *         final var latestAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .mostRecent(true)
     *             .build());
     * 
     *         var vpcCni = new Addon(&#34;vpcCni&#34;, AddonArgs.builder()        
     *             .clusterName(aws_eks_cluster.example().name())
     *             .addonName(&#34;vpc-cni&#34;)
     *             .addonVersion(latestAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()))
     *             .build());
     * 
     *         ctx.export(&#34;default&#34;, defaultAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()));
     *         ctx.export(&#34;latest&#34;, latestAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()));
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetAddonVersionResult> getAddonVersion(GetAddonVersionArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:eks/getAddonVersion:getAddonVersion", TypeShape.of(GetAddonVersionResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve information about a specific EKS add-on version compatible with an EKS cluster version.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonVersionArgs;
     * import com.pulumi.aws.eks.Addon;
     * import com.pulumi.aws.eks.AddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var defaultAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .build());
     * 
     *         final var latestAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName(&#34;vpc-cni&#34;)
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .mostRecent(true)
     *             .build());
     * 
     *         var vpcCni = new Addon(&#34;vpcCni&#34;, AddonArgs.builder()        
     *             .clusterName(aws_eks_cluster.example().name())
     *             .addonName(&#34;vpc-cni&#34;)
     *             .addonVersion(latestAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()))
     *             .build());
     * 
     *         ctx.export(&#34;default&#34;, defaultAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()));
     *         ctx.export(&#34;latest&#34;, latestAddonVersion.applyValue(getAddonVersionResult -&gt; getAddonVersionResult.version()));
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetAddonVersionResult> getAddonVersionPlain(GetAddonVersionPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:eks/getAddonVersion:getAddonVersion", TypeShape.of(GetAddonVersionResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve information about an EKS Cluster.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getCluster(GetClusterArgs.builder()
     *             .name(&#34;example&#34;)
     *             .build());
     * 
     *         ctx.export(&#34;endpoint&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.endpoint()));
     *         ctx.export(&#34;kubeconfig-certificate-authority-data&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.certificateAuthorities()[0].data()));
     *         ctx.export(&#34;identity-oidc-issuer&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.identities()[0].oidcs()[0].issuer()));
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetClusterResult> getCluster(GetClusterArgs args) {
        return getCluster(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve information about an EKS Cluster.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getCluster(GetClusterArgs.builder()
     *             .name(&#34;example&#34;)
     *             .build());
     * 
     *         ctx.export(&#34;endpoint&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.endpoint()));
     *         ctx.export(&#34;kubeconfig-certificate-authority-data&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.certificateAuthorities()[0].data()));
     *         ctx.export(&#34;identity-oidc-issuer&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.identities()[0].oidcs()[0].issuer()));
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetClusterResult> getClusterPlain(GetClusterPlainArgs args) {
        return getClusterPlain(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve information about an EKS Cluster.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getCluster(GetClusterArgs.builder()
     *             .name(&#34;example&#34;)
     *             .build());
     * 
     *         ctx.export(&#34;endpoint&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.endpoint()));
     *         ctx.export(&#34;kubeconfig-certificate-authority-data&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.certificateAuthorities()[0].data()));
     *         ctx.export(&#34;identity-oidc-issuer&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.identities()[0].oidcs()[0].issuer()));
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetClusterResult> getCluster(GetClusterArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:eks/getCluster:getCluster", TypeShape.of(GetClusterResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve information about an EKS Cluster.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getCluster(GetClusterArgs.builder()
     *             .name(&#34;example&#34;)
     *             .build());
     * 
     *         ctx.export(&#34;endpoint&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.endpoint()));
     *         ctx.export(&#34;kubeconfig-certificate-authority-data&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.certificateAuthorities()[0].data()));
     *         ctx.export(&#34;identity-oidc-issuer&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.identities()[0].oidcs()[0].issuer()));
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetClusterResult> getClusterPlain(GetClusterPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:eks/getCluster:getCluster", TypeShape.of(GetClusterResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Get an authentication token to communicate with an EKS cluster.
     * 
     * Uses IAM credentials from the AWS provider to generate a temporary token that is compatible with
     * [AWS IAM Authenticator](https://github.com/kubernetes-sigs/aws-iam-authenticator) authentication.
     * This can be used to authenticate to an EKS cluster or to a cluster that has the AWS IAM Authenticator
     * server configured.
     * 
     */
    public static Output<GetClusterAuthResult> getClusterAuth(GetClusterAuthArgs args) {
        return getClusterAuth(args, InvokeOptions.Empty);
    }
    /**
     * Get an authentication token to communicate with an EKS cluster.
     * 
     * Uses IAM credentials from the AWS provider to generate a temporary token that is compatible with
     * [AWS IAM Authenticator](https://github.com/kubernetes-sigs/aws-iam-authenticator) authentication.
     * This can be used to authenticate to an EKS cluster or to a cluster that has the AWS IAM Authenticator
     * server configured.
     * 
     */
    public static CompletableFuture<GetClusterAuthResult> getClusterAuthPlain(GetClusterAuthPlainArgs args) {
        return getClusterAuthPlain(args, InvokeOptions.Empty);
    }
    /**
     * Get an authentication token to communicate with an EKS cluster.
     * 
     * Uses IAM credentials from the AWS provider to generate a temporary token that is compatible with
     * [AWS IAM Authenticator](https://github.com/kubernetes-sigs/aws-iam-authenticator) authentication.
     * This can be used to authenticate to an EKS cluster or to a cluster that has the AWS IAM Authenticator
     * server configured.
     * 
     */
    public static Output<GetClusterAuthResult> getClusterAuth(GetClusterAuthArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:eks/getClusterAuth:getClusterAuth", TypeShape.of(GetClusterAuthResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Get an authentication token to communicate with an EKS cluster.
     * 
     * Uses IAM credentials from the AWS provider to generate a temporary token that is compatible with
     * [AWS IAM Authenticator](https://github.com/kubernetes-sigs/aws-iam-authenticator) authentication.
     * This can be used to authenticate to an EKS cluster or to a cluster that has the AWS IAM Authenticator
     * server configured.
     * 
     */
    public static CompletableFuture<GetClusterAuthResult> getClusterAuthPlain(GetClusterAuthPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:eks/getClusterAuth:getClusterAuth", TypeShape.of(GetClusterAuthResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve EKS Clusters list
     * 
     */
    public static Output<GetClustersResult> getClusters() {
        return getClusters(InvokeArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Retrieve EKS Clusters list
     * 
     */
    public static CompletableFuture<GetClustersResult> getClustersPlain() {
        return getClustersPlain(InvokeArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Retrieve EKS Clusters list
     * 
     */
    public static Output<GetClustersResult> getClusters(InvokeArgs args) {
        return getClusters(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve EKS Clusters list
     * 
     */
    public static CompletableFuture<GetClustersResult> getClustersPlain(InvokeArgs args) {
        return getClustersPlain(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve EKS Clusters list
     * 
     */
    public static Output<GetClustersResult> getClusters(InvokeArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:eks/getClusters:getClusters", TypeShape.of(GetClustersResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve EKS Clusters list
     * 
     */
    public static CompletableFuture<GetClustersResult> getClustersPlain(InvokeArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:eks/getClusters:getClusters", TypeShape.of(GetClustersResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve information about an EKS Node Group.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetNodeGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getNodeGroup(GetNodeGroupArgs.builder()
     *             .clusterName(&#34;example&#34;)
     *             .nodeGroupName(&#34;example&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetNodeGroupResult> getNodeGroup(GetNodeGroupArgs args) {
        return getNodeGroup(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve information about an EKS Node Group.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetNodeGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getNodeGroup(GetNodeGroupArgs.builder()
     *             .clusterName(&#34;example&#34;)
     *             .nodeGroupName(&#34;example&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetNodeGroupResult> getNodeGroupPlain(GetNodeGroupPlainArgs args) {
        return getNodeGroupPlain(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve information about an EKS Node Group.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetNodeGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getNodeGroup(GetNodeGroupArgs.builder()
     *             .clusterName(&#34;example&#34;)
     *             .nodeGroupName(&#34;example&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetNodeGroupResult> getNodeGroup(GetNodeGroupArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:eks/getNodeGroup:getNodeGroup", TypeShape.of(GetNodeGroupResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve information about an EKS Node Group.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetNodeGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getNodeGroup(GetNodeGroupArgs.builder()
     *             .clusterName(&#34;example&#34;)
     *             .nodeGroupName(&#34;example&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetNodeGroupResult> getNodeGroupPlain(GetNodeGroupPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:eks/getNodeGroup:getNodeGroup", TypeShape.of(GetNodeGroupResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve the EKS Node Groups associated with a named EKS cluster. This will allow you to pass a list of Node Group names to other resources.
     * 
     * ## Example Usage
     * 
     */
    public static Output<GetNodeGroupsResult> getNodeGroups(GetNodeGroupsArgs args) {
        return getNodeGroups(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve the EKS Node Groups associated with a named EKS cluster. This will allow you to pass a list of Node Group names to other resources.
     * 
     * ## Example Usage
     * 
     */
    public static CompletableFuture<GetNodeGroupsResult> getNodeGroupsPlain(GetNodeGroupsPlainArgs args) {
        return getNodeGroupsPlain(args, InvokeOptions.Empty);
    }
    /**
     * Retrieve the EKS Node Groups associated with a named EKS cluster. This will allow you to pass a list of Node Group names to other resources.
     * 
     * ## Example Usage
     * 
     */
    public static Output<GetNodeGroupsResult> getNodeGroups(GetNodeGroupsArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:eks/getNodeGroups:getNodeGroups", TypeShape.of(GetNodeGroupsResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Retrieve the EKS Node Groups associated with a named EKS cluster. This will allow you to pass a list of Node Group names to other resources.
     * 
     * ## Example Usage
     * 
     */
    public static CompletableFuture<GetNodeGroupsResult> getNodeGroupsPlain(GetNodeGroupsPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:eks/getNodeGroups:getNodeGroups", TypeShape.of(GetNodeGroupsResult.class), args, Utilities.withVersion(options));
    }
}
