// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.efs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class MountTargetArgs extends com.pulumi.resources.ResourceArgs {

    public static final MountTargetArgs Empty = new MountTargetArgs();

    /**
     * The ID of the file system for which the mount target is intended.
     * 
     */
    @Import(name="fileSystemId", required=true)
    private Output<String> fileSystemId;

    /**
     * @return The ID of the file system for which the mount target is intended.
     * 
     */
    public Output<String> fileSystemId() {
        return this.fileSystemId;
    }

    /**
     * The address (within the address range of the specified subnet) at
     * which the file system may be mounted via the mount target.
     * 
     */
    @Import(name="ipAddress")
    private @Nullable Output<String> ipAddress;

    /**
     * @return The address (within the address range of the specified subnet) at
     * which the file system may be mounted via the mount target.
     * 
     */
    public Optional<Output<String>> ipAddress() {
        return Optional.ofNullable(this.ipAddress);
    }

    /**
     * A list of up to 5 VPC security group IDs (that must
     * be for the same VPC as subnet specified) in effect for the mount target.
     * 
     */
    @Import(name="securityGroups")
    private @Nullable Output<List<String>> securityGroups;

    /**
     * @return A list of up to 5 VPC security group IDs (that must
     * be for the same VPC as subnet specified) in effect for the mount target.
     * 
     */
    public Optional<Output<List<String>>> securityGroups() {
        return Optional.ofNullable(this.securityGroups);
    }

    /**
     * The ID of the subnet to add the mount target in.
     * 
     */
    @Import(name="subnetId", required=true)
    private Output<String> subnetId;

    /**
     * @return The ID of the subnet to add the mount target in.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }

    private MountTargetArgs() {}

    private MountTargetArgs(MountTargetArgs $) {
        this.fileSystemId = $.fileSystemId;
        this.ipAddress = $.ipAddress;
        this.securityGroups = $.securityGroups;
        this.subnetId = $.subnetId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(MountTargetArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private MountTargetArgs $;

        public Builder() {
            $ = new MountTargetArgs();
        }

        public Builder(MountTargetArgs defaults) {
            $ = new MountTargetArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param fileSystemId The ID of the file system for which the mount target is intended.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemId(Output<String> fileSystemId) {
            $.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * @param fileSystemId The ID of the file system for which the mount target is intended.
         * 
         * @return builder
         * 
         */
        public Builder fileSystemId(String fileSystemId) {
            return fileSystemId(Output.of(fileSystemId));
        }

        /**
         * @param ipAddress The address (within the address range of the specified subnet) at
         * which the file system may be mounted via the mount target.
         * 
         * @return builder
         * 
         */
        public Builder ipAddress(@Nullable Output<String> ipAddress) {
            $.ipAddress = ipAddress;
            return this;
        }

        /**
         * @param ipAddress The address (within the address range of the specified subnet) at
         * which the file system may be mounted via the mount target.
         * 
         * @return builder
         * 
         */
        public Builder ipAddress(String ipAddress) {
            return ipAddress(Output.of(ipAddress));
        }

        /**
         * @param securityGroups A list of up to 5 VPC security group IDs (that must
         * be for the same VPC as subnet specified) in effect for the mount target.
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(@Nullable Output<List<String>> securityGroups) {
            $.securityGroups = securityGroups;
            return this;
        }

        /**
         * @param securityGroups A list of up to 5 VPC security group IDs (that must
         * be for the same VPC as subnet specified) in effect for the mount target.
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(List<String> securityGroups) {
            return securityGroups(Output.of(securityGroups));
        }

        /**
         * @param securityGroups A list of up to 5 VPC security group IDs (that must
         * be for the same VPC as subnet specified) in effect for the mount target.
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(String... securityGroups) {
            return securityGroups(List.of(securityGroups));
        }

        /**
         * @param subnetId The ID of the subnet to add the mount target in.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId The ID of the subnet to add the mount target in.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        public MountTargetArgs build() {
            $.fileSystemId = Objects.requireNonNull($.fileSystemId, "expected parameter 'fileSystemId' to be non-null");
            $.subnetId = Objects.requireNonNull($.subnetId, "expected parameter 'subnetId' to be non-null");
            return $;
        }
    }

}
