// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.efs;

import com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class FileSystemArgs extends com.pulumi.resources.ResourceArgs {

    public static final FileSystemArgs Empty = new FileSystemArgs();

    /**
     * the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
     * 
     */
    @Import(name="availabilityZoneName")
    private @Nullable Output<String> availabilityZoneName;

    /**
     * @return the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
     * 
     */
    public Optional<Output<String>> availabilityZoneName() {
        return Optional.ofNullable(this.availabilityZoneName);
    }

    /**
     * A unique name (a maximum of 64 characters are allowed)
     * used as reference when creating the Elastic File System to ensure idempotent file
     * system creation. By default generated by this provider. See [Elastic File System]
     * user guide for more information.
     * 
     */
    @Import(name="creationToken")
    private @Nullable Output<String> creationToken;

    /**
     * @return A unique name (a maximum of 64 characters are allowed)
     * used as reference when creating the Elastic File System to ensure idempotent file
     * system creation. By default generated by this provider. See [Elastic File System]
     * user guide for more information.
     * 
     */
    public Optional<Output<String>> creationToken() {
        return Optional.ofNullable(this.creationToken);
    }

    /**
     * If true, the disk will be encrypted.
     * 
     */
    @Import(name="encrypted")
    private @Nullable Output<Boolean> encrypted;

    /**
     * @return If true, the disk will be encrypted.
     * 
     */
    public Optional<Output<Boolean>> encrypted() {
        return Optional.ofNullable(this.encrypted);
    }

    /**
     * The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     * 
     */
    @Import(name="lifecyclePolicies")
    private @Nullable Output<List<FileSystemLifecyclePolicyArgs>> lifecyclePolicies;

    /**
     * @return A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
     * 
     */
    public Optional<Output<List<FileSystemLifecyclePolicyArgs>>> lifecyclePolicies() {
        return Optional.ofNullable(this.lifecyclePolicies);
    }

    /**
     * The file system performance mode. Can be either `&#34;generalPurpose&#34;` or `&#34;maxIO&#34;` (Default: `&#34;generalPurpose&#34;`).
     * 
     */
    @Import(name="performanceMode")
    private @Nullable Output<String> performanceMode;

    /**
     * @return The file system performance mode. Can be either `&#34;generalPurpose&#34;` or `&#34;maxIO&#34;` (Default: `&#34;generalPurpose&#34;`).
     * 
     */
    public Optional<Output<String>> performanceMode() {
        return Optional.ofNullable(this.performanceMode);
    }

    /**
     * The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
     * 
     */
    @Import(name="provisionedThroughputInMibps")
    private @Nullable Output<Double> provisionedThroughputInMibps;

    /**
     * @return The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
     * 
     */
    public Optional<Output<Double>> provisionedThroughputInMibps() {
        return Optional.ofNullable(this.provisionedThroughputInMibps);
    }

    /**
     * A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
     * 
     */
    @Import(name="throughputMode")
    private @Nullable Output<String> throughputMode;

    /**
     * @return Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
     * 
     */
    public Optional<Output<String>> throughputMode() {
        return Optional.ofNullable(this.throughputMode);
    }

    private FileSystemArgs() {}

    private FileSystemArgs(FileSystemArgs $) {
        this.availabilityZoneName = $.availabilityZoneName;
        this.creationToken = $.creationToken;
        this.encrypted = $.encrypted;
        this.kmsKeyId = $.kmsKeyId;
        this.lifecyclePolicies = $.lifecyclePolicies;
        this.performanceMode = $.performanceMode;
        this.provisionedThroughputInMibps = $.provisionedThroughputInMibps;
        this.tags = $.tags;
        this.throughputMode = $.throughputMode;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(FileSystemArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FileSystemArgs $;

        public Builder() {
            $ = new FileSystemArgs();
        }

        public Builder(FileSystemArgs defaults) {
            $ = new FileSystemArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param availabilityZoneName the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZoneName(@Nullable Output<String> availabilityZoneName) {
            $.availabilityZoneName = availabilityZoneName;
            return this;
        }

        /**
         * @param availabilityZoneName the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZoneName(String availabilityZoneName) {
            return availabilityZoneName(Output.of(availabilityZoneName));
        }

        /**
         * @param creationToken A unique name (a maximum of 64 characters are allowed)
         * used as reference when creating the Elastic File System to ensure idempotent file
         * system creation. By default generated by this provider. See [Elastic File System]
         * user guide for more information.
         * 
         * @return builder
         * 
         */
        public Builder creationToken(@Nullable Output<String> creationToken) {
            $.creationToken = creationToken;
            return this;
        }

        /**
         * @param creationToken A unique name (a maximum of 64 characters are allowed)
         * used as reference when creating the Elastic File System to ensure idempotent file
         * system creation. By default generated by this provider. See [Elastic File System]
         * user guide for more information.
         * 
         * @return builder
         * 
         */
        public Builder creationToken(String creationToken) {
            return creationToken(Output.of(creationToken));
        }

        /**
         * @param encrypted If true, the disk will be encrypted.
         * 
         * @return builder
         * 
         */
        public Builder encrypted(@Nullable Output<Boolean> encrypted) {
            $.encrypted = encrypted;
            return this;
        }

        /**
         * @param encrypted If true, the disk will be encrypted.
         * 
         * @return builder
         * 
         */
        public Builder encrypted(Boolean encrypted) {
            return encrypted(Output.of(encrypted));
        }

        /**
         * @param kmsKeyId The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param lifecyclePolicies A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
         * 
         * @return builder
         * 
         */
        public Builder lifecyclePolicies(@Nullable Output<List<FileSystemLifecyclePolicyArgs>> lifecyclePolicies) {
            $.lifecyclePolicies = lifecyclePolicies;
            return this;
        }

        /**
         * @param lifecyclePolicies A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
         * 
         * @return builder
         * 
         */
        public Builder lifecyclePolicies(List<FileSystemLifecyclePolicyArgs> lifecyclePolicies) {
            return lifecyclePolicies(Output.of(lifecyclePolicies));
        }

        /**
         * @param lifecyclePolicies A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object (documented below).
         * 
         * @return builder
         * 
         */
        public Builder lifecyclePolicies(FileSystemLifecyclePolicyArgs... lifecyclePolicies) {
            return lifecyclePolicies(List.of(lifecyclePolicies));
        }

        /**
         * @param performanceMode The file system performance mode. Can be either `&#34;generalPurpose&#34;` or `&#34;maxIO&#34;` (Default: `&#34;generalPurpose&#34;`).
         * 
         * @return builder
         * 
         */
        public Builder performanceMode(@Nullable Output<String> performanceMode) {
            $.performanceMode = performanceMode;
            return this;
        }

        /**
         * @param performanceMode The file system performance mode. Can be either `&#34;generalPurpose&#34;` or `&#34;maxIO&#34;` (Default: `&#34;generalPurpose&#34;`).
         * 
         * @return builder
         * 
         */
        public Builder performanceMode(String performanceMode) {
            return performanceMode(Output.of(performanceMode));
        }

        /**
         * @param provisionedThroughputInMibps The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
         * 
         * @return builder
         * 
         */
        public Builder provisionedThroughputInMibps(@Nullable Output<Double> provisionedThroughputInMibps) {
            $.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        /**
         * @param provisionedThroughputInMibps The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
         * 
         * @return builder
         * 
         */
        public Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            return provisionedThroughputInMibps(Output.of(provisionedThroughputInMibps));
        }

        /**
         * @param tags A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param throughputMode Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
         * 
         * @return builder
         * 
         */
        public Builder throughputMode(@Nullable Output<String> throughputMode) {
            $.throughputMode = throughputMode;
            return this;
        }

        /**
         * @param throughputMode Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
         * 
         * @return builder
         * 
         */
        public Builder throughputMode(String throughputMode) {
            return throughputMode(Output.of(throughputMode));
        }

        public FileSystemArgs build() {
            return $;
        }
    }

}
