// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ecs.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceLoadBalancer {
    /**
     * @return Name of the container to associate with the load balancer (as it appears in a container definition).
     * 
     */
    private String containerName;
    /**
     * @return Port on the container to associate with the load balancer.
     * 
     * &gt; **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
     * 
     */
    private Integer containerPort;
    /**
     * @return Name of the ELB (Classic) to associate with the service.
     * 
     */
    private @Nullable String elbName;
    /**
     * @return ARN of the Load Balancer target group to associate with the service.
     * 
     */
    private @Nullable String targetGroupArn;

    private ServiceLoadBalancer() {}
    /**
     * @return Name of the container to associate with the load balancer (as it appears in a container definition).
     * 
     */
    public String containerName() {
        return this.containerName;
    }
    /**
     * @return Port on the container to associate with the load balancer.
     * 
     * &gt; **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
     * 
     */
    public Integer containerPort() {
        return this.containerPort;
    }
    /**
     * @return Name of the ELB (Classic) to associate with the service.
     * 
     */
    public Optional<String> elbName() {
        return Optional.ofNullable(this.elbName);
    }
    /**
     * @return ARN of the Load Balancer target group to associate with the service.
     * 
     */
    public Optional<String> targetGroupArn() {
        return Optional.ofNullable(this.targetGroupArn);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceLoadBalancer defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private String containerName;
        private Integer containerPort;
        private @Nullable String elbName;
        private @Nullable String targetGroupArn;
        public Builder() {}
        public Builder(ServiceLoadBalancer defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.containerName = defaults.containerName;
    	      this.containerPort = defaults.containerPort;
    	      this.elbName = defaults.elbName;
    	      this.targetGroupArn = defaults.targetGroupArn;
        }

        @CustomType.Setter
        public Builder containerName(String containerName) {
            this.containerName = Objects.requireNonNull(containerName);
            return this;
        }
        @CustomType.Setter
        public Builder containerPort(Integer containerPort) {
            this.containerPort = Objects.requireNonNull(containerPort);
            return this;
        }
        @CustomType.Setter
        public Builder elbName(@Nullable String elbName) {
            this.elbName = elbName;
            return this;
        }
        @CustomType.Setter
        public Builder targetGroupArn(@Nullable String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }
        public ServiceLoadBalancer build() {
            final var o = new ServiceLoadBalancer();
            o.containerName = containerName;
            o.containerPort = containerPort;
            o.elbName = elbName;
            o.targetGroupArn = targetGroupArn;
            return o;
        }
    }
}
