// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ecs.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TaskSetLoadBalancerArgs extends com.pulumi.resources.ResourceArgs {

    public static final TaskSetLoadBalancerArgs Empty = new TaskSetLoadBalancerArgs();

    /**
     * The name of the container to associate with the load balancer (as it appears in a container definition).
     * 
     */
    @Import(name="containerName", required=true)
    private Output<String> containerName;

    /**
     * @return The name of the container to associate with the load balancer (as it appears in a container definition).
     * 
     */
    public Output<String> containerName() {
        return this.containerName;
    }

    /**
     * The port on the container to associate with the load balancer. Defaults to `0` if not specified.
     * 
     * &gt; **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
     * 
     */
    @Import(name="containerPort")
    private @Nullable Output<Integer> containerPort;

    /**
     * @return The port on the container to associate with the load balancer. Defaults to `0` if not specified.
     * 
     * &gt; **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
     * 
     */
    public Optional<Output<Integer>> containerPort() {
        return Optional.ofNullable(this.containerPort);
    }

    /**
     * The name of the ELB (Classic) to associate with the service.
     * 
     */
    @Import(name="loadBalancerName")
    private @Nullable Output<String> loadBalancerName;

    /**
     * @return The name of the ELB (Classic) to associate with the service.
     * 
     */
    public Optional<Output<String>> loadBalancerName() {
        return Optional.ofNullable(this.loadBalancerName);
    }

    /**
     * The ARN of the Load Balancer target group to associate with the service.
     * 
     */
    @Import(name="targetGroupArn")
    private @Nullable Output<String> targetGroupArn;

    /**
     * @return The ARN of the Load Balancer target group to associate with the service.
     * 
     */
    public Optional<Output<String>> targetGroupArn() {
        return Optional.ofNullable(this.targetGroupArn);
    }

    private TaskSetLoadBalancerArgs() {}

    private TaskSetLoadBalancerArgs(TaskSetLoadBalancerArgs $) {
        this.containerName = $.containerName;
        this.containerPort = $.containerPort;
        this.loadBalancerName = $.loadBalancerName;
        this.targetGroupArn = $.targetGroupArn;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TaskSetLoadBalancerArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TaskSetLoadBalancerArgs $;

        public Builder() {
            $ = new TaskSetLoadBalancerArgs();
        }

        public Builder(TaskSetLoadBalancerArgs defaults) {
            $ = new TaskSetLoadBalancerArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param containerName The name of the container to associate with the load balancer (as it appears in a container definition).
         * 
         * @return builder
         * 
         */
        public Builder containerName(Output<String> containerName) {
            $.containerName = containerName;
            return this;
        }

        /**
         * @param containerName The name of the container to associate with the load balancer (as it appears in a container definition).
         * 
         * @return builder
         * 
         */
        public Builder containerName(String containerName) {
            return containerName(Output.of(containerName));
        }

        /**
         * @param containerPort The port on the container to associate with the load balancer. Defaults to `0` if not specified.
         * 
         * &gt; **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
         * 
         * @return builder
         * 
         */
        public Builder containerPort(@Nullable Output<Integer> containerPort) {
            $.containerPort = containerPort;
            return this;
        }

        /**
         * @param containerPort The port on the container to associate with the load balancer. Defaults to `0` if not specified.
         * 
         * &gt; **Note:** Specifying multiple `load_balancer` configurations is still not supported by AWS for ECS task set.
         * 
         * @return builder
         * 
         */
        public Builder containerPort(Integer containerPort) {
            return containerPort(Output.of(containerPort));
        }

        /**
         * @param loadBalancerName The name of the ELB (Classic) to associate with the service.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancerName(@Nullable Output<String> loadBalancerName) {
            $.loadBalancerName = loadBalancerName;
            return this;
        }

        /**
         * @param loadBalancerName The name of the ELB (Classic) to associate with the service.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancerName(String loadBalancerName) {
            return loadBalancerName(Output.of(loadBalancerName));
        }

        /**
         * @param targetGroupArn The ARN of the Load Balancer target group to associate with the service.
         * 
         * @return builder
         * 
         */
        public Builder targetGroupArn(@Nullable Output<String> targetGroupArn) {
            $.targetGroupArn = targetGroupArn;
            return this;
        }

        /**
         * @param targetGroupArn The ARN of the Load Balancer target group to associate with the service.
         * 
         * @return builder
         * 
         */
        public Builder targetGroupArn(String targetGroupArn) {
            return targetGroupArn(Output.of(targetGroupArn));
        }

        public TaskSetLoadBalancerArgs build() {
            $.containerName = Objects.requireNonNull($.containerName, "expected parameter 'containerName' to be non-null");
            return $;
        }
    }

}
