// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ecs.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ServiceLoadBalancerArgs extends com.pulumi.resources.ResourceArgs {

    public static final ServiceLoadBalancerArgs Empty = new ServiceLoadBalancerArgs();

    /**
     * Name of the container to associate with the load balancer (as it appears in a container definition).
     * 
     */
    @Import(name="containerName", required=true)
    private Output<String> containerName;

    /**
     * @return Name of the container to associate with the load balancer (as it appears in a container definition).
     * 
     */
    public Output<String> containerName() {
        return this.containerName;
    }

    /**
     * Port on the container to associate with the load balancer.
     * 
     * &gt; **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
     * 
     */
    @Import(name="containerPort", required=true)
    private Output<Integer> containerPort;

    /**
     * @return Port on the container to associate with the load balancer.
     * 
     * &gt; **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
     * 
     */
    public Output<Integer> containerPort() {
        return this.containerPort;
    }

    /**
     * Name of the ELB (Classic) to associate with the service.
     * 
     */
    @Import(name="elbName")
    private @Nullable Output<String> elbName;

    /**
     * @return Name of the ELB (Classic) to associate with the service.
     * 
     */
    public Optional<Output<String>> elbName() {
        return Optional.ofNullable(this.elbName);
    }

    /**
     * ARN of the Load Balancer target group to associate with the service.
     * 
     */
    @Import(name="targetGroupArn")
    private @Nullable Output<String> targetGroupArn;

    /**
     * @return ARN of the Load Balancer target group to associate with the service.
     * 
     */
    public Optional<Output<String>> targetGroupArn() {
        return Optional.ofNullable(this.targetGroupArn);
    }

    private ServiceLoadBalancerArgs() {}

    private ServiceLoadBalancerArgs(ServiceLoadBalancerArgs $) {
        this.containerName = $.containerName;
        this.containerPort = $.containerPort;
        this.elbName = $.elbName;
        this.targetGroupArn = $.targetGroupArn;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ServiceLoadBalancerArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ServiceLoadBalancerArgs $;

        public Builder() {
            $ = new ServiceLoadBalancerArgs();
        }

        public Builder(ServiceLoadBalancerArgs defaults) {
            $ = new ServiceLoadBalancerArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param containerName Name of the container to associate with the load balancer (as it appears in a container definition).
         * 
         * @return builder
         * 
         */
        public Builder containerName(Output<String> containerName) {
            $.containerName = containerName;
            return this;
        }

        /**
         * @param containerName Name of the container to associate with the load balancer (as it appears in a container definition).
         * 
         * @return builder
         * 
         */
        public Builder containerName(String containerName) {
            return containerName(Output.of(containerName));
        }

        /**
         * @param containerPort Port on the container to associate with the load balancer.
         * 
         * &gt; **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
         * 
         * @return builder
         * 
         */
        public Builder containerPort(Output<Integer> containerPort) {
            $.containerPort = containerPort;
            return this;
        }

        /**
         * @param containerPort Port on the container to associate with the load balancer.
         * 
         * &gt; **Version note:** Multiple `load_balancer` configuration block support was added in version 2.22.0 of the provider. This allows configuration of [ECS service support for multiple target groups](https://aws.amazon.com/about-aws/whats-new/2019/07/amazon-ecs-services-now-support-multiple-load-balancer-target-groups/).
         * 
         * @return builder
         * 
         */
        public Builder containerPort(Integer containerPort) {
            return containerPort(Output.of(containerPort));
        }

        /**
         * @param elbName Name of the ELB (Classic) to associate with the service.
         * 
         * @return builder
         * 
         */
        public Builder elbName(@Nullable Output<String> elbName) {
            $.elbName = elbName;
            return this;
        }

        /**
         * @param elbName Name of the ELB (Classic) to associate with the service.
         * 
         * @return builder
         * 
         */
        public Builder elbName(String elbName) {
            return elbName(Output.of(elbName));
        }

        /**
         * @param targetGroupArn ARN of the Load Balancer target group to associate with the service.
         * 
         * @return builder
         * 
         */
        public Builder targetGroupArn(@Nullable Output<String> targetGroupArn) {
            $.targetGroupArn = targetGroupArn;
            return this;
        }

        /**
         * @param targetGroupArn ARN of the Load Balancer target group to associate with the service.
         * 
         * @return builder
         * 
         */
        public Builder targetGroupArn(String targetGroupArn) {
            return targetGroupArn(Output.of(targetGroupArn));
        }

        public ServiceLoadBalancerArgs build() {
            $.containerName = Objects.requireNonNull($.containerName, "expected parameter 'containerName' to be non-null");
            $.containerPort = Objects.requireNonNull($.containerPort, "expected parameter 'containerPort' to be non-null");
            return $;
        }
    }

}
