// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ecs;

import com.pulumi.aws.ecs.inputs.TaskSetCapacityProviderStrategyArgs;
import com.pulumi.aws.ecs.inputs.TaskSetLoadBalancerArgs;
import com.pulumi.aws.ecs.inputs.TaskSetNetworkConfigurationArgs;
import com.pulumi.aws.ecs.inputs.TaskSetScaleArgs;
import com.pulumi.aws.ecs.inputs.TaskSetServiceRegistriesArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TaskSetArgs extends com.pulumi.resources.ResourceArgs {

    public static final TaskSetArgs Empty = new TaskSetArgs();

    /**
     * The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     * 
     */
    @Import(name="capacityProviderStrategies")
    private @Nullable Output<List<TaskSetCapacityProviderStrategyArgs>> capacityProviderStrategies;

    /**
     * @return The capacity provider strategy to use for the service. Can be one or more.  Defined below.
     * 
     */
    public Optional<Output<List<TaskSetCapacityProviderStrategyArgs>>> capacityProviderStrategies() {
        return Optional.ofNullable(this.capacityProviderStrategies);
    }

    /**
     * The short name or ARN of the cluster that hosts the service to create the task set in.
     * 
     */
    @Import(name="cluster", required=true)
    private Output<String> cluster;

    /**
     * @return The short name or ARN of the cluster that hosts the service to create the task set in.
     * 
     */
    public Output<String> cluster() {
        return this.cluster;
    }

    /**
     * The external ID associated with the task set.
     * 
     */
    @Import(name="externalId")
    private @Nullable Output<String> externalId;

    /**
     * @return The external ID associated with the task set.
     * 
     */
    public Optional<Output<String>> externalId() {
        return Optional.ofNullable(this.externalId);
    }

    /**
     * Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it&#39;s in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
     * 
     */
    @Import(name="forceDelete")
    private @Nullable Output<Boolean> forceDelete;

    /**
     * @return Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it&#39;s in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
     * 
     */
    public Optional<Output<Boolean>> forceDelete() {
        return Optional.ofNullable(this.forceDelete);
    }

    /**
     * The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
     * 
     */
    @Import(name="launchType")
    private @Nullable Output<String> launchType;

    /**
     * @return The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
     * 
     */
    public Optional<Output<String>> launchType() {
        return Optional.ofNullable(this.launchType);
    }

    /**
     * Details on load balancers that are used with a task set. Detailed below.
     * 
     */
    @Import(name="loadBalancers")
    private @Nullable Output<List<TaskSetLoadBalancerArgs>> loadBalancers;

    /**
     * @return Details on load balancers that are used with a task set. Detailed below.
     * 
     */
    public Optional<Output<List<TaskSetLoadBalancerArgs>>> loadBalancers() {
        return Optional.ofNullable(this.loadBalancers);
    }

    /**
     * The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
     * 
     */
    @Import(name="networkConfiguration")
    private @Nullable Output<TaskSetNetworkConfigurationArgs> networkConfiguration;

    /**
     * @return The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
     * 
     */
    public Optional<Output<TaskSetNetworkConfigurationArgs>> networkConfiguration() {
        return Optional.ofNullable(this.networkConfiguration);
    }

    /**
     * The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     * 
     */
    @Import(name="platformVersion")
    private @Nullable Output<String> platformVersion;

    /**
     * @return The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
     * 
     */
    public Optional<Output<String>> platformVersion() {
        return Optional.ofNullable(this.platformVersion);
    }

    /**
     * A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
     * 
     */
    @Import(name="scale")
    private @Nullable Output<TaskSetScaleArgs> scale;

    /**
     * @return A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
     * 
     */
    public Optional<Output<TaskSetScaleArgs>> scale() {
        return Optional.ofNullable(this.scale);
    }

    /**
     * The short name or ARN of the ECS service.
     * 
     */
    @Import(name="service", required=true)
    private Output<String> service;

    /**
     * @return The short name or ARN of the ECS service.
     * 
     */
    public Output<String> service() {
        return this.service;
    }

    /**
     * The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
     * 
     */
    @Import(name="serviceRegistries")
    private @Nullable Output<TaskSetServiceRegistriesArgs> serviceRegistries;

    /**
     * @return The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
     * 
     */
    public Optional<Output<TaskSetServiceRegistriesArgs>> serviceRegistries() {
        return Optional.ofNullable(this.serviceRegistries);
    }

    /**
     * A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="taskDefinition", required=true)
    private Output<String> taskDefinition;

    /**
     * @return The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> taskDefinition() {
        return this.taskDefinition;
    }

    /**
     * Whether the provider should wait until the task set has reached `STEADY_STATE`.
     * 
     */
    @Import(name="waitUntilStable")
    private @Nullable Output<Boolean> waitUntilStable;

    /**
     * @return Whether the provider should wait until the task set has reached `STEADY_STATE`.
     * 
     */
    public Optional<Output<Boolean>> waitUntilStable() {
        return Optional.ofNullable(this.waitUntilStable);
    }

    /**
     * Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
     * 
     */
    @Import(name="waitUntilStableTimeout")
    private @Nullable Output<String> waitUntilStableTimeout;

    /**
     * @return Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
     * 
     */
    public Optional<Output<String>> waitUntilStableTimeout() {
        return Optional.ofNullable(this.waitUntilStableTimeout);
    }

    private TaskSetArgs() {}

    private TaskSetArgs(TaskSetArgs $) {
        this.capacityProviderStrategies = $.capacityProviderStrategies;
        this.cluster = $.cluster;
        this.externalId = $.externalId;
        this.forceDelete = $.forceDelete;
        this.launchType = $.launchType;
        this.loadBalancers = $.loadBalancers;
        this.networkConfiguration = $.networkConfiguration;
        this.platformVersion = $.platformVersion;
        this.scale = $.scale;
        this.service = $.service;
        this.serviceRegistries = $.serviceRegistries;
        this.tags = $.tags;
        this.taskDefinition = $.taskDefinition;
        this.waitUntilStable = $.waitUntilStable;
        this.waitUntilStableTimeout = $.waitUntilStableTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TaskSetArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TaskSetArgs $;

        public Builder() {
            $ = new TaskSetArgs();
        }

        public Builder(TaskSetArgs defaults) {
            $ = new TaskSetArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param capacityProviderStrategies The capacity provider strategy to use for the service. Can be one or more.  Defined below.
         * 
         * @return builder
         * 
         */
        public Builder capacityProviderStrategies(@Nullable Output<List<TaskSetCapacityProviderStrategyArgs>> capacityProviderStrategies) {
            $.capacityProviderStrategies = capacityProviderStrategies;
            return this;
        }

        /**
         * @param capacityProviderStrategies The capacity provider strategy to use for the service. Can be one or more.  Defined below.
         * 
         * @return builder
         * 
         */
        public Builder capacityProviderStrategies(List<TaskSetCapacityProviderStrategyArgs> capacityProviderStrategies) {
            return capacityProviderStrategies(Output.of(capacityProviderStrategies));
        }

        /**
         * @param capacityProviderStrategies The capacity provider strategy to use for the service. Can be one or more.  Defined below.
         * 
         * @return builder
         * 
         */
        public Builder capacityProviderStrategies(TaskSetCapacityProviderStrategyArgs... capacityProviderStrategies) {
            return capacityProviderStrategies(List.of(capacityProviderStrategies));
        }

        /**
         * @param cluster The short name or ARN of the cluster that hosts the service to create the task set in.
         * 
         * @return builder
         * 
         */
        public Builder cluster(Output<String> cluster) {
            $.cluster = cluster;
            return this;
        }

        /**
         * @param cluster The short name or ARN of the cluster that hosts the service to create the task set in.
         * 
         * @return builder
         * 
         */
        public Builder cluster(String cluster) {
            return cluster(Output.of(cluster));
        }

        /**
         * @param externalId The external ID associated with the task set.
         * 
         * @return builder
         * 
         */
        public Builder externalId(@Nullable Output<String> externalId) {
            $.externalId = externalId;
            return this;
        }

        /**
         * @param externalId The external ID associated with the task set.
         * 
         * @return builder
         * 
         */
        public Builder externalId(String externalId) {
            return externalId(Output.of(externalId));
        }

        /**
         * @param forceDelete Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it&#39;s in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
         * 
         * @return builder
         * 
         */
        public Builder forceDelete(@Nullable Output<Boolean> forceDelete) {
            $.forceDelete = forceDelete;
            return this;
        }

        /**
         * @param forceDelete Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it&#39;s in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
         * 
         * @return builder
         * 
         */
        public Builder forceDelete(Boolean forceDelete) {
            return forceDelete(Output.of(forceDelete));
        }

        /**
         * @param launchType The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
         * 
         * @return builder
         * 
         */
        public Builder launchType(@Nullable Output<String> launchType) {
            $.launchType = launchType;
            return this;
        }

        /**
         * @param launchType The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
         * 
         * @return builder
         * 
         */
        public Builder launchType(String launchType) {
            return launchType(Output.of(launchType));
        }

        /**
         * @param loadBalancers Details on load balancers that are used with a task set. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancers(@Nullable Output<List<TaskSetLoadBalancerArgs>> loadBalancers) {
            $.loadBalancers = loadBalancers;
            return this;
        }

        /**
         * @param loadBalancers Details on load balancers that are used with a task set. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancers(List<TaskSetLoadBalancerArgs> loadBalancers) {
            return loadBalancers(Output.of(loadBalancers));
        }

        /**
         * @param loadBalancers Details on load balancers that are used with a task set. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancers(TaskSetLoadBalancerArgs... loadBalancers) {
            return loadBalancers(List.of(loadBalancers));
        }

        /**
         * @param networkConfiguration The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder networkConfiguration(@Nullable Output<TaskSetNetworkConfigurationArgs> networkConfiguration) {
            $.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * @param networkConfiguration The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder networkConfiguration(TaskSetNetworkConfigurationArgs networkConfiguration) {
            return networkConfiguration(Output.of(networkConfiguration));
        }

        /**
         * @param platformVersion The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
         * 
         * @return builder
         * 
         */
        public Builder platformVersion(@Nullable Output<String> platformVersion) {
            $.platformVersion = platformVersion;
            return this;
        }

        /**
         * @param platformVersion The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
         * 
         * @return builder
         * 
         */
        public Builder platformVersion(String platformVersion) {
            return platformVersion(Output.of(platformVersion));
        }

        /**
         * @param scale A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder scale(@Nullable Output<TaskSetScaleArgs> scale) {
            $.scale = scale;
            return this;
        }

        /**
         * @param scale A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder scale(TaskSetScaleArgs scale) {
            return scale(Output.of(scale));
        }

        /**
         * @param service The short name or ARN of the ECS service.
         * 
         * @return builder
         * 
         */
        public Builder service(Output<String> service) {
            $.service = service;
            return this;
        }

        /**
         * @param service The short name or ARN of the ECS service.
         * 
         * @return builder
         * 
         */
        public Builder service(String service) {
            return service(Output.of(service));
        }

        /**
         * @param serviceRegistries The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder serviceRegistries(@Nullable Output<TaskSetServiceRegistriesArgs> serviceRegistries) {
            $.serviceRegistries = serviceRegistries;
            return this;
        }

        /**
         * @param serviceRegistries The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder serviceRegistries(TaskSetServiceRegistriesArgs serviceRegistries) {
            return serviceRegistries(Output.of(serviceRegistries));
        }

        /**
         * @param tags A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param taskDefinition The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder taskDefinition(Output<String> taskDefinition) {
            $.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * @param taskDefinition The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder taskDefinition(String taskDefinition) {
            return taskDefinition(Output.of(taskDefinition));
        }

        /**
         * @param waitUntilStable Whether the provider should wait until the task set has reached `STEADY_STATE`.
         * 
         * @return builder
         * 
         */
        public Builder waitUntilStable(@Nullable Output<Boolean> waitUntilStable) {
            $.waitUntilStable = waitUntilStable;
            return this;
        }

        /**
         * @param waitUntilStable Whether the provider should wait until the task set has reached `STEADY_STATE`.
         * 
         * @return builder
         * 
         */
        public Builder waitUntilStable(Boolean waitUntilStable) {
            return waitUntilStable(Output.of(waitUntilStable));
        }

        /**
         * @param waitUntilStableTimeout Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
         * 
         * @return builder
         * 
         */
        public Builder waitUntilStableTimeout(@Nullable Output<String> waitUntilStableTimeout) {
            $.waitUntilStableTimeout = waitUntilStableTimeout;
            return this;
        }

        /**
         * @param waitUntilStableTimeout Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
         * 
         * @return builder
         * 
         */
        public Builder waitUntilStableTimeout(String waitUntilStableTimeout) {
            return waitUntilStableTimeout(Output.of(waitUntilStableTimeout));
        }

        public TaskSetArgs build() {
            $.cluster = Objects.requireNonNull($.cluster, "expected parameter 'cluster' to be non-null");
            $.service = Objects.requireNonNull($.service, "expected parameter 'service' to be non-null");
            $.taskDefinition = Objects.requireNonNull($.taskDefinition, "expected parameter 'taskDefinition' to be non-null");
            return $;
        }
    }

}
