// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ecs;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ecs.ClusterArgs;
import com.pulumi.aws.ecs.inputs.ClusterState;
import com.pulumi.aws.ecs.outputs.ClusterConfiguration;
import com.pulumi.aws.ecs.outputs.ClusterServiceConnectDefaults;
import com.pulumi.aws.ecs.outputs.ClusterSetting;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an ECS cluster.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var foo = new Cluster(&#34;foo&#34;, ClusterArgs.builder()        
 *             .settings(ClusterSettingArgs.builder()
 *                 .name(&#34;containerInsights&#34;)
 *                 .value(&#34;enabled&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Example with Log Configuration
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.ecs.Cluster;
 * import com.pulumi.aws.ecs.ClusterArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationArgs;
 * import com.pulumi.aws.ecs.inputs.ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key(&#34;exampleKey&#34;, KeyArgs.builder()        
 *             .description(&#34;example&#34;)
 *             .deletionWindowInDays(7)
 *             .build());
 * 
 *         var exampleLogGroup = new LogGroup(&#34;exampleLogGroup&#34;);
 * 
 *         var test = new Cluster(&#34;test&#34;, ClusterArgs.builder()        
 *             .configuration(ClusterConfigurationArgs.builder()
 *                 .executeCommandConfiguration(ClusterConfigurationExecuteCommandConfigurationArgs.builder()
 *                     .kmsKeyId(exampleKey.arn())
 *                     .logging(&#34;OVERRIDE&#34;)
 *                     .logConfiguration(ClusterConfigurationExecuteCommandConfigurationLogConfigurationArgs.builder()
 *                         .cloudWatchEncryptionEnabled(true)
 *                         .cloudWatchLogGroupName(exampleLogGroup.name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import ECS clusters using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ecs/cluster:Cluster stateless stateless-app
 * ```
 * 
 */
@ResourceType(type="aws:ecs/cluster:Cluster")
public class Cluster extends com.pulumi.resources.CustomResource {
    /**
     * ARN that identifies the cluster.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN that identifies the cluster.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The execute command configuration for the cluster. Detailed below.
     * 
     */
    @Export(name="configuration", refs={ClusterConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ ClusterConfiguration> configuration;

    /**
     * @return The execute command configuration for the cluster. Detailed below.
     * 
     */
    public Output<Optional<ClusterConfiguration>> configuration() {
        return Codegen.optional(this.configuration);
    }
    /**
     * Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the cluster (up to 255 letters, numbers, hyphens, and underscores)
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Configures a default Service Connect namespace. Detailed below.
     * 
     */
    @Export(name="serviceConnectDefaults", refs={ClusterServiceConnectDefaults.class}, tree="[0]")
    private Output</* @Nullable */ ClusterServiceConnectDefaults> serviceConnectDefaults;

    /**
     * @return Configures a default Service Connect namespace. Detailed below.
     * 
     */
    public Output<Optional<ClusterServiceConnectDefaults>> serviceConnectDefaults() {
        return Codegen.optional(this.serviceConnectDefaults);
    }
    /**
     * Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     * 
     */
    @Export(name="settings", refs={List.class,ClusterSetting.class}, tree="[0,1]")
    private Output<List<ClusterSetting>> settings;

    /**
     * @return Configuration block(s) with cluster settings. For example, this can be used to enable CloudWatch Container Insights for a cluster. Detailed below.
     * 
     */
    public Output<List<ClusterSetting>> settings() {
        return this.settings;
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Cluster(String name) {
        this(name, ClusterArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Cluster(String name, @Nullable ClusterArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Cluster(String name, @Nullable ClusterArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ecs/cluster:Cluster", name, args == null ? ClusterArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Cluster(String name, Output<String> id, @Nullable ClusterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ecs/cluster:Cluster", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Cluster get(String name, Output<String> id, @Nullable ClusterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Cluster(name, id, state, options);
    }
}
