// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ecrpublic.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class RepositoryCatalogData {
    /**
     * @return A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
     * 
     */
    private @Nullable String aboutText;
    /**
     * @return The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
     * 
     */
    private @Nullable List<String> architectures;
    /**
     * @return A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
     * 
     */
    private @Nullable String description;
    /**
     * @return The base64-encoded repository logo payload. (Only visible for verified accounts) Note that drift detection is disabled for this attribute.
     * 
     */
    private @Nullable String logoImageBlob;
    /**
     * @return The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
     * 
     */
    private @Nullable List<String> operatingSystems;
    /**
     * @return Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
     * 
     */
    private @Nullable String usageText;

    private RepositoryCatalogData() {}
    /**
     * @return A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The text must be in markdown format.
     * 
     */
    public Optional<String> aboutText() {
        return Optional.ofNullable(this.aboutText);
    }
    /**
     * @return The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported architectures will appear as badges on the repository and are used as search filters: `ARM`, `ARM 64`, `x86`, `x86-64`
     * 
     */
    public List<String> architectures() {
        return this.architectures == null ? List.of() : this.architectures;
    }
    /**
     * @return A short description of the contents of the repository. This text appears in both the image details and also when searching for repositories on the Amazon ECR Public Gallery.
     * 
     */
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }
    /**
     * @return The base64-encoded repository logo payload. (Only visible for verified accounts) Note that drift detection is disabled for this attribute.
     * 
     */
    public Optional<String> logoImageBlob() {
        return Optional.ofNullable(this.logoImageBlob);
    }
    /**
     * @return The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery, the following supported operating systems will appear as badges on the repository and are used as search filters: `Linux`, `Windows`
     * 
     */
    public List<String> operatingSystems() {
        return this.operatingSystems == null ? List.of() : this.operatingSystems;
    }
    /**
     * @return Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage details for users of the repository. The text must be in markdown format.
     * 
     */
    public Optional<String> usageText() {
        return Optional.ofNullable(this.usageText);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RepositoryCatalogData defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable String aboutText;
        private @Nullable List<String> architectures;
        private @Nullable String description;
        private @Nullable String logoImageBlob;
        private @Nullable List<String> operatingSystems;
        private @Nullable String usageText;
        public Builder() {}
        public Builder(RepositoryCatalogData defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.aboutText = defaults.aboutText;
    	      this.architectures = defaults.architectures;
    	      this.description = defaults.description;
    	      this.logoImageBlob = defaults.logoImageBlob;
    	      this.operatingSystems = defaults.operatingSystems;
    	      this.usageText = defaults.usageText;
        }

        @CustomType.Setter
        public Builder aboutText(@Nullable String aboutText) {
            this.aboutText = aboutText;
            return this;
        }
        @CustomType.Setter
        public Builder architectures(@Nullable List<String> architectures) {
            this.architectures = architectures;
            return this;
        }
        public Builder architectures(String... architectures) {
            return architectures(List.of(architectures));
        }
        @CustomType.Setter
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }
        @CustomType.Setter
        public Builder logoImageBlob(@Nullable String logoImageBlob) {
            this.logoImageBlob = logoImageBlob;
            return this;
        }
        @CustomType.Setter
        public Builder operatingSystems(@Nullable List<String> operatingSystems) {
            this.operatingSystems = operatingSystems;
            return this;
        }
        public Builder operatingSystems(String... operatingSystems) {
            return operatingSystems(List.of(operatingSystems));
        }
        @CustomType.Setter
        public Builder usageText(@Nullable String usageText) {
            this.usageText = usageText;
            return this;
        }
        public RepositoryCatalogData build() {
            final var o = new RepositoryCatalogData();
            o.aboutText = aboutText;
            o.architectures = architectures;
            o.description = description;
            o.logoImageBlob = logoImageBlob;
            o.operatingSystems = operatingSystems;
            o.usageText = usageText;
            return o;
        }
    }
}
