// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ecr;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ecr.ReplicationConfigurationArgs;
import com.pulumi.aws.ecr.inputs.ReplicationConfigurationState;
import com.pulumi.aws.ecr.outputs.ReplicationConfigurationReplicationConfiguration;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an Elastic Container Registry Replication Configuration.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionsArgs;
 * import com.pulumi.aws.ecr.ReplicationConfiguration;
 * import com.pulumi.aws.ecr.ReplicationConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 * 
 *         final var exampleRegions = AwsFunctions.getRegions();
 * 
 *         var exampleReplicationConfiguration = new ReplicationConfiguration(&#34;exampleReplicationConfiguration&#34;, ReplicationConfigurationArgs.builder()        
 *             .replicationConfiguration(ReplicationConfigurationReplicationConfigurationArgs.builder()
 *                 .rules(ReplicationConfigurationReplicationConfigurationRuleArgs.builder()
 *                     .destinations(ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder()
 *                         .region(exampleRegions.applyValue(getRegionsResult -&gt; getRegionsResult.names()[0]))
 *                         .registryId(current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ## Multiple Region Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionsArgs;
 * import com.pulumi.aws.ecr.ReplicationConfiguration;
 * import com.pulumi.aws.ecr.ReplicationConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 * 
 *         final var exampleRegions = AwsFunctions.getRegions();
 * 
 *         var exampleReplicationConfiguration = new ReplicationConfiguration(&#34;exampleReplicationConfiguration&#34;, ReplicationConfigurationArgs.builder()        
 *             .replicationConfiguration(ReplicationConfigurationReplicationConfigurationArgs.builder()
 *                 .rules(ReplicationConfigurationReplicationConfigurationRuleArgs.builder()
 *                     .destinations(                    
 *                         ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder()
 *                             .region(exampleRegions.applyValue(getRegionsResult -&gt; getRegionsResult.names()[0]))
 *                             .registryId(current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()))
 *                             .build(),
 *                         ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder()
 *                             .region(exampleRegions.applyValue(getRegionsResult -&gt; getRegionsResult.names()[1]))
 *                             .registryId(current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()))
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Repository Filter Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionsArgs;
 * import com.pulumi.aws.ecr.ReplicationConfiguration;
 * import com.pulumi.aws.ecr.ReplicationConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.ReplicationConfigurationReplicationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 * 
 *         final var exampleRegions = AwsFunctions.getRegions();
 * 
 *         var exampleReplicationConfiguration = new ReplicationConfiguration(&#34;exampleReplicationConfiguration&#34;, ReplicationConfigurationArgs.builder()        
 *             .replicationConfiguration(ReplicationConfigurationReplicationConfigurationArgs.builder()
 *                 .rules(ReplicationConfigurationReplicationConfigurationRuleArgs.builder()
 *                     .destinations(ReplicationConfigurationReplicationConfigurationRuleDestinationArgs.builder()
 *                         .region(exampleRegions.applyValue(getRegionsResult -&gt; getRegionsResult.names()[0]))
 *                         .registryId(current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()))
 *                         .build())
 *                     .repositoryFilters(ReplicationConfigurationReplicationConfigurationRuleRepositoryFilterArgs.builder()
 *                         .filter(&#34;prod-microservice&#34;)
 *                         .filterType(&#34;PREFIX_MATCH&#34;)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import ECR Replication Configuration using the `registry_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ecr/replicationConfiguration:ReplicationConfiguration service 012345678912
 * ```
 * 
 */
@ResourceType(type="aws:ecr/replicationConfiguration:ReplicationConfiguration")
public class ReplicationConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * The account ID of the destination registry to replicate to.
     * 
     */
    @Export(name="registryId", refs={String.class}, tree="[0]")
    private Output<String> registryId;

    /**
     * @return The account ID of the destination registry to replicate to.
     * 
     */
    public Output<String> registryId() {
        return this.registryId;
    }
    /**
     * Replication configuration for a registry. See Replication Configuration.
     * 
     */
    @Export(name="replicationConfiguration", refs={ReplicationConfigurationReplicationConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ ReplicationConfigurationReplicationConfiguration> replicationConfiguration;

    /**
     * @return Replication configuration for a registry. See Replication Configuration.
     * 
     */
    public Output<Optional<ReplicationConfigurationReplicationConfiguration>> replicationConfiguration() {
        return Codegen.optional(this.replicationConfiguration);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ReplicationConfiguration(String name) {
        this(name, ReplicationConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ReplicationConfiguration(String name, @Nullable ReplicationConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ReplicationConfiguration(String name, @Nullable ReplicationConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ecr/replicationConfiguration:ReplicationConfiguration", name, args == null ? ReplicationConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ReplicationConfiguration(String name, Output<String> id, @Nullable ReplicationConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ecr/replicationConfiguration:ReplicationConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ReplicationConfiguration get(String name, Output<String> id, @Nullable ReplicationConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ReplicationConfiguration(name, id, state, options);
    }
}
