// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ecr;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ecr.PullThroughCacheRuleArgs;
import com.pulumi.aws.ecr.inputs.PullThroughCacheRuleState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides an Elastic Container Registry Pull Through Cache Rule.
 * 
 * More information about pull through cache rules, including the set of supported
 * upstream repositories, see [Using pull through cache rules](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html).
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.PullThroughCacheRule;
 * import com.pulumi.aws.ecr.PullThroughCacheRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new PullThroughCacheRule(&#34;example&#34;, PullThroughCacheRuleArgs.builder()        
 *             .ecrRepositoryPrefix(&#34;ecr-public&#34;)
 *             .upstreamRegistryUrl(&#34;public.ecr.aws&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import a pull-through cache rule using the `ecr_repository_prefix`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ecr/pullThroughCacheRule:PullThroughCacheRule example ecr-public
 * ```
 * 
 */
@ResourceType(type="aws:ecr/pullThroughCacheRule:PullThroughCacheRule")
public class PullThroughCacheRule extends com.pulumi.resources.CustomResource {
    /**
     * The repository name prefix to use when caching images from the source registry.
     * 
     */
    @Export(name="ecrRepositoryPrefix", refs={String.class}, tree="[0]")
    private Output<String> ecrRepositoryPrefix;

    /**
     * @return The repository name prefix to use when caching images from the source registry.
     * 
     */
    public Output<String> ecrRepositoryPrefix() {
        return this.ecrRepositoryPrefix;
    }
    /**
     * The registry ID where the repository was created.
     * 
     */
    @Export(name="registryId", refs={String.class}, tree="[0]")
    private Output<String> registryId;

    /**
     * @return The registry ID where the repository was created.
     * 
     */
    public Output<String> registryId() {
        return this.registryId;
    }
    /**
     * The registry URL of the upstream public registry to use as the source.
     * 
     */
    @Export(name="upstreamRegistryUrl", refs={String.class}, tree="[0]")
    private Output<String> upstreamRegistryUrl;

    /**
     * @return The registry URL of the upstream public registry to use as the source.
     * 
     */
    public Output<String> upstreamRegistryUrl() {
        return this.upstreamRegistryUrl;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public PullThroughCacheRule(String name) {
        this(name, PullThroughCacheRuleArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public PullThroughCacheRule(String name, PullThroughCacheRuleArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public PullThroughCacheRule(String name, PullThroughCacheRuleArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ecr/pullThroughCacheRule:PullThroughCacheRule", name, args == null ? PullThroughCacheRuleArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private PullThroughCacheRule(String name, Output<String> id, @Nullable PullThroughCacheRuleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ecr/pullThroughCacheRule:PullThroughCacheRule", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static PullThroughCacheRule get(String name, Output<String> id, @Nullable PullThroughCacheRuleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new PullThroughCacheRule(name, id, state, options);
    }
}
