// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2transitgateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepterArgs;
import com.pulumi.aws.ec2transitgateway.inputs.VpcAttachmentAccepterState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages the accepter&#39;s side of an EC2 Transit Gateway VPC Attachment.
 * 
 * When a cross-account (requester&#39;s AWS account differs from the accepter&#39;s AWS account) EC2 Transit Gateway VPC Attachment
 * is created, an EC2 Transit Gateway VPC Attachment resource is automatically created in the accepter&#39;s account.
 * The requester can use the `aws.ec2transitgateway.VpcAttachment` resource to manage its side of the connection
 * and the accepter can use the `aws.ec2transitgateway.VpcAttachmentAccepter` resource to &#34;adopt&#34; its side of the
 * connection into management.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepter;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachmentAccepter(&#34;example&#34;, VpcAttachmentAccepterArgs.builder()        
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .tags(Map.of(&#34;Name&#34;, &#34;Example cross-account attachment&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_ec2_transit_gateway_vpc_attachment_accepter` using the EC2 Transit Gateway Attachment identifier. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/vpcAttachmentAccepter:VpcAttachmentAccepter example tgw-attach-12345678
 * ```
 * 
 */
@ResourceType(type="aws:ec2transitgateway/vpcAttachmentAccepter:VpcAttachmentAccepter")
public class VpcAttachmentAccepter extends com.pulumi.resources.CustomResource {
    /**
     * Whether Appliance Mode support is enabled. Valid values: `disable`, `enable`.
     * 
     */
    @Export(name="applianceModeSupport", refs={String.class}, tree="[0]")
    private Output<String> applianceModeSupport;

    /**
     * @return Whether Appliance Mode support is enabled. Valid values: `disable`, `enable`.
     * 
     */
    public Output<String> applianceModeSupport() {
        return this.applianceModeSupport;
    }
    /**
     * Whether DNS support is enabled. Valid values: `disable`, `enable`.
     * 
     */
    @Export(name="dnsSupport", refs={String.class}, tree="[0]")
    private Output<String> dnsSupport;

    /**
     * @return Whether DNS support is enabled. Valid values: `disable`, `enable`.
     * 
     */
    public Output<String> dnsSupport() {
        return this.dnsSupport;
    }
    /**
     * Whether IPv6 support is enabled. Valid values: `disable`, `enable`.
     * 
     */
    @Export(name="ipv6Support", refs={String.class}, tree="[0]")
    private Output<String> ipv6Support;

    /**
     * @return Whether IPv6 support is enabled. Valid values: `disable`, `enable`.
     * 
     */
    public Output<String> ipv6Support() {
        return this.ipv6Support;
    }
    /**
     * Identifiers of EC2 Subnets.
     * 
     */
    @Export(name="subnetIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> subnetIds;

    /**
     * @return Identifiers of EC2 Subnets.
     * 
     */
    public Output<List<String>> subnetIds() {
        return this.subnetIds;
    }
    /**
     * Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The ID of the EC2 Transit Gateway Attachment to manage.
     * 
     */
    @Export(name="transitGatewayAttachmentId", refs={String.class}, tree="[0]")
    private Output<String> transitGatewayAttachmentId;

    /**
     * @return The ID of the EC2 Transit Gateway Attachment to manage.
     * 
     */
    public Output<String> transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }
    /**
     * Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. Default value: `true`.
     * 
     */
    @Export(name="transitGatewayDefaultRouteTableAssociation", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> transitGatewayDefaultRouteTableAssociation;

    /**
     * @return Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. Default value: `true`.
     * 
     */
    public Output<Optional<Boolean>> transitGatewayDefaultRouteTableAssociation() {
        return Codegen.optional(this.transitGatewayDefaultRouteTableAssociation);
    }
    /**
     * Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. Default value: `true`.
     * 
     */
    @Export(name="transitGatewayDefaultRouteTablePropagation", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> transitGatewayDefaultRouteTablePropagation;

    /**
     * @return Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. Default value: `true`.
     * 
     */
    public Output<Optional<Boolean>> transitGatewayDefaultRouteTablePropagation() {
        return Codegen.optional(this.transitGatewayDefaultRouteTablePropagation);
    }
    /**
     * Identifier of EC2 Transit Gateway.
     * 
     */
    @Export(name="transitGatewayId", refs={String.class}, tree="[0]")
    private Output<String> transitGatewayId;

    /**
     * @return Identifier of EC2 Transit Gateway.
     * 
     */
    public Output<String> transitGatewayId() {
        return this.transitGatewayId;
    }
    /**
     * Identifier of EC2 VPC.
     * 
     */
    @Export(name="vpcId", refs={String.class}, tree="[0]")
    private Output<String> vpcId;

    /**
     * @return Identifier of EC2 VPC.
     * 
     */
    public Output<String> vpcId() {
        return this.vpcId;
    }
    /**
     * Identifier of the AWS account that owns the EC2 VPC.
     * 
     */
    @Export(name="vpcOwnerId", refs={String.class}, tree="[0]")
    private Output<String> vpcOwnerId;

    /**
     * @return Identifier of the AWS account that owns the EC2 VPC.
     * 
     */
    public Output<String> vpcOwnerId() {
        return this.vpcOwnerId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VpcAttachmentAccepter(String name) {
        this(name, VpcAttachmentAccepterArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VpcAttachmentAccepter(String name, VpcAttachmentAccepterArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VpcAttachmentAccepter(String name, VpcAttachmentAccepterArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2transitgateway/vpcAttachmentAccepter:VpcAttachmentAccepter", name, args == null ? VpcAttachmentAccepterArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VpcAttachmentAccepter(String name, Output<String> id, @Nullable VpcAttachmentAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2transitgateway/vpcAttachmentAccepter:VpcAttachmentAccepter", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VpcAttachmentAccepter get(String name, Output<String> id, @Nullable VpcAttachmentAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VpcAttachmentAccepter(name, id, state, options);
    }
}
