// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2transitgateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs;
import com.pulumi.aws.ec2transitgateway.inputs.RouteTableAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an EC2 Transit Gateway Route Table association.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.RouteTableAssociation;
 * import com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new RouteTableAssociation(&#34;example&#34;, RouteTableAssociationArgs.builder()        
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway_route_table.example().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_ec2_transit_gateway_route_table_association` using the EC2 Transit Gateway Route Table identifier, an underscore, and the EC2 Transit Gateway Attachment identifier. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/routeTableAssociation:RouteTableAssociation example tgw-rtb-12345678_tgw-attach-87654321
 * ```
 * 
 */
@ResourceType(type="aws:ec2transitgateway/routeTableAssociation:RouteTableAssociation")
public class RouteTableAssociation extends com.pulumi.resources.CustomResource {
    /**
     * Boolean whether the Gateway Attachment should remove any current Route Table association before associating with the specified Route Table. Default value: `false`. This argument is intended for use with EC2 Transit Gateways shared into the current account, otherwise the `transit_gateway_default_route_table_association` argument of the `aws.ec2transitgateway.VpcAttachment` resource should be used.
     * 
     */
    @Export(name="replaceExistingAssociation", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> replaceExistingAssociation;

    /**
     * @return Boolean whether the Gateway Attachment should remove any current Route Table association before associating with the specified Route Table. Default value: `false`. This argument is intended for use with EC2 Transit Gateways shared into the current account, otherwise the `transit_gateway_default_route_table_association` argument of the `aws.ec2transitgateway.VpcAttachment` resource should be used.
     * 
     */
    public Output<Optional<Boolean>> replaceExistingAssociation() {
        return Codegen.optional(this.replaceExistingAssociation);
    }
    /**
     * Identifier of the resource
     * 
     */
    @Export(name="resourceId", refs={String.class}, tree="[0]")
    private Output<String> resourceId;

    /**
     * @return Identifier of the resource
     * 
     */
    public Output<String> resourceId() {
        return this.resourceId;
    }
    /**
     * Type of the resource
     * 
     */
    @Export(name="resourceType", refs={String.class}, tree="[0]")
    private Output<String> resourceType;

    /**
     * @return Type of the resource
     * 
     */
    public Output<String> resourceType() {
        return this.resourceType;
    }
    /**
     * Identifier of EC2 Transit Gateway Attachment.
     * 
     */
    @Export(name="transitGatewayAttachmentId", refs={String.class}, tree="[0]")
    private Output<String> transitGatewayAttachmentId;

    /**
     * @return Identifier of EC2 Transit Gateway Attachment.
     * 
     */
    public Output<String> transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }
    /**
     * Identifier of EC2 Transit Gateway Route Table.
     * 
     */
    @Export(name="transitGatewayRouteTableId", refs={String.class}, tree="[0]")
    private Output<String> transitGatewayRouteTableId;

    /**
     * @return Identifier of EC2 Transit Gateway Route Table.
     * 
     */
    public Output<String> transitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public RouteTableAssociation(String name) {
        this(name, RouteTableAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public RouteTableAssociation(String name, RouteTableAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public RouteTableAssociation(String name, RouteTableAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2transitgateway/routeTableAssociation:RouteTableAssociation", name, args == null ? RouteTableAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private RouteTableAssociation(String name, Output<String> id, @Nullable RouteTableAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2transitgateway/routeTableAssociation:RouteTableAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static RouteTableAssociation get(String name, Output<String> id, @Nullable RouteTableAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new RouteTableAssociation(name, id, state, options);
    }
}
