// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2transitgateway;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs;
import com.pulumi.aws.ec2transitgateway.inputs.PrefixListReferenceState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages an EC2 Transit Gateway Prefix List Reference.
 * 
 * ## Example Usage
 * ### Attachment Routing
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReference;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new PrefixListReference(&#34;example&#34;, PrefixListReferenceArgs.builder()        
 *             .prefixListId(aws_ec2_managed_prefix_list.example().id())
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway.example().association_default_route_table_id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Blackhole Routing
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReference;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new PrefixListReference(&#34;example&#34;, PrefixListReferenceArgs.builder()        
 *             .blackhole(true)
 *             .prefixListId(aws_ec2_managed_prefix_list.example().id())
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway.example().association_default_route_table_id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_ec2_transit_gateway_prefix_list_reference` using the EC2 Transit Gateway Route Table identifier and EC2 Prefix List identifier, separated by an underscore (`_`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/prefixListReference:PrefixListReference example tgw-rtb-12345678_pl-12345678
 * ```
 * 
 */
@ResourceType(type="aws:ec2transitgateway/prefixListReference:PrefixListReference")
public class PrefixListReference extends com.pulumi.resources.CustomResource {
    /**
     * Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
     * 
     */
    @Export(name="blackhole", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> blackhole;

    /**
     * @return Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> blackhole() {
        return Codegen.optional(this.blackhole);
    }
    /**
     * Identifier of EC2 Prefix List.
     * 
     */
    @Export(name="prefixListId", refs={String.class}, tree="[0]")
    private Output<String> prefixListId;

    /**
     * @return Identifier of EC2 Prefix List.
     * 
     */
    public Output<String> prefixListId() {
        return this.prefixListId;
    }
    @Export(name="prefixListOwnerId", refs={String.class}, tree="[0]")
    private Output<String> prefixListOwnerId;

    public Output<String> prefixListOwnerId() {
        return this.prefixListOwnerId;
    }
    /**
     * Identifier of EC2 Transit Gateway Attachment.
     * 
     */
    @Export(name="transitGatewayAttachmentId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> transitGatewayAttachmentId;

    /**
     * @return Identifier of EC2 Transit Gateway Attachment.
     * 
     */
    public Output<Optional<String>> transitGatewayAttachmentId() {
        return Codegen.optional(this.transitGatewayAttachmentId);
    }
    /**
     * Identifier of EC2 Transit Gateway Route Table.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="transitGatewayRouteTableId", refs={String.class}, tree="[0]")
    private Output<String> transitGatewayRouteTableId;

    /**
     * @return Identifier of EC2 Transit Gateway Route Table.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> transitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public PrefixListReference(String name) {
        this(name, PrefixListReferenceArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public PrefixListReference(String name, PrefixListReferenceArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public PrefixListReference(String name, PrefixListReferenceArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2transitgateway/prefixListReference:PrefixListReference", name, args == null ? PrefixListReferenceArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private PrefixListReference(String name, Output<String> id, @Nullable PrefixListReferenceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2transitgateway/prefixListReference:PrefixListReference", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static PrefixListReference get(String name, Output<String> id, @Nullable PrefixListReferenceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new PrefixListReference(name, id, state, options);
    }
}
