// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2transitgateway;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ConnectPeerArgs extends com.pulumi.resources.ResourceArgs {

    public static final ConnectPeerArgs Empty = new ConnectPeerArgs();

    /**
     * The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
     * 
     */
    @Import(name="bgpAsn")
    private @Nullable Output<String> bgpAsn;

    /**
     * @return The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
     * 
     */
    public Optional<Output<String>> bgpAsn() {
        return Optional.ofNullable(this.bgpAsn);
    }

    /**
     * The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     * 
     */
    @Import(name="insideCidrBlocks", required=true)
    private Output<List<String>> insideCidrBlocks;

    /**
     * @return The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     * 
     */
    public Output<List<String>> insideCidrBlocks() {
        return this.insideCidrBlocks;
    }

    /**
     * The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
     * 
     */
    @Import(name="peerAddress", required=true)
    private Output<String> peerAddress;

    /**
     * @return The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
     * 
     */
    public Output<String> peerAddress() {
        return this.peerAddress;
    }

    /**
     * Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
     * 
     */
    @Import(name="transitGatewayAddress")
    private @Nullable Output<String> transitGatewayAddress;

    /**
     * @return The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
     * 
     */
    public Optional<Output<String>> transitGatewayAddress() {
        return Optional.ofNullable(this.transitGatewayAddress);
    }

    /**
     * The Transit Gateway Connect
     * 
     */
    @Import(name="transitGatewayAttachmentId", required=true)
    private Output<String> transitGatewayAttachmentId;

    /**
     * @return The Transit Gateway Connect
     * 
     */
    public Output<String> transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    private ConnectPeerArgs() {}

    private ConnectPeerArgs(ConnectPeerArgs $) {
        this.bgpAsn = $.bgpAsn;
        this.insideCidrBlocks = $.insideCidrBlocks;
        this.peerAddress = $.peerAddress;
        this.tags = $.tags;
        this.transitGatewayAddress = $.transitGatewayAddress;
        this.transitGatewayAttachmentId = $.transitGatewayAttachmentId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ConnectPeerArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ConnectPeerArgs $;

        public Builder() {
            $ = new ConnectPeerArgs();
        }

        public Builder(ConnectPeerArgs defaults) {
            $ = new ConnectPeerArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param bgpAsn The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
         * 
         * @return builder
         * 
         */
        public Builder bgpAsn(@Nullable Output<String> bgpAsn) {
            $.bgpAsn = bgpAsn;
            return this;
        }

        /**
         * @param bgpAsn The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
         * 
         * @return builder
         * 
         */
        public Builder bgpAsn(String bgpAsn) {
            return bgpAsn(Output.of(bgpAsn));
        }

        /**
         * @param insideCidrBlocks The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
         * 
         * @return builder
         * 
         */
        public Builder insideCidrBlocks(Output<List<String>> insideCidrBlocks) {
            $.insideCidrBlocks = insideCidrBlocks;
            return this;
        }

        /**
         * @param insideCidrBlocks The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
         * 
         * @return builder
         * 
         */
        public Builder insideCidrBlocks(List<String> insideCidrBlocks) {
            return insideCidrBlocks(Output.of(insideCidrBlocks));
        }

        /**
         * @param insideCidrBlocks The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
         * 
         * @return builder
         * 
         */
        public Builder insideCidrBlocks(String... insideCidrBlocks) {
            return insideCidrBlocks(List.of(insideCidrBlocks));
        }

        /**
         * @param peerAddress The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
         * 
         * @return builder
         * 
         */
        public Builder peerAddress(Output<String> peerAddress) {
            $.peerAddress = peerAddress;
            return this;
        }

        /**
         * @param peerAddress The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
         * 
         * @return builder
         * 
         */
        public Builder peerAddress(String peerAddress) {
            return peerAddress(Output.of(peerAddress));
        }

        /**
         * @param tags Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param transitGatewayAddress The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
         * 
         * @return builder
         * 
         */
        public Builder transitGatewayAddress(@Nullable Output<String> transitGatewayAddress) {
            $.transitGatewayAddress = transitGatewayAddress;
            return this;
        }

        /**
         * @param transitGatewayAddress The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
         * 
         * @return builder
         * 
         */
        public Builder transitGatewayAddress(String transitGatewayAddress) {
            return transitGatewayAddress(Output.of(transitGatewayAddress));
        }

        /**
         * @param transitGatewayAttachmentId The Transit Gateway Connect
         * 
         * @return builder
         * 
         */
        public Builder transitGatewayAttachmentId(Output<String> transitGatewayAttachmentId) {
            $.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        /**
         * @param transitGatewayAttachmentId The Transit Gateway Connect
         * 
         * @return builder
         * 
         */
        public Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            return transitGatewayAttachmentId(Output.of(transitGatewayAttachmentId));
        }

        public ConnectPeerArgs build() {
            $.insideCidrBlocks = Objects.requireNonNull($.insideCidrBlocks, "expected parameter 'insideCidrBlocks' to be non-null");
            $.peerAddress = Objects.requireNonNull($.peerAddress, "expected parameter 'peerAddress' to be non-null");
            $.transitGatewayAttachmentId = Objects.requireNonNull($.transitGatewayAttachmentId, "expected parameter 'transitGatewayAttachmentId' to be non-null");
            return $;
        }
    }

}
