// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2clientvpn.inputs;

import com.pulumi.aws.ec2clientvpn.inputs.EndpointAuthenticationOptionArgs;
import com.pulumi.aws.ec2clientvpn.inputs.EndpointClientConnectOptionsArgs;
import com.pulumi.aws.ec2clientvpn.inputs.EndpointClientLoginBannerOptionsArgs;
import com.pulumi.aws.ec2clientvpn.inputs.EndpointConnectionLogOptionsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class EndpointState extends com.pulumi.resources.ResourceArgs {

    public static final EndpointState Empty = new EndpointState();

    /**
     * The ARN of the Client VPN endpoint.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return The ARN of the Client VPN endpoint.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Information about the authentication method to be used to authenticate clients.
     * 
     */
    @Import(name="authenticationOptions")
    private @Nullable Output<List<EndpointAuthenticationOptionArgs>> authenticationOptions;

    /**
     * @return Information about the authentication method to be used to authenticate clients.
     * 
     */
    public Optional<Output<List<EndpointAuthenticationOptionArgs>>> authenticationOptions() {
        return Optional.ofNullable(this.authenticationOptions);
    }

    /**
     * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     * 
     */
    @Import(name="clientCidrBlock")
    private @Nullable Output<String> clientCidrBlock;

    /**
     * @return The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     * 
     */
    public Optional<Output<String>> clientCidrBlock() {
        return Optional.ofNullable(this.clientCidrBlock);
    }

    /**
     * The options for managing connection authorization for new client connections.
     * 
     */
    @Import(name="clientConnectOptions")
    private @Nullable Output<EndpointClientConnectOptionsArgs> clientConnectOptions;

    /**
     * @return The options for managing connection authorization for new client connections.
     * 
     */
    public Optional<Output<EndpointClientConnectOptionsArgs>> clientConnectOptions() {
        return Optional.ofNullable(this.clientConnectOptions);
    }

    /**
     * Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     * 
     */
    @Import(name="clientLoginBannerOptions")
    private @Nullable Output<EndpointClientLoginBannerOptionsArgs> clientLoginBannerOptions;

    /**
     * @return Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     * 
     */
    public Optional<Output<EndpointClientLoginBannerOptionsArgs>> clientLoginBannerOptions() {
        return Optional.ofNullable(this.clientLoginBannerOptions);
    }

    /**
     * Information about the client connection logging options.
     * 
     */
    @Import(name="connectionLogOptions")
    private @Nullable Output<EndpointConnectionLogOptionsArgs> connectionLogOptions;

    /**
     * @return Information about the client connection logging options.
     * 
     */
    public Optional<Output<EndpointConnectionLogOptionsArgs>> connectionLogOptions() {
        return Optional.ofNullable(this.connectionLogOptions);
    }

    /**
     * A brief description of the Client VPN endpoint.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A brief description of the Client VPN endpoint.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The DNS name to be used by clients when establishing their VPN session.
     * 
     */
    @Import(name="dnsName")
    private @Nullable Output<String> dnsName;

    /**
     * @return The DNS name to be used by clients when establishing their VPN session.
     * 
     */
    public Optional<Output<String>> dnsName() {
        return Optional.ofNullable(this.dnsName);
    }

    /**
     * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     * 
     */
    @Import(name="dnsServers")
    private @Nullable Output<List<String>> dnsServers;

    /**
     * @return Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
     * 
     */
    public Optional<Output<List<String>>> dnsServers() {
        return Optional.ofNullable(this.dnsServers);
    }

    /**
     * The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     * 
     */
    @Import(name="securityGroupIds")
    private @Nullable Output<List<String>> securityGroupIds;

    /**
     * @return The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
     * 
     */
    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    /**
     * Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
     * 
     */
    @Import(name="selfServicePortal")
    private @Nullable Output<String> selfServicePortal;

    /**
     * @return Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
     * 
     */
    public Optional<Output<String>> selfServicePortal() {
        return Optional.ofNullable(this.selfServicePortal);
    }

    /**
     * The ARN of the ACM server certificate.
     * 
     */
    @Import(name="serverCertificateArn")
    private @Nullable Output<String> serverCertificateArn;

    /**
     * @return The ARN of the ACM server certificate.
     * 
     */
    public Optional<Output<String>> serverCertificateArn() {
        return Optional.ofNullable(this.serverCertificateArn);
    }

    /**
     * The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
     * 
     */
    @Import(name="sessionTimeoutHours")
    private @Nullable Output<Integer> sessionTimeoutHours;

    /**
     * @return The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
     * 
     */
    public Optional<Output<Integer>> sessionTimeoutHours() {
        return Optional.ofNullable(this.sessionTimeoutHours);
    }

    /**
     * Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
     * 
     */
    @Import(name="splitTunnel")
    private @Nullable Output<Boolean> splitTunnel;

    /**
     * @return Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
     * 
     */
    public Optional<Output<Boolean>> splitTunnel() {
        return Optional.ofNullable(this.splitTunnel);
    }

    /**
     * A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * The transport protocol to be used by the VPN session. Default value is `udp`.
     * 
     */
    @Import(name="transportProtocol")
    private @Nullable Output<String> transportProtocol;

    /**
     * @return The transport protocol to be used by the VPN session. Default value is `udp`.
     * 
     */
    public Optional<Output<String>> transportProtocol() {
        return Optional.ofNullable(this.transportProtocol);
    }

    /**
     * The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
     * 
     */
    @Import(name="vpcId")
    private @Nullable Output<String> vpcId;

    /**
     * @return The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
     * 
     */
    public Optional<Output<String>> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    /**
     * The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
     * 
     */
    @Import(name="vpnPort")
    private @Nullable Output<Integer> vpnPort;

    /**
     * @return The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
     * 
     */
    public Optional<Output<Integer>> vpnPort() {
        return Optional.ofNullable(this.vpnPort);
    }

    private EndpointState() {}

    private EndpointState(EndpointState $) {
        this.arn = $.arn;
        this.authenticationOptions = $.authenticationOptions;
        this.clientCidrBlock = $.clientCidrBlock;
        this.clientConnectOptions = $.clientConnectOptions;
        this.clientLoginBannerOptions = $.clientLoginBannerOptions;
        this.connectionLogOptions = $.connectionLogOptions;
        this.description = $.description;
        this.dnsName = $.dnsName;
        this.dnsServers = $.dnsServers;
        this.securityGroupIds = $.securityGroupIds;
        this.selfServicePortal = $.selfServicePortal;
        this.serverCertificateArn = $.serverCertificateArn;
        this.sessionTimeoutHours = $.sessionTimeoutHours;
        this.splitTunnel = $.splitTunnel;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.transportProtocol = $.transportProtocol;
        this.vpcId = $.vpcId;
        this.vpnPort = $.vpnPort;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EndpointState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointState $;

        public Builder() {
            $ = new EndpointState();
        }

        public Builder(EndpointState defaults) {
            $ = new EndpointState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn The ARN of the Client VPN endpoint.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn The ARN of the Client VPN endpoint.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param authenticationOptions Information about the authentication method to be used to authenticate clients.
         * 
         * @return builder
         * 
         */
        public Builder authenticationOptions(@Nullable Output<List<EndpointAuthenticationOptionArgs>> authenticationOptions) {
            $.authenticationOptions = authenticationOptions;
            return this;
        }

        /**
         * @param authenticationOptions Information about the authentication method to be used to authenticate clients.
         * 
         * @return builder
         * 
         */
        public Builder authenticationOptions(List<EndpointAuthenticationOptionArgs> authenticationOptions) {
            return authenticationOptions(Output.of(authenticationOptions));
        }

        /**
         * @param authenticationOptions Information about the authentication method to be used to authenticate clients.
         * 
         * @return builder
         * 
         */
        public Builder authenticationOptions(EndpointAuthenticationOptionArgs... authenticationOptions) {
            return authenticationOptions(List.of(authenticationOptions));
        }

        /**
         * @param clientCidrBlock The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
         * 
         * @return builder
         * 
         */
        public Builder clientCidrBlock(@Nullable Output<String> clientCidrBlock) {
            $.clientCidrBlock = clientCidrBlock;
            return this;
        }

        /**
         * @param clientCidrBlock The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
         * 
         * @return builder
         * 
         */
        public Builder clientCidrBlock(String clientCidrBlock) {
            return clientCidrBlock(Output.of(clientCidrBlock));
        }

        /**
         * @param clientConnectOptions The options for managing connection authorization for new client connections.
         * 
         * @return builder
         * 
         */
        public Builder clientConnectOptions(@Nullable Output<EndpointClientConnectOptionsArgs> clientConnectOptions) {
            $.clientConnectOptions = clientConnectOptions;
            return this;
        }

        /**
         * @param clientConnectOptions The options for managing connection authorization for new client connections.
         * 
         * @return builder
         * 
         */
        public Builder clientConnectOptions(EndpointClientConnectOptionsArgs clientConnectOptions) {
            return clientConnectOptions(Output.of(clientConnectOptions));
        }

        /**
         * @param clientLoginBannerOptions Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
         * 
         * @return builder
         * 
         */
        public Builder clientLoginBannerOptions(@Nullable Output<EndpointClientLoginBannerOptionsArgs> clientLoginBannerOptions) {
            $.clientLoginBannerOptions = clientLoginBannerOptions;
            return this;
        }

        /**
         * @param clientLoginBannerOptions Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
         * 
         * @return builder
         * 
         */
        public Builder clientLoginBannerOptions(EndpointClientLoginBannerOptionsArgs clientLoginBannerOptions) {
            return clientLoginBannerOptions(Output.of(clientLoginBannerOptions));
        }

        /**
         * @param connectionLogOptions Information about the client connection logging options.
         * 
         * @return builder
         * 
         */
        public Builder connectionLogOptions(@Nullable Output<EndpointConnectionLogOptionsArgs> connectionLogOptions) {
            $.connectionLogOptions = connectionLogOptions;
            return this;
        }

        /**
         * @param connectionLogOptions Information about the client connection logging options.
         * 
         * @return builder
         * 
         */
        public Builder connectionLogOptions(EndpointConnectionLogOptionsArgs connectionLogOptions) {
            return connectionLogOptions(Output.of(connectionLogOptions));
        }

        /**
         * @param description A brief description of the Client VPN endpoint.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A brief description of the Client VPN endpoint.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param dnsName The DNS name to be used by clients when establishing their VPN session.
         * 
         * @return builder
         * 
         */
        public Builder dnsName(@Nullable Output<String> dnsName) {
            $.dnsName = dnsName;
            return this;
        }

        /**
         * @param dnsName The DNS name to be used by clients when establishing their VPN session.
         * 
         * @return builder
         * 
         */
        public Builder dnsName(String dnsName) {
            return dnsName(Output.of(dnsName));
        }

        /**
         * @param dnsServers Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
         * 
         * @return builder
         * 
         */
        public Builder dnsServers(@Nullable Output<List<String>> dnsServers) {
            $.dnsServers = dnsServers;
            return this;
        }

        /**
         * @param dnsServers Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
         * 
         * @return builder
         * 
         */
        public Builder dnsServers(List<String> dnsServers) {
            return dnsServers(Output.of(dnsServers));
        }

        /**
         * @param dnsServers Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address of the connecting device is used.
         * 
         * @return builder
         * 
         */
        public Builder dnsServers(String... dnsServers) {
            return dnsServers(List.of(dnsServers));
        }

        /**
         * @param securityGroupIds The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            $.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * @param securityGroupIds The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(List<String> securityGroupIds) {
            return securityGroupIds(Output.of(securityGroupIds));
        }

        /**
         * @param securityGroupIds The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(String... securityGroupIds) {
            return securityGroupIds(List.of(securityGroupIds));
        }

        /**
         * @param selfServicePortal Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
         * 
         * @return builder
         * 
         */
        public Builder selfServicePortal(@Nullable Output<String> selfServicePortal) {
            $.selfServicePortal = selfServicePortal;
            return this;
        }

        /**
         * @param selfServicePortal Specify whether to enable the self-service portal for the Client VPN endpoint. Values can be `enabled` or `disabled`. Default value is `disabled`.
         * 
         * @return builder
         * 
         */
        public Builder selfServicePortal(String selfServicePortal) {
            return selfServicePortal(Output.of(selfServicePortal));
        }

        /**
         * @param serverCertificateArn The ARN of the ACM server certificate.
         * 
         * @return builder
         * 
         */
        public Builder serverCertificateArn(@Nullable Output<String> serverCertificateArn) {
            $.serverCertificateArn = serverCertificateArn;
            return this;
        }

        /**
         * @param serverCertificateArn The ARN of the ACM server certificate.
         * 
         * @return builder
         * 
         */
        public Builder serverCertificateArn(String serverCertificateArn) {
            return serverCertificateArn(Output.of(serverCertificateArn));
        }

        /**
         * @param sessionTimeoutHours The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
         * 
         * @return builder
         * 
         */
        public Builder sessionTimeoutHours(@Nullable Output<Integer> sessionTimeoutHours) {
            $.sessionTimeoutHours = sessionTimeoutHours;
            return this;
        }

        /**
         * @param sessionTimeoutHours The maximum session duration is a trigger by which end-users are required to re-authenticate prior to establishing a VPN session. Default value is `24` - Valid values: `8 | 10 | 12 | 24`
         * 
         * @return builder
         * 
         */
        public Builder sessionTimeoutHours(Integer sessionTimeoutHours) {
            return sessionTimeoutHours(Output.of(sessionTimeoutHours));
        }

        /**
         * @param splitTunnel Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
         * 
         * @return builder
         * 
         */
        public Builder splitTunnel(@Nullable Output<Boolean> splitTunnel) {
            $.splitTunnel = splitTunnel;
            return this;
        }

        /**
         * @param splitTunnel Indicates whether split-tunnel is enabled on VPN endpoint. Default value is `false`.
         * 
         * @return builder
         * 
         */
        public Builder splitTunnel(Boolean splitTunnel) {
            return splitTunnel(Output.of(splitTunnel));
        }

        /**
         * @param tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param transportProtocol The transport protocol to be used by the VPN session. Default value is `udp`.
         * 
         * @return builder
         * 
         */
        public Builder transportProtocol(@Nullable Output<String> transportProtocol) {
            $.transportProtocol = transportProtocol;
            return this;
        }

        /**
         * @param transportProtocol The transport protocol to be used by the VPN session. Default value is `udp`.
         * 
         * @return builder
         * 
         */
        public Builder transportProtocol(String transportProtocol) {
            return transportProtocol(Output.of(transportProtocol));
        }

        /**
         * @param vpcId The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(@Nullable Output<String> vpcId) {
            $.vpcId = vpcId;
            return this;
        }

        /**
         * @param vpcId The ID of the VPC to associate with the Client VPN endpoint. If no security group IDs are specified in the request, the default security group for the VPC is applied.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(String vpcId) {
            return vpcId(Output.of(vpcId));
        }

        /**
         * @param vpnPort The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
         * 
         * @return builder
         * 
         */
        public Builder vpnPort(@Nullable Output<Integer> vpnPort) {
            $.vpnPort = vpnPort;
            return this;
        }

        /**
         * @param vpnPort The port number for the Client VPN endpoint. Valid values are `443` and `1194`. Default value is `443`.
         * 
         * @return builder
         * 
         */
        public Builder vpnPort(Integer vpnPort) {
            return vpnPort(Output.of(vpnPort));
        }

        public EndpointState build() {
            return $;
        }
    }

}
