// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2.outputs;

import com.pulumi.aws.ec2.outputs.GetInstanceCreditSpecification;
import com.pulumi.aws.ec2.outputs.GetInstanceEbsBlockDevice;
import com.pulumi.aws.ec2.outputs.GetInstanceEnclaveOption;
import com.pulumi.aws.ec2.outputs.GetInstanceEphemeralBlockDevice;
import com.pulumi.aws.ec2.outputs.GetInstanceFilter;
import com.pulumi.aws.ec2.outputs.GetInstanceMaintenanceOption;
import com.pulumi.aws.ec2.outputs.GetInstanceMetadataOption;
import com.pulumi.aws.ec2.outputs.GetInstancePrivateDnsNameOption;
import com.pulumi.aws.ec2.outputs.GetInstanceRootBlockDevice;
import com.pulumi.core.annotations.CustomType;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetInstanceResult {
    /**
     * @return ID of the AMI used to launch the instance.
     * 
     */
    private String ami;
    /**
     * @return ARN of the instance.
     * 
     */
    private String arn;
    /**
     * @return Whether or not the Instance is associated with a public IP address or not (Boolean).
     * 
     */
    private Boolean associatePublicIpAddress;
    /**
     * @return Availability zone of the Instance.
     * 
     */
    private String availabilityZone;
    /**
     * @return Credit specification of the Instance.
     * 
     */
    private List<GetInstanceCreditSpecification> creditSpecifications;
    /**
     * @return Whether or not EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection) is enabled (Boolean).
     * 
     */
    private Boolean disableApiStop;
    /**
     * @return Whether or not [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination) is enabled (Boolean).
     * 
     */
    private Boolean disableApiTermination;
    /**
     * @return EBS block device mappings of the Instance.
     * 
     */
    private List<GetInstanceEbsBlockDevice> ebsBlockDevices;
    /**
     * @return Whether the Instance is EBS optimized or not (Boolean).
     * 
     */
    private Boolean ebsOptimized;
    /**
     * @return Enclave options of the instance.
     * 
     */
    private List<GetInstanceEnclaveOption> enclaveOptions;
    /**
     * @return Ephemeral block device mappings of the Instance.
     * 
     */
    private List<GetInstanceEphemeralBlockDevice> ephemeralBlockDevices;
    private @Nullable List<GetInstanceFilter> filters;
    private @Nullable Boolean getPasswordData;
    private @Nullable Boolean getUserData;
    /**
     * @return ID of the dedicated host the instance will be assigned to.
     * 
     */
    private String hostId;
    /**
     * @return ARN of the host resource group the instance is associated with.
     * 
     */
    private String hostResourceGroupArn;
    /**
     * @return Name of the instance profile associated with the Instance.
     * 
     */
    private String iamInstanceProfile;
    /**
     * @return The provider-assigned unique ID for this managed resource.
     * 
     */
    private String id;
    private @Nullable String instanceId;
    /**
     * @return State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
     * 
     */
    private String instanceState;
    private Map<String,String> instanceTags;
    /**
     * @return Type of the Instance.
     * 
     */
    private String instanceType;
    /**
     * @return IPv6 addresses associated to the Instance, if applicable. **NOTE**: Unlike the IPv4 address, this doesn&#39;t change if you attach an EIP to the instance.
     * 
     */
    private List<String> ipv6Addresses;
    /**
     * @return Key name of the Instance.
     * 
     */
    private String keyName;
    /**
     * @return Maintenance and recovery options for the instance.
     * 
     */
    private List<GetInstanceMaintenanceOption> maintenanceOptions;
    /**
     * @return Metadata options of the Instance.
     * 
     */
    private List<GetInstanceMetadataOption> metadataOptions;
    /**
     * @return Whether detailed monitoring is enabled or disabled for the Instance (Boolean).
     * 
     */
    private Boolean monitoring;
    /**
     * @return ID of the network interface that was created with the Instance.
     * 
     */
    private String networkInterfaceId;
    /**
     * @return ARN of the Outpost.
     * 
     */
    private String outpostArn;
    /**
     * @return Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    private String passwordData;
    /**
     * @return Placement group of the Instance.
     * 
     */
    private String placementGroup;
    /**
     * @return Number of the partition the instance is in.
     * 
     */
    private Integer placementPartitionNumber;
    /**
     * @return Private DNS name assigned to the Instance. Can only be used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames for your VPC.
     * 
     */
    private String privateDns;
    /**
     * @return Options for the instance hostname.
     * 
     */
    private List<GetInstancePrivateDnsNameOption> privateDnsNameOptions;
    /**
     * @return Private IP address assigned to the Instance.
     * 
     */
    private String privateIp;
    /**
     * @return Public DNS name assigned to the Instance. For EC2-VPC, this is only available if you&#39;ve enabled DNS hostnames for your VPC.
     * 
     */
    private String publicDns;
    /**
     * @return Public IP address assigned to the Instance, if applicable. **NOTE**: If you are using an `aws.ec2.Eip` with your instance, you should refer to the EIP&#39;s address directly and not use `public_ip`, as this field will change after the EIP is attached.
     * 
     */
    private String publicIp;
    /**
     * @return Root block device mappings of the Instance
     * 
     */
    private List<GetInstanceRootBlockDevice> rootBlockDevices;
    /**
     * @return Secondary private IPv4 addresses assigned to the instance&#39;s primary network interface (eth0) in a VPC.
     * 
     */
    private List<String> secondaryPrivateIps;
    /**
     * @return Associated security groups.
     * 
     */
    private List<String> securityGroups;
    /**
     * @return Whether the network interface performs source/destination checking (Boolean).
     * 
     */
    private Boolean sourceDestCheck;
    /**
     * @return VPC subnet ID.
     * 
     */
    private String subnetId;
    /**
     * @return Map of tags assigned to the Instance.
     * 
     */
    private Map<String,String> tags;
    /**
     * @return Tenancy of the instance: `dedicated`, `default`, `host`.
     * 
     */
    private String tenancy;
    /**
     * @return SHA-1 hash of User Data supplied to the Instance.
     * 
     */
    private String userData;
    /**
     * @return Base64 encoded contents of User Data supplied to the Instance. This attribute is only exported if `get_user_data` is true.
     * 
     */
    private String userDataBase64;
    /**
     * @return Associated security groups in a non-default VPC.
     * 
     */
    private List<String> vpcSecurityGroupIds;

    private GetInstanceResult() {}
    /**
     * @return ID of the AMI used to launch the instance.
     * 
     */
    public String ami() {
        return this.ami;
    }
    /**
     * @return ARN of the instance.
     * 
     */
    public String arn() {
        return this.arn;
    }
    /**
     * @return Whether or not the Instance is associated with a public IP address or not (Boolean).
     * 
     */
    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }
    /**
     * @return Availability zone of the Instance.
     * 
     */
    public String availabilityZone() {
        return this.availabilityZone;
    }
    /**
     * @return Credit specification of the Instance.
     * 
     */
    public List<GetInstanceCreditSpecification> creditSpecifications() {
        return this.creditSpecifications;
    }
    /**
     * @return Whether or not EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection) is enabled (Boolean).
     * 
     */
    public Boolean disableApiStop() {
        return this.disableApiStop;
    }
    /**
     * @return Whether or not [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination) is enabled (Boolean).
     * 
     */
    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }
    /**
     * @return EBS block device mappings of the Instance.
     * 
     */
    public List<GetInstanceEbsBlockDevice> ebsBlockDevices() {
        return this.ebsBlockDevices;
    }
    /**
     * @return Whether the Instance is EBS optimized or not (Boolean).
     * 
     */
    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }
    /**
     * @return Enclave options of the instance.
     * 
     */
    public List<GetInstanceEnclaveOption> enclaveOptions() {
        return this.enclaveOptions;
    }
    /**
     * @return Ephemeral block device mappings of the Instance.
     * 
     */
    public List<GetInstanceEphemeralBlockDevice> ephemeralBlockDevices() {
        return this.ephemeralBlockDevices;
    }
    public List<GetInstanceFilter> filters() {
        return this.filters == null ? List.of() : this.filters;
    }
    public Optional<Boolean> getPasswordData() {
        return Optional.ofNullable(this.getPasswordData);
    }
    public Optional<Boolean> getUserData() {
        return Optional.ofNullable(this.getUserData);
    }
    /**
     * @return ID of the dedicated host the instance will be assigned to.
     * 
     */
    public String hostId() {
        return this.hostId;
    }
    /**
     * @return ARN of the host resource group the instance is associated with.
     * 
     */
    public String hostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }
    /**
     * @return Name of the instance profile associated with the Instance.
     * 
     */
    public String iamInstanceProfile() {
        return this.iamInstanceProfile;
    }
    /**
     * @return The provider-assigned unique ID for this managed resource.
     * 
     */
    public String id() {
        return this.id;
    }
    public Optional<String> instanceId() {
        return Optional.ofNullable(this.instanceId);
    }
    /**
     * @return State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
     * 
     */
    public String instanceState() {
        return this.instanceState;
    }
    public Map<String,String> instanceTags() {
        return this.instanceTags;
    }
    /**
     * @return Type of the Instance.
     * 
     */
    public String instanceType() {
        return this.instanceType;
    }
    /**
     * @return IPv6 addresses associated to the Instance, if applicable. **NOTE**: Unlike the IPv4 address, this doesn&#39;t change if you attach an EIP to the instance.
     * 
     */
    public List<String> ipv6Addresses() {
        return this.ipv6Addresses;
    }
    /**
     * @return Key name of the Instance.
     * 
     */
    public String keyName() {
        return this.keyName;
    }
    /**
     * @return Maintenance and recovery options for the instance.
     * 
     */
    public List<GetInstanceMaintenanceOption> maintenanceOptions() {
        return this.maintenanceOptions;
    }
    /**
     * @return Metadata options of the Instance.
     * 
     */
    public List<GetInstanceMetadataOption> metadataOptions() {
        return this.metadataOptions;
    }
    /**
     * @return Whether detailed monitoring is enabled or disabled for the Instance (Boolean).
     * 
     */
    public Boolean monitoring() {
        return this.monitoring;
    }
    /**
     * @return ID of the network interface that was created with the Instance.
     * 
     */
    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }
    /**
     * @return ARN of the Outpost.
     * 
     */
    public String outpostArn() {
        return this.outpostArn;
    }
    /**
     * @return Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    public String passwordData() {
        return this.passwordData;
    }
    /**
     * @return Placement group of the Instance.
     * 
     */
    public String placementGroup() {
        return this.placementGroup;
    }
    /**
     * @return Number of the partition the instance is in.
     * 
     */
    public Integer placementPartitionNumber() {
        return this.placementPartitionNumber;
    }
    /**
     * @return Private DNS name assigned to the Instance. Can only be used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames for your VPC.
     * 
     */
    public String privateDns() {
        return this.privateDns;
    }
    /**
     * @return Options for the instance hostname.
     * 
     */
    public List<GetInstancePrivateDnsNameOption> privateDnsNameOptions() {
        return this.privateDnsNameOptions;
    }
    /**
     * @return Private IP address assigned to the Instance.
     * 
     */
    public String privateIp() {
        return this.privateIp;
    }
    /**
     * @return Public DNS name assigned to the Instance. For EC2-VPC, this is only available if you&#39;ve enabled DNS hostnames for your VPC.
     * 
     */
    public String publicDns() {
        return this.publicDns;
    }
    /**
     * @return Public IP address assigned to the Instance, if applicable. **NOTE**: If you are using an `aws.ec2.Eip` with your instance, you should refer to the EIP&#39;s address directly and not use `public_ip`, as this field will change after the EIP is attached.
     * 
     */
    public String publicIp() {
        return this.publicIp;
    }
    /**
     * @return Root block device mappings of the Instance
     * 
     */
    public List<GetInstanceRootBlockDevice> rootBlockDevices() {
        return this.rootBlockDevices;
    }
    /**
     * @return Secondary private IPv4 addresses assigned to the instance&#39;s primary network interface (eth0) in a VPC.
     * 
     */
    public List<String> secondaryPrivateIps() {
        return this.secondaryPrivateIps;
    }
    /**
     * @return Associated security groups.
     * 
     */
    public List<String> securityGroups() {
        return this.securityGroups;
    }
    /**
     * @return Whether the network interface performs source/destination checking (Boolean).
     * 
     */
    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }
    /**
     * @return VPC subnet ID.
     * 
     */
    public String subnetId() {
        return this.subnetId;
    }
    /**
     * @return Map of tags assigned to the Instance.
     * 
     */
    public Map<String,String> tags() {
        return this.tags;
    }
    /**
     * @return Tenancy of the instance: `dedicated`, `default`, `host`.
     * 
     */
    public String tenancy() {
        return this.tenancy;
    }
    /**
     * @return SHA-1 hash of User Data supplied to the Instance.
     * 
     */
    public String userData() {
        return this.userData;
    }
    /**
     * @return Base64 encoded contents of User Data supplied to the Instance. This attribute is only exported if `get_user_data` is true.
     * 
     */
    public String userDataBase64() {
        return this.userDataBase64;
    }
    /**
     * @return Associated security groups in a non-default VPC.
     * 
     */
    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetInstanceResult defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private String ami;
        private String arn;
        private Boolean associatePublicIpAddress;
        private String availabilityZone;
        private List<GetInstanceCreditSpecification> creditSpecifications;
        private Boolean disableApiStop;
        private Boolean disableApiTermination;
        private List<GetInstanceEbsBlockDevice> ebsBlockDevices;
        private Boolean ebsOptimized;
        private List<GetInstanceEnclaveOption> enclaveOptions;
        private List<GetInstanceEphemeralBlockDevice> ephemeralBlockDevices;
        private @Nullable List<GetInstanceFilter> filters;
        private @Nullable Boolean getPasswordData;
        private @Nullable Boolean getUserData;
        private String hostId;
        private String hostResourceGroupArn;
        private String iamInstanceProfile;
        private String id;
        private @Nullable String instanceId;
        private String instanceState;
        private Map<String,String> instanceTags;
        private String instanceType;
        private List<String> ipv6Addresses;
        private String keyName;
        private List<GetInstanceMaintenanceOption> maintenanceOptions;
        private List<GetInstanceMetadataOption> metadataOptions;
        private Boolean monitoring;
        private String networkInterfaceId;
        private String outpostArn;
        private String passwordData;
        private String placementGroup;
        private Integer placementPartitionNumber;
        private String privateDns;
        private List<GetInstancePrivateDnsNameOption> privateDnsNameOptions;
        private String privateIp;
        private String publicDns;
        private String publicIp;
        private List<GetInstanceRootBlockDevice> rootBlockDevices;
        private List<String> secondaryPrivateIps;
        private List<String> securityGroups;
        private Boolean sourceDestCheck;
        private String subnetId;
        private Map<String,String> tags;
        private String tenancy;
        private String userData;
        private String userDataBase64;
        private List<String> vpcSecurityGroupIds;
        public Builder() {}
        public Builder(GetInstanceResult defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.ami = defaults.ami;
    	      this.arn = defaults.arn;
    	      this.associatePublicIpAddress = defaults.associatePublicIpAddress;
    	      this.availabilityZone = defaults.availabilityZone;
    	      this.creditSpecifications = defaults.creditSpecifications;
    	      this.disableApiStop = defaults.disableApiStop;
    	      this.disableApiTermination = defaults.disableApiTermination;
    	      this.ebsBlockDevices = defaults.ebsBlockDevices;
    	      this.ebsOptimized = defaults.ebsOptimized;
    	      this.enclaveOptions = defaults.enclaveOptions;
    	      this.ephemeralBlockDevices = defaults.ephemeralBlockDevices;
    	      this.filters = defaults.filters;
    	      this.getPasswordData = defaults.getPasswordData;
    	      this.getUserData = defaults.getUserData;
    	      this.hostId = defaults.hostId;
    	      this.hostResourceGroupArn = defaults.hostResourceGroupArn;
    	      this.iamInstanceProfile = defaults.iamInstanceProfile;
    	      this.id = defaults.id;
    	      this.instanceId = defaults.instanceId;
    	      this.instanceState = defaults.instanceState;
    	      this.instanceTags = defaults.instanceTags;
    	      this.instanceType = defaults.instanceType;
    	      this.ipv6Addresses = defaults.ipv6Addresses;
    	      this.keyName = defaults.keyName;
    	      this.maintenanceOptions = defaults.maintenanceOptions;
    	      this.metadataOptions = defaults.metadataOptions;
    	      this.monitoring = defaults.monitoring;
    	      this.networkInterfaceId = defaults.networkInterfaceId;
    	      this.outpostArn = defaults.outpostArn;
    	      this.passwordData = defaults.passwordData;
    	      this.placementGroup = defaults.placementGroup;
    	      this.placementPartitionNumber = defaults.placementPartitionNumber;
    	      this.privateDns = defaults.privateDns;
    	      this.privateDnsNameOptions = defaults.privateDnsNameOptions;
    	      this.privateIp = defaults.privateIp;
    	      this.publicDns = defaults.publicDns;
    	      this.publicIp = defaults.publicIp;
    	      this.rootBlockDevices = defaults.rootBlockDevices;
    	      this.secondaryPrivateIps = defaults.secondaryPrivateIps;
    	      this.securityGroups = defaults.securityGroups;
    	      this.sourceDestCheck = defaults.sourceDestCheck;
    	      this.subnetId = defaults.subnetId;
    	      this.tags = defaults.tags;
    	      this.tenancy = defaults.tenancy;
    	      this.userData = defaults.userData;
    	      this.userDataBase64 = defaults.userDataBase64;
    	      this.vpcSecurityGroupIds = defaults.vpcSecurityGroupIds;
        }

        @CustomType.Setter
        public Builder ami(String ami) {
            this.ami = Objects.requireNonNull(ami);
            return this;
        }
        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }
        @CustomType.Setter
        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = Objects.requireNonNull(associatePublicIpAddress);
            return this;
        }
        @CustomType.Setter
        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = Objects.requireNonNull(availabilityZone);
            return this;
        }
        @CustomType.Setter
        public Builder creditSpecifications(List<GetInstanceCreditSpecification> creditSpecifications) {
            this.creditSpecifications = Objects.requireNonNull(creditSpecifications);
            return this;
        }
        public Builder creditSpecifications(GetInstanceCreditSpecification... creditSpecifications) {
            return creditSpecifications(List.of(creditSpecifications));
        }
        @CustomType.Setter
        public Builder disableApiStop(Boolean disableApiStop) {
            this.disableApiStop = Objects.requireNonNull(disableApiStop);
            return this;
        }
        @CustomType.Setter
        public Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = Objects.requireNonNull(disableApiTermination);
            return this;
        }
        @CustomType.Setter
        public Builder ebsBlockDevices(List<GetInstanceEbsBlockDevice> ebsBlockDevices) {
            this.ebsBlockDevices = Objects.requireNonNull(ebsBlockDevices);
            return this;
        }
        public Builder ebsBlockDevices(GetInstanceEbsBlockDevice... ebsBlockDevices) {
            return ebsBlockDevices(List.of(ebsBlockDevices));
        }
        @CustomType.Setter
        public Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = Objects.requireNonNull(ebsOptimized);
            return this;
        }
        @CustomType.Setter
        public Builder enclaveOptions(List<GetInstanceEnclaveOption> enclaveOptions) {
            this.enclaveOptions = Objects.requireNonNull(enclaveOptions);
            return this;
        }
        public Builder enclaveOptions(GetInstanceEnclaveOption... enclaveOptions) {
            return enclaveOptions(List.of(enclaveOptions));
        }
        @CustomType.Setter
        public Builder ephemeralBlockDevices(List<GetInstanceEphemeralBlockDevice> ephemeralBlockDevices) {
            this.ephemeralBlockDevices = Objects.requireNonNull(ephemeralBlockDevices);
            return this;
        }
        public Builder ephemeralBlockDevices(GetInstanceEphemeralBlockDevice... ephemeralBlockDevices) {
            return ephemeralBlockDevices(List.of(ephemeralBlockDevices));
        }
        @CustomType.Setter
        public Builder filters(@Nullable List<GetInstanceFilter> filters) {
            this.filters = filters;
            return this;
        }
        public Builder filters(GetInstanceFilter... filters) {
            return filters(List.of(filters));
        }
        @CustomType.Setter
        public Builder getPasswordData(@Nullable Boolean getPasswordData) {
            this.getPasswordData = getPasswordData;
            return this;
        }
        @CustomType.Setter
        public Builder getUserData(@Nullable Boolean getUserData) {
            this.getUserData = getUserData;
            return this;
        }
        @CustomType.Setter
        public Builder hostId(String hostId) {
            this.hostId = Objects.requireNonNull(hostId);
            return this;
        }
        @CustomType.Setter
        public Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.hostResourceGroupArn = Objects.requireNonNull(hostResourceGroupArn);
            return this;
        }
        @CustomType.Setter
        public Builder iamInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = Objects.requireNonNull(iamInstanceProfile);
            return this;
        }
        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }
        @CustomType.Setter
        public Builder instanceId(@Nullable String instanceId) {
            this.instanceId = instanceId;
            return this;
        }
        @CustomType.Setter
        public Builder instanceState(String instanceState) {
            this.instanceState = Objects.requireNonNull(instanceState);
            return this;
        }
        @CustomType.Setter
        public Builder instanceTags(Map<String,String> instanceTags) {
            this.instanceTags = Objects.requireNonNull(instanceTags);
            return this;
        }
        @CustomType.Setter
        public Builder instanceType(String instanceType) {
            this.instanceType = Objects.requireNonNull(instanceType);
            return this;
        }
        @CustomType.Setter
        public Builder ipv6Addresses(List<String> ipv6Addresses) {
            this.ipv6Addresses = Objects.requireNonNull(ipv6Addresses);
            return this;
        }
        public Builder ipv6Addresses(String... ipv6Addresses) {
            return ipv6Addresses(List.of(ipv6Addresses));
        }
        @CustomType.Setter
        public Builder keyName(String keyName) {
            this.keyName = Objects.requireNonNull(keyName);
            return this;
        }
        @CustomType.Setter
        public Builder maintenanceOptions(List<GetInstanceMaintenanceOption> maintenanceOptions) {
            this.maintenanceOptions = Objects.requireNonNull(maintenanceOptions);
            return this;
        }
        public Builder maintenanceOptions(GetInstanceMaintenanceOption... maintenanceOptions) {
            return maintenanceOptions(List.of(maintenanceOptions));
        }
        @CustomType.Setter
        public Builder metadataOptions(List<GetInstanceMetadataOption> metadataOptions) {
            this.metadataOptions = Objects.requireNonNull(metadataOptions);
            return this;
        }
        public Builder metadataOptions(GetInstanceMetadataOption... metadataOptions) {
            return metadataOptions(List.of(metadataOptions));
        }
        @CustomType.Setter
        public Builder monitoring(Boolean monitoring) {
            this.monitoring = Objects.requireNonNull(monitoring);
            return this;
        }
        @CustomType.Setter
        public Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = Objects.requireNonNull(networkInterfaceId);
            return this;
        }
        @CustomType.Setter
        public Builder outpostArn(String outpostArn) {
            this.outpostArn = Objects.requireNonNull(outpostArn);
            return this;
        }
        @CustomType.Setter
        public Builder passwordData(String passwordData) {
            this.passwordData = Objects.requireNonNull(passwordData);
            return this;
        }
        @CustomType.Setter
        public Builder placementGroup(String placementGroup) {
            this.placementGroup = Objects.requireNonNull(placementGroup);
            return this;
        }
        @CustomType.Setter
        public Builder placementPartitionNumber(Integer placementPartitionNumber) {
            this.placementPartitionNumber = Objects.requireNonNull(placementPartitionNumber);
            return this;
        }
        @CustomType.Setter
        public Builder privateDns(String privateDns) {
            this.privateDns = Objects.requireNonNull(privateDns);
            return this;
        }
        @CustomType.Setter
        public Builder privateDnsNameOptions(List<GetInstancePrivateDnsNameOption> privateDnsNameOptions) {
            this.privateDnsNameOptions = Objects.requireNonNull(privateDnsNameOptions);
            return this;
        }
        public Builder privateDnsNameOptions(GetInstancePrivateDnsNameOption... privateDnsNameOptions) {
            return privateDnsNameOptions(List.of(privateDnsNameOptions));
        }
        @CustomType.Setter
        public Builder privateIp(String privateIp) {
            this.privateIp = Objects.requireNonNull(privateIp);
            return this;
        }
        @CustomType.Setter
        public Builder publicDns(String publicDns) {
            this.publicDns = Objects.requireNonNull(publicDns);
            return this;
        }
        @CustomType.Setter
        public Builder publicIp(String publicIp) {
            this.publicIp = Objects.requireNonNull(publicIp);
            return this;
        }
        @CustomType.Setter
        public Builder rootBlockDevices(List<GetInstanceRootBlockDevice> rootBlockDevices) {
            this.rootBlockDevices = Objects.requireNonNull(rootBlockDevices);
            return this;
        }
        public Builder rootBlockDevices(GetInstanceRootBlockDevice... rootBlockDevices) {
            return rootBlockDevices(List.of(rootBlockDevices));
        }
        @CustomType.Setter
        public Builder secondaryPrivateIps(List<String> secondaryPrivateIps) {
            this.secondaryPrivateIps = Objects.requireNonNull(secondaryPrivateIps);
            return this;
        }
        public Builder secondaryPrivateIps(String... secondaryPrivateIps) {
            return secondaryPrivateIps(List.of(secondaryPrivateIps));
        }
        @CustomType.Setter
        public Builder securityGroups(List<String> securityGroups) {
            this.securityGroups = Objects.requireNonNull(securityGroups);
            return this;
        }
        public Builder securityGroups(String... securityGroups) {
            return securityGroups(List.of(securityGroups));
        }
        @CustomType.Setter
        public Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = Objects.requireNonNull(sourceDestCheck);
            return this;
        }
        @CustomType.Setter
        public Builder subnetId(String subnetId) {
            this.subnetId = Objects.requireNonNull(subnetId);
            return this;
        }
        @CustomType.Setter
        public Builder tags(Map<String,String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }
        @CustomType.Setter
        public Builder tenancy(String tenancy) {
            this.tenancy = Objects.requireNonNull(tenancy);
            return this;
        }
        @CustomType.Setter
        public Builder userData(String userData) {
            this.userData = Objects.requireNonNull(userData);
            return this;
        }
        @CustomType.Setter
        public Builder userDataBase64(String userDataBase64) {
            this.userDataBase64 = Objects.requireNonNull(userDataBase64);
            return this;
        }
        @CustomType.Setter
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = Objects.requireNonNull(vpcSecurityGroupIds);
            return this;
        }
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }
        public GetInstanceResult build() {
            final var o = new GetInstanceResult();
            o.ami = ami;
            o.arn = arn;
            o.associatePublicIpAddress = associatePublicIpAddress;
            o.availabilityZone = availabilityZone;
            o.creditSpecifications = creditSpecifications;
            o.disableApiStop = disableApiStop;
            o.disableApiTermination = disableApiTermination;
            o.ebsBlockDevices = ebsBlockDevices;
            o.ebsOptimized = ebsOptimized;
            o.enclaveOptions = enclaveOptions;
            o.ephemeralBlockDevices = ephemeralBlockDevices;
            o.filters = filters;
            o.getPasswordData = getPasswordData;
            o.getUserData = getUserData;
            o.hostId = hostId;
            o.hostResourceGroupArn = hostResourceGroupArn;
            o.iamInstanceProfile = iamInstanceProfile;
            o.id = id;
            o.instanceId = instanceId;
            o.instanceState = instanceState;
            o.instanceTags = instanceTags;
            o.instanceType = instanceType;
            o.ipv6Addresses = ipv6Addresses;
            o.keyName = keyName;
            o.maintenanceOptions = maintenanceOptions;
            o.metadataOptions = metadataOptions;
            o.monitoring = monitoring;
            o.networkInterfaceId = networkInterfaceId;
            o.outpostArn = outpostArn;
            o.passwordData = passwordData;
            o.placementGroup = placementGroup;
            o.placementPartitionNumber = placementPartitionNumber;
            o.privateDns = privateDns;
            o.privateDnsNameOptions = privateDnsNameOptions;
            o.privateIp = privateIp;
            o.publicDns = publicDns;
            o.publicIp = publicIp;
            o.rootBlockDevices = rootBlockDevices;
            o.secondaryPrivateIps = secondaryPrivateIps;
            o.securityGroups = securityGroups;
            o.sourceDestCheck = sourceDestCheck;
            o.subnetId = subnetId;
            o.tags = tags;
            o.tenancy = tenancy;
            o.userData = userData;
            o.userDataBase64 = userDataBase64;
            o.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return o;
        }
    }
}
