// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2.inputs;

import com.pulumi.aws.ec2.inputs.VpnConnectionRouteArgs;
import com.pulumi.aws.ec2.inputs.VpnConnectionTunnel1LogOptionsArgs;
import com.pulumi.aws.ec2.inputs.VpnConnectionTunnel2LogOptionsArgs;
import com.pulumi.aws.ec2.inputs.VpnConnectionVgwTelemetryArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VpnConnectionState extends com.pulumi.resources.ResourceArgs {

    public static final VpnConnectionState Empty = new VpnConnectionState();

    /**
     * Amazon Resource Name (ARN) of the VPN Connection.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the VPN Connection.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The ARN of the core network.
     * 
     */
    @Import(name="coreNetworkArn")
    private @Nullable Output<String> coreNetworkArn;

    /**
     * @return The ARN of the core network.
     * 
     */
    public Optional<Output<String>> coreNetworkArn() {
        return Optional.ofNullable(this.coreNetworkArn);
    }

    /**
     * The ARN of the core network attachment.
     * 
     */
    @Import(name="coreNetworkAttachmentArn")
    private @Nullable Output<String> coreNetworkAttachmentArn;

    /**
     * @return The ARN of the core network attachment.
     * 
     */
    public Optional<Output<String>> coreNetworkAttachmentArn() {
        return Optional.ofNullable(this.coreNetworkAttachmentArn);
    }

    /**
     * The configuration information for the VPN connection&#39;s customer gateway (in the native XML format).
     * 
     */
    @Import(name="customerGatewayConfiguration")
    private @Nullable Output<String> customerGatewayConfiguration;

    /**
     * @return The configuration information for the VPN connection&#39;s customer gateway (in the native XML format).
     * 
     */
    public Optional<Output<String>> customerGatewayConfiguration() {
        return Optional.ofNullable(this.customerGatewayConfiguration);
    }

    /**
     * The ID of the customer gateway.
     * 
     */
    @Import(name="customerGatewayId")
    private @Nullable Output<String> customerGatewayId;

    /**
     * @return The ID of the customer gateway.
     * 
     */
    public Optional<Output<String>> customerGatewayId() {
        return Optional.ofNullable(this.customerGatewayId);
    }

    /**
     * Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
     * 
     */
    @Import(name="enableAcceleration")
    private @Nullable Output<Boolean> enableAcceleration;

    /**
     * @return Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
     * 
     */
    public Optional<Output<Boolean>> enableAcceleration() {
        return Optional.ofNullable(this.enableAcceleration);
    }

    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    @Import(name="localIpv4NetworkCidr")
    private @Nullable Output<String> localIpv4NetworkCidr;

    /**
     * @return The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    public Optional<Output<String>> localIpv4NetworkCidr() {
        return Optional.ofNullable(this.localIpv4NetworkCidr);
    }

    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    @Import(name="localIpv6NetworkCidr")
    private @Nullable Output<String> localIpv6NetworkCidr;

    /**
     * @return The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    public Optional<Output<String>> localIpv6NetworkCidr() {
        return Optional.ofNullable(this.localIpv6NetworkCidr);
    }

    /**
     * Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
     * 
     */
    @Import(name="outsideIpAddressType")
    private @Nullable Output<String> outsideIpAddressType;

    /**
     * @return Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
     * 
     */
    public Optional<Output<String>> outsideIpAddressType() {
        return Optional.ofNullable(this.outsideIpAddressType);
    }

    /**
     * The IPv4 CIDR on the AWS side of the VPN connection.
     * 
     */
    @Import(name="remoteIpv4NetworkCidr")
    private @Nullable Output<String> remoteIpv4NetworkCidr;

    /**
     * @return The IPv4 CIDR on the AWS side of the VPN connection.
     * 
     */
    public Optional<Output<String>> remoteIpv4NetworkCidr() {
        return Optional.ofNullable(this.remoteIpv4NetworkCidr);
    }

    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    @Import(name="remoteIpv6NetworkCidr")
    private @Nullable Output<String> remoteIpv6NetworkCidr;

    /**
     * @return The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    public Optional<Output<String>> remoteIpv6NetworkCidr() {
        return Optional.ofNullable(this.remoteIpv6NetworkCidr);
    }

    /**
     * The static routes associated with the VPN connection. Detailed below.
     * 
     */
    @Import(name="routes")
    private @Nullable Output<List<VpnConnectionRouteArgs>> routes;

    /**
     * @return The static routes associated with the VPN connection. Detailed below.
     * 
     */
    public Optional<Output<List<VpnConnectionRouteArgs>>> routes() {
        return Optional.ofNullable(this.routes);
    }

    /**
     * Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don&#39;t support BGP.
     * 
     */
    @Import(name="staticRoutesOnly")
    private @Nullable Output<Boolean> staticRoutesOnly;

    /**
     * @return Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don&#39;t support BGP.
     * 
     */
    public Optional<Output<Boolean>> staticRoutesOnly() {
        return Optional.ofNullable(this.staticRoutesOnly);
    }

    /**
     * Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `aws.ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
     * 
     */
    @Import(name="transitGatewayAttachmentId")
    private @Nullable Output<String> transitGatewayAttachmentId;

    /**
     * @return When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `aws.ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
     * 
     */
    public Optional<Output<String>> transitGatewayAttachmentId() {
        return Optional.ofNullable(this.transitGatewayAttachmentId);
    }

    /**
     * The ID of the EC2 Transit Gateway.
     * 
     */
    @Import(name="transitGatewayId")
    private @Nullable Output<String> transitGatewayId;

    /**
     * @return The ID of the EC2 Transit Gateway.
     * 
     */
    public Optional<Output<String>> transitGatewayId() {
        return Optional.ofNullable(this.transitGatewayId);
    }

    /**
     * . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
     * 
     */
    @Import(name="transportTransitGatewayAttachmentId")
    private @Nullable Output<String> transportTransitGatewayAttachmentId;

    /**
     * @return . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
     * 
     */
    public Optional<Output<String>> transportTransitGatewayAttachmentId() {
        return Optional.ofNullable(this.transportTransitGatewayAttachmentId);
    }

    /**
     * The public IP address of the first VPN tunnel.
     * 
     */
    @Import(name="tunnel1Address")
    private @Nullable Output<String> tunnel1Address;

    /**
     * @return The public IP address of the first VPN tunnel.
     * 
     */
    public Optional<Output<String>> tunnel1Address() {
        return Optional.ofNullable(this.tunnel1Address);
    }

    /**
     * The bgp asn number of the first VPN tunnel.
     * 
     */
    @Import(name="tunnel1BgpAsn")
    private @Nullable Output<String> tunnel1BgpAsn;

    /**
     * @return The bgp asn number of the first VPN tunnel.
     * 
     */
    public Optional<Output<String>> tunnel1BgpAsn() {
        return Optional.ofNullable(this.tunnel1BgpAsn);
    }

    /**
     * The bgp holdtime of the first VPN tunnel.
     * 
     */
    @Import(name="tunnel1BgpHoldtime")
    private @Nullable Output<Integer> tunnel1BgpHoldtime;

    /**
     * @return The bgp holdtime of the first VPN tunnel.
     * 
     */
    public Optional<Output<Integer>> tunnel1BgpHoldtime() {
        return Optional.ofNullable(this.tunnel1BgpHoldtime);
    }

    /**
     * The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
     * 
     */
    @Import(name="tunnel1CgwInsideAddress")
    private @Nullable Output<String> tunnel1CgwInsideAddress;

    /**
     * @return The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
     * 
     */
    public Optional<Output<String>> tunnel1CgwInsideAddress() {
        return Optional.ofNullable(this.tunnel1CgwInsideAddress);
    }

    /**
     * The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     * 
     */
    @Import(name="tunnel1DpdTimeoutAction")
    private @Nullable Output<String> tunnel1DpdTimeoutAction;

    /**
     * @return The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     * 
     */
    public Optional<Output<String>> tunnel1DpdTimeoutAction() {
        return Optional.ofNullable(this.tunnel1DpdTimeoutAction);
    }

    /**
     * The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
     * 
     */
    @Import(name="tunnel1DpdTimeoutSeconds")
    private @Nullable Output<Integer> tunnel1DpdTimeoutSeconds;

    /**
     * @return The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
     * 
     */
    public Optional<Output<Integer>> tunnel1DpdTimeoutSeconds() {
        return Optional.ofNullable(this.tunnel1DpdTimeoutSeconds);
    }

    /**
     * Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
     * 
     */
    @Import(name="tunnel1EnableTunnelLifecycleControl")
    private @Nullable Output<Boolean> tunnel1EnableTunnelLifecycleControl;

    /**
     * @return Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
     * 
     */
    public Optional<Output<Boolean>> tunnel1EnableTunnelLifecycleControl() {
        return Optional.ofNullable(this.tunnel1EnableTunnelLifecycleControl);
    }

    /**
     * The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
     * 
     */
    @Import(name="tunnel1IkeVersions")
    private @Nullable Output<List<String>> tunnel1IkeVersions;

    /**
     * @return The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
     * 
     */
    public Optional<Output<List<String>>> tunnel1IkeVersions() {
        return Optional.ofNullable(this.tunnel1IkeVersions);
    }

    /**
     * The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     */
    @Import(name="tunnel1InsideCidr")
    private @Nullable Output<String> tunnel1InsideCidr;

    /**
     * @return The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     */
    public Optional<Output<String>> tunnel1InsideCidr() {
        return Optional.ofNullable(this.tunnel1InsideCidr);
    }

    /**
     * The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     * 
     */
    @Import(name="tunnel1InsideIpv6Cidr")
    private @Nullable Output<String> tunnel1InsideIpv6Cidr;

    /**
     * @return The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     * 
     */
    public Optional<Output<String>> tunnel1InsideIpv6Cidr() {
        return Optional.ofNullable(this.tunnel1InsideIpv6Cidr);
    }

    /**
     * Options for logging VPN tunnel activity. See Log Options below for more details.
     * 
     */
    @Import(name="tunnel1LogOptions")
    private @Nullable Output<VpnConnectionTunnel1LogOptionsArgs> tunnel1LogOptions;

    /**
     * @return Options for logging VPN tunnel activity. See Log Options below for more details.
     * 
     */
    public Optional<Output<VpnConnectionTunnel1LogOptionsArgs>> tunnel1LogOptions() {
        return Optional.ofNullable(this.tunnel1LogOptions);
    }

    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
     * 
     */
    @Import(name="tunnel1Phase1DhGroupNumbers")
    private @Nullable Output<List<Integer>> tunnel1Phase1DhGroupNumbers;

    /**
     * @return List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
     * 
     */
    public Optional<Output<List<Integer>>> tunnel1Phase1DhGroupNumbers() {
        return Optional.ofNullable(this.tunnel1Phase1DhGroupNumbers);
    }

    /**
     * List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    @Import(name="tunnel1Phase1EncryptionAlgorithms")
    private @Nullable Output<List<String>> tunnel1Phase1EncryptionAlgorithms;

    /**
     * @return List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    public Optional<Output<List<String>>> tunnel1Phase1EncryptionAlgorithms() {
        return Optional.ofNullable(this.tunnel1Phase1EncryptionAlgorithms);
    }

    /**
     * One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    @Import(name="tunnel1Phase1IntegrityAlgorithms")
    private @Nullable Output<List<String>> tunnel1Phase1IntegrityAlgorithms;

    /**
     * @return One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    public Optional<Output<List<String>>> tunnel1Phase1IntegrityAlgorithms() {
        return Optional.ofNullable(this.tunnel1Phase1IntegrityAlgorithms);
    }

    /**
     * The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     * 
     */
    @Import(name="tunnel1Phase1LifetimeSeconds")
    private @Nullable Output<Integer> tunnel1Phase1LifetimeSeconds;

    /**
     * @return The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     * 
     */
    public Optional<Output<Integer>> tunnel1Phase1LifetimeSeconds() {
        return Optional.ofNullable(this.tunnel1Phase1LifetimeSeconds);
    }

    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     * 
     */
    @Import(name="tunnel1Phase2DhGroupNumbers")
    private @Nullable Output<List<Integer>> tunnel1Phase2DhGroupNumbers;

    /**
     * @return List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     * 
     */
    public Optional<Output<List<Integer>>> tunnel1Phase2DhGroupNumbers() {
        return Optional.ofNullable(this.tunnel1Phase2DhGroupNumbers);
    }

    /**
     * List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    @Import(name="tunnel1Phase2EncryptionAlgorithms")
    private @Nullable Output<List<String>> tunnel1Phase2EncryptionAlgorithms;

    /**
     * @return List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    public Optional<Output<List<String>>> tunnel1Phase2EncryptionAlgorithms() {
        return Optional.ofNullable(this.tunnel1Phase2EncryptionAlgorithms);
    }

    /**
     * List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    @Import(name="tunnel1Phase2IntegrityAlgorithms")
    private @Nullable Output<List<String>> tunnel1Phase2IntegrityAlgorithms;

    /**
     * @return List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    public Optional<Output<List<String>>> tunnel1Phase2IntegrityAlgorithms() {
        return Optional.ofNullable(this.tunnel1Phase2IntegrityAlgorithms);
    }

    /**
     * The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     * 
     */
    @Import(name="tunnel1Phase2LifetimeSeconds")
    private @Nullable Output<Integer> tunnel1Phase2LifetimeSeconds;

    /**
     * @return The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     * 
     */
    public Optional<Output<Integer>> tunnel1Phase2LifetimeSeconds() {
        return Optional.ofNullable(this.tunnel1Phase2LifetimeSeconds);
    }

    /**
     * The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     * 
     */
    @Import(name="tunnel1PresharedKey")
    private @Nullable Output<String> tunnel1PresharedKey;

    /**
     * @return The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     * 
     */
    public Optional<Output<String>> tunnel1PresharedKey() {
        return Optional.ofNullable(this.tunnel1PresharedKey);
    }

    /**
     * The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     * 
     */
    @Import(name="tunnel1RekeyFuzzPercentage")
    private @Nullable Output<Integer> tunnel1RekeyFuzzPercentage;

    /**
     * @return The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     * 
     */
    public Optional<Output<Integer>> tunnel1RekeyFuzzPercentage() {
        return Optional.ofNullable(this.tunnel1RekeyFuzzPercentage);
    }

    /**
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
     * 
     */
    @Import(name="tunnel1RekeyMarginTimeSeconds")
    private @Nullable Output<Integer> tunnel1RekeyMarginTimeSeconds;

    /**
     * @return The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
     * 
     */
    public Optional<Output<Integer>> tunnel1RekeyMarginTimeSeconds() {
        return Optional.ofNullable(this.tunnel1RekeyMarginTimeSeconds);
    }

    /**
     * The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
     * 
     */
    @Import(name="tunnel1ReplayWindowSize")
    private @Nullable Output<Integer> tunnel1ReplayWindowSize;

    /**
     * @return The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
     * 
     */
    public Optional<Output<Integer>> tunnel1ReplayWindowSize() {
        return Optional.ofNullable(this.tunnel1ReplayWindowSize);
    }

    /**
     * The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     * 
     */
    @Import(name="tunnel1StartupAction")
    private @Nullable Output<String> tunnel1StartupAction;

    /**
     * @return The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     * 
     */
    public Optional<Output<String>> tunnel1StartupAction() {
        return Optional.ofNullable(this.tunnel1StartupAction);
    }

    /**
     * The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
     * 
     */
    @Import(name="tunnel1VgwInsideAddress")
    private @Nullable Output<String> tunnel1VgwInsideAddress;

    /**
     * @return The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
     * 
     */
    public Optional<Output<String>> tunnel1VgwInsideAddress() {
        return Optional.ofNullable(this.tunnel1VgwInsideAddress);
    }

    /**
     * The public IP address of the second VPN tunnel.
     * 
     */
    @Import(name="tunnel2Address")
    private @Nullable Output<String> tunnel2Address;

    /**
     * @return The public IP address of the second VPN tunnel.
     * 
     */
    public Optional<Output<String>> tunnel2Address() {
        return Optional.ofNullable(this.tunnel2Address);
    }

    /**
     * The bgp asn number of the second VPN tunnel.
     * 
     */
    @Import(name="tunnel2BgpAsn")
    private @Nullable Output<String> tunnel2BgpAsn;

    /**
     * @return The bgp asn number of the second VPN tunnel.
     * 
     */
    public Optional<Output<String>> tunnel2BgpAsn() {
        return Optional.ofNullable(this.tunnel2BgpAsn);
    }

    /**
     * The bgp holdtime of the second VPN tunnel.
     * 
     */
    @Import(name="tunnel2BgpHoldtime")
    private @Nullable Output<Integer> tunnel2BgpHoldtime;

    /**
     * @return The bgp holdtime of the second VPN tunnel.
     * 
     */
    public Optional<Output<Integer>> tunnel2BgpHoldtime() {
        return Optional.ofNullable(this.tunnel2BgpHoldtime);
    }

    /**
     * The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
     * 
     */
    @Import(name="tunnel2CgwInsideAddress")
    private @Nullable Output<String> tunnel2CgwInsideAddress;

    /**
     * @return The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
     * 
     */
    public Optional<Output<String>> tunnel2CgwInsideAddress() {
        return Optional.ofNullable(this.tunnel2CgwInsideAddress);
    }

    /**
     * The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     * 
     */
    @Import(name="tunnel2DpdTimeoutAction")
    private @Nullable Output<String> tunnel2DpdTimeoutAction;

    /**
     * @return The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     * 
     */
    public Optional<Output<String>> tunnel2DpdTimeoutAction() {
        return Optional.ofNullable(this.tunnel2DpdTimeoutAction);
    }

    /**
     * The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
     * 
     */
    @Import(name="tunnel2DpdTimeoutSeconds")
    private @Nullable Output<Integer> tunnel2DpdTimeoutSeconds;

    /**
     * @return The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
     * 
     */
    public Optional<Output<Integer>> tunnel2DpdTimeoutSeconds() {
        return Optional.ofNullable(this.tunnel2DpdTimeoutSeconds);
    }

    /**
     * Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
     * 
     */
    @Import(name="tunnel2EnableTunnelLifecycleControl")
    private @Nullable Output<Boolean> tunnel2EnableTunnelLifecycleControl;

    /**
     * @return Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
     * 
     */
    public Optional<Output<Boolean>> tunnel2EnableTunnelLifecycleControl() {
        return Optional.ofNullable(this.tunnel2EnableTunnelLifecycleControl);
    }

    /**
     * The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
     * 
     */
    @Import(name="tunnel2IkeVersions")
    private @Nullable Output<List<String>> tunnel2IkeVersions;

    /**
     * @return The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
     * 
     */
    public Optional<Output<List<String>>> tunnel2IkeVersions() {
        return Optional.ofNullable(this.tunnel2IkeVersions);
    }

    /**
     * The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     */
    @Import(name="tunnel2InsideCidr")
    private @Nullable Output<String> tunnel2InsideCidr;

    /**
     * @return The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     */
    public Optional<Output<String>> tunnel2InsideCidr() {
        return Optional.ofNullable(this.tunnel2InsideCidr);
    }

    /**
     * The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     * 
     */
    @Import(name="tunnel2InsideIpv6Cidr")
    private @Nullable Output<String> tunnel2InsideIpv6Cidr;

    /**
     * @return The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     * 
     */
    public Optional<Output<String>> tunnel2InsideIpv6Cidr() {
        return Optional.ofNullable(this.tunnel2InsideIpv6Cidr);
    }

    /**
     * Options for logging VPN tunnel activity. See Log Options below for more details.
     * 
     */
    @Import(name="tunnel2LogOptions")
    private @Nullable Output<VpnConnectionTunnel2LogOptionsArgs> tunnel2LogOptions;

    /**
     * @return Options for logging VPN tunnel activity. See Log Options below for more details.
     * 
     */
    public Optional<Output<VpnConnectionTunnel2LogOptionsArgs>> tunnel2LogOptions() {
        return Optional.ofNullable(this.tunnel2LogOptions);
    }

    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
     * 
     */
    @Import(name="tunnel2Phase1DhGroupNumbers")
    private @Nullable Output<List<Integer>> tunnel2Phase1DhGroupNumbers;

    /**
     * @return List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
     * 
     */
    public Optional<Output<List<Integer>>> tunnel2Phase1DhGroupNumbers() {
        return Optional.ofNullable(this.tunnel2Phase1DhGroupNumbers);
    }

    /**
     * List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    @Import(name="tunnel2Phase1EncryptionAlgorithms")
    private @Nullable Output<List<String>> tunnel2Phase1EncryptionAlgorithms;

    /**
     * @return List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    public Optional<Output<List<String>>> tunnel2Phase1EncryptionAlgorithms() {
        return Optional.ofNullable(this.tunnel2Phase1EncryptionAlgorithms);
    }

    /**
     * One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    @Import(name="tunnel2Phase1IntegrityAlgorithms")
    private @Nullable Output<List<String>> tunnel2Phase1IntegrityAlgorithms;

    /**
     * @return One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    public Optional<Output<List<String>>> tunnel2Phase1IntegrityAlgorithms() {
        return Optional.ofNullable(this.tunnel2Phase1IntegrityAlgorithms);
    }

    /**
     * The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     * 
     */
    @Import(name="tunnel2Phase1LifetimeSeconds")
    private @Nullable Output<Integer> tunnel2Phase1LifetimeSeconds;

    /**
     * @return The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     * 
     */
    public Optional<Output<Integer>> tunnel2Phase1LifetimeSeconds() {
        return Optional.ofNullable(this.tunnel2Phase1LifetimeSeconds);
    }

    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     * 
     */
    @Import(name="tunnel2Phase2DhGroupNumbers")
    private @Nullable Output<List<Integer>> tunnel2Phase2DhGroupNumbers;

    /**
     * @return List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     * 
     */
    public Optional<Output<List<Integer>>> tunnel2Phase2DhGroupNumbers() {
        return Optional.ofNullable(this.tunnel2Phase2DhGroupNumbers);
    }

    /**
     * List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    @Import(name="tunnel2Phase2EncryptionAlgorithms")
    private @Nullable Output<List<String>> tunnel2Phase2EncryptionAlgorithms;

    /**
     * @return List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    public Optional<Output<List<String>>> tunnel2Phase2EncryptionAlgorithms() {
        return Optional.ofNullable(this.tunnel2Phase2EncryptionAlgorithms);
    }

    /**
     * List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    @Import(name="tunnel2Phase2IntegrityAlgorithms")
    private @Nullable Output<List<String>> tunnel2Phase2IntegrityAlgorithms;

    /**
     * @return List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    public Optional<Output<List<String>>> tunnel2Phase2IntegrityAlgorithms() {
        return Optional.ofNullable(this.tunnel2Phase2IntegrityAlgorithms);
    }

    /**
     * The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     * 
     */
    @Import(name="tunnel2Phase2LifetimeSeconds")
    private @Nullable Output<Integer> tunnel2Phase2LifetimeSeconds;

    /**
     * @return The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     * 
     */
    public Optional<Output<Integer>> tunnel2Phase2LifetimeSeconds() {
        return Optional.ofNullable(this.tunnel2Phase2LifetimeSeconds);
    }

    /**
     * The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     * 
     */
    @Import(name="tunnel2PresharedKey")
    private @Nullable Output<String> tunnel2PresharedKey;

    /**
     * @return The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     * 
     */
    public Optional<Output<String>> tunnel2PresharedKey() {
        return Optional.ofNullable(this.tunnel2PresharedKey);
    }

    /**
     * The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     * 
     */
    @Import(name="tunnel2RekeyFuzzPercentage")
    private @Nullable Output<Integer> tunnel2RekeyFuzzPercentage;

    /**
     * @return The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     * 
     */
    public Optional<Output<Integer>> tunnel2RekeyFuzzPercentage() {
        return Optional.ofNullable(this.tunnel2RekeyFuzzPercentage);
    }

    /**
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
     * 
     */
    @Import(name="tunnel2RekeyMarginTimeSeconds")
    private @Nullable Output<Integer> tunnel2RekeyMarginTimeSeconds;

    /**
     * @return The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
     * 
     */
    public Optional<Output<Integer>> tunnel2RekeyMarginTimeSeconds() {
        return Optional.ofNullable(this.tunnel2RekeyMarginTimeSeconds);
    }

    /**
     * The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
     * 
     */
    @Import(name="tunnel2ReplayWindowSize")
    private @Nullable Output<Integer> tunnel2ReplayWindowSize;

    /**
     * @return The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
     * 
     */
    public Optional<Output<Integer>> tunnel2ReplayWindowSize() {
        return Optional.ofNullable(this.tunnel2ReplayWindowSize);
    }

    /**
     * The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     * 
     */
    @Import(name="tunnel2StartupAction")
    private @Nullable Output<String> tunnel2StartupAction;

    /**
     * @return The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     * 
     */
    public Optional<Output<String>> tunnel2StartupAction() {
        return Optional.ofNullable(this.tunnel2StartupAction);
    }

    /**
     * The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
     * 
     */
    @Import(name="tunnel2VgwInsideAddress")
    private @Nullable Output<String> tunnel2VgwInsideAddress;

    /**
     * @return The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
     * 
     */
    public Optional<Output<String>> tunnel2VgwInsideAddress() {
        return Optional.ofNullable(this.tunnel2VgwInsideAddress);
    }

    /**
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
     * 
     */
    @Import(name="tunnelInsideIpVersion")
    private @Nullable Output<String> tunnelInsideIpVersion;

    /**
     * @return Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
     * 
     */
    public Optional<Output<String>> tunnelInsideIpVersion() {
        return Optional.ofNullable(this.tunnelInsideIpVersion);
    }

    /**
     * The type of VPN connection. The only type AWS supports at this time is &#34;ipsec.1&#34;.
     * 
     */
    @Import(name="type")
    private @Nullable Output<String> type;

    /**
     * @return The type of VPN connection. The only type AWS supports at this time is &#34;ipsec.1&#34;.
     * 
     */
    public Optional<Output<String>> type() {
        return Optional.ofNullable(this.type);
    }

    /**
     * Telemetry for the VPN tunnels. Detailed below.
     * 
     */
    @Import(name="vgwTelemetries")
    private @Nullable Output<List<VpnConnectionVgwTelemetryArgs>> vgwTelemetries;

    /**
     * @return Telemetry for the VPN tunnels. Detailed below.
     * 
     */
    public Optional<Output<List<VpnConnectionVgwTelemetryArgs>>> vgwTelemetries() {
        return Optional.ofNullable(this.vgwTelemetries);
    }

    /**
     * The ID of the Virtual Private Gateway.
     * 
     */
    @Import(name="vpnGatewayId")
    private @Nullable Output<String> vpnGatewayId;

    /**
     * @return The ID of the Virtual Private Gateway.
     * 
     */
    public Optional<Output<String>> vpnGatewayId() {
        return Optional.ofNullable(this.vpnGatewayId);
    }

    private VpnConnectionState() {}

    private VpnConnectionState(VpnConnectionState $) {
        this.arn = $.arn;
        this.coreNetworkArn = $.coreNetworkArn;
        this.coreNetworkAttachmentArn = $.coreNetworkAttachmentArn;
        this.customerGatewayConfiguration = $.customerGatewayConfiguration;
        this.customerGatewayId = $.customerGatewayId;
        this.enableAcceleration = $.enableAcceleration;
        this.localIpv4NetworkCidr = $.localIpv4NetworkCidr;
        this.localIpv6NetworkCidr = $.localIpv6NetworkCidr;
        this.outsideIpAddressType = $.outsideIpAddressType;
        this.remoteIpv4NetworkCidr = $.remoteIpv4NetworkCidr;
        this.remoteIpv6NetworkCidr = $.remoteIpv6NetworkCidr;
        this.routes = $.routes;
        this.staticRoutesOnly = $.staticRoutesOnly;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.transitGatewayAttachmentId = $.transitGatewayAttachmentId;
        this.transitGatewayId = $.transitGatewayId;
        this.transportTransitGatewayAttachmentId = $.transportTransitGatewayAttachmentId;
        this.tunnel1Address = $.tunnel1Address;
        this.tunnel1BgpAsn = $.tunnel1BgpAsn;
        this.tunnel1BgpHoldtime = $.tunnel1BgpHoldtime;
        this.tunnel1CgwInsideAddress = $.tunnel1CgwInsideAddress;
        this.tunnel1DpdTimeoutAction = $.tunnel1DpdTimeoutAction;
        this.tunnel1DpdTimeoutSeconds = $.tunnel1DpdTimeoutSeconds;
        this.tunnel1EnableTunnelLifecycleControl = $.tunnel1EnableTunnelLifecycleControl;
        this.tunnel1IkeVersions = $.tunnel1IkeVersions;
        this.tunnel1InsideCidr = $.tunnel1InsideCidr;
        this.tunnel1InsideIpv6Cidr = $.tunnel1InsideIpv6Cidr;
        this.tunnel1LogOptions = $.tunnel1LogOptions;
        this.tunnel1Phase1DhGroupNumbers = $.tunnel1Phase1DhGroupNumbers;
        this.tunnel1Phase1EncryptionAlgorithms = $.tunnel1Phase1EncryptionAlgorithms;
        this.tunnel1Phase1IntegrityAlgorithms = $.tunnel1Phase1IntegrityAlgorithms;
        this.tunnel1Phase1LifetimeSeconds = $.tunnel1Phase1LifetimeSeconds;
        this.tunnel1Phase2DhGroupNumbers = $.tunnel1Phase2DhGroupNumbers;
        this.tunnel1Phase2EncryptionAlgorithms = $.tunnel1Phase2EncryptionAlgorithms;
        this.tunnel1Phase2IntegrityAlgorithms = $.tunnel1Phase2IntegrityAlgorithms;
        this.tunnel1Phase2LifetimeSeconds = $.tunnel1Phase2LifetimeSeconds;
        this.tunnel1PresharedKey = $.tunnel1PresharedKey;
        this.tunnel1RekeyFuzzPercentage = $.tunnel1RekeyFuzzPercentage;
        this.tunnel1RekeyMarginTimeSeconds = $.tunnel1RekeyMarginTimeSeconds;
        this.tunnel1ReplayWindowSize = $.tunnel1ReplayWindowSize;
        this.tunnel1StartupAction = $.tunnel1StartupAction;
        this.tunnel1VgwInsideAddress = $.tunnel1VgwInsideAddress;
        this.tunnel2Address = $.tunnel2Address;
        this.tunnel2BgpAsn = $.tunnel2BgpAsn;
        this.tunnel2BgpHoldtime = $.tunnel2BgpHoldtime;
        this.tunnel2CgwInsideAddress = $.tunnel2CgwInsideAddress;
        this.tunnel2DpdTimeoutAction = $.tunnel2DpdTimeoutAction;
        this.tunnel2DpdTimeoutSeconds = $.tunnel2DpdTimeoutSeconds;
        this.tunnel2EnableTunnelLifecycleControl = $.tunnel2EnableTunnelLifecycleControl;
        this.tunnel2IkeVersions = $.tunnel2IkeVersions;
        this.tunnel2InsideCidr = $.tunnel2InsideCidr;
        this.tunnel2InsideIpv6Cidr = $.tunnel2InsideIpv6Cidr;
        this.tunnel2LogOptions = $.tunnel2LogOptions;
        this.tunnel2Phase1DhGroupNumbers = $.tunnel2Phase1DhGroupNumbers;
        this.tunnel2Phase1EncryptionAlgorithms = $.tunnel2Phase1EncryptionAlgorithms;
        this.tunnel2Phase1IntegrityAlgorithms = $.tunnel2Phase1IntegrityAlgorithms;
        this.tunnel2Phase1LifetimeSeconds = $.tunnel2Phase1LifetimeSeconds;
        this.tunnel2Phase2DhGroupNumbers = $.tunnel2Phase2DhGroupNumbers;
        this.tunnel2Phase2EncryptionAlgorithms = $.tunnel2Phase2EncryptionAlgorithms;
        this.tunnel2Phase2IntegrityAlgorithms = $.tunnel2Phase2IntegrityAlgorithms;
        this.tunnel2Phase2LifetimeSeconds = $.tunnel2Phase2LifetimeSeconds;
        this.tunnel2PresharedKey = $.tunnel2PresharedKey;
        this.tunnel2RekeyFuzzPercentage = $.tunnel2RekeyFuzzPercentage;
        this.tunnel2RekeyMarginTimeSeconds = $.tunnel2RekeyMarginTimeSeconds;
        this.tunnel2ReplayWindowSize = $.tunnel2ReplayWindowSize;
        this.tunnel2StartupAction = $.tunnel2StartupAction;
        this.tunnel2VgwInsideAddress = $.tunnel2VgwInsideAddress;
        this.tunnelInsideIpVersion = $.tunnelInsideIpVersion;
        this.type = $.type;
        this.vgwTelemetries = $.vgwTelemetries;
        this.vpnGatewayId = $.vpnGatewayId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VpnConnectionState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VpnConnectionState $;

        public Builder() {
            $ = new VpnConnectionState();
        }

        public Builder(VpnConnectionState defaults) {
            $ = new VpnConnectionState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the VPN Connection.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the VPN Connection.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param coreNetworkArn The ARN of the core network.
         * 
         * @return builder
         * 
         */
        public Builder coreNetworkArn(@Nullable Output<String> coreNetworkArn) {
            $.coreNetworkArn = coreNetworkArn;
            return this;
        }

        /**
         * @param coreNetworkArn The ARN of the core network.
         * 
         * @return builder
         * 
         */
        public Builder coreNetworkArn(String coreNetworkArn) {
            return coreNetworkArn(Output.of(coreNetworkArn));
        }

        /**
         * @param coreNetworkAttachmentArn The ARN of the core network attachment.
         * 
         * @return builder
         * 
         */
        public Builder coreNetworkAttachmentArn(@Nullable Output<String> coreNetworkAttachmentArn) {
            $.coreNetworkAttachmentArn = coreNetworkAttachmentArn;
            return this;
        }

        /**
         * @param coreNetworkAttachmentArn The ARN of the core network attachment.
         * 
         * @return builder
         * 
         */
        public Builder coreNetworkAttachmentArn(String coreNetworkAttachmentArn) {
            return coreNetworkAttachmentArn(Output.of(coreNetworkAttachmentArn));
        }

        /**
         * @param customerGatewayConfiguration The configuration information for the VPN connection&#39;s customer gateway (in the native XML format).
         * 
         * @return builder
         * 
         */
        public Builder customerGatewayConfiguration(@Nullable Output<String> customerGatewayConfiguration) {
            $.customerGatewayConfiguration = customerGatewayConfiguration;
            return this;
        }

        /**
         * @param customerGatewayConfiguration The configuration information for the VPN connection&#39;s customer gateway (in the native XML format).
         * 
         * @return builder
         * 
         */
        public Builder customerGatewayConfiguration(String customerGatewayConfiguration) {
            return customerGatewayConfiguration(Output.of(customerGatewayConfiguration));
        }

        /**
         * @param customerGatewayId The ID of the customer gateway.
         * 
         * @return builder
         * 
         */
        public Builder customerGatewayId(@Nullable Output<String> customerGatewayId) {
            $.customerGatewayId = customerGatewayId;
            return this;
        }

        /**
         * @param customerGatewayId The ID of the customer gateway.
         * 
         * @return builder
         * 
         */
        public Builder customerGatewayId(String customerGatewayId) {
            return customerGatewayId(Output.of(customerGatewayId));
        }

        /**
         * @param enableAcceleration Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
         * 
         * @return builder
         * 
         */
        public Builder enableAcceleration(@Nullable Output<Boolean> enableAcceleration) {
            $.enableAcceleration = enableAcceleration;
            return this;
        }

        /**
         * @param enableAcceleration Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
         * 
         * @return builder
         * 
         */
        public Builder enableAcceleration(Boolean enableAcceleration) {
            return enableAcceleration(Output.of(enableAcceleration));
        }

        /**
         * @param localIpv4NetworkCidr The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * 
         * @return builder
         * 
         */
        public Builder localIpv4NetworkCidr(@Nullable Output<String> localIpv4NetworkCidr) {
            $.localIpv4NetworkCidr = localIpv4NetworkCidr;
            return this;
        }

        /**
         * @param localIpv4NetworkCidr The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * 
         * @return builder
         * 
         */
        public Builder localIpv4NetworkCidr(String localIpv4NetworkCidr) {
            return localIpv4NetworkCidr(Output.of(localIpv4NetworkCidr));
        }

        /**
         * @param localIpv6NetworkCidr The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * 
         * @return builder
         * 
         */
        public Builder localIpv6NetworkCidr(@Nullable Output<String> localIpv6NetworkCidr) {
            $.localIpv6NetworkCidr = localIpv6NetworkCidr;
            return this;
        }

        /**
         * @param localIpv6NetworkCidr The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * 
         * @return builder
         * 
         */
        public Builder localIpv6NetworkCidr(String localIpv6NetworkCidr) {
            return localIpv6NetworkCidr(Output.of(localIpv6NetworkCidr));
        }

        /**
         * @param outsideIpAddressType Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
         * 
         * @return builder
         * 
         */
        public Builder outsideIpAddressType(@Nullable Output<String> outsideIpAddressType) {
            $.outsideIpAddressType = outsideIpAddressType;
            return this;
        }

        /**
         * @param outsideIpAddressType Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
         * 
         * @return builder
         * 
         */
        public Builder outsideIpAddressType(String outsideIpAddressType) {
            return outsideIpAddressType(Output.of(outsideIpAddressType));
        }

        /**
         * @param remoteIpv4NetworkCidr The IPv4 CIDR on the AWS side of the VPN connection.
         * 
         * @return builder
         * 
         */
        public Builder remoteIpv4NetworkCidr(@Nullable Output<String> remoteIpv4NetworkCidr) {
            $.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
            return this;
        }

        /**
         * @param remoteIpv4NetworkCidr The IPv4 CIDR on the AWS side of the VPN connection.
         * 
         * @return builder
         * 
         */
        public Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            return remoteIpv4NetworkCidr(Output.of(remoteIpv4NetworkCidr));
        }

        /**
         * @param remoteIpv6NetworkCidr The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * 
         * @return builder
         * 
         */
        public Builder remoteIpv6NetworkCidr(@Nullable Output<String> remoteIpv6NetworkCidr) {
            $.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
            return this;
        }

        /**
         * @param remoteIpv6NetworkCidr The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * 
         * @return builder
         * 
         */
        public Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            return remoteIpv6NetworkCidr(Output.of(remoteIpv6NetworkCidr));
        }

        /**
         * @param routes The static routes associated with the VPN connection. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder routes(@Nullable Output<List<VpnConnectionRouteArgs>> routes) {
            $.routes = routes;
            return this;
        }

        /**
         * @param routes The static routes associated with the VPN connection. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder routes(List<VpnConnectionRouteArgs> routes) {
            return routes(Output.of(routes));
        }

        /**
         * @param routes The static routes associated with the VPN connection. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder routes(VpnConnectionRouteArgs... routes) {
            return routes(List.of(routes));
        }

        /**
         * @param staticRoutesOnly Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don&#39;t support BGP.
         * 
         * @return builder
         * 
         */
        public Builder staticRoutesOnly(@Nullable Output<Boolean> staticRoutesOnly) {
            $.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        /**
         * @param staticRoutesOnly Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don&#39;t support BGP.
         * 
         * @return builder
         * 
         */
        public Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            return staticRoutesOnly(Output.of(staticRoutesOnly));
        }

        /**
         * @param tags Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param transitGatewayAttachmentId When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `aws.ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
         * 
         * @return builder
         * 
         */
        public Builder transitGatewayAttachmentId(@Nullable Output<String> transitGatewayAttachmentId) {
            $.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        /**
         * @param transitGatewayAttachmentId When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `aws.ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
         * 
         * @return builder
         * 
         */
        public Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            return transitGatewayAttachmentId(Output.of(transitGatewayAttachmentId));
        }

        /**
         * @param transitGatewayId The ID of the EC2 Transit Gateway.
         * 
         * @return builder
         * 
         */
        public Builder transitGatewayId(@Nullable Output<String> transitGatewayId) {
            $.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * @param transitGatewayId The ID of the EC2 Transit Gateway.
         * 
         * @return builder
         * 
         */
        public Builder transitGatewayId(String transitGatewayId) {
            return transitGatewayId(Output.of(transitGatewayId));
        }

        /**
         * @param transportTransitGatewayAttachmentId . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
         * 
         * @return builder
         * 
         */
        public Builder transportTransitGatewayAttachmentId(@Nullable Output<String> transportTransitGatewayAttachmentId) {
            $.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
            return this;
        }

        /**
         * @param transportTransitGatewayAttachmentId . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
         * 
         * @return builder
         * 
         */
        public Builder transportTransitGatewayAttachmentId(String transportTransitGatewayAttachmentId) {
            return transportTransitGatewayAttachmentId(Output.of(transportTransitGatewayAttachmentId));
        }

        /**
         * @param tunnel1Address The public IP address of the first VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Address(@Nullable Output<String> tunnel1Address) {
            $.tunnel1Address = tunnel1Address;
            return this;
        }

        /**
         * @param tunnel1Address The public IP address of the first VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Address(String tunnel1Address) {
            return tunnel1Address(Output.of(tunnel1Address));
        }

        /**
         * @param tunnel1BgpAsn The bgp asn number of the first VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1BgpAsn(@Nullable Output<String> tunnel1BgpAsn) {
            $.tunnel1BgpAsn = tunnel1BgpAsn;
            return this;
        }

        /**
         * @param tunnel1BgpAsn The bgp asn number of the first VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1BgpAsn(String tunnel1BgpAsn) {
            return tunnel1BgpAsn(Output.of(tunnel1BgpAsn));
        }

        /**
         * @param tunnel1BgpHoldtime The bgp holdtime of the first VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1BgpHoldtime(@Nullable Output<Integer> tunnel1BgpHoldtime) {
            $.tunnel1BgpHoldtime = tunnel1BgpHoldtime;
            return this;
        }

        /**
         * @param tunnel1BgpHoldtime The bgp holdtime of the first VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1BgpHoldtime(Integer tunnel1BgpHoldtime) {
            return tunnel1BgpHoldtime(Output.of(tunnel1BgpHoldtime));
        }

        /**
         * @param tunnel1CgwInsideAddress The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
         * 
         * @return builder
         * 
         */
        public Builder tunnel1CgwInsideAddress(@Nullable Output<String> tunnel1CgwInsideAddress) {
            $.tunnel1CgwInsideAddress = tunnel1CgwInsideAddress;
            return this;
        }

        /**
         * @param tunnel1CgwInsideAddress The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
         * 
         * @return builder
         * 
         */
        public Builder tunnel1CgwInsideAddress(String tunnel1CgwInsideAddress) {
            return tunnel1CgwInsideAddress(Output.of(tunnel1CgwInsideAddress));
        }

        /**
         * @param tunnel1DpdTimeoutAction The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1DpdTimeoutAction(@Nullable Output<String> tunnel1DpdTimeoutAction) {
            $.tunnel1DpdTimeoutAction = tunnel1DpdTimeoutAction;
            return this;
        }

        /**
         * @param tunnel1DpdTimeoutAction The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1DpdTimeoutAction(String tunnel1DpdTimeoutAction) {
            return tunnel1DpdTimeoutAction(Output.of(tunnel1DpdTimeoutAction));
        }

        /**
         * @param tunnel1DpdTimeoutSeconds The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1DpdTimeoutSeconds(@Nullable Output<Integer> tunnel1DpdTimeoutSeconds) {
            $.tunnel1DpdTimeoutSeconds = tunnel1DpdTimeoutSeconds;
            return this;
        }

        /**
         * @param tunnel1DpdTimeoutSeconds The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1DpdTimeoutSeconds(Integer tunnel1DpdTimeoutSeconds) {
            return tunnel1DpdTimeoutSeconds(Output.of(tunnel1DpdTimeoutSeconds));
        }

        /**
         * @param tunnel1EnableTunnelLifecycleControl Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1EnableTunnelLifecycleControl(@Nullable Output<Boolean> tunnel1EnableTunnelLifecycleControl) {
            $.tunnel1EnableTunnelLifecycleControl = tunnel1EnableTunnelLifecycleControl;
            return this;
        }

        /**
         * @param tunnel1EnableTunnelLifecycleControl Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1EnableTunnelLifecycleControl(Boolean tunnel1EnableTunnelLifecycleControl) {
            return tunnel1EnableTunnelLifecycleControl(Output.of(tunnel1EnableTunnelLifecycleControl));
        }

        /**
         * @param tunnel1IkeVersions The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1IkeVersions(@Nullable Output<List<String>> tunnel1IkeVersions) {
            $.tunnel1IkeVersions = tunnel1IkeVersions;
            return this;
        }

        /**
         * @param tunnel1IkeVersions The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1IkeVersions(List<String> tunnel1IkeVersions) {
            return tunnel1IkeVersions(Output.of(tunnel1IkeVersions));
        }

        /**
         * @param tunnel1IkeVersions The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1IkeVersions(String... tunnel1IkeVersions) {
            return tunnel1IkeVersions(List.of(tunnel1IkeVersions));
        }

        /**
         * @param tunnel1InsideCidr The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1InsideCidr(@Nullable Output<String> tunnel1InsideCidr) {
            $.tunnel1InsideCidr = tunnel1InsideCidr;
            return this;
        }

        /**
         * @param tunnel1InsideCidr The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1InsideCidr(String tunnel1InsideCidr) {
            return tunnel1InsideCidr(Output.of(tunnel1InsideCidr));
        }

        /**
         * @param tunnel1InsideIpv6Cidr The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1InsideIpv6Cidr(@Nullable Output<String> tunnel1InsideIpv6Cidr) {
            $.tunnel1InsideIpv6Cidr = tunnel1InsideIpv6Cidr;
            return this;
        }

        /**
         * @param tunnel1InsideIpv6Cidr The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1InsideIpv6Cidr(String tunnel1InsideIpv6Cidr) {
            return tunnel1InsideIpv6Cidr(Output.of(tunnel1InsideIpv6Cidr));
        }

        /**
         * @param tunnel1LogOptions Options for logging VPN tunnel activity. See Log Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1LogOptions(@Nullable Output<VpnConnectionTunnel1LogOptionsArgs> tunnel1LogOptions) {
            $.tunnel1LogOptions = tunnel1LogOptions;
            return this;
        }

        /**
         * @param tunnel1LogOptions Options for logging VPN tunnel activity. See Log Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1LogOptions(VpnConnectionTunnel1LogOptionsArgs tunnel1LogOptions) {
            return tunnel1LogOptions(Output.of(tunnel1LogOptions));
        }

        /**
         * @param tunnel1Phase1DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1DhGroupNumbers(@Nullable Output<List<Integer>> tunnel1Phase1DhGroupNumbers) {
            $.tunnel1Phase1DhGroupNumbers = tunnel1Phase1DhGroupNumbers;
            return this;
        }

        /**
         * @param tunnel1Phase1DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1DhGroupNumbers(List<Integer> tunnel1Phase1DhGroupNumbers) {
            return tunnel1Phase1DhGroupNumbers(Output.of(tunnel1Phase1DhGroupNumbers));
        }

        /**
         * @param tunnel1Phase1DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1DhGroupNumbers(Integer... tunnel1Phase1DhGroupNumbers) {
            return tunnel1Phase1DhGroupNumbers(List.of(tunnel1Phase1DhGroupNumbers));
        }

        /**
         * @param tunnel1Phase1EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1EncryptionAlgorithms(@Nullable Output<List<String>> tunnel1Phase1EncryptionAlgorithms) {
            $.tunnel1Phase1EncryptionAlgorithms = tunnel1Phase1EncryptionAlgorithms;
            return this;
        }

        /**
         * @param tunnel1Phase1EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1EncryptionAlgorithms(List<String> tunnel1Phase1EncryptionAlgorithms) {
            return tunnel1Phase1EncryptionAlgorithms(Output.of(tunnel1Phase1EncryptionAlgorithms));
        }

        /**
         * @param tunnel1Phase1EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1EncryptionAlgorithms(String... tunnel1Phase1EncryptionAlgorithms) {
            return tunnel1Phase1EncryptionAlgorithms(List.of(tunnel1Phase1EncryptionAlgorithms));
        }

        /**
         * @param tunnel1Phase1IntegrityAlgorithms One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1IntegrityAlgorithms(@Nullable Output<List<String>> tunnel1Phase1IntegrityAlgorithms) {
            $.tunnel1Phase1IntegrityAlgorithms = tunnel1Phase1IntegrityAlgorithms;
            return this;
        }

        /**
         * @param tunnel1Phase1IntegrityAlgorithms One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1IntegrityAlgorithms(List<String> tunnel1Phase1IntegrityAlgorithms) {
            return tunnel1Phase1IntegrityAlgorithms(Output.of(tunnel1Phase1IntegrityAlgorithms));
        }

        /**
         * @param tunnel1Phase1IntegrityAlgorithms One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1IntegrityAlgorithms(String... tunnel1Phase1IntegrityAlgorithms) {
            return tunnel1Phase1IntegrityAlgorithms(List.of(tunnel1Phase1IntegrityAlgorithms));
        }

        /**
         * @param tunnel1Phase1LifetimeSeconds The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1LifetimeSeconds(@Nullable Output<Integer> tunnel1Phase1LifetimeSeconds) {
            $.tunnel1Phase1LifetimeSeconds = tunnel1Phase1LifetimeSeconds;
            return this;
        }

        /**
         * @param tunnel1Phase1LifetimeSeconds The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase1LifetimeSeconds(Integer tunnel1Phase1LifetimeSeconds) {
            return tunnel1Phase1LifetimeSeconds(Output.of(tunnel1Phase1LifetimeSeconds));
        }

        /**
         * @param tunnel1Phase2DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2DhGroupNumbers(@Nullable Output<List<Integer>> tunnel1Phase2DhGroupNumbers) {
            $.tunnel1Phase2DhGroupNumbers = tunnel1Phase2DhGroupNumbers;
            return this;
        }

        /**
         * @param tunnel1Phase2DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2DhGroupNumbers(List<Integer> tunnel1Phase2DhGroupNumbers) {
            return tunnel1Phase2DhGroupNumbers(Output.of(tunnel1Phase2DhGroupNumbers));
        }

        /**
         * @param tunnel1Phase2DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2DhGroupNumbers(Integer... tunnel1Phase2DhGroupNumbers) {
            return tunnel1Phase2DhGroupNumbers(List.of(tunnel1Phase2DhGroupNumbers));
        }

        /**
         * @param tunnel1Phase2EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2EncryptionAlgorithms(@Nullable Output<List<String>> tunnel1Phase2EncryptionAlgorithms) {
            $.tunnel1Phase2EncryptionAlgorithms = tunnel1Phase2EncryptionAlgorithms;
            return this;
        }

        /**
         * @param tunnel1Phase2EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2EncryptionAlgorithms(List<String> tunnel1Phase2EncryptionAlgorithms) {
            return tunnel1Phase2EncryptionAlgorithms(Output.of(tunnel1Phase2EncryptionAlgorithms));
        }

        /**
         * @param tunnel1Phase2EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2EncryptionAlgorithms(String... tunnel1Phase2EncryptionAlgorithms) {
            return tunnel1Phase2EncryptionAlgorithms(List.of(tunnel1Phase2EncryptionAlgorithms));
        }

        /**
         * @param tunnel1Phase2IntegrityAlgorithms List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2IntegrityAlgorithms(@Nullable Output<List<String>> tunnel1Phase2IntegrityAlgorithms) {
            $.tunnel1Phase2IntegrityAlgorithms = tunnel1Phase2IntegrityAlgorithms;
            return this;
        }

        /**
         * @param tunnel1Phase2IntegrityAlgorithms List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2IntegrityAlgorithms(List<String> tunnel1Phase2IntegrityAlgorithms) {
            return tunnel1Phase2IntegrityAlgorithms(Output.of(tunnel1Phase2IntegrityAlgorithms));
        }

        /**
         * @param tunnel1Phase2IntegrityAlgorithms List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2IntegrityAlgorithms(String... tunnel1Phase2IntegrityAlgorithms) {
            return tunnel1Phase2IntegrityAlgorithms(List.of(tunnel1Phase2IntegrityAlgorithms));
        }

        /**
         * @param tunnel1Phase2LifetimeSeconds The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2LifetimeSeconds(@Nullable Output<Integer> tunnel1Phase2LifetimeSeconds) {
            $.tunnel1Phase2LifetimeSeconds = tunnel1Phase2LifetimeSeconds;
            return this;
        }

        /**
         * @param tunnel1Phase2LifetimeSeconds The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1Phase2LifetimeSeconds(Integer tunnel1Phase2LifetimeSeconds) {
            return tunnel1Phase2LifetimeSeconds(Output.of(tunnel1Phase2LifetimeSeconds));
        }

        /**
         * @param tunnel1PresharedKey The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
         * 
         * @return builder
         * 
         */
        public Builder tunnel1PresharedKey(@Nullable Output<String> tunnel1PresharedKey) {
            $.tunnel1PresharedKey = tunnel1PresharedKey;
            return this;
        }

        /**
         * @param tunnel1PresharedKey The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
         * 
         * @return builder
         * 
         */
        public Builder tunnel1PresharedKey(String tunnel1PresharedKey) {
            return tunnel1PresharedKey(Output.of(tunnel1PresharedKey));
        }

        /**
         * @param tunnel1RekeyFuzzPercentage The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1RekeyFuzzPercentage(@Nullable Output<Integer> tunnel1RekeyFuzzPercentage) {
            $.tunnel1RekeyFuzzPercentage = tunnel1RekeyFuzzPercentage;
            return this;
        }

        /**
         * @param tunnel1RekeyFuzzPercentage The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1RekeyFuzzPercentage(Integer tunnel1RekeyFuzzPercentage) {
            return tunnel1RekeyFuzzPercentage(Output.of(tunnel1RekeyFuzzPercentage));
        }

        /**
         * @param tunnel1RekeyMarginTimeSeconds The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1RekeyMarginTimeSeconds(@Nullable Output<Integer> tunnel1RekeyMarginTimeSeconds) {
            $.tunnel1RekeyMarginTimeSeconds = tunnel1RekeyMarginTimeSeconds;
            return this;
        }

        /**
         * @param tunnel1RekeyMarginTimeSeconds The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1RekeyMarginTimeSeconds(Integer tunnel1RekeyMarginTimeSeconds) {
            return tunnel1RekeyMarginTimeSeconds(Output.of(tunnel1RekeyMarginTimeSeconds));
        }

        /**
         * @param tunnel1ReplayWindowSize The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1ReplayWindowSize(@Nullable Output<Integer> tunnel1ReplayWindowSize) {
            $.tunnel1ReplayWindowSize = tunnel1ReplayWindowSize;
            return this;
        }

        /**
         * @param tunnel1ReplayWindowSize The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1ReplayWindowSize(Integer tunnel1ReplayWindowSize) {
            return tunnel1ReplayWindowSize(Output.of(tunnel1ReplayWindowSize));
        }

        /**
         * @param tunnel1StartupAction The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1StartupAction(@Nullable Output<String> tunnel1StartupAction) {
            $.tunnel1StartupAction = tunnel1StartupAction;
            return this;
        }

        /**
         * @param tunnel1StartupAction The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel1StartupAction(String tunnel1StartupAction) {
            return tunnel1StartupAction(Output.of(tunnel1StartupAction));
        }

        /**
         * @param tunnel1VgwInsideAddress The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
         * 
         * @return builder
         * 
         */
        public Builder tunnel1VgwInsideAddress(@Nullable Output<String> tunnel1VgwInsideAddress) {
            $.tunnel1VgwInsideAddress = tunnel1VgwInsideAddress;
            return this;
        }

        /**
         * @param tunnel1VgwInsideAddress The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
         * 
         * @return builder
         * 
         */
        public Builder tunnel1VgwInsideAddress(String tunnel1VgwInsideAddress) {
            return tunnel1VgwInsideAddress(Output.of(tunnel1VgwInsideAddress));
        }

        /**
         * @param tunnel2Address The public IP address of the second VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Address(@Nullable Output<String> tunnel2Address) {
            $.tunnel2Address = tunnel2Address;
            return this;
        }

        /**
         * @param tunnel2Address The public IP address of the second VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Address(String tunnel2Address) {
            return tunnel2Address(Output.of(tunnel2Address));
        }

        /**
         * @param tunnel2BgpAsn The bgp asn number of the second VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2BgpAsn(@Nullable Output<String> tunnel2BgpAsn) {
            $.tunnel2BgpAsn = tunnel2BgpAsn;
            return this;
        }

        /**
         * @param tunnel2BgpAsn The bgp asn number of the second VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2BgpAsn(String tunnel2BgpAsn) {
            return tunnel2BgpAsn(Output.of(tunnel2BgpAsn));
        }

        /**
         * @param tunnel2BgpHoldtime The bgp holdtime of the second VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2BgpHoldtime(@Nullable Output<Integer> tunnel2BgpHoldtime) {
            $.tunnel2BgpHoldtime = tunnel2BgpHoldtime;
            return this;
        }

        /**
         * @param tunnel2BgpHoldtime The bgp holdtime of the second VPN tunnel.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2BgpHoldtime(Integer tunnel2BgpHoldtime) {
            return tunnel2BgpHoldtime(Output.of(tunnel2BgpHoldtime));
        }

        /**
         * @param tunnel2CgwInsideAddress The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
         * 
         * @return builder
         * 
         */
        public Builder tunnel2CgwInsideAddress(@Nullable Output<String> tunnel2CgwInsideAddress) {
            $.tunnel2CgwInsideAddress = tunnel2CgwInsideAddress;
            return this;
        }

        /**
         * @param tunnel2CgwInsideAddress The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
         * 
         * @return builder
         * 
         */
        public Builder tunnel2CgwInsideAddress(String tunnel2CgwInsideAddress) {
            return tunnel2CgwInsideAddress(Output.of(tunnel2CgwInsideAddress));
        }

        /**
         * @param tunnel2DpdTimeoutAction The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2DpdTimeoutAction(@Nullable Output<String> tunnel2DpdTimeoutAction) {
            $.tunnel2DpdTimeoutAction = tunnel2DpdTimeoutAction;
            return this;
        }

        /**
         * @param tunnel2DpdTimeoutAction The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2DpdTimeoutAction(String tunnel2DpdTimeoutAction) {
            return tunnel2DpdTimeoutAction(Output.of(tunnel2DpdTimeoutAction));
        }

        /**
         * @param tunnel2DpdTimeoutSeconds The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2DpdTimeoutSeconds(@Nullable Output<Integer> tunnel2DpdTimeoutSeconds) {
            $.tunnel2DpdTimeoutSeconds = tunnel2DpdTimeoutSeconds;
            return this;
        }

        /**
         * @param tunnel2DpdTimeoutSeconds The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2DpdTimeoutSeconds(Integer tunnel2DpdTimeoutSeconds) {
            return tunnel2DpdTimeoutSeconds(Output.of(tunnel2DpdTimeoutSeconds));
        }

        /**
         * @param tunnel2EnableTunnelLifecycleControl Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2EnableTunnelLifecycleControl(@Nullable Output<Boolean> tunnel2EnableTunnelLifecycleControl) {
            $.tunnel2EnableTunnelLifecycleControl = tunnel2EnableTunnelLifecycleControl;
            return this;
        }

        /**
         * @param tunnel2EnableTunnelLifecycleControl Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2EnableTunnelLifecycleControl(Boolean tunnel2EnableTunnelLifecycleControl) {
            return tunnel2EnableTunnelLifecycleControl(Output.of(tunnel2EnableTunnelLifecycleControl));
        }

        /**
         * @param tunnel2IkeVersions The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2IkeVersions(@Nullable Output<List<String>> tunnel2IkeVersions) {
            $.tunnel2IkeVersions = tunnel2IkeVersions;
            return this;
        }

        /**
         * @param tunnel2IkeVersions The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2IkeVersions(List<String> tunnel2IkeVersions) {
            return tunnel2IkeVersions(Output.of(tunnel2IkeVersions));
        }

        /**
         * @param tunnel2IkeVersions The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2IkeVersions(String... tunnel2IkeVersions) {
            return tunnel2IkeVersions(List.of(tunnel2IkeVersions));
        }

        /**
         * @param tunnel2InsideCidr The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2InsideCidr(@Nullable Output<String> tunnel2InsideCidr) {
            $.tunnel2InsideCidr = tunnel2InsideCidr;
            return this;
        }

        /**
         * @param tunnel2InsideCidr The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2InsideCidr(String tunnel2InsideCidr) {
            return tunnel2InsideCidr(Output.of(tunnel2InsideCidr));
        }

        /**
         * @param tunnel2InsideIpv6Cidr The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2InsideIpv6Cidr(@Nullable Output<String> tunnel2InsideIpv6Cidr) {
            $.tunnel2InsideIpv6Cidr = tunnel2InsideIpv6Cidr;
            return this;
        }

        /**
         * @param tunnel2InsideIpv6Cidr The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2InsideIpv6Cidr(String tunnel2InsideIpv6Cidr) {
            return tunnel2InsideIpv6Cidr(Output.of(tunnel2InsideIpv6Cidr));
        }

        /**
         * @param tunnel2LogOptions Options for logging VPN tunnel activity. See Log Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2LogOptions(@Nullable Output<VpnConnectionTunnel2LogOptionsArgs> tunnel2LogOptions) {
            $.tunnel2LogOptions = tunnel2LogOptions;
            return this;
        }

        /**
         * @param tunnel2LogOptions Options for logging VPN tunnel activity. See Log Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2LogOptions(VpnConnectionTunnel2LogOptionsArgs tunnel2LogOptions) {
            return tunnel2LogOptions(Output.of(tunnel2LogOptions));
        }

        /**
         * @param tunnel2Phase1DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1DhGroupNumbers(@Nullable Output<List<Integer>> tunnel2Phase1DhGroupNumbers) {
            $.tunnel2Phase1DhGroupNumbers = tunnel2Phase1DhGroupNumbers;
            return this;
        }

        /**
         * @param tunnel2Phase1DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1DhGroupNumbers(List<Integer> tunnel2Phase1DhGroupNumbers) {
            return tunnel2Phase1DhGroupNumbers(Output.of(tunnel2Phase1DhGroupNumbers));
        }

        /**
         * @param tunnel2Phase1DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1DhGroupNumbers(Integer... tunnel2Phase1DhGroupNumbers) {
            return tunnel2Phase1DhGroupNumbers(List.of(tunnel2Phase1DhGroupNumbers));
        }

        /**
         * @param tunnel2Phase1EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1EncryptionAlgorithms(@Nullable Output<List<String>> tunnel2Phase1EncryptionAlgorithms) {
            $.tunnel2Phase1EncryptionAlgorithms = tunnel2Phase1EncryptionAlgorithms;
            return this;
        }

        /**
         * @param tunnel2Phase1EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1EncryptionAlgorithms(List<String> tunnel2Phase1EncryptionAlgorithms) {
            return tunnel2Phase1EncryptionAlgorithms(Output.of(tunnel2Phase1EncryptionAlgorithms));
        }

        /**
         * @param tunnel2Phase1EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1EncryptionAlgorithms(String... tunnel2Phase1EncryptionAlgorithms) {
            return tunnel2Phase1EncryptionAlgorithms(List.of(tunnel2Phase1EncryptionAlgorithms));
        }

        /**
         * @param tunnel2Phase1IntegrityAlgorithms One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1IntegrityAlgorithms(@Nullable Output<List<String>> tunnel2Phase1IntegrityAlgorithms) {
            $.tunnel2Phase1IntegrityAlgorithms = tunnel2Phase1IntegrityAlgorithms;
            return this;
        }

        /**
         * @param tunnel2Phase1IntegrityAlgorithms One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1IntegrityAlgorithms(List<String> tunnel2Phase1IntegrityAlgorithms) {
            return tunnel2Phase1IntegrityAlgorithms(Output.of(tunnel2Phase1IntegrityAlgorithms));
        }

        /**
         * @param tunnel2Phase1IntegrityAlgorithms One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1IntegrityAlgorithms(String... tunnel2Phase1IntegrityAlgorithms) {
            return tunnel2Phase1IntegrityAlgorithms(List.of(tunnel2Phase1IntegrityAlgorithms));
        }

        /**
         * @param tunnel2Phase1LifetimeSeconds The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1LifetimeSeconds(@Nullable Output<Integer> tunnel2Phase1LifetimeSeconds) {
            $.tunnel2Phase1LifetimeSeconds = tunnel2Phase1LifetimeSeconds;
            return this;
        }

        /**
         * @param tunnel2Phase1LifetimeSeconds The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase1LifetimeSeconds(Integer tunnel2Phase1LifetimeSeconds) {
            return tunnel2Phase1LifetimeSeconds(Output.of(tunnel2Phase1LifetimeSeconds));
        }

        /**
         * @param tunnel2Phase2DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2DhGroupNumbers(@Nullable Output<List<Integer>> tunnel2Phase2DhGroupNumbers) {
            $.tunnel2Phase2DhGroupNumbers = tunnel2Phase2DhGroupNumbers;
            return this;
        }

        /**
         * @param tunnel2Phase2DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2DhGroupNumbers(List<Integer> tunnel2Phase2DhGroupNumbers) {
            return tunnel2Phase2DhGroupNumbers(Output.of(tunnel2Phase2DhGroupNumbers));
        }

        /**
         * @param tunnel2Phase2DhGroupNumbers List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2DhGroupNumbers(Integer... tunnel2Phase2DhGroupNumbers) {
            return tunnel2Phase2DhGroupNumbers(List.of(tunnel2Phase2DhGroupNumbers));
        }

        /**
         * @param tunnel2Phase2EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2EncryptionAlgorithms(@Nullable Output<List<String>> tunnel2Phase2EncryptionAlgorithms) {
            $.tunnel2Phase2EncryptionAlgorithms = tunnel2Phase2EncryptionAlgorithms;
            return this;
        }

        /**
         * @param tunnel2Phase2EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2EncryptionAlgorithms(List<String> tunnel2Phase2EncryptionAlgorithms) {
            return tunnel2Phase2EncryptionAlgorithms(Output.of(tunnel2Phase2EncryptionAlgorithms));
        }

        /**
         * @param tunnel2Phase2EncryptionAlgorithms List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2EncryptionAlgorithms(String... tunnel2Phase2EncryptionAlgorithms) {
            return tunnel2Phase2EncryptionAlgorithms(List.of(tunnel2Phase2EncryptionAlgorithms));
        }

        /**
         * @param tunnel2Phase2IntegrityAlgorithms List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2IntegrityAlgorithms(@Nullable Output<List<String>> tunnel2Phase2IntegrityAlgorithms) {
            $.tunnel2Phase2IntegrityAlgorithms = tunnel2Phase2IntegrityAlgorithms;
            return this;
        }

        /**
         * @param tunnel2Phase2IntegrityAlgorithms List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2IntegrityAlgorithms(List<String> tunnel2Phase2IntegrityAlgorithms) {
            return tunnel2Phase2IntegrityAlgorithms(Output.of(tunnel2Phase2IntegrityAlgorithms));
        }

        /**
         * @param tunnel2Phase2IntegrityAlgorithms List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2IntegrityAlgorithms(String... tunnel2Phase2IntegrityAlgorithms) {
            return tunnel2Phase2IntegrityAlgorithms(List.of(tunnel2Phase2IntegrityAlgorithms));
        }

        /**
         * @param tunnel2Phase2LifetimeSeconds The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2LifetimeSeconds(@Nullable Output<Integer> tunnel2Phase2LifetimeSeconds) {
            $.tunnel2Phase2LifetimeSeconds = tunnel2Phase2LifetimeSeconds;
            return this;
        }

        /**
         * @param tunnel2Phase2LifetimeSeconds The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2Phase2LifetimeSeconds(Integer tunnel2Phase2LifetimeSeconds) {
            return tunnel2Phase2LifetimeSeconds(Output.of(tunnel2Phase2LifetimeSeconds));
        }

        /**
         * @param tunnel2PresharedKey The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
         * 
         * @return builder
         * 
         */
        public Builder tunnel2PresharedKey(@Nullable Output<String> tunnel2PresharedKey) {
            $.tunnel2PresharedKey = tunnel2PresharedKey;
            return this;
        }

        /**
         * @param tunnel2PresharedKey The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
         * 
         * @return builder
         * 
         */
        public Builder tunnel2PresharedKey(String tunnel2PresharedKey) {
            return tunnel2PresharedKey(Output.of(tunnel2PresharedKey));
        }

        /**
         * @param tunnel2RekeyFuzzPercentage The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2RekeyFuzzPercentage(@Nullable Output<Integer> tunnel2RekeyFuzzPercentage) {
            $.tunnel2RekeyFuzzPercentage = tunnel2RekeyFuzzPercentage;
            return this;
        }

        /**
         * @param tunnel2RekeyFuzzPercentage The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2RekeyFuzzPercentage(Integer tunnel2RekeyFuzzPercentage) {
            return tunnel2RekeyFuzzPercentage(Output.of(tunnel2RekeyFuzzPercentage));
        }

        /**
         * @param tunnel2RekeyMarginTimeSeconds The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2RekeyMarginTimeSeconds(@Nullable Output<Integer> tunnel2RekeyMarginTimeSeconds) {
            $.tunnel2RekeyMarginTimeSeconds = tunnel2RekeyMarginTimeSeconds;
            return this;
        }

        /**
         * @param tunnel2RekeyMarginTimeSeconds The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2RekeyMarginTimeSeconds(Integer tunnel2RekeyMarginTimeSeconds) {
            return tunnel2RekeyMarginTimeSeconds(Output.of(tunnel2RekeyMarginTimeSeconds));
        }

        /**
         * @param tunnel2ReplayWindowSize The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2ReplayWindowSize(@Nullable Output<Integer> tunnel2ReplayWindowSize) {
            $.tunnel2ReplayWindowSize = tunnel2ReplayWindowSize;
            return this;
        }

        /**
         * @param tunnel2ReplayWindowSize The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2ReplayWindowSize(Integer tunnel2ReplayWindowSize) {
            return tunnel2ReplayWindowSize(Output.of(tunnel2ReplayWindowSize));
        }

        /**
         * @param tunnel2StartupAction The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2StartupAction(@Nullable Output<String> tunnel2StartupAction) {
            $.tunnel2StartupAction = tunnel2StartupAction;
            return this;
        }

        /**
         * @param tunnel2StartupAction The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
         * 
         * @return builder
         * 
         */
        public Builder tunnel2StartupAction(String tunnel2StartupAction) {
            return tunnel2StartupAction(Output.of(tunnel2StartupAction));
        }

        /**
         * @param tunnel2VgwInsideAddress The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
         * 
         * @return builder
         * 
         */
        public Builder tunnel2VgwInsideAddress(@Nullable Output<String> tunnel2VgwInsideAddress) {
            $.tunnel2VgwInsideAddress = tunnel2VgwInsideAddress;
            return this;
        }

        /**
         * @param tunnel2VgwInsideAddress The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
         * 
         * @return builder
         * 
         */
        public Builder tunnel2VgwInsideAddress(String tunnel2VgwInsideAddress) {
            return tunnel2VgwInsideAddress(Output.of(tunnel2VgwInsideAddress));
        }

        /**
         * @param tunnelInsideIpVersion Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
         * 
         * @return builder
         * 
         */
        public Builder tunnelInsideIpVersion(@Nullable Output<String> tunnelInsideIpVersion) {
            $.tunnelInsideIpVersion = tunnelInsideIpVersion;
            return this;
        }

        /**
         * @param tunnelInsideIpVersion Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
         * 
         * @return builder
         * 
         */
        public Builder tunnelInsideIpVersion(String tunnelInsideIpVersion) {
            return tunnelInsideIpVersion(Output.of(tunnelInsideIpVersion));
        }

        /**
         * @param type The type of VPN connection. The only type AWS supports at this time is &#34;ipsec.1&#34;.
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type The type of VPN connection. The only type AWS supports at this time is &#34;ipsec.1&#34;.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        /**
         * @param vgwTelemetries Telemetry for the VPN tunnels. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder vgwTelemetries(@Nullable Output<List<VpnConnectionVgwTelemetryArgs>> vgwTelemetries) {
            $.vgwTelemetries = vgwTelemetries;
            return this;
        }

        /**
         * @param vgwTelemetries Telemetry for the VPN tunnels. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder vgwTelemetries(List<VpnConnectionVgwTelemetryArgs> vgwTelemetries) {
            return vgwTelemetries(Output.of(vgwTelemetries));
        }

        /**
         * @param vgwTelemetries Telemetry for the VPN tunnels. Detailed below.
         * 
         * @return builder
         * 
         */
        public Builder vgwTelemetries(VpnConnectionVgwTelemetryArgs... vgwTelemetries) {
            return vgwTelemetries(List.of(vgwTelemetries));
        }

        /**
         * @param vpnGatewayId The ID of the Virtual Private Gateway.
         * 
         * @return builder
         * 
         */
        public Builder vpnGatewayId(@Nullable Output<String> vpnGatewayId) {
            $.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * @param vpnGatewayId The ID of the Virtual Private Gateway.
         * 
         * @return builder
         * 
         */
        public Builder vpnGatewayId(String vpnGatewayId) {
            return vpnGatewayId(Output.of(vpnGatewayId));
        }

        public VpnConnectionState build() {
            return $;
        }
    }

}
