// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2.inputs;

import com.pulumi.aws.ec2.inputs.VpcPeeringConnectionAccepterArgs;
import com.pulumi.aws.ec2.inputs.VpcPeeringConnectionRequesterArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VpcPeeringConnectionState extends com.pulumi.resources.ResourceArgs {

    public static final VpcPeeringConnectionState Empty = new VpcPeeringConnectionState();

    /**
     * The status of the VPC Peering Connection request.
     * 
     */
    @Import(name="acceptStatus")
    private @Nullable Output<String> acceptStatus;

    /**
     * @return The status of the VPC Peering Connection request.
     * 
     */
    public Optional<Output<String>> acceptStatus() {
        return Optional.ofNullable(this.acceptStatus);
    }

    /**
     * An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that accepts
     * the peering connection (a maximum of one).
     * 
     */
    @Import(name="accepter")
    private @Nullable Output<VpcPeeringConnectionAccepterArgs> accepter;

    /**
     * @return An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that accepts
     * the peering connection (a maximum of one).
     * 
     */
    public Optional<Output<VpcPeeringConnectionAccepterArgs>> accepter() {
        return Optional.ofNullable(this.accepter);
    }

    /**
     * Accept the peering (both VPCs need to be in the same AWS account and region).
     * 
     */
    @Import(name="autoAccept")
    private @Nullable Output<Boolean> autoAccept;

    /**
     * @return Accept the peering (both VPCs need to be in the same AWS account and region).
     * 
     */
    public Optional<Output<Boolean>> autoAccept() {
        return Optional.ofNullable(this.autoAccept);
    }

    /**
     * The AWS account ID of the owner of the peer VPC.
     * Defaults to the account ID the AWS provider is currently connected to.
     * 
     */
    @Import(name="peerOwnerId")
    private @Nullable Output<String> peerOwnerId;

    /**
     * @return The AWS account ID of the owner of the peer VPC.
     * Defaults to the account ID the AWS provider is currently connected to.
     * 
     */
    public Optional<Output<String>> peerOwnerId() {
        return Optional.ofNullable(this.peerOwnerId);
    }

    /**
     * The region of the accepter VPC of the VPC Peering Connection. `auto_accept` must be `false`,
     * and use the `aws.ec2.VpcPeeringConnectionAccepter` to manage the accepter side.
     * 
     */
    @Import(name="peerRegion")
    private @Nullable Output<String> peerRegion;

    /**
     * @return The region of the accepter VPC of the VPC Peering Connection. `auto_accept` must be `false`,
     * and use the `aws.ec2.VpcPeeringConnectionAccepter` to manage the accepter side.
     * 
     */
    public Optional<Output<String>> peerRegion() {
        return Optional.ofNullable(this.peerRegion);
    }

    /**
     * The ID of the VPC with which you are creating the VPC Peering Connection.
     * 
     */
    @Import(name="peerVpcId")
    private @Nullable Output<String> peerVpcId;

    /**
     * @return The ID of the VPC with which you are creating the VPC Peering Connection.
     * 
     */
    public Optional<Output<String>> peerVpcId() {
        return Optional.ofNullable(this.peerVpcId);
    }

    /**
     * A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requests
     * the peering connection (a maximum of one).
     * 
     */
    @Import(name="requester")
    private @Nullable Output<VpcPeeringConnectionRequesterArgs> requester;

    /**
     * @return A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requests
     * the peering connection (a maximum of one).
     * 
     */
    public Optional<Output<VpcPeeringConnectionRequesterArgs>> requester() {
        return Optional.ofNullable(this.requester);
    }

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * The ID of the requester VPC.
     * 
     */
    @Import(name="vpcId")
    private @Nullable Output<String> vpcId;

    /**
     * @return The ID of the requester VPC.
     * 
     */
    public Optional<Output<String>> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    private VpcPeeringConnectionState() {}

    private VpcPeeringConnectionState(VpcPeeringConnectionState $) {
        this.acceptStatus = $.acceptStatus;
        this.accepter = $.accepter;
        this.autoAccept = $.autoAccept;
        this.peerOwnerId = $.peerOwnerId;
        this.peerRegion = $.peerRegion;
        this.peerVpcId = $.peerVpcId;
        this.requester = $.requester;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.vpcId = $.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VpcPeeringConnectionState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VpcPeeringConnectionState $;

        public Builder() {
            $ = new VpcPeeringConnectionState();
        }

        public Builder(VpcPeeringConnectionState defaults) {
            $ = new VpcPeeringConnectionState(Objects.requireNonNull(defaults));
        }

        /**
         * @param acceptStatus The status of the VPC Peering Connection request.
         * 
         * @return builder
         * 
         */
        public Builder acceptStatus(@Nullable Output<String> acceptStatus) {
            $.acceptStatus = acceptStatus;
            return this;
        }

        /**
         * @param acceptStatus The status of the VPC Peering Connection request.
         * 
         * @return builder
         * 
         */
        public Builder acceptStatus(String acceptStatus) {
            return acceptStatus(Output.of(acceptStatus));
        }

        /**
         * @param accepter An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that accepts
         * the peering connection (a maximum of one).
         * 
         * @return builder
         * 
         */
        public Builder accepter(@Nullable Output<VpcPeeringConnectionAccepterArgs> accepter) {
            $.accepter = accepter;
            return this;
        }

        /**
         * @param accepter An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that accepts
         * the peering connection (a maximum of one).
         * 
         * @return builder
         * 
         */
        public Builder accepter(VpcPeeringConnectionAccepterArgs accepter) {
            return accepter(Output.of(accepter));
        }

        /**
         * @param autoAccept Accept the peering (both VPCs need to be in the same AWS account and region).
         * 
         * @return builder
         * 
         */
        public Builder autoAccept(@Nullable Output<Boolean> autoAccept) {
            $.autoAccept = autoAccept;
            return this;
        }

        /**
         * @param autoAccept Accept the peering (both VPCs need to be in the same AWS account and region).
         * 
         * @return builder
         * 
         */
        public Builder autoAccept(Boolean autoAccept) {
            return autoAccept(Output.of(autoAccept));
        }

        /**
         * @param peerOwnerId The AWS account ID of the owner of the peer VPC.
         * Defaults to the account ID the AWS provider is currently connected to.
         * 
         * @return builder
         * 
         */
        public Builder peerOwnerId(@Nullable Output<String> peerOwnerId) {
            $.peerOwnerId = peerOwnerId;
            return this;
        }

        /**
         * @param peerOwnerId The AWS account ID of the owner of the peer VPC.
         * Defaults to the account ID the AWS provider is currently connected to.
         * 
         * @return builder
         * 
         */
        public Builder peerOwnerId(String peerOwnerId) {
            return peerOwnerId(Output.of(peerOwnerId));
        }

        /**
         * @param peerRegion The region of the accepter VPC of the VPC Peering Connection. `auto_accept` must be `false`,
         * and use the `aws.ec2.VpcPeeringConnectionAccepter` to manage the accepter side.
         * 
         * @return builder
         * 
         */
        public Builder peerRegion(@Nullable Output<String> peerRegion) {
            $.peerRegion = peerRegion;
            return this;
        }

        /**
         * @param peerRegion The region of the accepter VPC of the VPC Peering Connection. `auto_accept` must be `false`,
         * and use the `aws.ec2.VpcPeeringConnectionAccepter` to manage the accepter side.
         * 
         * @return builder
         * 
         */
        public Builder peerRegion(String peerRegion) {
            return peerRegion(Output.of(peerRegion));
        }

        /**
         * @param peerVpcId The ID of the VPC with which you are creating the VPC Peering Connection.
         * 
         * @return builder
         * 
         */
        public Builder peerVpcId(@Nullable Output<String> peerVpcId) {
            $.peerVpcId = peerVpcId;
            return this;
        }

        /**
         * @param peerVpcId The ID of the VPC with which you are creating the VPC Peering Connection.
         * 
         * @return builder
         * 
         */
        public Builder peerVpcId(String peerVpcId) {
            return peerVpcId(Output.of(peerVpcId));
        }

        /**
         * @param requester A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requests
         * the peering connection (a maximum of one).
         * 
         * @return builder
         * 
         */
        public Builder requester(@Nullable Output<VpcPeeringConnectionRequesterArgs> requester) {
            $.requester = requester;
            return this;
        }

        /**
         * @param requester A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requests
         * the peering connection (a maximum of one).
         * 
         * @return builder
         * 
         */
        public Builder requester(VpcPeeringConnectionRequesterArgs requester) {
            return requester(Output.of(requester));
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param vpcId The ID of the requester VPC.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(@Nullable Output<String> vpcId) {
            $.vpcId = vpcId;
            return this;
        }

        /**
         * @param vpcId The ID of the requester VPC.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(String vpcId) {
            return vpcId(Output.of(vpcId));
        }

        public VpcPeeringConnectionState build() {
            return $;
        }
    }

}
