// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2.inputs;

import com.pulumi.aws.ec2.inputs.SpotInstanceRequestCapacityReservationSpecificationArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestCpuOptionsArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestCreditSpecificationArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestEbsBlockDeviceArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestEnclaveOptionsArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestEphemeralBlockDeviceArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestLaunchTemplateArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestMaintenanceOptionsArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestMetadataOptionsArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestNetworkInterfaceArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestPrivateDnsNameOptionsArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestRootBlockDeviceArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SpotInstanceRequestState extends com.pulumi.resources.ResourceArgs {

    public static final SpotInstanceRequestState Empty = new SpotInstanceRequestState();

    /**
     * AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     * 
     */
    @Import(name="ami")
    private @Nullable Output<String> ami;

    /**
     * @return AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     * 
     */
    public Optional<Output<String>> ami() {
        return Optional.ofNullable(this.ami);
    }

    @Import(name="arn")
    private @Nullable Output<String> arn;

    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Whether to associate a public IP address with an instance in a VPC.
     * 
     */
    @Import(name="associatePublicIpAddress")
    private @Nullable Output<Boolean> associatePublicIpAddress;

    /**
     * @return Whether to associate a public IP address with an instance in a VPC.
     * 
     */
    public Optional<Output<Boolean>> associatePublicIpAddress() {
        return Optional.ofNullable(this.associatePublicIpAddress);
    }

    /**
     * AZ to start the instance in.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return AZ to start the instance in.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
     * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
     * Note that you can&#39;t specify an Availability Zone group or a launch group if you specify a duration.
     * 
     */
    @Import(name="blockDurationMinutes")
    private @Nullable Output<Integer> blockDurationMinutes;

    /**
     * @return The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
     * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
     * Note that you can&#39;t specify an Availability Zone group or a launch group if you specify a duration.
     * 
     */
    public Optional<Output<Integer>> blockDurationMinutes() {
        return Optional.ofNullable(this.blockDurationMinutes);
    }

    /**
     * Describes an instance&#39;s Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * 
     * &gt; **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     * 
     */
    @Import(name="capacityReservationSpecification")
    private @Nullable Output<SpotInstanceRequestCapacityReservationSpecificationArgs> capacityReservationSpecification;

    /**
     * @return Describes an instance&#39;s Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * 
     * &gt; **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     * 
     */
    public Optional<Output<SpotInstanceRequestCapacityReservationSpecificationArgs>> capacityReservationSpecification() {
        return Optional.ofNullable(this.capacityReservationSpecification);
    }

    /**
     * Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     * 
     * @deprecated
     * use &#39;cpu_options&#39; argument instead
     * 
     */
    @Deprecated /* use 'cpu_options' argument instead */
    @Import(name="cpuCoreCount")
    private @Nullable Output<Integer> cpuCoreCount;

    /**
     * @return Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     * 
     * @deprecated
     * use &#39;cpu_options&#39; argument instead
     * 
     */
    @Deprecated /* use 'cpu_options' argument instead */
    public Optional<Output<Integer>> cpuCoreCount() {
        return Optional.ofNullable(this.cpuCoreCount);
    }

    /**
     * The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    @Import(name="cpuOptions")
    private @Nullable Output<SpotInstanceRequestCpuOptionsArgs> cpuOptions;

    /**
     * @return The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    public Optional<Output<SpotInstanceRequestCpuOptionsArgs>> cpuOptions() {
        return Optional.ofNullable(this.cpuOptions);
    }

    /**
     * If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     * 
     * @deprecated
     * use &#39;cpu_options&#39; argument instead
     * 
     */
    @Deprecated /* use 'cpu_options' argument instead */
    @Import(name="cpuThreadsPerCore")
    private @Nullable Output<Integer> cpuThreadsPerCore;

    /**
     * @return If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     * 
     * @deprecated
     * use &#39;cpu_options&#39; argument instead
     * 
     */
    @Deprecated /* use 'cpu_options' argument instead */
    public Optional<Output<Integer>> cpuThreadsPerCore() {
        return Optional.ofNullable(this.cpuThreadsPerCore);
    }

    /**
     * Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     * 
     */
    @Import(name="creditSpecification")
    private @Nullable Output<SpotInstanceRequestCreditSpecificationArgs> creditSpecification;

    /**
     * @return Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     * 
     */
    public Optional<Output<SpotInstanceRequestCreditSpecificationArgs>> creditSpecification() {
        return Optional.ofNullable(this.creditSpecification);
    }

    /**
     * If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    @Import(name="disableApiStop")
    private @Nullable Output<Boolean> disableApiStop;

    /**
     * @return If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    public Optional<Output<Boolean>> disableApiStop() {
        return Optional.ofNullable(this.disableApiStop);
    }

    /**
     * If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     * 
     */
    @Import(name="disableApiTermination")
    private @Nullable Output<Boolean> disableApiTermination;

    /**
     * @return If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     * 
     */
    public Optional<Output<Boolean>> disableApiTermination() {
        return Optional.ofNullable(this.disableApiTermination);
    }

    /**
     * One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    @Import(name="ebsBlockDevices")
    private @Nullable Output<List<SpotInstanceRequestEbsBlockDeviceArgs>> ebsBlockDevices;

    /**
     * @return One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    public Optional<Output<List<SpotInstanceRequestEbsBlockDeviceArgs>>> ebsBlockDevices() {
        return Optional.ofNullable(this.ebsBlockDevices);
    }

    /**
     * If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     * 
     */
    @Import(name="ebsOptimized")
    private @Nullable Output<Boolean> ebsOptimized;

    /**
     * @return If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     * 
     */
    public Optional<Output<Boolean>> ebsOptimized() {
        return Optional.ofNullable(this.ebsOptimized);
    }

    /**
     * Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    @Import(name="enclaveOptions")
    private @Nullable Output<SpotInstanceRequestEnclaveOptionsArgs> enclaveOptions;

    /**
     * @return Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    public Optional<Output<SpotInstanceRequestEnclaveOptionsArgs>> enclaveOptions() {
        return Optional.ofNullable(this.enclaveOptions);
    }

    /**
     * One or more configuration blocks to customize Ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    @Import(name="ephemeralBlockDevices")
    private @Nullable Output<List<SpotInstanceRequestEphemeralBlockDeviceArgs>> ephemeralBlockDevices;

    /**
     * @return One or more configuration blocks to customize Ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    public Optional<Output<List<SpotInstanceRequestEphemeralBlockDeviceArgs>>> ephemeralBlockDevices() {
        return Optional.ofNullable(this.ephemeralBlockDevices);
    }

    /**
     * If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    @Import(name="getPasswordData")
    private @Nullable Output<Boolean> getPasswordData;

    /**
     * @return If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    public Optional<Output<Boolean>> getPasswordData() {
        return Optional.ofNullable(this.getPasswordData);
    }

    /**
     * If true, the launched EC2 instance will support hibernation.
     * 
     */
    @Import(name="hibernation")
    private @Nullable Output<Boolean> hibernation;

    /**
     * @return If true, the launched EC2 instance will support hibernation.
     * 
     */
    public Optional<Output<Boolean>> hibernation() {
        return Optional.ofNullable(this.hibernation);
    }

    /**
     * ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     * 
     */
    @Import(name="hostId")
    private @Nullable Output<String> hostId;

    /**
     * @return ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     * 
     */
    public Optional<Output<String>> hostId() {
        return Optional.ofNullable(this.hostId);
    }

    /**
     * ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     * 
     */
    @Import(name="hostResourceGroupArn")
    private @Nullable Output<String> hostResourceGroupArn;

    /**
     * @return ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     * 
     */
    public Optional<Output<String>> hostResourceGroupArn() {
        return Optional.ofNullable(this.hostResourceGroupArn);
    }

    /**
     * IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     * 
     */
    @Import(name="iamInstanceProfile")
    private @Nullable Output<String> iamInstanceProfile;

    /**
     * @return IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     * 
     */
    public Optional<Output<String>> iamInstanceProfile() {
        return Optional.ofNullable(this.iamInstanceProfile);
    }

    /**
     * Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     * 
     */
    @Import(name="instanceInitiatedShutdownBehavior")
    private @Nullable Output<String> instanceInitiatedShutdownBehavior;

    /**
     * @return Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     * 
     */
    public Optional<Output<String>> instanceInitiatedShutdownBehavior() {
        return Optional.ofNullable(this.instanceInitiatedShutdownBehavior);
    }

    /**
     * The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
     * 
     */
    @Import(name="instanceInterruptionBehavior")
    private @Nullable Output<String> instanceInterruptionBehavior;

    /**
     * @return The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
     * 
     */
    public Optional<Output<String>> instanceInterruptionBehavior() {
        return Optional.ofNullable(this.instanceInterruptionBehavior);
    }

    @Import(name="instanceState")
    private @Nullable Output<String> instanceState;

    public Optional<Output<String>> instanceState() {
        return Optional.ofNullable(this.instanceState);
    }

    /**
     * Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     * 
     */
    @Import(name="instanceType")
    private @Nullable Output<String> instanceType;

    /**
     * @return Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     * 
     */
    public Optional<Output<String>> instanceType() {
        return Optional.ofNullable(this.instanceType);
    }

    /**
     * Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     * 
     */
    @Import(name="ipv6AddressCount")
    private @Nullable Output<Integer> ipv6AddressCount;

    /**
     * @return Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     * 
     */
    public Optional<Output<Integer>> ipv6AddressCount() {
        return Optional.ofNullable(this.ipv6AddressCount);
    }

    /**
     * Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     * 
     */
    @Import(name="ipv6Addresses")
    private @Nullable Output<List<String>> ipv6Addresses;

    /**
     * @return Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     * 
     */
    public Optional<Output<List<String>>> ipv6Addresses() {
        return Optional.ofNullable(this.ipv6Addresses);
    }

    /**
     * Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     * 
     */
    @Import(name="keyName")
    private @Nullable Output<String> keyName;

    /**
     * @return Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     * 
     */
    public Optional<Output<String>> keyName() {
        return Optional.ofNullable(this.keyName);
    }

    /**
     * A launch group is a group of spot instances that launch together and terminate together.
     * If left empty instances are launched and terminated individually.
     * 
     */
    @Import(name="launchGroup")
    private @Nullable Output<String> launchGroup;

    /**
     * @return A launch group is a group of spot instances that launch together and terminate together.
     * If left empty instances are launched and terminated individually.
     * 
     */
    public Optional<Output<String>> launchGroup() {
        return Optional.ofNullable(this.launchGroup);
    }

    /**
     * Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     * 
     */
    @Import(name="launchTemplate")
    private @Nullable Output<SpotInstanceRequestLaunchTemplateArgs> launchTemplate;

    /**
     * @return Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     * 
     */
    public Optional<Output<SpotInstanceRequestLaunchTemplateArgs>> launchTemplate() {
        return Optional.ofNullable(this.launchTemplate);
    }

    /**
     * Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     * 
     */
    @Import(name="maintenanceOptions")
    private @Nullable Output<SpotInstanceRequestMaintenanceOptionsArgs> maintenanceOptions;

    /**
     * @return Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     * 
     */
    public Optional<Output<SpotInstanceRequestMaintenanceOptionsArgs>> maintenanceOptions() {
        return Optional.ofNullable(this.maintenanceOptions);
    }

    /**
     * Customize the metadata options of the instance. See Metadata Options below for more details.
     * 
     */
    @Import(name="metadataOptions")
    private @Nullable Output<SpotInstanceRequestMetadataOptionsArgs> metadataOptions;

    /**
     * @return Customize the metadata options of the instance. See Metadata Options below for more details.
     * 
     */
    public Optional<Output<SpotInstanceRequestMetadataOptionsArgs>> metadataOptions() {
        return Optional.ofNullable(this.metadataOptions);
    }

    /**
     * If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     * 
     */
    @Import(name="monitoring")
    private @Nullable Output<Boolean> monitoring;

    /**
     * @return If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     * 
     */
    public Optional<Output<Boolean>> monitoring() {
        return Optional.ofNullable(this.monitoring);
    }

    /**
     * Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     * 
     */
    @Import(name="networkInterfaces")
    private @Nullable Output<List<SpotInstanceRequestNetworkInterfaceArgs>> networkInterfaces;

    /**
     * @return Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     * 
     */
    public Optional<Output<List<SpotInstanceRequestNetworkInterfaceArgs>>> networkInterfaces() {
        return Optional.ofNullable(this.networkInterfaces);
    }

    @Import(name="outpostArn")
    private @Nullable Output<String> outpostArn;

    public Optional<Output<String>> outpostArn() {
        return Optional.ofNullable(this.outpostArn);
    }

    @Import(name="passwordData")
    private @Nullable Output<String> passwordData;

    public Optional<Output<String>> passwordData() {
        return Optional.ofNullable(this.passwordData);
    }

    /**
     * Placement Group to start the instance in.
     * 
     */
    @Import(name="placementGroup")
    private @Nullable Output<String> placementGroup;

    /**
     * @return Placement Group to start the instance in.
     * 
     */
    public Optional<Output<String>> placementGroup() {
        return Optional.ofNullable(this.placementGroup);
    }

    /**
     * Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource&#39;s `strategy` argument is set to `&#34;partition&#34;`.
     * 
     */
    @Import(name="placementPartitionNumber")
    private @Nullable Output<Integer> placementPartitionNumber;

    /**
     * @return Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource&#39;s `strategy` argument is set to `&#34;partition&#34;`.
     * 
     */
    public Optional<Output<Integer>> placementPartitionNumber() {
        return Optional.ofNullable(this.placementPartitionNumber);
    }

    @Import(name="primaryNetworkInterfaceId")
    private @Nullable Output<String> primaryNetworkInterfaceId;

    public Optional<Output<String>> primaryNetworkInterfaceId() {
        return Optional.ofNullable(this.primaryNetworkInterfaceId);
    }

    /**
     * The private DNS name assigned to the instance. Can only be
     * used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames
     * for your VPC
     * 
     */
    @Import(name="privateDns")
    private @Nullable Output<String> privateDns;

    /**
     * @return The private DNS name assigned to the instance. Can only be
     * used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames
     * for your VPC
     * 
     */
    public Optional<Output<String>> privateDns() {
        return Optional.ofNullable(this.privateDns);
    }

    /**
     * Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    @Import(name="privateDnsNameOptions")
    private @Nullable Output<SpotInstanceRequestPrivateDnsNameOptionsArgs> privateDnsNameOptions;

    /**
     * @return Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    public Optional<Output<SpotInstanceRequestPrivateDnsNameOptionsArgs>> privateDnsNameOptions() {
        return Optional.ofNullable(this.privateDnsNameOptions);
    }

    /**
     * Private IP address to associate with the instance in a VPC.
     * 
     */
    @Import(name="privateIp")
    private @Nullable Output<String> privateIp;

    /**
     * @return Private IP address to associate with the instance in a VPC.
     * 
     */
    public Optional<Output<String>> privateIp() {
        return Optional.ofNullable(this.privateIp);
    }

    /**
     * The public DNS name assigned to the instance. For EC2-VPC, this
     * is only available if you&#39;ve enabled DNS hostnames for your VPC
     * 
     */
    @Import(name="publicDns")
    private @Nullable Output<String> publicDns;

    /**
     * @return The public DNS name assigned to the instance. For EC2-VPC, this
     * is only available if you&#39;ve enabled DNS hostnames for your VPC
     * 
     */
    public Optional<Output<String>> publicDns() {
        return Optional.ofNullable(this.publicDns);
    }

    /**
     * The public IP address assigned to the instance, if applicable.
     * 
     */
    @Import(name="publicIp")
    private @Nullable Output<String> publicIp;

    /**
     * @return The public IP address assigned to the instance, if applicable.
     * 
     */
    public Optional<Output<String>> publicIp() {
        return Optional.ofNullable(this.publicIp);
    }

    /**
     * Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     * 
     */
    @Import(name="rootBlockDevice")
    private @Nullable Output<SpotInstanceRequestRootBlockDeviceArgs> rootBlockDevice;

    /**
     * @return Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     * 
     */
    public Optional<Output<SpotInstanceRequestRootBlockDeviceArgs>> rootBlockDevice() {
        return Optional.ofNullable(this.rootBlockDevice);
    }

    /**
     * List of secondary private IPv4 addresses to assign to the instance&#39;s primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     * 
     */
    @Import(name="secondaryPrivateIps")
    private @Nullable Output<List<String>> secondaryPrivateIps;

    /**
     * @return List of secondary private IPv4 addresses to assign to the instance&#39;s primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     * 
     */
    public Optional<Output<List<String>>> secondaryPrivateIps() {
        return Optional.ofNullable(this.secondaryPrivateIps);
    }

    /**
     * List of security group names to associate with.
     * 
     * &gt; **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     * 
     */
    @Import(name="securityGroups")
    private @Nullable Output<List<String>> securityGroups;

    /**
     * @return List of security group names to associate with.
     * 
     * &gt; **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     * 
     */
    public Optional<Output<List<String>>> securityGroups() {
        return Optional.ofNullable(this.securityGroups);
    }

    /**
     * Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     * 
     */
    @Import(name="sourceDestCheck")
    private @Nullable Output<Boolean> sourceDestCheck;

    /**
     * @return Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     * 
     */
    public Optional<Output<Boolean>> sourceDestCheck() {
        return Optional.ofNullable(this.sourceDestCheck);
    }

    /**
     * The current [bid
     * status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
     * of the Spot Instance Request.
     * 
     */
    @Import(name="spotBidStatus")
    private @Nullable Output<String> spotBidStatus;

    /**
     * @return The current [bid
     * status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
     * of the Spot Instance Request.
     * 
     */
    public Optional<Output<String>> spotBidStatus() {
        return Optional.ofNullable(this.spotBidStatus);
    }

    /**
     * The Instance ID (if any) that is currently fulfilling
     * the Spot Instance request.
     * 
     */
    @Import(name="spotInstanceId")
    private @Nullable Output<String> spotInstanceId;

    /**
     * @return The Instance ID (if any) that is currently fulfilling
     * the Spot Instance request.
     * 
     */
    public Optional<Output<String>> spotInstanceId() {
        return Optional.ofNullable(this.spotInstanceId);
    }

    /**
     * The maximum price to request on the spot market.
     * 
     */
    @Import(name="spotPrice")
    private @Nullable Output<String> spotPrice;

    /**
     * @return The maximum price to request on the spot market.
     * 
     */
    public Optional<Output<String>> spotPrice() {
        return Optional.ofNullable(this.spotPrice);
    }

    /**
     * The current [request
     * state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
     * of the Spot Instance Request.
     * 
     */
    @Import(name="spotRequestState")
    private @Nullable Output<String> spotRequestState;

    /**
     * @return The current [request
     * state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
     * of the Spot Instance Request.
     * 
     */
    public Optional<Output<String>> spotRequestState() {
        return Optional.ofNullable(this.spotRequestState);
    }

    /**
     * If set to `one-time`, after
     * the instance is terminated, the spot request will be closed.
     * 
     */
    @Import(name="spotType")
    private @Nullable Output<String> spotType;

    /**
     * @return If set to `one-time`, after
     * the instance is terminated, the spot request will be closed.
     * 
     */
    public Optional<Output<String>> spotType() {
        return Optional.ofNullable(this.spotType);
    }

    /**
     * VPC Subnet ID to launch in.
     * 
     */
    @Import(name="subnetId")
    private @Nullable Output<String> subnetId;

    /**
     * @return VPC Subnet ID to launch in.
     * 
     */
    public Optional<Output<String>> subnetId() {
        return Optional.ofNullable(this.subnetId);
    }

    /**
     * Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     * 
     */
    @Import(name="tenancy")
    private @Nullable Output<String> tenancy;

    /**
     * @return Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     * 
     */
    public Optional<Output<String>> tenancy() {
        return Optional.ofNullable(this.tenancy);
    }

    /**
     * User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    @Import(name="userData")
    private @Nullable Output<String> userData;

    /**
     * @return User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    public Optional<Output<String>> userData() {
        return Optional.ofNullable(this.userData);
    }

    /**
     * Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    @Import(name="userDataBase64")
    private @Nullable Output<String> userDataBase64;

    /**
     * @return Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    public Optional<Output<String>> userDataBase64() {
        return Optional.ofNullable(this.userDataBase64);
    }

    /**
     * When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     * 
     */
    @Import(name="userDataReplaceOnChange")
    private @Nullable Output<Boolean> userDataReplaceOnChange;

    /**
     * @return When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     * 
     */
    public Optional<Output<Boolean>> userDataReplaceOnChange() {
        return Optional.ofNullable(this.userDataReplaceOnChange);
    }

    /**
     * The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     * 
     */
    @Import(name="validFrom")
    private @Nullable Output<String> validFrom;

    /**
     * @return The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     * 
     */
    public Optional<Output<String>> validFrom() {
        return Optional.ofNullable(this.validFrom);
    }

    /**
     * The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
     * 
     */
    @Import(name="validUntil")
    private @Nullable Output<String> validUntil;

    /**
     * @return The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
     * 
     */
    public Optional<Output<String>> validUntil() {
        return Optional.ofNullable(this.validUntil);
    }

    /**
     * Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * 
     * &gt; **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     * 
     */
    @Import(name="volumeTags")
    private @Nullable Output<Map<String,String>> volumeTags;

    /**
     * @return Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * 
     * &gt; **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     * 
     */
    public Optional<Output<Map<String,String>>> volumeTags() {
        return Optional.ofNullable(this.volumeTags);
    }

    /**
     * List of security group IDs to associate with.
     * 
     */
    @Import(name="vpcSecurityGroupIds")
    private @Nullable Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return List of security group IDs to associate with.
     * 
     */
    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    /**
     * If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     * 
     */
    @Import(name="waitForFulfillment")
    private @Nullable Output<Boolean> waitForFulfillment;

    /**
     * @return If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     * 
     */
    public Optional<Output<Boolean>> waitForFulfillment() {
        return Optional.ofNullable(this.waitForFulfillment);
    }

    private SpotInstanceRequestState() {}

    private SpotInstanceRequestState(SpotInstanceRequestState $) {
        this.ami = $.ami;
        this.arn = $.arn;
        this.associatePublicIpAddress = $.associatePublicIpAddress;
        this.availabilityZone = $.availabilityZone;
        this.blockDurationMinutes = $.blockDurationMinutes;
        this.capacityReservationSpecification = $.capacityReservationSpecification;
        this.cpuCoreCount = $.cpuCoreCount;
        this.cpuOptions = $.cpuOptions;
        this.cpuThreadsPerCore = $.cpuThreadsPerCore;
        this.creditSpecification = $.creditSpecification;
        this.disableApiStop = $.disableApiStop;
        this.disableApiTermination = $.disableApiTermination;
        this.ebsBlockDevices = $.ebsBlockDevices;
        this.ebsOptimized = $.ebsOptimized;
        this.enclaveOptions = $.enclaveOptions;
        this.ephemeralBlockDevices = $.ephemeralBlockDevices;
        this.getPasswordData = $.getPasswordData;
        this.hibernation = $.hibernation;
        this.hostId = $.hostId;
        this.hostResourceGroupArn = $.hostResourceGroupArn;
        this.iamInstanceProfile = $.iamInstanceProfile;
        this.instanceInitiatedShutdownBehavior = $.instanceInitiatedShutdownBehavior;
        this.instanceInterruptionBehavior = $.instanceInterruptionBehavior;
        this.instanceState = $.instanceState;
        this.instanceType = $.instanceType;
        this.ipv6AddressCount = $.ipv6AddressCount;
        this.ipv6Addresses = $.ipv6Addresses;
        this.keyName = $.keyName;
        this.launchGroup = $.launchGroup;
        this.launchTemplate = $.launchTemplate;
        this.maintenanceOptions = $.maintenanceOptions;
        this.metadataOptions = $.metadataOptions;
        this.monitoring = $.monitoring;
        this.networkInterfaces = $.networkInterfaces;
        this.outpostArn = $.outpostArn;
        this.passwordData = $.passwordData;
        this.placementGroup = $.placementGroup;
        this.placementPartitionNumber = $.placementPartitionNumber;
        this.primaryNetworkInterfaceId = $.primaryNetworkInterfaceId;
        this.privateDns = $.privateDns;
        this.privateDnsNameOptions = $.privateDnsNameOptions;
        this.privateIp = $.privateIp;
        this.publicDns = $.publicDns;
        this.publicIp = $.publicIp;
        this.rootBlockDevice = $.rootBlockDevice;
        this.secondaryPrivateIps = $.secondaryPrivateIps;
        this.securityGroups = $.securityGroups;
        this.sourceDestCheck = $.sourceDestCheck;
        this.spotBidStatus = $.spotBidStatus;
        this.spotInstanceId = $.spotInstanceId;
        this.spotPrice = $.spotPrice;
        this.spotRequestState = $.spotRequestState;
        this.spotType = $.spotType;
        this.subnetId = $.subnetId;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.tenancy = $.tenancy;
        this.userData = $.userData;
        this.userDataBase64 = $.userDataBase64;
        this.userDataReplaceOnChange = $.userDataReplaceOnChange;
        this.validFrom = $.validFrom;
        this.validUntil = $.validUntil;
        this.volumeTags = $.volumeTags;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
        this.waitForFulfillment = $.waitForFulfillment;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SpotInstanceRequestState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SpotInstanceRequestState $;

        public Builder() {
            $ = new SpotInstanceRequestState();
        }

        public Builder(SpotInstanceRequestState defaults) {
            $ = new SpotInstanceRequestState(Objects.requireNonNull(defaults));
        }

        /**
         * @param ami AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
         * 
         * @return builder
         * 
         */
        public Builder ami(@Nullable Output<String> ami) {
            $.ami = ami;
            return this;
        }

        /**
         * @param ami AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
         * 
         * @return builder
         * 
         */
        public Builder ami(String ami) {
            return ami(Output.of(ami));
        }

        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param associatePublicIpAddress Whether to associate a public IP address with an instance in a VPC.
         * 
         * @return builder
         * 
         */
        public Builder associatePublicIpAddress(@Nullable Output<Boolean> associatePublicIpAddress) {
            $.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * @param associatePublicIpAddress Whether to associate a public IP address with an instance in a VPC.
         * 
         * @return builder
         * 
         */
        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            return associatePublicIpAddress(Output.of(associatePublicIpAddress));
        }

        /**
         * @param availabilityZone AZ to start the instance in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone AZ to start the instance in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param blockDurationMinutes The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
         * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
         * Note that you can&#39;t specify an Availability Zone group or a launch group if you specify a duration.
         * 
         * @return builder
         * 
         */
        public Builder blockDurationMinutes(@Nullable Output<Integer> blockDurationMinutes) {
            $.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        /**
         * @param blockDurationMinutes The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
         * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
         * Note that you can&#39;t specify an Availability Zone group or a launch group if you specify a duration.
         * 
         * @return builder
         * 
         */
        public Builder blockDurationMinutes(Integer blockDurationMinutes) {
            return blockDurationMinutes(Output.of(blockDurationMinutes));
        }

        /**
         * @param capacityReservationSpecification Describes an instance&#39;s Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
         * 
         * &gt; **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
         * 
         * @return builder
         * 
         */
        public Builder capacityReservationSpecification(@Nullable Output<SpotInstanceRequestCapacityReservationSpecificationArgs> capacityReservationSpecification) {
            $.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        /**
         * @param capacityReservationSpecification Describes an instance&#39;s Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
         * 
         * &gt; **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
         * 
         * @return builder
         * 
         */
        public Builder capacityReservationSpecification(SpotInstanceRequestCapacityReservationSpecificationArgs capacityReservationSpecification) {
            return capacityReservationSpecification(Output.of(capacityReservationSpecification));
        }

        /**
         * @param cpuCoreCount Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
         * 
         * @return builder
         * 
         * @deprecated
         * use &#39;cpu_options&#39; argument instead
         * 
         */
        @Deprecated /* use 'cpu_options' argument instead */
        public Builder cpuCoreCount(@Nullable Output<Integer> cpuCoreCount) {
            $.cpuCoreCount = cpuCoreCount;
            return this;
        }

        /**
         * @param cpuCoreCount Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
         * 
         * @return builder
         * 
         * @deprecated
         * use &#39;cpu_options&#39; argument instead
         * 
         */
        @Deprecated /* use 'cpu_options' argument instead */
        public Builder cpuCoreCount(Integer cpuCoreCount) {
            return cpuCoreCount(Output.of(cpuCoreCount));
        }

        /**
         * @param cpuOptions The CPU options for the instance. See CPU Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder cpuOptions(@Nullable Output<SpotInstanceRequestCpuOptionsArgs> cpuOptions) {
            $.cpuOptions = cpuOptions;
            return this;
        }

        /**
         * @param cpuOptions The CPU options for the instance. See CPU Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder cpuOptions(SpotInstanceRequestCpuOptionsArgs cpuOptions) {
            return cpuOptions(Output.of(cpuOptions));
        }

        /**
         * @param cpuThreadsPerCore If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
         * 
         * @return builder
         * 
         * @deprecated
         * use &#39;cpu_options&#39; argument instead
         * 
         */
        @Deprecated /* use 'cpu_options' argument instead */
        public Builder cpuThreadsPerCore(@Nullable Output<Integer> cpuThreadsPerCore) {
            $.cpuThreadsPerCore = cpuThreadsPerCore;
            return this;
        }

        /**
         * @param cpuThreadsPerCore If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
         * 
         * @return builder
         * 
         * @deprecated
         * use &#39;cpu_options&#39; argument instead
         * 
         */
        @Deprecated /* use 'cpu_options' argument instead */
        public Builder cpuThreadsPerCore(Integer cpuThreadsPerCore) {
            return cpuThreadsPerCore(Output.of(cpuThreadsPerCore));
        }

        /**
         * @param creditSpecification Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
         * 
         * @return builder
         * 
         */
        public Builder creditSpecification(@Nullable Output<SpotInstanceRequestCreditSpecificationArgs> creditSpecification) {
            $.creditSpecification = creditSpecification;
            return this;
        }

        /**
         * @param creditSpecification Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
         * 
         * @return builder
         * 
         */
        public Builder creditSpecification(SpotInstanceRequestCreditSpecificationArgs creditSpecification) {
            return creditSpecification(Output.of(creditSpecification));
        }

        /**
         * @param disableApiStop If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
         * 
         * @return builder
         * 
         */
        public Builder disableApiStop(@Nullable Output<Boolean> disableApiStop) {
            $.disableApiStop = disableApiStop;
            return this;
        }

        /**
         * @param disableApiStop If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
         * 
         * @return builder
         * 
         */
        public Builder disableApiStop(Boolean disableApiStop) {
            return disableApiStop(Output.of(disableApiStop));
        }

        /**
         * @param disableApiTermination If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
         * 
         * @return builder
         * 
         */
        public Builder disableApiTermination(@Nullable Output<Boolean> disableApiTermination) {
            $.disableApiTermination = disableApiTermination;
            return this;
        }

        /**
         * @param disableApiTermination If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
         * 
         * @return builder
         * 
         */
        public Builder disableApiTermination(Boolean disableApiTermination) {
            return disableApiTermination(Output.of(disableApiTermination));
        }

        /**
         * @param ebsBlockDevices One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
         * 
         * @return builder
         * 
         */
        public Builder ebsBlockDevices(@Nullable Output<List<SpotInstanceRequestEbsBlockDeviceArgs>> ebsBlockDevices) {
            $.ebsBlockDevices = ebsBlockDevices;
            return this;
        }

        /**
         * @param ebsBlockDevices One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
         * 
         * @return builder
         * 
         */
        public Builder ebsBlockDevices(List<SpotInstanceRequestEbsBlockDeviceArgs> ebsBlockDevices) {
            return ebsBlockDevices(Output.of(ebsBlockDevices));
        }

        /**
         * @param ebsBlockDevices One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
         * 
         * @return builder
         * 
         */
        public Builder ebsBlockDevices(SpotInstanceRequestEbsBlockDeviceArgs... ebsBlockDevices) {
            return ebsBlockDevices(List.of(ebsBlockDevices));
        }

        /**
         * @param ebsOptimized If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
         * 
         * @return builder
         * 
         */
        public Builder ebsOptimized(@Nullable Output<Boolean> ebsOptimized) {
            $.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * @param ebsOptimized If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
         * 
         * @return builder
         * 
         */
        public Builder ebsOptimized(Boolean ebsOptimized) {
            return ebsOptimized(Output.of(ebsOptimized));
        }

        /**
         * @param enclaveOptions Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder enclaveOptions(@Nullable Output<SpotInstanceRequestEnclaveOptionsArgs> enclaveOptions) {
            $.enclaveOptions = enclaveOptions;
            return this;
        }

        /**
         * @param enclaveOptions Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder enclaveOptions(SpotInstanceRequestEnclaveOptionsArgs enclaveOptions) {
            return enclaveOptions(Output.of(enclaveOptions));
        }

        /**
         * @param ephemeralBlockDevices One or more configuration blocks to customize Ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
         * 
         * @return builder
         * 
         */
        public Builder ephemeralBlockDevices(@Nullable Output<List<SpotInstanceRequestEphemeralBlockDeviceArgs>> ephemeralBlockDevices) {
            $.ephemeralBlockDevices = ephemeralBlockDevices;
            return this;
        }

        /**
         * @param ephemeralBlockDevices One or more configuration blocks to customize Ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
         * 
         * @return builder
         * 
         */
        public Builder ephemeralBlockDevices(List<SpotInstanceRequestEphemeralBlockDeviceArgs> ephemeralBlockDevices) {
            return ephemeralBlockDevices(Output.of(ephemeralBlockDevices));
        }

        /**
         * @param ephemeralBlockDevices One or more configuration blocks to customize Ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
         * 
         * @return builder
         * 
         */
        public Builder ephemeralBlockDevices(SpotInstanceRequestEphemeralBlockDeviceArgs... ephemeralBlockDevices) {
            return ephemeralBlockDevices(List.of(ephemeralBlockDevices));
        }

        /**
         * @param getPasswordData If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder getPasswordData(@Nullable Output<Boolean> getPasswordData) {
            $.getPasswordData = getPasswordData;
            return this;
        }

        /**
         * @param getPasswordData If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder getPasswordData(Boolean getPasswordData) {
            return getPasswordData(Output.of(getPasswordData));
        }

        /**
         * @param hibernation If true, the launched EC2 instance will support hibernation.
         * 
         * @return builder
         * 
         */
        public Builder hibernation(@Nullable Output<Boolean> hibernation) {
            $.hibernation = hibernation;
            return this;
        }

        /**
         * @param hibernation If true, the launched EC2 instance will support hibernation.
         * 
         * @return builder
         * 
         */
        public Builder hibernation(Boolean hibernation) {
            return hibernation(Output.of(hibernation));
        }

        /**
         * @param hostId ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
         * 
         * @return builder
         * 
         */
        public Builder hostId(@Nullable Output<String> hostId) {
            $.hostId = hostId;
            return this;
        }

        /**
         * @param hostId ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
         * 
         * @return builder
         * 
         */
        public Builder hostId(String hostId) {
            return hostId(Output.of(hostId));
        }

        /**
         * @param hostResourceGroupArn ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
         * 
         * @return builder
         * 
         */
        public Builder hostResourceGroupArn(@Nullable Output<String> hostResourceGroupArn) {
            $.hostResourceGroupArn = hostResourceGroupArn;
            return this;
        }

        /**
         * @param hostResourceGroupArn ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
         * 
         * @return builder
         * 
         */
        public Builder hostResourceGroupArn(String hostResourceGroupArn) {
            return hostResourceGroupArn(Output.of(hostResourceGroupArn));
        }

        /**
         * @param iamInstanceProfile IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
         * 
         * @return builder
         * 
         */
        public Builder iamInstanceProfile(@Nullable Output<String> iamInstanceProfile) {
            $.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        /**
         * @param iamInstanceProfile IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
         * 
         * @return builder
         * 
         */
        public Builder iamInstanceProfile(String iamInstanceProfile) {
            return iamInstanceProfile(Output.of(iamInstanceProfile));
        }

        /**
         * @param instanceInitiatedShutdownBehavior Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
         * 
         * @return builder
         * 
         */
        public Builder instanceInitiatedShutdownBehavior(@Nullable Output<String> instanceInitiatedShutdownBehavior) {
            $.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        /**
         * @param instanceInitiatedShutdownBehavior Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
         * 
         * @return builder
         * 
         */
        public Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            return instanceInitiatedShutdownBehavior(Output.of(instanceInitiatedShutdownBehavior));
        }

        /**
         * @param instanceInterruptionBehavior The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
         * 
         * @return builder
         * 
         */
        public Builder instanceInterruptionBehavior(@Nullable Output<String> instanceInterruptionBehavior) {
            $.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        /**
         * @param instanceInterruptionBehavior The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
         * 
         * @return builder
         * 
         */
        public Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            return instanceInterruptionBehavior(Output.of(instanceInterruptionBehavior));
        }

        public Builder instanceState(@Nullable Output<String> instanceState) {
            $.instanceState = instanceState;
            return this;
        }

        public Builder instanceState(String instanceState) {
            return instanceState(Output.of(instanceState));
        }

        /**
         * @param instanceType Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
         * 
         * @return builder
         * 
         */
        public Builder instanceType(@Nullable Output<String> instanceType) {
            $.instanceType = instanceType;
            return this;
        }

        /**
         * @param instanceType Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
         * 
         * @return builder
         * 
         */
        public Builder instanceType(String instanceType) {
            return instanceType(Output.of(instanceType));
        }

        /**
         * @param ipv6AddressCount Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
         * 
         * @return builder
         * 
         */
        public Builder ipv6AddressCount(@Nullable Output<Integer> ipv6AddressCount) {
            $.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        /**
         * @param ipv6AddressCount Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
         * 
         * @return builder
         * 
         */
        public Builder ipv6AddressCount(Integer ipv6AddressCount) {
            return ipv6AddressCount(Output.of(ipv6AddressCount));
        }

        /**
         * @param ipv6Addresses Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
         * 
         * @return builder
         * 
         */
        public Builder ipv6Addresses(@Nullable Output<List<String>> ipv6Addresses) {
            $.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * @param ipv6Addresses Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
         * 
         * @return builder
         * 
         */
        public Builder ipv6Addresses(List<String> ipv6Addresses) {
            return ipv6Addresses(Output.of(ipv6Addresses));
        }

        /**
         * @param ipv6Addresses Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
         * 
         * @return builder
         * 
         */
        public Builder ipv6Addresses(String... ipv6Addresses) {
            return ipv6Addresses(List.of(ipv6Addresses));
        }

        /**
         * @param keyName Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
         * 
         * @return builder
         * 
         */
        public Builder keyName(@Nullable Output<String> keyName) {
            $.keyName = keyName;
            return this;
        }

        /**
         * @param keyName Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
         * 
         * @return builder
         * 
         */
        public Builder keyName(String keyName) {
            return keyName(Output.of(keyName));
        }

        /**
         * @param launchGroup A launch group is a group of spot instances that launch together and terminate together.
         * If left empty instances are launched and terminated individually.
         * 
         * @return builder
         * 
         */
        public Builder launchGroup(@Nullable Output<String> launchGroup) {
            $.launchGroup = launchGroup;
            return this;
        }

        /**
         * @param launchGroup A launch group is a group of spot instances that launch together and terminate together.
         * If left empty instances are launched and terminated individually.
         * 
         * @return builder
         * 
         */
        public Builder launchGroup(String launchGroup) {
            return launchGroup(Output.of(launchGroup));
        }

        /**
         * @param launchTemplate Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
         * 
         * @return builder
         * 
         */
        public Builder launchTemplate(@Nullable Output<SpotInstanceRequestLaunchTemplateArgs> launchTemplate) {
            $.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * @param launchTemplate Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
         * 
         * @return builder
         * 
         */
        public Builder launchTemplate(SpotInstanceRequestLaunchTemplateArgs launchTemplate) {
            return launchTemplate(Output.of(launchTemplate));
        }

        /**
         * @param maintenanceOptions Maintenance and recovery options for the instance. See Maintenance Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder maintenanceOptions(@Nullable Output<SpotInstanceRequestMaintenanceOptionsArgs> maintenanceOptions) {
            $.maintenanceOptions = maintenanceOptions;
            return this;
        }

        /**
         * @param maintenanceOptions Maintenance and recovery options for the instance. See Maintenance Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder maintenanceOptions(SpotInstanceRequestMaintenanceOptionsArgs maintenanceOptions) {
            return maintenanceOptions(Output.of(maintenanceOptions));
        }

        /**
         * @param metadataOptions Customize the metadata options of the instance. See Metadata Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder metadataOptions(@Nullable Output<SpotInstanceRequestMetadataOptionsArgs> metadataOptions) {
            $.metadataOptions = metadataOptions;
            return this;
        }

        /**
         * @param metadataOptions Customize the metadata options of the instance. See Metadata Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder metadataOptions(SpotInstanceRequestMetadataOptionsArgs metadataOptions) {
            return metadataOptions(Output.of(metadataOptions));
        }

        /**
         * @param monitoring If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
         * 
         * @return builder
         * 
         */
        public Builder monitoring(@Nullable Output<Boolean> monitoring) {
            $.monitoring = monitoring;
            return this;
        }

        /**
         * @param monitoring If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
         * 
         * @return builder
         * 
         */
        public Builder monitoring(Boolean monitoring) {
            return monitoring(Output.of(monitoring));
        }

        /**
         * @param networkInterfaces Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaces(@Nullable Output<List<SpotInstanceRequestNetworkInterfaceArgs>> networkInterfaces) {
            $.networkInterfaces = networkInterfaces;
            return this;
        }

        /**
         * @param networkInterfaces Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaces(List<SpotInstanceRequestNetworkInterfaceArgs> networkInterfaces) {
            return networkInterfaces(Output.of(networkInterfaces));
        }

        /**
         * @param networkInterfaces Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaces(SpotInstanceRequestNetworkInterfaceArgs... networkInterfaces) {
            return networkInterfaces(List.of(networkInterfaces));
        }

        public Builder outpostArn(@Nullable Output<String> outpostArn) {
            $.outpostArn = outpostArn;
            return this;
        }

        public Builder outpostArn(String outpostArn) {
            return outpostArn(Output.of(outpostArn));
        }

        public Builder passwordData(@Nullable Output<String> passwordData) {
            $.passwordData = passwordData;
            return this;
        }

        public Builder passwordData(String passwordData) {
            return passwordData(Output.of(passwordData));
        }

        /**
         * @param placementGroup Placement Group to start the instance in.
         * 
         * @return builder
         * 
         */
        public Builder placementGroup(@Nullable Output<String> placementGroup) {
            $.placementGroup = placementGroup;
            return this;
        }

        /**
         * @param placementGroup Placement Group to start the instance in.
         * 
         * @return builder
         * 
         */
        public Builder placementGroup(String placementGroup) {
            return placementGroup(Output.of(placementGroup));
        }

        /**
         * @param placementPartitionNumber Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource&#39;s `strategy` argument is set to `&#34;partition&#34;`.
         * 
         * @return builder
         * 
         */
        public Builder placementPartitionNumber(@Nullable Output<Integer> placementPartitionNumber) {
            $.placementPartitionNumber = placementPartitionNumber;
            return this;
        }

        /**
         * @param placementPartitionNumber Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource&#39;s `strategy` argument is set to `&#34;partition&#34;`.
         * 
         * @return builder
         * 
         */
        public Builder placementPartitionNumber(Integer placementPartitionNumber) {
            return placementPartitionNumber(Output.of(placementPartitionNumber));
        }

        public Builder primaryNetworkInterfaceId(@Nullable Output<String> primaryNetworkInterfaceId) {
            $.primaryNetworkInterfaceId = primaryNetworkInterfaceId;
            return this;
        }

        public Builder primaryNetworkInterfaceId(String primaryNetworkInterfaceId) {
            return primaryNetworkInterfaceId(Output.of(primaryNetworkInterfaceId));
        }

        /**
         * @param privateDns The private DNS name assigned to the instance. Can only be
         * used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames
         * for your VPC
         * 
         * @return builder
         * 
         */
        public Builder privateDns(@Nullable Output<String> privateDns) {
            $.privateDns = privateDns;
            return this;
        }

        /**
         * @param privateDns The private DNS name assigned to the instance. Can only be
         * used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames
         * for your VPC
         * 
         * @return builder
         * 
         */
        public Builder privateDns(String privateDns) {
            return privateDns(Output.of(privateDns));
        }

        /**
         * @param privateDnsNameOptions Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder privateDnsNameOptions(@Nullable Output<SpotInstanceRequestPrivateDnsNameOptionsArgs> privateDnsNameOptions) {
            $.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        /**
         * @param privateDnsNameOptions Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder privateDnsNameOptions(SpotInstanceRequestPrivateDnsNameOptionsArgs privateDnsNameOptions) {
            return privateDnsNameOptions(Output.of(privateDnsNameOptions));
        }

        /**
         * @param privateIp Private IP address to associate with the instance in a VPC.
         * 
         * @return builder
         * 
         */
        public Builder privateIp(@Nullable Output<String> privateIp) {
            $.privateIp = privateIp;
            return this;
        }

        /**
         * @param privateIp Private IP address to associate with the instance in a VPC.
         * 
         * @return builder
         * 
         */
        public Builder privateIp(String privateIp) {
            return privateIp(Output.of(privateIp));
        }

        /**
         * @param publicDns The public DNS name assigned to the instance. For EC2-VPC, this
         * is only available if you&#39;ve enabled DNS hostnames for your VPC
         * 
         * @return builder
         * 
         */
        public Builder publicDns(@Nullable Output<String> publicDns) {
            $.publicDns = publicDns;
            return this;
        }

        /**
         * @param publicDns The public DNS name assigned to the instance. For EC2-VPC, this
         * is only available if you&#39;ve enabled DNS hostnames for your VPC
         * 
         * @return builder
         * 
         */
        public Builder publicDns(String publicDns) {
            return publicDns(Output.of(publicDns));
        }

        /**
         * @param publicIp The public IP address assigned to the instance, if applicable.
         * 
         * @return builder
         * 
         */
        public Builder publicIp(@Nullable Output<String> publicIp) {
            $.publicIp = publicIp;
            return this;
        }

        /**
         * @param publicIp The public IP address assigned to the instance, if applicable.
         * 
         * @return builder
         * 
         */
        public Builder publicIp(String publicIp) {
            return publicIp(Output.of(publicIp));
        }

        /**
         * @param rootBlockDevice Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
         * 
         * @return builder
         * 
         */
        public Builder rootBlockDevice(@Nullable Output<SpotInstanceRequestRootBlockDeviceArgs> rootBlockDevice) {
            $.rootBlockDevice = rootBlockDevice;
            return this;
        }

        /**
         * @param rootBlockDevice Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
         * 
         * @return builder
         * 
         */
        public Builder rootBlockDevice(SpotInstanceRequestRootBlockDeviceArgs rootBlockDevice) {
            return rootBlockDevice(Output.of(rootBlockDevice));
        }

        /**
         * @param secondaryPrivateIps List of secondary private IPv4 addresses to assign to the instance&#39;s primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
         * 
         * @return builder
         * 
         */
        public Builder secondaryPrivateIps(@Nullable Output<List<String>> secondaryPrivateIps) {
            $.secondaryPrivateIps = secondaryPrivateIps;
            return this;
        }

        /**
         * @param secondaryPrivateIps List of secondary private IPv4 addresses to assign to the instance&#39;s primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
         * 
         * @return builder
         * 
         */
        public Builder secondaryPrivateIps(List<String> secondaryPrivateIps) {
            return secondaryPrivateIps(Output.of(secondaryPrivateIps));
        }

        /**
         * @param secondaryPrivateIps List of secondary private IPv4 addresses to assign to the instance&#39;s primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
         * 
         * @return builder
         * 
         */
        public Builder secondaryPrivateIps(String... secondaryPrivateIps) {
            return secondaryPrivateIps(List.of(secondaryPrivateIps));
        }

        /**
         * @param securityGroups List of security group names to associate with.
         * 
         * &gt; **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(@Nullable Output<List<String>> securityGroups) {
            $.securityGroups = securityGroups;
            return this;
        }

        /**
         * @param securityGroups List of security group names to associate with.
         * 
         * &gt; **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(List<String> securityGroups) {
            return securityGroups(Output.of(securityGroups));
        }

        /**
         * @param securityGroups List of security group names to associate with.
         * 
         * &gt; **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
         * 
         * @return builder
         * 
         */
        public Builder securityGroups(String... securityGroups) {
            return securityGroups(List.of(securityGroups));
        }

        /**
         * @param sourceDestCheck Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
         * 
         * @return builder
         * 
         */
        public Builder sourceDestCheck(@Nullable Output<Boolean> sourceDestCheck) {
            $.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * @param sourceDestCheck Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
         * 
         * @return builder
         * 
         */
        public Builder sourceDestCheck(Boolean sourceDestCheck) {
            return sourceDestCheck(Output.of(sourceDestCheck));
        }

        /**
         * @param spotBidStatus The current [bid
         * status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
         * of the Spot Instance Request.
         * 
         * @return builder
         * 
         */
        public Builder spotBidStatus(@Nullable Output<String> spotBidStatus) {
            $.spotBidStatus = spotBidStatus;
            return this;
        }

        /**
         * @param spotBidStatus The current [bid
         * status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
         * of the Spot Instance Request.
         * 
         * @return builder
         * 
         */
        public Builder spotBidStatus(String spotBidStatus) {
            return spotBidStatus(Output.of(spotBidStatus));
        }

        /**
         * @param spotInstanceId The Instance ID (if any) that is currently fulfilling
         * the Spot Instance request.
         * 
         * @return builder
         * 
         */
        public Builder spotInstanceId(@Nullable Output<String> spotInstanceId) {
            $.spotInstanceId = spotInstanceId;
            return this;
        }

        /**
         * @param spotInstanceId The Instance ID (if any) that is currently fulfilling
         * the Spot Instance request.
         * 
         * @return builder
         * 
         */
        public Builder spotInstanceId(String spotInstanceId) {
            return spotInstanceId(Output.of(spotInstanceId));
        }

        /**
         * @param spotPrice The maximum price to request on the spot market.
         * 
         * @return builder
         * 
         */
        public Builder spotPrice(@Nullable Output<String> spotPrice) {
            $.spotPrice = spotPrice;
            return this;
        }

        /**
         * @param spotPrice The maximum price to request on the spot market.
         * 
         * @return builder
         * 
         */
        public Builder spotPrice(String spotPrice) {
            return spotPrice(Output.of(spotPrice));
        }

        /**
         * @param spotRequestState The current [request
         * state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
         * of the Spot Instance Request.
         * 
         * @return builder
         * 
         */
        public Builder spotRequestState(@Nullable Output<String> spotRequestState) {
            $.spotRequestState = spotRequestState;
            return this;
        }

        /**
         * @param spotRequestState The current [request
         * state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
         * of the Spot Instance Request.
         * 
         * @return builder
         * 
         */
        public Builder spotRequestState(String spotRequestState) {
            return spotRequestState(Output.of(spotRequestState));
        }

        /**
         * @param spotType If set to `one-time`, after
         * the instance is terminated, the spot request will be closed.
         * 
         * @return builder
         * 
         */
        public Builder spotType(@Nullable Output<String> spotType) {
            $.spotType = spotType;
            return this;
        }

        /**
         * @param spotType If set to `one-time`, after
         * the instance is terminated, the spot request will be closed.
         * 
         * @return builder
         * 
         */
        public Builder spotType(String spotType) {
            return spotType(Output.of(spotType));
        }

        /**
         * @param subnetId VPC Subnet ID to launch in.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(@Nullable Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId VPC Subnet ID to launch in.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        /**
         * @param tags Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param tenancy Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
         * 
         * @return builder
         * 
         */
        public Builder tenancy(@Nullable Output<String> tenancy) {
            $.tenancy = tenancy;
            return this;
        }

        /**
         * @param tenancy Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
         * 
         * @return builder
         * 
         */
        public Builder tenancy(String tenancy) {
            return tenancy(Output.of(tenancy));
        }

        /**
         * @param userData User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
         * 
         * @return builder
         * 
         */
        public Builder userData(@Nullable Output<String> userData) {
            $.userData = userData;
            return this;
        }

        /**
         * @param userData User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
         * 
         * @return builder
         * 
         */
        public Builder userData(String userData) {
            return userData(Output.of(userData));
        }

        /**
         * @param userDataBase64 Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
         * 
         * @return builder
         * 
         */
        public Builder userDataBase64(@Nullable Output<String> userDataBase64) {
            $.userDataBase64 = userDataBase64;
            return this;
        }

        /**
         * @param userDataBase64 Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
         * 
         * @return builder
         * 
         */
        public Builder userDataBase64(String userDataBase64) {
            return userDataBase64(Output.of(userDataBase64));
        }

        /**
         * @param userDataReplaceOnChange When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
         * 
         * @return builder
         * 
         */
        public Builder userDataReplaceOnChange(@Nullable Output<Boolean> userDataReplaceOnChange) {
            $.userDataReplaceOnChange = userDataReplaceOnChange;
            return this;
        }

        /**
         * @param userDataReplaceOnChange When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
         * 
         * @return builder
         * 
         */
        public Builder userDataReplaceOnChange(Boolean userDataReplaceOnChange) {
            return userDataReplaceOnChange(Output.of(userDataReplaceOnChange));
        }

        /**
         * @param validFrom The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
         * 
         * @return builder
         * 
         */
        public Builder validFrom(@Nullable Output<String> validFrom) {
            $.validFrom = validFrom;
            return this;
        }

        /**
         * @param validFrom The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
         * 
         * @return builder
         * 
         */
        public Builder validFrom(String validFrom) {
            return validFrom(Output.of(validFrom));
        }

        /**
         * @param validUntil The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
         * 
         * @return builder
         * 
         */
        public Builder validUntil(@Nullable Output<String> validUntil) {
            $.validUntil = validUntil;
            return this;
        }

        /**
         * @param validUntil The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
         * 
         * @return builder
         * 
         */
        public Builder validUntil(String validUntil) {
            return validUntil(Output.of(validUntil));
        }

        /**
         * @param volumeTags Map of tags to assign, at instance-creation time, to root and EBS volumes.
         * 
         * &gt; **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
         * 
         * @return builder
         * 
         */
        public Builder volumeTags(@Nullable Output<Map<String,String>> volumeTags) {
            $.volumeTags = volumeTags;
            return this;
        }

        /**
         * @param volumeTags Map of tags to assign, at instance-creation time, to root and EBS volumes.
         * 
         * &gt; **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
         * 
         * @return builder
         * 
         */
        public Builder volumeTags(Map<String,String> volumeTags) {
            return volumeTags(Output.of(volumeTags));
        }

        /**
         * @param vpcSecurityGroupIds List of security group IDs to associate with.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            $.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * @param vpcSecurityGroupIds List of security group IDs to associate with.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(Output.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSecurityGroupIds List of security group IDs to associate with.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        /**
         * @param waitForFulfillment If set, this provider will
         * wait for the Spot Request to be fulfilled, and will throw an error if the
         * timeout of 10m is reached.
         * 
         * @return builder
         * 
         */
        public Builder waitForFulfillment(@Nullable Output<Boolean> waitForFulfillment) {
            $.waitForFulfillment = waitForFulfillment;
            return this;
        }

        /**
         * @param waitForFulfillment If set, this provider will
         * wait for the Spot Request to be fulfilled, and will throw an error if the
         * timeout of 10m is reached.
         * 
         * @return builder
         * 
         */
        public Builder waitForFulfillment(Boolean waitForFulfillment) {
            return waitForFulfillment(Output.of(waitForFulfillment));
        }

        public SpotInstanceRequestState build() {
            return $;
        }
    }

}
