// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2.inputs;

import com.pulumi.aws.ec2.enums.PlacementStrategy;
import com.pulumi.core.Either;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class PlacementGroupState extends com.pulumi.resources.ResourceArgs {

    public static final PlacementGroupState Empty = new PlacementGroupState();

    /**
     * Amazon Resource Name (ARN) of the placement group.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the placement group.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The name of the placement group.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the placement group.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The number of partitions to create in the
     * placement group.  Can only be specified when the `strategy` is set to
     * `partition`.  Valid values are 1 - 7 (default is `2`).
     * 
     */
    @Import(name="partitionCount")
    private @Nullable Output<Integer> partitionCount;

    /**
     * @return The number of partitions to create in the
     * placement group.  Can only be specified when the `strategy` is set to
     * `partition`.  Valid values are 1 - 7 (default is `2`).
     * 
     */
    public Optional<Output<Integer>> partitionCount() {
        return Optional.ofNullable(this.partitionCount);
    }

    /**
     * The ID of the placement group.
     * 
     */
    @Import(name="placementGroupId")
    private @Nullable Output<String> placementGroupId;

    /**
     * @return The ID of the placement group.
     * 
     */
    public Optional<Output<String>> placementGroupId() {
        return Optional.ofNullable(this.placementGroupId);
    }

    /**
     * Determines how placement groups spread instances. Can only be used
     * when the `strategy` is set to `spread`. Can be `host` or `rack`. `host` can only be used for Outpost placement groups. Defaults to `rack`.
     * 
     */
    @Import(name="spreadLevel")
    private @Nullable Output<String> spreadLevel;

    /**
     * @return Determines how placement groups spread instances. Can only be used
     * when the `strategy` is set to `spread`. Can be `host` or `rack`. `host` can only be used for Outpost placement groups. Defaults to `rack`.
     * 
     */
    public Optional<Output<String>> spreadLevel() {
        return Optional.ofNullable(this.spreadLevel);
    }

    /**
     * The placement strategy. Can be `cluster`, `partition` or `spread`.
     * 
     */
    @Import(name="strategy")
    private @Nullable Output<Either<String,PlacementStrategy>> strategy;

    /**
     * @return The placement strategy. Can be `cluster`, `partition` or `spread`.
     * 
     */
    public Optional<Output<Either<String,PlacementStrategy>>> strategy() {
        return Optional.ofNullable(this.strategy);
    }

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    private PlacementGroupState() {}

    private PlacementGroupState(PlacementGroupState $) {
        this.arn = $.arn;
        this.name = $.name;
        this.partitionCount = $.partitionCount;
        this.placementGroupId = $.placementGroupId;
        this.spreadLevel = $.spreadLevel;
        this.strategy = $.strategy;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PlacementGroupState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PlacementGroupState $;

        public Builder() {
            $ = new PlacementGroupState();
        }

        public Builder(PlacementGroupState defaults) {
            $ = new PlacementGroupState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the placement group.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the placement group.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param name The name of the placement group.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the placement group.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param partitionCount The number of partitions to create in the
         * placement group.  Can only be specified when the `strategy` is set to
         * `partition`.  Valid values are 1 - 7 (default is `2`).
         * 
         * @return builder
         * 
         */
        public Builder partitionCount(@Nullable Output<Integer> partitionCount) {
            $.partitionCount = partitionCount;
            return this;
        }

        /**
         * @param partitionCount The number of partitions to create in the
         * placement group.  Can only be specified when the `strategy` is set to
         * `partition`.  Valid values are 1 - 7 (default is `2`).
         * 
         * @return builder
         * 
         */
        public Builder partitionCount(Integer partitionCount) {
            return partitionCount(Output.of(partitionCount));
        }

        /**
         * @param placementGroupId The ID of the placement group.
         * 
         * @return builder
         * 
         */
        public Builder placementGroupId(@Nullable Output<String> placementGroupId) {
            $.placementGroupId = placementGroupId;
            return this;
        }

        /**
         * @param placementGroupId The ID of the placement group.
         * 
         * @return builder
         * 
         */
        public Builder placementGroupId(String placementGroupId) {
            return placementGroupId(Output.of(placementGroupId));
        }

        /**
         * @param spreadLevel Determines how placement groups spread instances. Can only be used
         * when the `strategy` is set to `spread`. Can be `host` or `rack`. `host` can only be used for Outpost placement groups. Defaults to `rack`.
         * 
         * @return builder
         * 
         */
        public Builder spreadLevel(@Nullable Output<String> spreadLevel) {
            $.spreadLevel = spreadLevel;
            return this;
        }

        /**
         * @param spreadLevel Determines how placement groups spread instances. Can only be used
         * when the `strategy` is set to `spread`. Can be `host` or `rack`. `host` can only be used for Outpost placement groups. Defaults to `rack`.
         * 
         * @return builder
         * 
         */
        public Builder spreadLevel(String spreadLevel) {
            return spreadLevel(Output.of(spreadLevel));
        }

        /**
         * @param strategy The placement strategy. Can be `cluster`, `partition` or `spread`.
         * 
         * @return builder
         * 
         */
        public Builder strategy(@Nullable Output<Either<String,PlacementStrategy>> strategy) {
            $.strategy = strategy;
            return this;
        }

        /**
         * @param strategy The placement strategy. Can be `cluster`, `partition` or `spread`.
         * 
         * @return builder
         * 
         */
        public Builder strategy(Either<String,PlacementStrategy> strategy) {
            return strategy(Output.of(strategy));
        }

        /**
         * @param strategy The placement strategy. Can be `cluster`, `partition` or `spread`.
         * 
         * @return builder
         * 
         */
        public Builder strategy(String strategy) {
            return strategy(Either.ofLeft(strategy));
        }

        /**
         * @param strategy The placement strategy. Can be `cluster`, `partition` or `spread`.
         * 
         * @return builder
         * 
         */
        public Builder strategy(PlacementStrategy strategy) {
            return strategy(Either.ofRight(strategy));
        }

        /**
         * @param tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        public PlacementGroupState build() {
            return $;
        }
    }

}
