// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2.inputs;

import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GetRoutePlainArgs extends com.pulumi.resources.InvokeArgs {

    public static final GetRoutePlainArgs Empty = new GetRoutePlainArgs();

    /**
     * EC2 Carrier Gateway ID of the Route belonging to the Route Table.
     * 
     */
    @Import(name="carrierGatewayId")
    private @Nullable String carrierGatewayId;

    /**
     * @return EC2 Carrier Gateway ID of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> carrierGatewayId() {
        return Optional.ofNullable(this.carrierGatewayId);
    }

    /**
     * Core network ARN of the Route belonging to the Route Table.
     * 
     */
    @Import(name="coreNetworkArn")
    private @Nullable String coreNetworkArn;

    /**
     * @return Core network ARN of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> coreNetworkArn() {
        return Optional.ofNullable(this.coreNetworkArn);
    }

    /**
     * CIDR block of the Route belonging to the Route Table.
     * 
     */
    @Import(name="destinationCidrBlock")
    private @Nullable String destinationCidrBlock;

    /**
     * @return CIDR block of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> destinationCidrBlock() {
        return Optional.ofNullable(this.destinationCidrBlock);
    }

    /**
     * IPv6 CIDR block of the Route belonging to the Route Table.
     * 
     */
    @Import(name="destinationIpv6CidrBlock")
    private @Nullable String destinationIpv6CidrBlock;

    /**
     * @return IPv6 CIDR block of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> destinationIpv6CidrBlock() {
        return Optional.ofNullable(this.destinationIpv6CidrBlock);
    }

    /**
     * ID of a managed prefix list destination of the Route belonging to the Route Table.
     * 
     */
    @Import(name="destinationPrefixListId")
    private @Nullable String destinationPrefixListId;

    /**
     * @return ID of a managed prefix list destination of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> destinationPrefixListId() {
        return Optional.ofNullable(this.destinationPrefixListId);
    }

    /**
     * Egress Only Gateway ID of the Route belonging to the Route Table.
     * 
     */
    @Import(name="egressOnlyGatewayId")
    private @Nullable String egressOnlyGatewayId;

    /**
     * @return Egress Only Gateway ID of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> egressOnlyGatewayId() {
        return Optional.ofNullable(this.egressOnlyGatewayId);
    }

    /**
     * Gateway ID of the Route belonging to the Route Table.
     * 
     */
    @Import(name="gatewayId")
    private @Nullable String gatewayId;

    /**
     * @return Gateway ID of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> gatewayId() {
        return Optional.ofNullable(this.gatewayId);
    }

    /**
     * Instance ID of the Route belonging to the Route Table.
     * 
     */
    @Import(name="instanceId")
    private @Nullable String instanceId;

    /**
     * @return Instance ID of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> instanceId() {
        return Optional.ofNullable(this.instanceId);
    }

    /**
     * Local Gateway ID of the Route belonging to the Route Table.
     * 
     */
    @Import(name="localGatewayId")
    private @Nullable String localGatewayId;

    /**
     * @return Local Gateway ID of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> localGatewayId() {
        return Optional.ofNullable(this.localGatewayId);
    }

    /**
     * NAT Gateway ID of the Route belonging to the Route Table.
     * 
     */
    @Import(name="natGatewayId")
    private @Nullable String natGatewayId;

    /**
     * @return NAT Gateway ID of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> natGatewayId() {
        return Optional.ofNullable(this.natGatewayId);
    }

    /**
     * Network Interface ID of the Route belonging to the Route Table.
     * 
     */
    @Import(name="networkInterfaceId")
    private @Nullable String networkInterfaceId;

    /**
     * @return Network Interface ID of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> networkInterfaceId() {
        return Optional.ofNullable(this.networkInterfaceId);
    }

    /**
     * ID of the specific Route Table containing the Route entry.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="routeTableId", required=true)
    private String routeTableId;

    /**
     * @return ID of the specific Route Table containing the Route entry.
     * 
     * The following arguments are optional:
     * 
     */
    public String routeTableId() {
        return this.routeTableId;
    }

    /**
     * EC2 Transit Gateway ID of the Route belonging to the Route Table.
     * 
     */
    @Import(name="transitGatewayId")
    private @Nullable String transitGatewayId;

    /**
     * @return EC2 Transit Gateway ID of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> transitGatewayId() {
        return Optional.ofNullable(this.transitGatewayId);
    }

    /**
     * VPC Peering Connection ID of the Route belonging to the Route Table.
     * 
     */
    @Import(name="vpcPeeringConnectionId")
    private @Nullable String vpcPeeringConnectionId;

    /**
     * @return VPC Peering Connection ID of the Route belonging to the Route Table.
     * 
     */
    public Optional<String> vpcPeeringConnectionId() {
        return Optional.ofNullable(this.vpcPeeringConnectionId);
    }

    private GetRoutePlainArgs() {}

    private GetRoutePlainArgs(GetRoutePlainArgs $) {
        this.carrierGatewayId = $.carrierGatewayId;
        this.coreNetworkArn = $.coreNetworkArn;
        this.destinationCidrBlock = $.destinationCidrBlock;
        this.destinationIpv6CidrBlock = $.destinationIpv6CidrBlock;
        this.destinationPrefixListId = $.destinationPrefixListId;
        this.egressOnlyGatewayId = $.egressOnlyGatewayId;
        this.gatewayId = $.gatewayId;
        this.instanceId = $.instanceId;
        this.localGatewayId = $.localGatewayId;
        this.natGatewayId = $.natGatewayId;
        this.networkInterfaceId = $.networkInterfaceId;
        this.routeTableId = $.routeTableId;
        this.transitGatewayId = $.transitGatewayId;
        this.vpcPeeringConnectionId = $.vpcPeeringConnectionId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GetRoutePlainArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GetRoutePlainArgs $;

        public Builder() {
            $ = new GetRoutePlainArgs();
        }

        public Builder(GetRoutePlainArgs defaults) {
            $ = new GetRoutePlainArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param carrierGatewayId EC2 Carrier Gateway ID of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder carrierGatewayId(@Nullable String carrierGatewayId) {
            $.carrierGatewayId = carrierGatewayId;
            return this;
        }

        /**
         * @param coreNetworkArn Core network ARN of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder coreNetworkArn(@Nullable String coreNetworkArn) {
            $.coreNetworkArn = coreNetworkArn;
            return this;
        }

        /**
         * @param destinationCidrBlock CIDR block of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder destinationCidrBlock(@Nullable String destinationCidrBlock) {
            $.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * @param destinationIpv6CidrBlock IPv6 CIDR block of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder destinationIpv6CidrBlock(@Nullable String destinationIpv6CidrBlock) {
            $.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        /**
         * @param destinationPrefixListId ID of a managed prefix list destination of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder destinationPrefixListId(@Nullable String destinationPrefixListId) {
            $.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        /**
         * @param egressOnlyGatewayId Egress Only Gateway ID of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder egressOnlyGatewayId(@Nullable String egressOnlyGatewayId) {
            $.egressOnlyGatewayId = egressOnlyGatewayId;
            return this;
        }

        /**
         * @param gatewayId Gateway ID of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder gatewayId(@Nullable String gatewayId) {
            $.gatewayId = gatewayId;
            return this;
        }

        /**
         * @param instanceId Instance ID of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder instanceId(@Nullable String instanceId) {
            $.instanceId = instanceId;
            return this;
        }

        /**
         * @param localGatewayId Local Gateway ID of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder localGatewayId(@Nullable String localGatewayId) {
            $.localGatewayId = localGatewayId;
            return this;
        }

        /**
         * @param natGatewayId NAT Gateway ID of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder natGatewayId(@Nullable String natGatewayId) {
            $.natGatewayId = natGatewayId;
            return this;
        }

        /**
         * @param networkInterfaceId Network Interface ID of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaceId(@Nullable String networkInterfaceId) {
            $.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * @param routeTableId ID of the specific Route Table containing the Route entry.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder routeTableId(String routeTableId) {
            $.routeTableId = routeTableId;
            return this;
        }

        /**
         * @param transitGatewayId EC2 Transit Gateway ID of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder transitGatewayId(@Nullable String transitGatewayId) {
            $.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * @param vpcPeeringConnectionId VPC Peering Connection ID of the Route belonging to the Route Table.
         * 
         * @return builder
         * 
         */
        public Builder vpcPeeringConnectionId(@Nullable String vpcPeeringConnectionId) {
            $.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public GetRoutePlainArgs build() {
            $.routeTableId = Objects.requireNonNull($.routeTableId, "expected parameter 'routeTableId' to be non-null");
            return $;
        }
    }

}
