// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.VpnConnectionArgs;
import com.pulumi.aws.ec2.inputs.VpnConnectionState;
import com.pulumi.aws.ec2.outputs.VpnConnectionRoute;
import com.pulumi.aws.ec2.outputs.VpnConnectionTunnel1LogOptions;
import com.pulumi.aws.ec2.outputs.VpnConnectionTunnel2LogOptions;
import com.pulumi.aws.ec2.outputs.VpnConnectionVgwTelemetry;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a Site-to-Site VPN connection. A Site-to-Site VPN connection is an Internet Protocol security (IPsec) VPN connection between a VPC and an on-premises network.
 * Any new Site-to-Site VPN connection that you create is an [AWS VPN connection](https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-categories.html).
 * 
 * &gt; **Note:** The CIDR blocks in the arguments `tunnel1_inside_cidr` and `tunnel2_inside_cidr` must have a prefix of /30 and be a part of a specific range.
 * [Read more about this in the AWS documentation](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnTunnelOptionsSpecification.html).
 * 
 * ## Example Usage
 * ### EC2 Transit Gateway
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleTransitGateway = new TransitGateway(&#34;exampleTransitGateway&#34;);
 * 
 *         var exampleCustomerGateway = new CustomerGateway(&#34;exampleCustomerGateway&#34;, CustomerGatewayArgs.builder()        
 *             .bgpAsn(65000)
 *             .ipAddress(&#34;172.0.0.1&#34;)
 *             .type(&#34;ipsec.1&#34;)
 *             .build());
 * 
 *         var exampleVpnConnection = new VpnConnection(&#34;exampleVpnConnection&#34;, VpnConnectionArgs.builder()        
 *             .customerGatewayId(exampleCustomerGateway.id())
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .type(exampleCustomerGateway.type())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Virtual Private Gateway
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var vpc = new Vpc(&#34;vpc&#34;, VpcArgs.builder()        
 *             .cidrBlock(&#34;10.0.0.0/16&#34;)
 *             .build());
 * 
 *         var vpnGateway = new VpnGateway(&#34;vpnGateway&#34;, VpnGatewayArgs.builder()        
 *             .vpcId(vpc.id())
 *             .build());
 * 
 *         var customerGateway = new CustomerGateway(&#34;customerGateway&#34;, CustomerGatewayArgs.builder()        
 *             .bgpAsn(65000)
 *             .ipAddress(&#34;172.0.0.1&#34;)
 *             .type(&#34;ipsec.1&#34;)
 *             .build());
 * 
 *         var main = new VpnConnection(&#34;main&#34;, VpnConnectionArgs.builder()        
 *             .vpnGatewayId(vpnGateway.id())
 *             .customerGatewayId(customerGateway.id())
 *             .type(&#34;ipsec.1&#34;)
 *             .staticRoutesOnly(true)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### AWS Site to Site Private VPN
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.directconnect.GatewayAssociation;
 * import com.pulumi.aws.directconnect.GatewayAssociationArgs;
 * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
 * import com.pulumi.aws.ec2transitgateway.inputs.GetDirectConnectGatewayAttachmentArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway(&#34;exampleGateway&#34;, GatewayArgs.builder()        
 *             .amazonSideAsn(&#34;64512&#34;)
 *             .build());
 * 
 *         var exampleTransitGateway = new TransitGateway(&#34;exampleTransitGateway&#34;, TransitGatewayArgs.builder()        
 *             .amazonSideAsn(&#34;64513&#34;)
 *             .description(&#34;example_ipsec_vpn_example&#34;)
 *             .transitGatewayCidrBlocks(&#34;10.0.0.0/24&#34;)
 *             .build());
 * 
 *         var exampleCustomerGateway = new CustomerGateway(&#34;exampleCustomerGateway&#34;, CustomerGatewayArgs.builder()        
 *             .bgpAsn(64514)
 *             .ipAddress(&#34;10.0.0.1&#34;)
 *             .type(&#34;ipsec.1&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;example_ipsec_vpn_example&#34;))
 *             .build());
 * 
 *         var exampleGatewayAssociation = new GatewayAssociation(&#34;exampleGatewayAssociation&#34;, GatewayAssociationArgs.builder()        
 *             .dxGatewayId(exampleGateway.id())
 *             .associatedGatewayId(exampleTransitGateway.id())
 *             .allowedPrefixes(&#34;10.0.0.0/8&#34;)
 *             .build());
 * 
 *         final var exampleDirectConnectGatewayAttachment = Ec2transitgatewayFunctions.getDirectConnectGatewayAttachment(GetDirectConnectGatewayAttachmentArgs.builder()
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .dxGatewayId(exampleGateway.id())
 *             .build());
 * 
 *         var exampleVpnConnection = new VpnConnection(&#34;exampleVpnConnection&#34;, VpnConnectionArgs.builder()        
 *             .customerGatewayId(exampleCustomerGateway.id())
 *             .outsideIpAddressType(&#34;PrivateIpv4&#34;)
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .transportTransitGatewayAttachmentId(exampleDirectConnectGatewayAttachment.applyValue(getDirectConnectGatewayAttachmentResult -&gt; getDirectConnectGatewayAttachmentResult).applyValue(exampleDirectConnectGatewayAttachment -&gt; exampleDirectConnectGatewayAttachment.applyValue(getDirectConnectGatewayAttachmentResult -&gt; getDirectConnectGatewayAttachmentResult.id())))
 *             .type(&#34;ipsec.1&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;example_ipsec_vpn_example&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import VPN Connections using the VPN connection `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/vpnConnection:VpnConnection testvpnconnection vpn-40f41529
 * ```
 * 
 */
@ResourceType(type="aws:ec2/vpnConnection:VpnConnection")
public class VpnConnection extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of the VPN Connection.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the VPN Connection.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The ARN of the core network.
     * 
     */
    @Export(name="coreNetworkArn", refs={String.class}, tree="[0]")
    private Output<String> coreNetworkArn;

    /**
     * @return The ARN of the core network.
     * 
     */
    public Output<String> coreNetworkArn() {
        return this.coreNetworkArn;
    }
    /**
     * The ARN of the core network attachment.
     * 
     */
    @Export(name="coreNetworkAttachmentArn", refs={String.class}, tree="[0]")
    private Output<String> coreNetworkAttachmentArn;

    /**
     * @return The ARN of the core network attachment.
     * 
     */
    public Output<String> coreNetworkAttachmentArn() {
        return this.coreNetworkAttachmentArn;
    }
    /**
     * The configuration information for the VPN connection&#39;s customer gateway (in the native XML format).
     * 
     */
    @Export(name="customerGatewayConfiguration", refs={String.class}, tree="[0]")
    private Output<String> customerGatewayConfiguration;

    /**
     * @return The configuration information for the VPN connection&#39;s customer gateway (in the native XML format).
     * 
     */
    public Output<String> customerGatewayConfiguration() {
        return this.customerGatewayConfiguration;
    }
    /**
     * The ID of the customer gateway.
     * 
     */
    @Export(name="customerGatewayId", refs={String.class}, tree="[0]")
    private Output<String> customerGatewayId;

    /**
     * @return The ID of the customer gateway.
     * 
     */
    public Output<String> customerGatewayId() {
        return this.customerGatewayId;
    }
    /**
     * Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
     * 
     */
    @Export(name="enableAcceleration", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> enableAcceleration;

    /**
     * @return Indicate whether to enable acceleration for the VPN connection. Supports only EC2 Transit Gateway.
     * 
     */
    public Output<Boolean> enableAcceleration() {
        return this.enableAcceleration;
    }
    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    @Export(name="localIpv4NetworkCidr", refs={String.class}, tree="[0]")
    private Output<String> localIpv4NetworkCidr;

    /**
     * @return The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    public Output<String> localIpv4NetworkCidr() {
        return this.localIpv4NetworkCidr;
    }
    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    @Export(name="localIpv6NetworkCidr", refs={String.class}, tree="[0]")
    private Output<String> localIpv6NetworkCidr;

    /**
     * @return The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    public Output<String> localIpv6NetworkCidr() {
        return this.localIpv6NetworkCidr;
    }
    /**
     * Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
     * 
     */
    @Export(name="outsideIpAddressType", refs={String.class}, tree="[0]")
    private Output<String> outsideIpAddressType;

    /**
     * @return Indicates if a Public S2S VPN or Private S2S VPN over AWS Direct Connect. Valid values are `PublicIpv4 | PrivateIpv4`
     * 
     */
    public Output<String> outsideIpAddressType() {
        return this.outsideIpAddressType;
    }
    /**
     * The IPv4 CIDR on the AWS side of the VPN connection.
     * 
     */
    @Export(name="remoteIpv4NetworkCidr", refs={String.class}, tree="[0]")
    private Output<String> remoteIpv4NetworkCidr;

    /**
     * @return The IPv4 CIDR on the AWS side of the VPN connection.
     * 
     */
    public Output<String> remoteIpv4NetworkCidr() {
        return this.remoteIpv4NetworkCidr;
    }
    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    @Export(name="remoteIpv6NetworkCidr", refs={String.class}, tree="[0]")
    private Output<String> remoteIpv6NetworkCidr;

    /**
     * @return The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * 
     */
    public Output<String> remoteIpv6NetworkCidr() {
        return this.remoteIpv6NetworkCidr;
    }
    /**
     * The static routes associated with the VPN connection. Detailed below.
     * 
     */
    @Export(name="routes", refs={List.class,VpnConnectionRoute.class}, tree="[0,1]")
    private Output<List<VpnConnectionRoute>> routes;

    /**
     * @return The static routes associated with the VPN connection. Detailed below.
     * 
     */
    public Output<List<VpnConnectionRoute>> routes() {
        return this.routes;
    }
    /**
     * Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don&#39;t support BGP.
     * 
     */
    @Export(name="staticRoutesOnly", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> staticRoutesOnly;

    /**
     * @return Whether the VPN connection uses static routes exclusively. Static routes must be used for devices that don&#39;t support BGP.
     * 
     */
    public Output<Boolean> staticRoutesOnly() {
        return this.staticRoutesOnly;
    }
    /**
     * Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Tags to apply to the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `aws.ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
     * 
     */
    @Export(name="transitGatewayAttachmentId", refs={String.class}, tree="[0]")
    private Output<String> transitGatewayAttachmentId;

    /**
     * @return When associated with an EC2 Transit Gateway (`transit_gateway_id` argument), the attachment ID. See also the `aws.ec2.Tag` resource for tagging the EC2 Transit Gateway VPN Attachment.
     * 
     */
    public Output<String> transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }
    /**
     * The ID of the EC2 Transit Gateway.
     * 
     */
    @Export(name="transitGatewayId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> transitGatewayId;

    /**
     * @return The ID of the EC2 Transit Gateway.
     * 
     */
    public Output<Optional<String>> transitGatewayId() {
        return Codegen.optional(this.transitGatewayId);
    }
    /**
     * . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
     * 
     */
    @Export(name="transportTransitGatewayAttachmentId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> transportTransitGatewayAttachmentId;

    /**
     * @return . The attachment ID of the Transit Gateway attachment to Direct Connect Gateway. The ID is obtained through a data source only.
     * 
     */
    public Output<Optional<String>> transportTransitGatewayAttachmentId() {
        return Codegen.optional(this.transportTransitGatewayAttachmentId);
    }
    /**
     * The public IP address of the first VPN tunnel.
     * 
     */
    @Export(name="tunnel1Address", refs={String.class}, tree="[0]")
    private Output<String> tunnel1Address;

    /**
     * @return The public IP address of the first VPN tunnel.
     * 
     */
    public Output<String> tunnel1Address() {
        return this.tunnel1Address;
    }
    /**
     * The bgp asn number of the first VPN tunnel.
     * 
     */
    @Export(name="tunnel1BgpAsn", refs={String.class}, tree="[0]")
    private Output<String> tunnel1BgpAsn;

    /**
     * @return The bgp asn number of the first VPN tunnel.
     * 
     */
    public Output<String> tunnel1BgpAsn() {
        return this.tunnel1BgpAsn;
    }
    /**
     * The bgp holdtime of the first VPN tunnel.
     * 
     */
    @Export(name="tunnel1BgpHoldtime", refs={Integer.class}, tree="[0]")
    private Output<Integer> tunnel1BgpHoldtime;

    /**
     * @return The bgp holdtime of the first VPN tunnel.
     * 
     */
    public Output<Integer> tunnel1BgpHoldtime() {
        return this.tunnel1BgpHoldtime;
    }
    /**
     * The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
     * 
     */
    @Export(name="tunnel1CgwInsideAddress", refs={String.class}, tree="[0]")
    private Output<String> tunnel1CgwInsideAddress;

    /**
     * @return The RFC 6890 link-local address of the first VPN tunnel (Customer Gateway Side).
     * 
     */
    public Output<String> tunnel1CgwInsideAddress() {
        return this.tunnel1CgwInsideAddress;
    }
    /**
     * The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     * 
     */
    @Export(name="tunnel1DpdTimeoutAction", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> tunnel1DpdTimeoutAction;

    /**
     * @return The action to take after DPD timeout occurs for the first VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     * 
     */
    public Output<Optional<String>> tunnel1DpdTimeoutAction() {
        return Codegen.optional(this.tunnel1DpdTimeoutAction);
    }
    /**
     * The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
     * 
     */
    @Export(name="tunnel1DpdTimeoutSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel1DpdTimeoutSeconds;

    /**
     * @return The number of seconds after which a DPD timeout occurs for the first VPN tunnel. Valid value is equal or higher than `30`.
     * 
     */
    public Output<Optional<Integer>> tunnel1DpdTimeoutSeconds() {
        return Codegen.optional(this.tunnel1DpdTimeoutSeconds);
    }
    /**
     * Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
     * 
     */
    @Export(name="tunnel1EnableTunnelLifecycleControl", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> tunnel1EnableTunnelLifecycleControl;

    /**
     * @return Turn on or off tunnel endpoint lifecycle control feature for the first VPN tunnel. Valid values are `true | false`.
     * 
     */
    public Output<Optional<Boolean>> tunnel1EnableTunnelLifecycleControl() {
        return Codegen.optional(this.tunnel1EnableTunnelLifecycleControl);
    }
    /**
     * The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
     * 
     */
    @Export(name="tunnel1IkeVersions", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel1IkeVersions;

    /**
     * @return The IKE versions that are permitted for the first VPN tunnel. Valid values are `ikev1 | ikev2`.
     * 
     */
    public Output<Optional<List<String>>> tunnel1IkeVersions() {
        return Codegen.optional(this.tunnel1IkeVersions);
    }
    /**
     * The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     */
    @Export(name="tunnel1InsideCidr", refs={String.class}, tree="[0]")
    private Output<String> tunnel1InsideCidr;

    /**
     * @return The CIDR block of the inside IP addresses for the first VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     */
    public Output<String> tunnel1InsideCidr() {
        return this.tunnel1InsideCidr;
    }
    /**
     * The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     * 
     */
    @Export(name="tunnel1InsideIpv6Cidr", refs={String.class}, tree="[0]")
    private Output<String> tunnel1InsideIpv6Cidr;

    /**
     * @return The range of inside IPv6 addresses for the first VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     * 
     */
    public Output<String> tunnel1InsideIpv6Cidr() {
        return this.tunnel1InsideIpv6Cidr;
    }
    /**
     * Options for logging VPN tunnel activity. See Log Options below for more details.
     * 
     */
    @Export(name="tunnel1LogOptions", refs={VpnConnectionTunnel1LogOptions.class}, tree="[0]")
    private Output<VpnConnectionTunnel1LogOptions> tunnel1LogOptions;

    /**
     * @return Options for logging VPN tunnel activity. See Log Options below for more details.
     * 
     */
    public Output<VpnConnectionTunnel1LogOptions> tunnel1LogOptions() {
        return this.tunnel1LogOptions;
    }
    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
     * 
     */
    @Export(name="tunnel1Phase1DhGroupNumbers", refs={List.class,Integer.class}, tree="[0,1]")
    private Output</* @Nullable */ List<Integer>> tunnel1Phase1DhGroupNumbers;

    /**
     * @return List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
     * 
     */
    public Output<Optional<List<Integer>>> tunnel1Phase1DhGroupNumbers() {
        return Codegen.optional(this.tunnel1Phase1DhGroupNumbers);
    }
    /**
     * List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    @Export(name="tunnel1Phase1EncryptionAlgorithms", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel1Phase1EncryptionAlgorithms;

    /**
     * @return List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    public Output<Optional<List<String>>> tunnel1Phase1EncryptionAlgorithms() {
        return Codegen.optional(this.tunnel1Phase1EncryptionAlgorithms);
    }
    /**
     * One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    @Export(name="tunnel1Phase1IntegrityAlgorithms", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel1Phase1IntegrityAlgorithms;

    /**
     * @return One or more integrity algorithms that are permitted for the first VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    public Output<Optional<List<String>>> tunnel1Phase1IntegrityAlgorithms() {
        return Codegen.optional(this.tunnel1Phase1IntegrityAlgorithms);
    }
    /**
     * The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     * 
     */
    @Export(name="tunnel1Phase1LifetimeSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel1Phase1LifetimeSeconds;

    /**
     * @return The lifetime for phase 1 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     * 
     */
    public Output<Optional<Integer>> tunnel1Phase1LifetimeSeconds() {
        return Codegen.optional(this.tunnel1Phase1LifetimeSeconds);
    }
    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     * 
     */
    @Export(name="tunnel1Phase2DhGroupNumbers", refs={List.class,Integer.class}, tree="[0,1]")
    private Output</* @Nullable */ List<Integer>> tunnel1Phase2DhGroupNumbers;

    /**
     * @return List of one or more Diffie-Hellman group numbers that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     * 
     */
    public Output<Optional<List<Integer>>> tunnel1Phase2DhGroupNumbers() {
        return Codegen.optional(this.tunnel1Phase2DhGroupNumbers);
    }
    /**
     * List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    @Export(name="tunnel1Phase2EncryptionAlgorithms", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel1Phase2EncryptionAlgorithms;

    /**
     * @return List of one or more encryption algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    public Output<Optional<List<String>>> tunnel1Phase2EncryptionAlgorithms() {
        return Codegen.optional(this.tunnel1Phase2EncryptionAlgorithms);
    }
    /**
     * List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    @Export(name="tunnel1Phase2IntegrityAlgorithms", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel1Phase2IntegrityAlgorithms;

    /**
     * @return List of one or more integrity algorithms that are permitted for the first VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    public Output<Optional<List<String>>> tunnel1Phase2IntegrityAlgorithms() {
        return Codegen.optional(this.tunnel1Phase2IntegrityAlgorithms);
    }
    /**
     * The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     * 
     */
    @Export(name="tunnel1Phase2LifetimeSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel1Phase2LifetimeSeconds;

    /**
     * @return The lifetime for phase 2 of the IKE negotiation for the first VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     * 
     */
    public Output<Optional<Integer>> tunnel1Phase2LifetimeSeconds() {
        return Codegen.optional(this.tunnel1Phase2LifetimeSeconds);
    }
    /**
     * The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     * 
     */
    @Export(name="tunnel1PresharedKey", refs={String.class}, tree="[0]")
    private Output<String> tunnel1PresharedKey;

    /**
     * @return The preshared key of the first VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     * 
     */
    public Output<String> tunnel1PresharedKey() {
        return this.tunnel1PresharedKey;
    }
    /**
     * The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     * 
     */
    @Export(name="tunnel1RekeyFuzzPercentage", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel1RekeyFuzzPercentage;

    /**
     * @return The percentage of the rekey window for the first VPN tunnel (determined by `tunnel1_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     * 
     */
    public Output<Optional<Integer>> tunnel1RekeyFuzzPercentage() {
        return Codegen.optional(this.tunnel1RekeyFuzzPercentage);
    }
    /**
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
     * 
     */
    @Export(name="tunnel1RekeyMarginTimeSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel1RekeyMarginTimeSeconds;

    /**
     * @return The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the first VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel1_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel1_phase2_lifetime_seconds`.
     * 
     */
    public Output<Optional<Integer>> tunnel1RekeyMarginTimeSeconds() {
        return Codegen.optional(this.tunnel1RekeyMarginTimeSeconds);
    }
    /**
     * The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
     * 
     */
    @Export(name="tunnel1ReplayWindowSize", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel1ReplayWindowSize;

    /**
     * @return The number of packets in an IKE replay window for the first VPN tunnel. Valid value is between `64` and `2048`.
     * 
     */
    public Output<Optional<Integer>> tunnel1ReplayWindowSize() {
        return Codegen.optional(this.tunnel1ReplayWindowSize);
    }
    /**
     * The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     * 
     */
    @Export(name="tunnel1StartupAction", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> tunnel1StartupAction;

    /**
     * @return The action to take when the establishing the tunnel for the first VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     * 
     */
    public Output<Optional<String>> tunnel1StartupAction() {
        return Codegen.optional(this.tunnel1StartupAction);
    }
    /**
     * The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
     * 
     */
    @Export(name="tunnel1VgwInsideAddress", refs={String.class}, tree="[0]")
    private Output<String> tunnel1VgwInsideAddress;

    /**
     * @return The RFC 6890 link-local address of the first VPN tunnel (VPN Gateway Side).
     * 
     */
    public Output<String> tunnel1VgwInsideAddress() {
        return this.tunnel1VgwInsideAddress;
    }
    /**
     * The public IP address of the second VPN tunnel.
     * 
     */
    @Export(name="tunnel2Address", refs={String.class}, tree="[0]")
    private Output<String> tunnel2Address;

    /**
     * @return The public IP address of the second VPN tunnel.
     * 
     */
    public Output<String> tunnel2Address() {
        return this.tunnel2Address;
    }
    /**
     * The bgp asn number of the second VPN tunnel.
     * 
     */
    @Export(name="tunnel2BgpAsn", refs={String.class}, tree="[0]")
    private Output<String> tunnel2BgpAsn;

    /**
     * @return The bgp asn number of the second VPN tunnel.
     * 
     */
    public Output<String> tunnel2BgpAsn() {
        return this.tunnel2BgpAsn;
    }
    /**
     * The bgp holdtime of the second VPN tunnel.
     * 
     */
    @Export(name="tunnel2BgpHoldtime", refs={Integer.class}, tree="[0]")
    private Output<Integer> tunnel2BgpHoldtime;

    /**
     * @return The bgp holdtime of the second VPN tunnel.
     * 
     */
    public Output<Integer> tunnel2BgpHoldtime() {
        return this.tunnel2BgpHoldtime;
    }
    /**
     * The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
     * 
     */
    @Export(name="tunnel2CgwInsideAddress", refs={String.class}, tree="[0]")
    private Output<String> tunnel2CgwInsideAddress;

    /**
     * @return The RFC 6890 link-local address of the second VPN tunnel (Customer Gateway Side).
     * 
     */
    public Output<String> tunnel2CgwInsideAddress() {
        return this.tunnel2CgwInsideAddress;
    }
    /**
     * The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     * 
     */
    @Export(name="tunnel2DpdTimeoutAction", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> tunnel2DpdTimeoutAction;

    /**
     * @return The action to take after DPD timeout occurs for the second VPN tunnel. Specify restart to restart the IKE initiation. Specify clear to end the IKE session. Valid values are `clear | none | restart`.
     * 
     */
    public Output<Optional<String>> tunnel2DpdTimeoutAction() {
        return Codegen.optional(this.tunnel2DpdTimeoutAction);
    }
    /**
     * The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
     * 
     */
    @Export(name="tunnel2DpdTimeoutSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel2DpdTimeoutSeconds;

    /**
     * @return The number of seconds after which a DPD timeout occurs for the second VPN tunnel. Valid value is equal or higher than `30`.
     * 
     */
    public Output<Optional<Integer>> tunnel2DpdTimeoutSeconds() {
        return Codegen.optional(this.tunnel2DpdTimeoutSeconds);
    }
    /**
     * Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
     * 
     */
    @Export(name="tunnel2EnableTunnelLifecycleControl", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> tunnel2EnableTunnelLifecycleControl;

    /**
     * @return Turn on or off tunnel endpoint lifecycle control feature for the second VPN tunnel. Valid values are `true | false`.
     * 
     */
    public Output<Optional<Boolean>> tunnel2EnableTunnelLifecycleControl() {
        return Codegen.optional(this.tunnel2EnableTunnelLifecycleControl);
    }
    /**
     * The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
     * 
     */
    @Export(name="tunnel2IkeVersions", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel2IkeVersions;

    /**
     * @return The IKE versions that are permitted for the second VPN tunnel. Valid values are `ikev1 | ikev2`.
     * 
     */
    public Output<Optional<List<String>>> tunnel2IkeVersions() {
        return Codegen.optional(this.tunnel2IkeVersions);
    }
    /**
     * The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     */
    @Export(name="tunnel2InsideCidr", refs={String.class}, tree="[0]")
    private Output<String> tunnel2InsideCidr;

    /**
     * @return The CIDR block of the inside IP addresses for the second VPN tunnel. Valid value is a size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     */
    public Output<String> tunnel2InsideCidr() {
        return this.tunnel2InsideCidr;
    }
    /**
     * The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     * 
     */
    @Export(name="tunnel2InsideIpv6Cidr", refs={String.class}, tree="[0]")
    private Output<String> tunnel2InsideIpv6Cidr;

    /**
     * @return The range of inside IPv6 addresses for the second VPN tunnel. Supports only EC2 Transit Gateway. Valid value is a size /126 CIDR block from the local fd00::/8 range.
     * 
     */
    public Output<String> tunnel2InsideIpv6Cidr() {
        return this.tunnel2InsideIpv6Cidr;
    }
    /**
     * Options for logging VPN tunnel activity. See Log Options below for more details.
     * 
     */
    @Export(name="tunnel2LogOptions", refs={VpnConnectionTunnel2LogOptions.class}, tree="[0]")
    private Output<VpnConnectionTunnel2LogOptions> tunnel2LogOptions;

    /**
     * @return Options for logging VPN tunnel activity. See Log Options below for more details.
     * 
     */
    public Output<VpnConnectionTunnel2LogOptions> tunnel2LogOptions() {
        return this.tunnel2LogOptions;
    }
    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
     * 
     */
    @Export(name="tunnel2Phase1DhGroupNumbers", refs={List.class,Integer.class}, tree="[0,1]")
    private Output</* @Nullable */ List<Integer>> tunnel2Phase1DhGroupNumbers;

    /**
     * @return List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `  2 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24 `.
     * 
     */
    public Output<Optional<List<Integer>>> tunnel2Phase1DhGroupNumbers() {
        return Codegen.optional(this.tunnel2Phase1DhGroupNumbers);
    }
    /**
     * List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    @Export(name="tunnel2Phase1EncryptionAlgorithms", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel2Phase1EncryptionAlgorithms;

    /**
     * @return List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    public Output<Optional<List<String>>> tunnel2Phase1EncryptionAlgorithms() {
        return Codegen.optional(this.tunnel2Phase1EncryptionAlgorithms);
    }
    /**
     * One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    @Export(name="tunnel2Phase1IntegrityAlgorithms", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel2Phase1IntegrityAlgorithms;

    /**
     * @return One or more integrity algorithms that are permitted for the second VPN tunnel for phase 1 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    public Output<Optional<List<String>>> tunnel2Phase1IntegrityAlgorithms() {
        return Codegen.optional(this.tunnel2Phase1IntegrityAlgorithms);
    }
    /**
     * The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     * 
     */
    @Export(name="tunnel2Phase1LifetimeSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel2Phase1LifetimeSeconds;

    /**
     * @return The lifetime for phase 1 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `28800`.
     * 
     */
    public Output<Optional<Integer>> tunnel2Phase1LifetimeSeconds() {
        return Codegen.optional(this.tunnel2Phase1LifetimeSeconds);
    }
    /**
     * List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     * 
     */
    @Export(name="tunnel2Phase2DhGroupNumbers", refs={List.class,Integer.class}, tree="[0,1]")
    private Output</* @Nullable */ List<Integer>> tunnel2Phase2DhGroupNumbers;

    /**
     * @return List of one or more Diffie-Hellman group numbers that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `2 | 5 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | 24`.
     * 
     */
    public Output<Optional<List<Integer>>> tunnel2Phase2DhGroupNumbers() {
        return Codegen.optional(this.tunnel2Phase2DhGroupNumbers);
    }
    /**
     * List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    @Export(name="tunnel2Phase2EncryptionAlgorithms", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel2Phase2EncryptionAlgorithms;

    /**
     * @return List of one or more encryption algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `AES128 | AES256 | AES128-GCM-16 | AES256-GCM-16`.
     * 
     */
    public Output<Optional<List<String>>> tunnel2Phase2EncryptionAlgorithms() {
        return Codegen.optional(this.tunnel2Phase2EncryptionAlgorithms);
    }
    /**
     * List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    @Export(name="tunnel2Phase2IntegrityAlgorithms", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> tunnel2Phase2IntegrityAlgorithms;

    /**
     * @return List of one or more integrity algorithms that are permitted for the second VPN tunnel for phase 2 IKE negotiations. Valid values are `SHA1 | SHA2-256 | SHA2-384 | SHA2-512`.
     * 
     */
    public Output<Optional<List<String>>> tunnel2Phase2IntegrityAlgorithms() {
        return Codegen.optional(this.tunnel2Phase2IntegrityAlgorithms);
    }
    /**
     * The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     * 
     */
    @Export(name="tunnel2Phase2LifetimeSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel2Phase2LifetimeSeconds;

    /**
     * @return The lifetime for phase 2 of the IKE negotiation for the second VPN tunnel, in seconds. Valid value is between `900` and `3600`.
     * 
     */
    public Output<Optional<Integer>> tunnel2Phase2LifetimeSeconds() {
        return Codegen.optional(this.tunnel2Phase2LifetimeSeconds);
    }
    /**
     * The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     * 
     */
    @Export(name="tunnel2PresharedKey", refs={String.class}, tree="[0]")
    private Output<String> tunnel2PresharedKey;

    /**
     * @return The preshared key of the second VPN tunnel. The preshared key must be between 8 and 64 characters in length and cannot start with zero(0). Allowed characters are alphanumeric characters, periods(.) and underscores(_).
     * 
     */
    public Output<String> tunnel2PresharedKey() {
        return this.tunnel2PresharedKey;
    }
    /**
     * The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     * 
     */
    @Export(name="tunnel2RekeyFuzzPercentage", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel2RekeyFuzzPercentage;

    /**
     * @return The percentage of the rekey window for the second VPN tunnel (determined by `tunnel2_rekey_margin_time_seconds`) during which the rekey time is randomly selected. Valid value is between `0` and `100`.
     * 
     */
    public Output<Optional<Integer>> tunnel2RekeyFuzzPercentage() {
        return Codegen.optional(this.tunnel2RekeyFuzzPercentage);
    }
    /**
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
     * 
     */
    @Export(name="tunnel2RekeyMarginTimeSeconds", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel2RekeyMarginTimeSeconds;

    /**
     * @return The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the second VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for `tunnel2_rekey_fuzz_percentage`. Valid value is between `60` and half of `tunnel2_phase2_lifetime_seconds`.
     * 
     */
    public Output<Optional<Integer>> tunnel2RekeyMarginTimeSeconds() {
        return Codegen.optional(this.tunnel2RekeyMarginTimeSeconds);
    }
    /**
     * The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
     * 
     */
    @Export(name="tunnel2ReplayWindowSize", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> tunnel2ReplayWindowSize;

    /**
     * @return The number of packets in an IKE replay window for the second VPN tunnel. Valid value is between `64` and `2048`.
     * 
     */
    public Output<Optional<Integer>> tunnel2ReplayWindowSize() {
        return Codegen.optional(this.tunnel2ReplayWindowSize);
    }
    /**
     * The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     * 
     */
    @Export(name="tunnel2StartupAction", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> tunnel2StartupAction;

    /**
     * @return The action to take when the establishing the tunnel for the second VPN connection. By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify start for AWS to initiate the IKE negotiation. Valid values are `add | start`.
     * 
     */
    public Output<Optional<String>> tunnel2StartupAction() {
        return Codegen.optional(this.tunnel2StartupAction);
    }
    /**
     * The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
     * 
     */
    @Export(name="tunnel2VgwInsideAddress", refs={String.class}, tree="[0]")
    private Output<String> tunnel2VgwInsideAddress;

    /**
     * @return The RFC 6890 link-local address of the second VPN tunnel (VPN Gateway Side).
     * 
     */
    public Output<String> tunnel2VgwInsideAddress() {
        return this.tunnel2VgwInsideAddress;
    }
    /**
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
     * 
     */
    @Export(name="tunnelInsideIpVersion", refs={String.class}, tree="[0]")
    private Output<String> tunnelInsideIpVersion;

    /**
     * @return Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. Valid values are `ipv4 | ipv6`. `ipv6` Supports only EC2 Transit Gateway.
     * 
     */
    public Output<String> tunnelInsideIpVersion() {
        return this.tunnelInsideIpVersion;
    }
    /**
     * The type of VPN connection. The only type AWS supports at this time is &#34;ipsec.1&#34;.
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output<String> type;

    /**
     * @return The type of VPN connection. The only type AWS supports at this time is &#34;ipsec.1&#34;.
     * 
     */
    public Output<String> type() {
        return this.type;
    }
    /**
     * Telemetry for the VPN tunnels. Detailed below.
     * 
     */
    @Export(name="vgwTelemetries", refs={List.class,VpnConnectionVgwTelemetry.class}, tree="[0,1]")
    private Output<List<VpnConnectionVgwTelemetry>> vgwTelemetries;

    /**
     * @return Telemetry for the VPN tunnels. Detailed below.
     * 
     */
    public Output<List<VpnConnectionVgwTelemetry>> vgwTelemetries() {
        return this.vgwTelemetries;
    }
    /**
     * The ID of the Virtual Private Gateway.
     * 
     */
    @Export(name="vpnGatewayId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> vpnGatewayId;

    /**
     * @return The ID of the Virtual Private Gateway.
     * 
     */
    public Output<Optional<String>> vpnGatewayId() {
        return Codegen.optional(this.vpnGatewayId);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VpnConnection(String name) {
        this(name, VpnConnectionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VpnConnection(String name, VpnConnectionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VpnConnection(String name, VpnConnectionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpnConnection:VpnConnection", name, args == null ? VpnConnectionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VpnConnection(String name, Output<String> id, @Nullable VpnConnectionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpnConnection:VpnConnection", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "customerGatewayConfiguration",
                "tunnel1PresharedKey",
                "tunnel2PresharedKey"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VpnConnection get(String name, Output<String> id, @Nullable VpnConnectionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VpnConnection(name, id, state, options);
    }
}
