// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VpcIpv6CidrBlockAssociationArgs extends com.pulumi.resources.ResourceArgs {

    public static final VpcIpv6CidrBlockAssociationArgs Empty = new VpcIpv6CidrBlockAssociationArgs();

    /**
     * The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and he IPAM pool does not have `allocation_default_netmask` set.
     * 
     */
    @Import(name="ipv6CidrBlock")
    private @Nullable Output<String> ipv6CidrBlock;

    /**
     * @return The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and he IPAM pool does not have `allocation_default_netmask` set.
     * 
     */
    public Optional<Output<String>> ipv6CidrBlock() {
        return Optional.ofNullable(this.ipv6CidrBlock);
    }

    /**
     * The ID of an IPv6 IPAM pool you want to use for allocating this VPC&#39;s CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts.
     * 
     */
    @Import(name="ipv6IpamPoolId", required=true)
    private Output<String> ipv6IpamPoolId;

    /**
     * @return The ID of an IPv6 IPAM pool you want to use for allocating this VPC&#39;s CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts.
     * 
     */
    public Output<String> ipv6IpamPoolId() {
        return this.ipv6IpamPoolId;
    }

    /**
     * The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `cidr_block` are required
     * 
     */
    @Import(name="ipv6NetmaskLength")
    private @Nullable Output<Integer> ipv6NetmaskLength;

    /**
     * @return The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `cidr_block` are required
     * 
     */
    public Optional<Output<Integer>> ipv6NetmaskLength() {
        return Optional.ofNullable(this.ipv6NetmaskLength);
    }

    /**
     * The ID of the VPC to make the association with.
     * 
     */
    @Import(name="vpcId", required=true)
    private Output<String> vpcId;

    /**
     * @return The ID of the VPC to make the association with.
     * 
     */
    public Output<String> vpcId() {
        return this.vpcId;
    }

    private VpcIpv6CidrBlockAssociationArgs() {}

    private VpcIpv6CidrBlockAssociationArgs(VpcIpv6CidrBlockAssociationArgs $) {
        this.ipv6CidrBlock = $.ipv6CidrBlock;
        this.ipv6IpamPoolId = $.ipv6IpamPoolId;
        this.ipv6NetmaskLength = $.ipv6NetmaskLength;
        this.vpcId = $.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VpcIpv6CidrBlockAssociationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VpcIpv6CidrBlockAssociationArgs $;

        public Builder() {
            $ = new VpcIpv6CidrBlockAssociationArgs();
        }

        public Builder(VpcIpv6CidrBlockAssociationArgs defaults) {
            $ = new VpcIpv6CidrBlockAssociationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param ipv6CidrBlock The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and he IPAM pool does not have `allocation_default_netmask` set.
         * 
         * @return builder
         * 
         */
        public Builder ipv6CidrBlock(@Nullable Output<String> ipv6CidrBlock) {
            $.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        /**
         * @param ipv6CidrBlock The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and he IPAM pool does not have `allocation_default_netmask` set.
         * 
         * @return builder
         * 
         */
        public Builder ipv6CidrBlock(String ipv6CidrBlock) {
            return ipv6CidrBlock(Output.of(ipv6CidrBlock));
        }

        /**
         * @param ipv6IpamPoolId The ID of an IPv6 IPAM pool you want to use for allocating this VPC&#39;s CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts.
         * 
         * @return builder
         * 
         */
        public Builder ipv6IpamPoolId(Output<String> ipv6IpamPoolId) {
            $.ipv6IpamPoolId = ipv6IpamPoolId;
            return this;
        }

        /**
         * @param ipv6IpamPoolId The ID of an IPv6 IPAM pool you want to use for allocating this VPC&#39;s CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts.
         * 
         * @return builder
         * 
         */
        public Builder ipv6IpamPoolId(String ipv6IpamPoolId) {
            return ipv6IpamPoolId(Output.of(ipv6IpamPoolId));
        }

        /**
         * @param ipv6NetmaskLength The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `cidr_block` are required
         * 
         * @return builder
         * 
         */
        public Builder ipv6NetmaskLength(@Nullable Output<Integer> ipv6NetmaskLength) {
            $.ipv6NetmaskLength = ipv6NetmaskLength;
            return this;
        }

        /**
         * @param ipv6NetmaskLength The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `cidr_block` are required
         * 
         * @return builder
         * 
         */
        public Builder ipv6NetmaskLength(Integer ipv6NetmaskLength) {
            return ipv6NetmaskLength(Output.of(ipv6NetmaskLength));
        }

        /**
         * @param vpcId The ID of the VPC to make the association with.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(Output<String> vpcId) {
            $.vpcId = vpcId;
            return this;
        }

        /**
         * @param vpcId The ID of the VPC to make the association with.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(String vpcId) {
            return vpcId(Output.of(vpcId));
        }

        public VpcIpv6CidrBlockAssociationArgs build() {
            $.ipv6IpamPoolId = Objects.requireNonNull($.ipv6IpamPoolId, "expected parameter 'ipv6IpamPoolId' to be non-null");
            $.vpcId = Objects.requireNonNull($.vpcId, "expected parameter 'vpcId' to be non-null");
            return $;
        }
    }

}
