// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VpcIpv4CidrBlockAssociationArgs extends com.pulumi.resources.ResourceArgs {

    public static final VpcIpv4CidrBlockAssociationArgs Empty = new VpcIpv4CidrBlockAssociationArgs();

    /**
     * The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     * 
     */
    @Import(name="cidrBlock")
    private @Nullable Output<String> cidrBlock;

    /**
     * @return The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     * 
     */
    public Optional<Output<String>> cidrBlock() {
        return Optional.ofNullable(this.cidrBlock);
    }

    /**
     * The ID of an IPv4 IPAM pool you want to use for allocating this VPC&#39;s CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     * 
     */
    @Import(name="ipv4IpamPoolId")
    private @Nullable Output<String> ipv4IpamPoolId;

    /**
     * @return The ID of an IPv4 IPAM pool you want to use for allocating this VPC&#39;s CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     * 
     */
    public Optional<Output<String>> ipv4IpamPoolId() {
        return Optional.ofNullable(this.ipv4IpamPoolId);
    }

    /**
     * The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     * 
     */
    @Import(name="ipv4NetmaskLength")
    private @Nullable Output<Integer> ipv4NetmaskLength;

    /**
     * @return The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     * 
     */
    public Optional<Output<Integer>> ipv4NetmaskLength() {
        return Optional.ofNullable(this.ipv4NetmaskLength);
    }

    /**
     * The ID of the VPC to make the association with.
     * 
     */
    @Import(name="vpcId", required=true)
    private Output<String> vpcId;

    /**
     * @return The ID of the VPC to make the association with.
     * 
     */
    public Output<String> vpcId() {
        return this.vpcId;
    }

    private VpcIpv4CidrBlockAssociationArgs() {}

    private VpcIpv4CidrBlockAssociationArgs(VpcIpv4CidrBlockAssociationArgs $) {
        this.cidrBlock = $.cidrBlock;
        this.ipv4IpamPoolId = $.ipv4IpamPoolId;
        this.ipv4NetmaskLength = $.ipv4NetmaskLength;
        this.vpcId = $.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VpcIpv4CidrBlockAssociationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VpcIpv4CidrBlockAssociationArgs $;

        public Builder() {
            $ = new VpcIpv4CidrBlockAssociationArgs();
        }

        public Builder(VpcIpv4CidrBlockAssociationArgs defaults) {
            $ = new VpcIpv4CidrBlockAssociationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param cidrBlock The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
         * 
         * @return builder
         * 
         */
        public Builder cidrBlock(@Nullable Output<String> cidrBlock) {
            $.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * @param cidrBlock The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
         * 
         * @return builder
         * 
         */
        public Builder cidrBlock(String cidrBlock) {
            return cidrBlock(Output.of(cidrBlock));
        }

        /**
         * @param ipv4IpamPoolId The ID of an IPv4 IPAM pool you want to use for allocating this VPC&#39;s CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
         * 
         * @return builder
         * 
         */
        public Builder ipv4IpamPoolId(@Nullable Output<String> ipv4IpamPoolId) {
            $.ipv4IpamPoolId = ipv4IpamPoolId;
            return this;
        }

        /**
         * @param ipv4IpamPoolId The ID of an IPv4 IPAM pool you want to use for allocating this VPC&#39;s CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
         * 
         * @return builder
         * 
         */
        public Builder ipv4IpamPoolId(String ipv4IpamPoolId) {
            return ipv4IpamPoolId(Output.of(ipv4IpamPoolId));
        }

        /**
         * @param ipv4NetmaskLength The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
         * 
         * @return builder
         * 
         */
        public Builder ipv4NetmaskLength(@Nullable Output<Integer> ipv4NetmaskLength) {
            $.ipv4NetmaskLength = ipv4NetmaskLength;
            return this;
        }

        /**
         * @param ipv4NetmaskLength The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
         * 
         * @return builder
         * 
         */
        public Builder ipv4NetmaskLength(Integer ipv4NetmaskLength) {
            return ipv4NetmaskLength(Output.of(ipv4NetmaskLength));
        }

        /**
         * @param vpcId The ID of the VPC to make the association with.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(Output<String> vpcId) {
            $.vpcId = vpcId;
            return this;
        }

        /**
         * @param vpcId The ID of the VPC to make the association with.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(String vpcId) {
            return vpcId(Output.of(vpcId));
        }

        public VpcIpv4CidrBlockAssociationArgs build() {
            $.vpcId = Objects.requireNonNull($.vpcId, "expected parameter 'vpcId' to be non-null");
            return $;
        }
    }

}
