// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociationArgs;
import com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an association between an Amazon IP Address Manager (IPAM) and a IPAM Resource Discovery. IPAM Resource Discoveries are resources meant for multi-organization customers. If you wish to use a single IPAM across multiple orgs, a resource discovery can be created and shared from a subordinate organization to the management organizations IPAM delegated admin account.
 * 
 * Once an association is created between two organizations via IPAM &amp; a IPAM Resource Discovery, IPAM Pools can be shared via Resource Access Manager (RAM) to accounts in the subordinate organization; these RAM shares must be accepted by the end user account. Pools can then also discover and monitor IPAM resources in the subordinate organization.
 * 
 * ## Example Usage
 * 
 * Basic usage:
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociation;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new VpcIpamResourceDiscoveryAssociation(&#34;test&#34;, VpcIpamResourceDiscoveryAssociationArgs.builder()        
 *             .ipamId(aws_vpc_ipam.test().id())
 *             .ipamResourceDiscoveryId(aws_vpc_ipam_resource_discovery.test().id())
 *             .tags(Map.of(&#34;Name&#34;, &#34;test&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import IPAMs using the IPAM resource discovery association `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamResourceDiscoveryAssociation:VpcIpamResourceDiscoveryAssociation example ipam-res-disco-assoc-0178368ad2146a492
 * ```
 * 
 */
@ResourceType(type="aws:ec2/vpcIpamResourceDiscoveryAssociation:VpcIpamResourceDiscoveryAssociation")
public class VpcIpamResourceDiscoveryAssociation extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of IPAM Resource Discovery Association.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of IPAM Resource Discovery Association.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The Amazon Resource Name (ARN) of the IPAM.
     * 
     */
    @Export(name="ipamArn", refs={String.class}, tree="[0]")
    private Output<String> ipamArn;

    /**
     * @return The Amazon Resource Name (ARN) of the IPAM.
     * 
     */
    public Output<String> ipamArn() {
        return this.ipamArn;
    }
    /**
     * The ID of the IPAM to associate.
     * 
     */
    @Export(name="ipamId", refs={String.class}, tree="[0]")
    private Output<String> ipamId;

    /**
     * @return The ID of the IPAM to associate.
     * 
     */
    public Output<String> ipamId() {
        return this.ipamId;
    }
    /**
     * The home region of the IPAM.
     * 
     */
    @Export(name="ipamRegion", refs={String.class}, tree="[0]")
    private Output<String> ipamRegion;

    /**
     * @return The home region of the IPAM.
     * 
     */
    public Output<String> ipamRegion() {
        return this.ipamRegion;
    }
    /**
     * The ID of the Resource Discovery to associate.
     * 
     */
    @Export(name="ipamResourceDiscoveryId", refs={String.class}, tree="[0]")
    private Output<String> ipamResourceDiscoveryId;

    /**
     * @return The ID of the Resource Discovery to associate.
     * 
     */
    public Output<String> ipamResourceDiscoveryId() {
        return this.ipamResourceDiscoveryId;
    }
    /**
     * A boolean to identify if the Resource Discovery is the accounts default resource discovery.
     * 
     */
    @Export(name="isDefault", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> isDefault;

    /**
     * @return A boolean to identify if the Resource Discovery is the accounts default resource discovery.
     * 
     */
    public Output<Boolean> isDefault() {
        return this.isDefault;
    }
    /**
     * The account ID for the account that manages the Resource Discovery
     * 
     */
    @Export(name="ownerId", refs={String.class}, tree="[0]")
    private Output<String> ownerId;

    /**
     * @return The account ID for the account that manages the Resource Discovery
     * 
     */
    public Output<String> ownerId() {
        return this.ownerId;
    }
    /**
     * The lifecycle state of the association when you associate or disassociate a resource discovery.
     * 
     */
    @Export(name="state", refs={String.class}, tree="[0]")
    private Output<String> state;

    /**
     * @return The lifecycle state of the association when you associate or disassociate a resource discovery.
     * 
     */
    public Output<String> state() {
        return this.state;
    }
    /**
     * A map of tags to add to the IPAM resource discovery association resource.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to add to the IPAM resource discovery association resource.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VpcIpamResourceDiscoveryAssociation(String name) {
        this(name, VpcIpamResourceDiscoveryAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VpcIpamResourceDiscoveryAssociation(String name, VpcIpamResourceDiscoveryAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VpcIpamResourceDiscoveryAssociation(String name, VpcIpamResourceDiscoveryAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpcIpamResourceDiscoveryAssociation:VpcIpamResourceDiscoveryAssociation", name, args == null ? VpcIpamResourceDiscoveryAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VpcIpamResourceDiscoveryAssociation(String name, Output<String> id, @Nullable VpcIpamResourceDiscoveryAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpcIpamResourceDiscoveryAssociation:VpcIpamResourceDiscoveryAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VpcIpamResourceDiscoveryAssociation get(String name, Output<String> id, @Nullable VpcIpamResourceDiscoveryAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VpcIpamResourceDiscoveryAssociation(name, id, state, options);
    }
}
