// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs;
import com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryState;
import com.pulumi.aws.ec2.outputs.VpcIpamResourceDiscoveryOperatingRegion;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an IPAM Resource Discovery resource. IPAM Resource Discoveries are resources meant for multi-organization customers. If you wish to use a single IPAM across multiple orgs, a resource discovery can be created and shared from a subordinate organization to the management organizations IPAM delegated admin account. For a full deployment example, see `aws.ec2.VpcIpamResourceDiscoveryAssociation` resource.
 * 
 * ## Example Usage
 * 
 * Basic usage:
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscovery;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 * 
 *         var main = new VpcIpamResourceDiscovery(&#34;main&#34;, VpcIpamResourceDiscoveryArgs.builder()        
 *             .description(&#34;My IPAM Resource Discovery&#34;)
 *             .operatingRegions(VpcIpamResourceDiscoveryOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -&gt; getRegionResult.name()))
 *                 .build())
 *             .tags(Map.of(&#34;Test&#34;, &#34;Main&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import IPAMs using the IPAM resource discovery `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamResourceDiscovery:VpcIpamResourceDiscovery example ipam-res-disco-0178368ad2146a492
 * ```
 * 
 */
@ResourceType(type="aws:ec2/vpcIpamResourceDiscovery:VpcIpamResourceDiscovery")
public class VpcIpamResourceDiscovery extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of IPAM Resource Discovery
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of IPAM Resource Discovery
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * A description for the IPAM Resource Discovery.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A description for the IPAM Resource Discovery.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The home region of the Resource Discovery
     * 
     */
    @Export(name="ipamResourceDiscoveryRegion", refs={String.class}, tree="[0]")
    private Output<String> ipamResourceDiscoveryRegion;

    /**
     * @return The home region of the Resource Discovery
     * 
     */
    public Output<String> ipamResourceDiscoveryRegion() {
        return this.ipamResourceDiscoveryRegion;
    }
    /**
     * A boolean to identify if the Resource Discovery is the accounts default resource discovery
     * 
     */
    @Export(name="isDefault", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> isDefault;

    /**
     * @return A boolean to identify if the Resource Discovery is the accounts default resource discovery
     * 
     */
    public Output<Boolean> isDefault() {
        return this.isDefault;
    }
    /**
     * Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC&#39;s Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     * 
     */
    @Export(name="operatingRegions", refs={List.class,VpcIpamResourceDiscoveryOperatingRegion.class}, tree="[0,1]")
    private Output<List<VpcIpamResourceDiscoveryOperatingRegion>> operatingRegions;

    /**
     * @return Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC&#39;s Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     * 
     */
    public Output<List<VpcIpamResourceDiscoveryOperatingRegion>> operatingRegions() {
        return this.operatingRegions;
    }
    /**
     * The account ID for the account that manages the Resource Discovery
     * 
     */
    @Export(name="ownerId", refs={String.class}, tree="[0]")
    private Output<String> ownerId;

    /**
     * @return The account ID for the account that manages the Resource Discovery
     * 
     */
    public Output<String> ownerId() {
        return this.ownerId;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VpcIpamResourceDiscovery(String name) {
        this(name, VpcIpamResourceDiscoveryArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VpcIpamResourceDiscovery(String name, VpcIpamResourceDiscoveryArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VpcIpamResourceDiscovery(String name, VpcIpamResourceDiscoveryArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpcIpamResourceDiscovery:VpcIpamResourceDiscovery", name, args == null ? VpcIpamResourceDiscoveryArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VpcIpamResourceDiscovery(String name, Output<String> id, @Nullable VpcIpamResourceDiscoveryState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpcIpamResourceDiscovery:VpcIpamResourceDiscovery", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VpcIpamResourceDiscovery get(String name, Output<String> id, @Nullable VpcIpamResourceDiscoveryState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VpcIpamResourceDiscovery(name, id, state, options);
    }
}
