// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class VpcIpamPoolArgs extends com.pulumi.resources.ResourceArgs {

    public static final VpcIpamPoolArgs Empty = new VpcIpamPoolArgs();

    /**
     * The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
     * 
     */
    @Import(name="addressFamily", required=true)
    private Output<String> addressFamily;

    /**
     * @return The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
     * 
     */
    public Output<String> addressFamily() {
        return this.addressFamily;
    }

    /**
     * A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
     * 
     */
    @Import(name="allocationDefaultNetmaskLength")
    private @Nullable Output<Integer> allocationDefaultNetmaskLength;

    /**
     * @return A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
     * 
     */
    public Optional<Output<Integer>> allocationDefaultNetmaskLength() {
        return Optional.ofNullable(this.allocationDefaultNetmaskLength);
    }

    /**
     * The maximum netmask length that will be required for CIDR allocations in this pool.
     * 
     */
    @Import(name="allocationMaxNetmaskLength")
    private @Nullable Output<Integer> allocationMaxNetmaskLength;

    /**
     * @return The maximum netmask length that will be required for CIDR allocations in this pool.
     * 
     */
    public Optional<Output<Integer>> allocationMaxNetmaskLength() {
        return Optional.ofNullable(this.allocationMaxNetmaskLength);
    }

    /**
     * The minimum netmask length that will be required for CIDR allocations in this pool.
     * 
     */
    @Import(name="allocationMinNetmaskLength")
    private @Nullable Output<Integer> allocationMinNetmaskLength;

    /**
     * @return The minimum netmask length that will be required for CIDR allocations in this pool.
     * 
     */
    public Optional<Output<Integer>> allocationMinNetmaskLength() {
        return Optional.ofNullable(this.allocationMinNetmaskLength);
    }

    /**
     * Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
     * 
     */
    @Import(name="allocationResourceTags")
    private @Nullable Output<Map<String,String>> allocationResourceTags;

    /**
     * @return Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
     * 
     */
    public Optional<Output<Map<String,String>>> allocationResourceTags() {
        return Optional.ofNullable(this.allocationResourceTags);
    }

    /**
     * If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
     * within the CIDR range in the pool.
     * 
     */
    @Import(name="autoImport")
    private @Nullable Output<Boolean> autoImport;

    /**
     * @return If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
     * within the CIDR range in the pool.
     * 
     */
    public Optional<Output<Boolean>> autoImport() {
        return Optional.ofNullable(this.autoImport);
    }

    /**
     * Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
     * 
     */
    @Import(name="awsService")
    private @Nullable Output<String> awsService;

    /**
     * @return Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
     * 
     */
    public Optional<Output<String>> awsService() {
        return Optional.ofNullable(this.awsService);
    }

    /**
     * A description for the IPAM pool.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A description for the IPAM pool.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The ID of the scope in which you would like to create the IPAM pool.
     * 
     */
    @Import(name="ipamScopeId", required=true)
    private Output<String> ipamScopeId;

    /**
     * @return The ID of the scope in which you would like to create the IPAM pool.
     * 
     */
    public Output<String> ipamScopeId() {
        return this.ipamScopeId;
    }

    /**
     * The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC&#39;s Region. Possible values: Any AWS region, such as `us-east-1`.
     * 
     */
    @Import(name="locale")
    private @Nullable Output<String> locale;

    /**
     * @return The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC&#39;s Region. Possible values: Any AWS region, such as `us-east-1`.
     * 
     */
    public Optional<Output<String>> locale() {
        return Optional.ofNullable(this.locale);
    }

    /**
     * The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
     * 
     */
    @Import(name="publicIpSource")
    private @Nullable Output<String> publicIpSource;

    /**
     * @return The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
     * 
     */
    public Optional<Output<String>> publicIpSource() {
        return Optional.ofNullable(this.publicIpSource);
    }

    /**
     * Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = &#34;ipv6&#34;` and `public_ip_source = &#34;byoip&#34;`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = &#34;amazon&#34;`.
     * 
     */
    @Import(name="publiclyAdvertisable")
    private @Nullable Output<Boolean> publiclyAdvertisable;

    /**
     * @return Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = &#34;ipv6&#34;` and `public_ip_source = &#34;byoip&#34;`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = &#34;amazon&#34;`.
     * 
     */
    public Optional<Output<Boolean>> publiclyAdvertisable() {
        return Optional.ofNullable(this.publiclyAdvertisable);
    }

    /**
     * The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
     * 
     */
    @Import(name="sourceIpamPoolId")
    private @Nullable Output<String> sourceIpamPoolId;

    /**
     * @return The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
     * 
     */
    public Optional<Output<String>> sourceIpamPoolId() {
        return Optional.ofNullable(this.sourceIpamPoolId);
    }

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private VpcIpamPoolArgs() {}

    private VpcIpamPoolArgs(VpcIpamPoolArgs $) {
        this.addressFamily = $.addressFamily;
        this.allocationDefaultNetmaskLength = $.allocationDefaultNetmaskLength;
        this.allocationMaxNetmaskLength = $.allocationMaxNetmaskLength;
        this.allocationMinNetmaskLength = $.allocationMinNetmaskLength;
        this.allocationResourceTags = $.allocationResourceTags;
        this.autoImport = $.autoImport;
        this.awsService = $.awsService;
        this.description = $.description;
        this.ipamScopeId = $.ipamScopeId;
        this.locale = $.locale;
        this.publicIpSource = $.publicIpSource;
        this.publiclyAdvertisable = $.publiclyAdvertisable;
        this.sourceIpamPoolId = $.sourceIpamPoolId;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VpcIpamPoolArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VpcIpamPoolArgs $;

        public Builder() {
            $ = new VpcIpamPoolArgs();
        }

        public Builder(VpcIpamPoolArgs defaults) {
            $ = new VpcIpamPoolArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param addressFamily The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
         * 
         * @return builder
         * 
         */
        public Builder addressFamily(Output<String> addressFamily) {
            $.addressFamily = addressFamily;
            return this;
        }

        /**
         * @param addressFamily The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
         * 
         * @return builder
         * 
         */
        public Builder addressFamily(String addressFamily) {
            return addressFamily(Output.of(addressFamily));
        }

        /**
         * @param allocationDefaultNetmaskLength A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
         * 
         * @return builder
         * 
         */
        public Builder allocationDefaultNetmaskLength(@Nullable Output<Integer> allocationDefaultNetmaskLength) {
            $.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
            return this;
        }

        /**
         * @param allocationDefaultNetmaskLength A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
         * 
         * @return builder
         * 
         */
        public Builder allocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            return allocationDefaultNetmaskLength(Output.of(allocationDefaultNetmaskLength));
        }

        /**
         * @param allocationMaxNetmaskLength The maximum netmask length that will be required for CIDR allocations in this pool.
         * 
         * @return builder
         * 
         */
        public Builder allocationMaxNetmaskLength(@Nullable Output<Integer> allocationMaxNetmaskLength) {
            $.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
            return this;
        }

        /**
         * @param allocationMaxNetmaskLength The maximum netmask length that will be required for CIDR allocations in this pool.
         * 
         * @return builder
         * 
         */
        public Builder allocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            return allocationMaxNetmaskLength(Output.of(allocationMaxNetmaskLength));
        }

        /**
         * @param allocationMinNetmaskLength The minimum netmask length that will be required for CIDR allocations in this pool.
         * 
         * @return builder
         * 
         */
        public Builder allocationMinNetmaskLength(@Nullable Output<Integer> allocationMinNetmaskLength) {
            $.allocationMinNetmaskLength = allocationMinNetmaskLength;
            return this;
        }

        /**
         * @param allocationMinNetmaskLength The minimum netmask length that will be required for CIDR allocations in this pool.
         * 
         * @return builder
         * 
         */
        public Builder allocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            return allocationMinNetmaskLength(Output.of(allocationMinNetmaskLength));
        }

        /**
         * @param allocationResourceTags Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
         * 
         * @return builder
         * 
         */
        public Builder allocationResourceTags(@Nullable Output<Map<String,String>> allocationResourceTags) {
            $.allocationResourceTags = allocationResourceTags;
            return this;
        }

        /**
         * @param allocationResourceTags Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
         * 
         * @return builder
         * 
         */
        public Builder allocationResourceTags(Map<String,String> allocationResourceTags) {
            return allocationResourceTags(Output.of(allocationResourceTags));
        }

        /**
         * @param autoImport If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
         * within the CIDR range in the pool.
         * 
         * @return builder
         * 
         */
        public Builder autoImport(@Nullable Output<Boolean> autoImport) {
            $.autoImport = autoImport;
            return this;
        }

        /**
         * @param autoImport If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
         * within the CIDR range in the pool.
         * 
         * @return builder
         * 
         */
        public Builder autoImport(Boolean autoImport) {
            return autoImport(Output.of(autoImport));
        }

        /**
         * @param awsService Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
         * 
         * @return builder
         * 
         */
        public Builder awsService(@Nullable Output<String> awsService) {
            $.awsService = awsService;
            return this;
        }

        /**
         * @param awsService Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
         * 
         * @return builder
         * 
         */
        public Builder awsService(String awsService) {
            return awsService(Output.of(awsService));
        }

        /**
         * @param description A description for the IPAM pool.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description for the IPAM pool.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param ipamScopeId The ID of the scope in which you would like to create the IPAM pool.
         * 
         * @return builder
         * 
         */
        public Builder ipamScopeId(Output<String> ipamScopeId) {
            $.ipamScopeId = ipamScopeId;
            return this;
        }

        /**
         * @param ipamScopeId The ID of the scope in which you would like to create the IPAM pool.
         * 
         * @return builder
         * 
         */
        public Builder ipamScopeId(String ipamScopeId) {
            return ipamScopeId(Output.of(ipamScopeId));
        }

        /**
         * @param locale The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC&#39;s Region. Possible values: Any AWS region, such as `us-east-1`.
         * 
         * @return builder
         * 
         */
        public Builder locale(@Nullable Output<String> locale) {
            $.locale = locale;
            return this;
        }

        /**
         * @param locale The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC&#39;s Region. Possible values: Any AWS region, such as `us-east-1`.
         * 
         * @return builder
         * 
         */
        public Builder locale(String locale) {
            return locale(Output.of(locale));
        }

        /**
         * @param publicIpSource The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
         * 
         * @return builder
         * 
         */
        public Builder publicIpSource(@Nullable Output<String> publicIpSource) {
            $.publicIpSource = publicIpSource;
            return this;
        }

        /**
         * @param publicIpSource The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
         * 
         * @return builder
         * 
         */
        public Builder publicIpSource(String publicIpSource) {
            return publicIpSource(Output.of(publicIpSource));
        }

        /**
         * @param publiclyAdvertisable Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = &#34;ipv6&#34;` and `public_ip_source = &#34;byoip&#34;`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = &#34;amazon&#34;`.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAdvertisable(@Nullable Output<Boolean> publiclyAdvertisable) {
            $.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        /**
         * @param publiclyAdvertisable Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = &#34;ipv6&#34;` and `public_ip_source = &#34;byoip&#34;`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = &#34;amazon&#34;`.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAdvertisable(Boolean publiclyAdvertisable) {
            return publiclyAdvertisable(Output.of(publiclyAdvertisable));
        }

        /**
         * @param sourceIpamPoolId The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
         * 
         * @return builder
         * 
         */
        public Builder sourceIpamPoolId(@Nullable Output<String> sourceIpamPoolId) {
            $.sourceIpamPoolId = sourceIpamPoolId;
            return this;
        }

        /**
         * @param sourceIpamPoolId The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
         * 
         * @return builder
         * 
         */
        public Builder sourceIpamPoolId(String sourceIpamPoolId) {
            return sourceIpamPoolId(Output.of(sourceIpamPoolId));
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public VpcIpamPoolArgs build() {
            $.addressFamily = Objects.requireNonNull($.addressFamily, "expected parameter 'addressFamily' to be non-null");
            $.ipamScopeId = Objects.requireNonNull($.ipamScopeId, "expected parameter 'ipamScopeId' to be non-null");
            return $;
        }
    }

}
