// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.VpcIpamArgs;
import com.pulumi.aws.ec2.inputs.VpcIpamState;
import com.pulumi.aws.ec2.outputs.VpcIpamOperatingRegion;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an IPAM resource.
 * 
 * ## Import
 * 
 * Using `pulumi import`, import IPAMs using the IPAM `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpam:VpcIpam example ipam-0178368ad2146a492
 * ```
 * 
 */
@ResourceType(type="aws:ec2/vpcIpam:VpcIpam")
public class VpcIpam extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of IPAM
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of IPAM
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
     * 
     */
    @Export(name="cascade", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> cascade;

    /**
     * @return Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
     * 
     */
    public Output<Optional<Boolean>> cascade() {
        return Codegen.optional(this.cascade);
    }
    /**
     * The IPAM&#39;s default resource discovery association ID.
     * 
     */
    @Export(name="defaultResourceDiscoveryAssociationId", refs={String.class}, tree="[0]")
    private Output<String> defaultResourceDiscoveryAssociationId;

    /**
     * @return The IPAM&#39;s default resource discovery association ID.
     * 
     */
    public Output<String> defaultResourceDiscoveryAssociationId() {
        return this.defaultResourceDiscoveryAssociationId;
    }
    /**
     * The IPAM&#39;s default resource discovery ID.
     * 
     */
    @Export(name="defaultResourceDiscoveryId", refs={String.class}, tree="[0]")
    private Output<String> defaultResourceDiscoveryId;

    /**
     * @return The IPAM&#39;s default resource discovery ID.
     * 
     */
    public Output<String> defaultResourceDiscoveryId() {
        return this.defaultResourceDiscoveryId;
    }
    /**
     * A description for the IPAM.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A description for the IPAM.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC&#39;s Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     * 
     */
    @Export(name="operatingRegions", refs={List.class,VpcIpamOperatingRegion.class}, tree="[0,1]")
    private Output<List<VpcIpamOperatingRegion>> operatingRegions;

    /**
     * @return Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC&#39;s Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     * 
     */
    public Output<List<VpcIpamOperatingRegion>> operatingRegions() {
        return this.operatingRegions;
    }
    /**
     * The ID of the IPAM&#39;s private scope. A scope is a top-level container in IPAM. Each scope represents an IP-independent network. Scopes enable you to represent networks where you have overlapping IP space. When you create an IPAM, IPAM automatically creates two scopes: public and private. The private scope is intended for private IP space. The public scope is intended for all internet-routable IP space.
     * 
     */
    @Export(name="privateDefaultScopeId", refs={String.class}, tree="[0]")
    private Output<String> privateDefaultScopeId;

    /**
     * @return The ID of the IPAM&#39;s private scope. A scope is a top-level container in IPAM. Each scope represents an IP-independent network. Scopes enable you to represent networks where you have overlapping IP space. When you create an IPAM, IPAM automatically creates two scopes: public and private. The private scope is intended for private IP space. The public scope is intended for all internet-routable IP space.
     * 
     */
    public Output<String> privateDefaultScopeId() {
        return this.privateDefaultScopeId;
    }
    /**
     * The ID of the IPAM&#39;s public scope. A scope is a top-level container in IPAM. Each scope represents an IP-independent network. Scopes enable you to represent networks where you have overlapping IP space. When you create an IPAM, IPAM automatically creates two scopes: public and private. The private scope is intended for private
     * IP space. The public scope is intended for all internet-routable IP space.
     * 
     */
    @Export(name="publicDefaultScopeId", refs={String.class}, tree="[0]")
    private Output<String> publicDefaultScopeId;

    /**
     * @return The ID of the IPAM&#39;s public scope. A scope is a top-level container in IPAM. Each scope represents an IP-independent network. Scopes enable you to represent networks where you have overlapping IP space. When you create an IPAM, IPAM automatically creates two scopes: public and private. The private scope is intended for private
     * IP space. The public scope is intended for all internet-routable IP space.
     * 
     */
    public Output<String> publicDefaultScopeId() {
        return this.publicDefaultScopeId;
    }
    /**
     * The number of scopes in the IPAM.
     * 
     */
    @Export(name="scopeCount", refs={Integer.class}, tree="[0]")
    private Output<Integer> scopeCount;

    /**
     * @return The number of scopes in the IPAM.
     * 
     */
    public Output<Integer> scopeCount() {
        return this.scopeCount;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VpcIpam(String name) {
        this(name, VpcIpamArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VpcIpam(String name, VpcIpamArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VpcIpam(String name, VpcIpamArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpcIpam:VpcIpam", name, args == null ? VpcIpamArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VpcIpam(String name, Output<String> id, @Nullable VpcIpamState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpcIpam:VpcIpam", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VpcIpam get(String name, Output<String> id, @Nullable VpcIpamState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VpcIpam(name, id, state, options);
    }
}
