// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs;
import com.pulumi.aws.ec2.inputs.VpcEndpointSubnetAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a resource to create an association between a VPC endpoint and a subnet.
 * 
 * &gt; **NOTE on VPC Endpoints and VPC Endpoint Subnet Associations:** This provider provides
 * both a standalone VPC Endpoint Subnet Association (an association between a VPC endpoint
 * and a single `subnet_id`) and a VPC Endpoint resource with a `subnet_ids`
 * attribute. Do not use the same subnet ID in both a VPC Endpoint resource and a VPC Endpoint Subnet
 * Association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * 
 * ## Example Usage
 * 
 * Basic usage:
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointSubnetAssociation;
 * import com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var snEc2 = new VpcEndpointSubnetAssociation(&#34;snEc2&#34;, VpcEndpointSubnetAssociationArgs.builder()        
 *             .vpcEndpointId(aws_vpc_endpoint.ec2().id())
 *             .subnetId(aws_subnet.sn().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import VPC Endpoint Subnet Associations using `vpc_endpoint_id` together with `subnet_id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpointSubnetAssociation:VpcEndpointSubnetAssociation example vpce-aaaaaaaa/subnet-bbbbbbbbbbbbbbbbb
 * ```
 * 
 */
@ResourceType(type="aws:ec2/vpcEndpointSubnetAssociation:VpcEndpointSubnetAssociation")
public class VpcEndpointSubnetAssociation extends com.pulumi.resources.CustomResource {
    /**
     * The ID of the subnet to be associated with the VPC endpoint.
     * 
     */
    @Export(name="subnetId", refs={String.class}, tree="[0]")
    private Output<String> subnetId;

    /**
     * @return The ID of the subnet to be associated with the VPC endpoint.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }
    /**
     * The ID of the VPC endpoint with which the subnet will be associated.
     * 
     */
    @Export(name="vpcEndpointId", refs={String.class}, tree="[0]")
    private Output<String> vpcEndpointId;

    /**
     * @return The ID of the VPC endpoint with which the subnet will be associated.
     * 
     */
    public Output<String> vpcEndpointId() {
        return this.vpcEndpointId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VpcEndpointSubnetAssociation(String name) {
        this(name, VpcEndpointSubnetAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VpcEndpointSubnetAssociation(String name, VpcEndpointSubnetAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VpcEndpointSubnetAssociation(String name, VpcEndpointSubnetAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpcEndpointSubnetAssociation:VpcEndpointSubnetAssociation", name, args == null ? VpcEndpointSubnetAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VpcEndpointSubnetAssociation(String name, Output<String> id, @Nullable VpcEndpointSubnetAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/vpcEndpointSubnetAssociation:VpcEndpointSubnetAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VpcEndpointSubnetAssociation get(String name, Output<String> id, @Nullable VpcEndpointSubnetAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VpcEndpointSubnetAssociation(name, id, state, options);
    }
}
