// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgs;
import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleSourcePortRangeArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TrafficMirrorFilterRuleArgs extends com.pulumi.resources.ResourceArgs {

    public static final TrafficMirrorFilterRuleArgs Empty = new TrafficMirrorFilterRuleArgs();

    /**
     * Description of the traffic mirror filter rule.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the traffic mirror filter rule.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Destination CIDR block to assign to the Traffic Mirror rule.
     * 
     */
    @Import(name="destinationCidrBlock", required=true)
    private Output<String> destinationCidrBlock;

    /**
     * @return Destination CIDR block to assign to the Traffic Mirror rule.
     * 
     */
    public Output<String> destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    /**
     * Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     * 
     */
    @Import(name="destinationPortRange")
    private @Nullable Output<TrafficMirrorFilterRuleDestinationPortRangeArgs> destinationPortRange;

    /**
     * @return Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     * 
     */
    public Optional<Output<TrafficMirrorFilterRuleDestinationPortRangeArgs>> destinationPortRange() {
        return Optional.ofNullable(this.destinationPortRange);
    }

    /**
     * Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
     * 
     */
    @Import(name="protocol")
    private @Nullable Output<Integer> protocol;

    /**
     * @return Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
     * 
     */
    public Optional<Output<Integer>> protocol() {
        return Optional.ofNullable(this.protocol);
    }

    /**
     * Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
     * 
     */
    @Import(name="ruleAction", required=true)
    private Output<String> ruleAction;

    /**
     * @return Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
     * 
     */
    public Output<String> ruleAction() {
        return this.ruleAction;
    }

    /**
     * Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
     * 
     */
    @Import(name="ruleNumber", required=true)
    private Output<Integer> ruleNumber;

    /**
     * @return Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
     * 
     */
    public Output<Integer> ruleNumber() {
        return this.ruleNumber;
    }

    /**
     * Source CIDR block to assign to the Traffic Mirror rule.
     * 
     */
    @Import(name="sourceCidrBlock", required=true)
    private Output<String> sourceCidrBlock;

    /**
     * @return Source CIDR block to assign to the Traffic Mirror rule.
     * 
     */
    public Output<String> sourceCidrBlock() {
        return this.sourceCidrBlock;
    }

    /**
     * Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     * 
     */
    @Import(name="sourcePortRange")
    private @Nullable Output<TrafficMirrorFilterRuleSourcePortRangeArgs> sourcePortRange;

    /**
     * @return Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     * 
     */
    public Optional<Output<TrafficMirrorFilterRuleSourcePortRangeArgs>> sourcePortRange() {
        return Optional.ofNullable(this.sourcePortRange);
    }

    /**
     * Direction of traffic to be captured. Valid values are `ingress` and `egress`
     * 
     * Traffic mirror port range support following attributes:
     * 
     */
    @Import(name="trafficDirection", required=true)
    private Output<String> trafficDirection;

    /**
     * @return Direction of traffic to be captured. Valid values are `ingress` and `egress`
     * 
     * Traffic mirror port range support following attributes:
     * 
     */
    public Output<String> trafficDirection() {
        return this.trafficDirection;
    }

    /**
     * ID of the traffic mirror filter to which this rule should be added
     * 
     */
    @Import(name="trafficMirrorFilterId", required=true)
    private Output<String> trafficMirrorFilterId;

    /**
     * @return ID of the traffic mirror filter to which this rule should be added
     * 
     */
    public Output<String> trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    private TrafficMirrorFilterRuleArgs() {}

    private TrafficMirrorFilterRuleArgs(TrafficMirrorFilterRuleArgs $) {
        this.description = $.description;
        this.destinationCidrBlock = $.destinationCidrBlock;
        this.destinationPortRange = $.destinationPortRange;
        this.protocol = $.protocol;
        this.ruleAction = $.ruleAction;
        this.ruleNumber = $.ruleNumber;
        this.sourceCidrBlock = $.sourceCidrBlock;
        this.sourcePortRange = $.sourcePortRange;
        this.trafficDirection = $.trafficDirection;
        this.trafficMirrorFilterId = $.trafficMirrorFilterId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TrafficMirrorFilterRuleArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TrafficMirrorFilterRuleArgs $;

        public Builder() {
            $ = new TrafficMirrorFilterRuleArgs();
        }

        public Builder(TrafficMirrorFilterRuleArgs defaults) {
            $ = new TrafficMirrorFilterRuleArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description Description of the traffic mirror filter rule.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the traffic mirror filter rule.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param destinationCidrBlock Destination CIDR block to assign to the Traffic Mirror rule.
         * 
         * @return builder
         * 
         */
        public Builder destinationCidrBlock(Output<String> destinationCidrBlock) {
            $.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * @param destinationCidrBlock Destination CIDR block to assign to the Traffic Mirror rule.
         * 
         * @return builder
         * 
         */
        public Builder destinationCidrBlock(String destinationCidrBlock) {
            return destinationCidrBlock(Output.of(destinationCidrBlock));
        }

        /**
         * @param destinationPortRange Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
         * 
         * @return builder
         * 
         */
        public Builder destinationPortRange(@Nullable Output<TrafficMirrorFilterRuleDestinationPortRangeArgs> destinationPortRange) {
            $.destinationPortRange = destinationPortRange;
            return this;
        }

        /**
         * @param destinationPortRange Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
         * 
         * @return builder
         * 
         */
        public Builder destinationPortRange(TrafficMirrorFilterRuleDestinationPortRangeArgs destinationPortRange) {
            return destinationPortRange(Output.of(destinationPortRange));
        }

        /**
         * @param protocol Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
         * 
         * @return builder
         * 
         */
        public Builder protocol(@Nullable Output<Integer> protocol) {
            $.protocol = protocol;
            return this;
        }

        /**
         * @param protocol Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
         * 
         * @return builder
         * 
         */
        public Builder protocol(Integer protocol) {
            return protocol(Output.of(protocol));
        }

        /**
         * @param ruleAction Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
         * 
         * @return builder
         * 
         */
        public Builder ruleAction(Output<String> ruleAction) {
            $.ruleAction = ruleAction;
            return this;
        }

        /**
         * @param ruleAction Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
         * 
         * @return builder
         * 
         */
        public Builder ruleAction(String ruleAction) {
            return ruleAction(Output.of(ruleAction));
        }

        /**
         * @param ruleNumber Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
         * 
         * @return builder
         * 
         */
        public Builder ruleNumber(Output<Integer> ruleNumber) {
            $.ruleNumber = ruleNumber;
            return this;
        }

        /**
         * @param ruleNumber Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
         * 
         * @return builder
         * 
         */
        public Builder ruleNumber(Integer ruleNumber) {
            return ruleNumber(Output.of(ruleNumber));
        }

        /**
         * @param sourceCidrBlock Source CIDR block to assign to the Traffic Mirror rule.
         * 
         * @return builder
         * 
         */
        public Builder sourceCidrBlock(Output<String> sourceCidrBlock) {
            $.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        /**
         * @param sourceCidrBlock Source CIDR block to assign to the Traffic Mirror rule.
         * 
         * @return builder
         * 
         */
        public Builder sourceCidrBlock(String sourceCidrBlock) {
            return sourceCidrBlock(Output.of(sourceCidrBlock));
        }

        /**
         * @param sourcePortRange Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
         * 
         * @return builder
         * 
         */
        public Builder sourcePortRange(@Nullable Output<TrafficMirrorFilterRuleSourcePortRangeArgs> sourcePortRange) {
            $.sourcePortRange = sourcePortRange;
            return this;
        }

        /**
         * @param sourcePortRange Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
         * 
         * @return builder
         * 
         */
        public Builder sourcePortRange(TrafficMirrorFilterRuleSourcePortRangeArgs sourcePortRange) {
            return sourcePortRange(Output.of(sourcePortRange));
        }

        /**
         * @param trafficDirection Direction of traffic to be captured. Valid values are `ingress` and `egress`
         * 
         * Traffic mirror port range support following attributes:
         * 
         * @return builder
         * 
         */
        public Builder trafficDirection(Output<String> trafficDirection) {
            $.trafficDirection = trafficDirection;
            return this;
        }

        /**
         * @param trafficDirection Direction of traffic to be captured. Valid values are `ingress` and `egress`
         * 
         * Traffic mirror port range support following attributes:
         * 
         * @return builder
         * 
         */
        public Builder trafficDirection(String trafficDirection) {
            return trafficDirection(Output.of(trafficDirection));
        }

        /**
         * @param trafficMirrorFilterId ID of the traffic mirror filter to which this rule should be added
         * 
         * @return builder
         * 
         */
        public Builder trafficMirrorFilterId(Output<String> trafficMirrorFilterId) {
            $.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        /**
         * @param trafficMirrorFilterId ID of the traffic mirror filter to which this rule should be added
         * 
         * @return builder
         * 
         */
        public Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            return trafficMirrorFilterId(Output.of(trafficMirrorFilterId));
        }

        public TrafficMirrorFilterRuleArgs build() {
            $.destinationCidrBlock = Objects.requireNonNull($.destinationCidrBlock, "expected parameter 'destinationCidrBlock' to be non-null");
            $.ruleAction = Objects.requireNonNull($.ruleAction, "expected parameter 'ruleAction' to be non-null");
            $.ruleNumber = Objects.requireNonNull($.ruleNumber, "expected parameter 'ruleNumber' to be non-null");
            $.sourceCidrBlock = Objects.requireNonNull($.sourceCidrBlock, "expected parameter 'sourceCidrBlock' to be non-null");
            $.trafficDirection = Objects.requireNonNull($.trafficDirection, "expected parameter 'trafficDirection' to be non-null");
            $.trafficMirrorFilterId = Objects.requireNonNull($.trafficMirrorFilterId, "expected parameter 'trafficMirrorFilterId' to be non-null");
            return $;
        }
    }

}
