// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.TrafficMirrorFilterRuleArgs;
import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleState;
import com.pulumi.aws.ec2.outputs.TrafficMirrorFilterRuleDestinationPortRange;
import com.pulumi.aws.ec2.outputs.TrafficMirrorFilterRuleSourcePortRange;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an Traffic mirror filter rule.\
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * 
 * ## Example Usage
 * 
 * To create a basic traffic mirror session
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorFilter;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterArgs;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterRule;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterRuleArgs;
 * import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgs;
 * import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleSourcePortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var filter = new TrafficMirrorFilter(&#34;filter&#34;, TrafficMirrorFilterArgs.builder()        
 *             .description(&#34;traffic mirror filter - example&#34;)
 *             .networkServices(&#34;amazon-dns&#34;)
 *             .build());
 * 
 *         var ruleout = new TrafficMirrorFilterRule(&#34;ruleout&#34;, TrafficMirrorFilterRuleArgs.builder()        
 *             .description(&#34;test rule&#34;)
 *             .trafficMirrorFilterId(filter.id())
 *             .destinationCidrBlock(&#34;10.0.0.0/8&#34;)
 *             .sourceCidrBlock(&#34;10.0.0.0/8&#34;)
 *             .ruleNumber(1)
 *             .ruleAction(&#34;accept&#34;)
 *             .trafficDirection(&#34;egress&#34;)
 *             .build());
 * 
 *         var rulein = new TrafficMirrorFilterRule(&#34;rulein&#34;, TrafficMirrorFilterRuleArgs.builder()        
 *             .description(&#34;test rule&#34;)
 *             .trafficMirrorFilterId(filter.id())
 *             .destinationCidrBlock(&#34;10.0.0.0/8&#34;)
 *             .sourceCidrBlock(&#34;10.0.0.0/8&#34;)
 *             .ruleNumber(1)
 *             .ruleAction(&#34;accept&#34;)
 *             .trafficDirection(&#34;ingress&#34;)
 *             .protocol(6)
 *             .destinationPortRange(TrafficMirrorFilterRuleDestinationPortRangeArgs.builder()
 *                 .fromPort(22)
 *                 .toPort(53)
 *                 .build())
 *             .sourcePortRange(TrafficMirrorFilterRuleSourcePortRangeArgs.builder()
 *                 .fromPort(0)
 *                 .toPort(10)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import traffic mirror rules using the `traffic_mirror_filter_id` and `id` separated by `:`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule rule tmf-0fbb93ddf38198f64:tmfr-05a458f06445d0aee
 * ```
 * 
 */
@ResourceType(type="aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule")
public class TrafficMirrorFilterRule extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the traffic mirror filter rule.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the traffic mirror filter rule.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Description of the traffic mirror filter rule.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description of the traffic mirror filter rule.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Destination CIDR block to assign to the Traffic Mirror rule.
     * 
     */
    @Export(name="destinationCidrBlock", refs={String.class}, tree="[0]")
    private Output<String> destinationCidrBlock;

    /**
     * @return Destination CIDR block to assign to the Traffic Mirror rule.
     * 
     */
    public Output<String> destinationCidrBlock() {
        return this.destinationCidrBlock;
    }
    /**
     * Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     * 
     */
    @Export(name="destinationPortRange", refs={TrafficMirrorFilterRuleDestinationPortRange.class}, tree="[0]")
    private Output</* @Nullable */ TrafficMirrorFilterRuleDestinationPortRange> destinationPortRange;

    /**
     * @return Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     * 
     */
    public Output<Optional<TrafficMirrorFilterRuleDestinationPortRange>> destinationPortRange() {
        return Codegen.optional(this.destinationPortRange);
    }
    /**
     * Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
     * 
     */
    @Export(name="protocol", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> protocol;

    /**
     * @return Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
     * 
     */
    public Output<Optional<Integer>> protocol() {
        return Codegen.optional(this.protocol);
    }
    /**
     * Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
     * 
     */
    @Export(name="ruleAction", refs={String.class}, tree="[0]")
    private Output<String> ruleAction;

    /**
     * @return Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
     * 
     */
    public Output<String> ruleAction() {
        return this.ruleAction;
    }
    /**
     * Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
     * 
     */
    @Export(name="ruleNumber", refs={Integer.class}, tree="[0]")
    private Output<Integer> ruleNumber;

    /**
     * @return Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
     * 
     */
    public Output<Integer> ruleNumber() {
        return this.ruleNumber;
    }
    /**
     * Source CIDR block to assign to the Traffic Mirror rule.
     * 
     */
    @Export(name="sourceCidrBlock", refs={String.class}, tree="[0]")
    private Output<String> sourceCidrBlock;

    /**
     * @return Source CIDR block to assign to the Traffic Mirror rule.
     * 
     */
    public Output<String> sourceCidrBlock() {
        return this.sourceCidrBlock;
    }
    /**
     * Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     * 
     */
    @Export(name="sourcePortRange", refs={TrafficMirrorFilterRuleSourcePortRange.class}, tree="[0]")
    private Output</* @Nullable */ TrafficMirrorFilterRuleSourcePortRange> sourcePortRange;

    /**
     * @return Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     * 
     */
    public Output<Optional<TrafficMirrorFilterRuleSourcePortRange>> sourcePortRange() {
        return Codegen.optional(this.sourcePortRange);
    }
    /**
     * Direction of traffic to be captured. Valid values are `ingress` and `egress`
     * 
     * Traffic mirror port range support following attributes:
     * 
     */
    @Export(name="trafficDirection", refs={String.class}, tree="[0]")
    private Output<String> trafficDirection;

    /**
     * @return Direction of traffic to be captured. Valid values are `ingress` and `egress`
     * 
     * Traffic mirror port range support following attributes:
     * 
     */
    public Output<String> trafficDirection() {
        return this.trafficDirection;
    }
    /**
     * ID of the traffic mirror filter to which this rule should be added
     * 
     */
    @Export(name="trafficMirrorFilterId", refs={String.class}, tree="[0]")
    private Output<String> trafficMirrorFilterId;

    /**
     * @return ID of the traffic mirror filter to which this rule should be added
     * 
     */
    public Output<String> trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public TrafficMirrorFilterRule(String name) {
        this(name, TrafficMirrorFilterRuleArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public TrafficMirrorFilterRule(String name, TrafficMirrorFilterRuleArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public TrafficMirrorFilterRule(String name, TrafficMirrorFilterRuleArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule", name, args == null ? TrafficMirrorFilterRuleArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private TrafficMirrorFilterRule(String name, Output<String> id, @Nullable TrafficMirrorFilterRuleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static TrafficMirrorFilterRule get(String name, Output<String> id, @Nullable TrafficMirrorFilterRuleState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new TrafficMirrorFilterRule(name, id, state, options);
    }
}
