// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.SpotInstanceRequestArgs;
import com.pulumi.aws.ec2.inputs.SpotInstanceRequestState;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestCapacityReservationSpecification;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestCpuOptions;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestCreditSpecification;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestEbsBlockDevice;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestEnclaveOptions;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestEphemeralBlockDevice;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestLaunchTemplate;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestMaintenanceOptions;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestMetadataOptions;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestNetworkInterface;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestPrivateDnsNameOptions;
import com.pulumi.aws.ec2.outputs.SpotInstanceRequestRootBlockDevice;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an EC2 Spot Instance Request resource. This allows instances to be
 * requested on the spot market.
 * 
 * By default this provider creates Spot Instance Requests with a `persistent` type,
 * which means that for the duration of their lifetime, AWS will launch an
 * instance with the configured details if and when the spot market will accept
 * the requested price.
 * 
 * On destruction, this provider will make an attempt to terminate the associated Spot
 * Instance if there is one present.
 * 
 * Spot Instances requests with a `one-time` type will close the spot request
 * when the instance is terminated either by the request being below the current spot
 * price availability or by a user.
 * 
 * &gt; **NOTE:** Because their behavior depends on the live status of the spot
 * market, Spot Instance Requests have a unique lifecycle that makes them behave
 * differently than other resources. Most importantly: there is __no
 * guarantee__ that a Spot Instance exists to fulfill the request at any given
 * point in time. See the [AWS Spot Instance
 * documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html)
 * for more information.
 * 
 * &gt; **NOTE [AWS strongly discourages](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-best-practices.html#which-spot-request-method-to-use) the use of the legacy APIs called by this resource.
 * We recommend using the EC2 Instance resource with `instance_market_options` instead.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SpotInstanceRequest;
 * import com.pulumi.aws.ec2.SpotInstanceRequestArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var cheapWorker = new SpotInstanceRequest(&#34;cheapWorker&#34;, SpotInstanceRequestArgs.builder()        
 *             .ami(&#34;ami-1234&#34;)
 *             .instanceType(&#34;c4.xlarge&#34;)
 *             .spotPrice(&#34;0.03&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;CheapWorker&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:ec2/spotInstanceRequest:SpotInstanceRequest")
public class SpotInstanceRequest extends com.pulumi.resources.CustomResource {
    /**
     * AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     * 
     */
    @Export(name="ami", refs={String.class}, tree="[0]")
    private Output<String> ami;

    /**
     * @return AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     * 
     */
    public Output<String> ami() {
        return this.ami;
    }
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Whether to associate a public IP address with an instance in a VPC.
     * 
     */
    @Export(name="associatePublicIpAddress", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> associatePublicIpAddress;

    /**
     * @return Whether to associate a public IP address with an instance in a VPC.
     * 
     */
    public Output<Boolean> associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }
    /**
     * AZ to start the instance in.
     * 
     */
    @Export(name="availabilityZone", refs={String.class}, tree="[0]")
    private Output<String> availabilityZone;

    /**
     * @return AZ to start the instance in.
     * 
     */
    public Output<String> availabilityZone() {
        return this.availabilityZone;
    }
    /**
     * The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
     * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
     * Note that you can&#39;t specify an Availability Zone group or a launch group if you specify a duration.
     * 
     */
    @Export(name="blockDurationMinutes", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> blockDurationMinutes;

    /**
     * @return The required duration for the Spot instances, in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).
     * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which gives the instance a two-minute warning before it terminates.
     * Note that you can&#39;t specify an Availability Zone group or a launch group if you specify a duration.
     * 
     */
    public Output<Optional<Integer>> blockDurationMinutes() {
        return Codegen.optional(this.blockDurationMinutes);
    }
    /**
     * Describes an instance&#39;s Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * 
     * &gt; **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     * 
     */
    @Export(name="capacityReservationSpecification", refs={SpotInstanceRequestCapacityReservationSpecification.class}, tree="[0]")
    private Output<SpotInstanceRequestCapacityReservationSpecification> capacityReservationSpecification;

    /**
     * @return Describes an instance&#39;s Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * 
     * &gt; **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     * 
     */
    public Output<SpotInstanceRequestCapacityReservationSpecification> capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }
    /**
     * Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     * 
     * @deprecated
     * use &#39;cpu_options&#39; argument instead
     * 
     */
    @Deprecated /* use 'cpu_options' argument instead */
    @Export(name="cpuCoreCount", refs={Integer.class}, tree="[0]")
    private Output<Integer> cpuCoreCount;

    /**
     * @return Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     * 
     */
    public Output<Integer> cpuCoreCount() {
        return this.cpuCoreCount;
    }
    /**
     * The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    @Export(name="cpuOptions", refs={SpotInstanceRequestCpuOptions.class}, tree="[0]")
    private Output<SpotInstanceRequestCpuOptions> cpuOptions;

    /**
     * @return The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    public Output<SpotInstanceRequestCpuOptions> cpuOptions() {
        return this.cpuOptions;
    }
    /**
     * If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     * 
     * @deprecated
     * use &#39;cpu_options&#39; argument instead
     * 
     */
    @Deprecated /* use 'cpu_options' argument instead */
    @Export(name="cpuThreadsPerCore", refs={Integer.class}, tree="[0]")
    private Output<Integer> cpuThreadsPerCore;

    /**
     * @return If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     * 
     */
    public Output<Integer> cpuThreadsPerCore() {
        return this.cpuThreadsPerCore;
    }
    /**
     * Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     * 
     */
    @Export(name="creditSpecification", refs={SpotInstanceRequestCreditSpecification.class}, tree="[0]")
    private Output</* @Nullable */ SpotInstanceRequestCreditSpecification> creditSpecification;

    /**
     * @return Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     * 
     */
    public Output<Optional<SpotInstanceRequestCreditSpecification>> creditSpecification() {
        return Codegen.optional(this.creditSpecification);
    }
    /**
     * If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    @Export(name="disableApiStop", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> disableApiStop;

    /**
     * @return If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    public Output<Boolean> disableApiStop() {
        return this.disableApiStop;
    }
    /**
     * If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     * 
     */
    @Export(name="disableApiTermination", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> disableApiTermination;

    /**
     * @return If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     * 
     */
    public Output<Boolean> disableApiTermination() {
        return this.disableApiTermination;
    }
    /**
     * One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    @Export(name="ebsBlockDevices", refs={List.class,SpotInstanceRequestEbsBlockDevice.class}, tree="[0,1]")
    private Output<List<SpotInstanceRequestEbsBlockDevice>> ebsBlockDevices;

    /**
     * @return One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    public Output<List<SpotInstanceRequestEbsBlockDevice>> ebsBlockDevices() {
        return this.ebsBlockDevices;
    }
    /**
     * If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     * 
     */
    @Export(name="ebsOptimized", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> ebsOptimized;

    /**
     * @return If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     * 
     */
    public Output<Boolean> ebsOptimized() {
        return this.ebsOptimized;
    }
    /**
     * Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    @Export(name="enclaveOptions", refs={SpotInstanceRequestEnclaveOptions.class}, tree="[0]")
    private Output<SpotInstanceRequestEnclaveOptions> enclaveOptions;

    /**
     * @return Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    public Output<SpotInstanceRequestEnclaveOptions> enclaveOptions() {
        return this.enclaveOptions;
    }
    /**
     * One or more configuration blocks to customize Ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    @Export(name="ephemeralBlockDevices", refs={List.class,SpotInstanceRequestEphemeralBlockDevice.class}, tree="[0,1]")
    private Output<List<SpotInstanceRequestEphemeralBlockDevice>> ephemeralBlockDevices;

    /**
     * @return One or more configuration blocks to customize Ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    public Output<List<SpotInstanceRequestEphemeralBlockDevice>> ephemeralBlockDevices() {
        return this.ephemeralBlockDevices;
    }
    /**
     * If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    @Export(name="getPasswordData", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> getPasswordData;

    /**
     * @return If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    public Output<Optional<Boolean>> getPasswordData() {
        return Codegen.optional(this.getPasswordData);
    }
    /**
     * If true, the launched EC2 instance will support hibernation.
     * 
     */
    @Export(name="hibernation", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> hibernation;

    /**
     * @return If true, the launched EC2 instance will support hibernation.
     * 
     */
    public Output<Optional<Boolean>> hibernation() {
        return Codegen.optional(this.hibernation);
    }
    /**
     * ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     * 
     */
    @Export(name="hostId", refs={String.class}, tree="[0]")
    private Output<String> hostId;

    /**
     * @return ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     * 
     */
    public Output<String> hostId() {
        return this.hostId;
    }
    /**
     * ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     * 
     */
    @Export(name="hostResourceGroupArn", refs={String.class}, tree="[0]")
    private Output<String> hostResourceGroupArn;

    /**
     * @return ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     * 
     */
    public Output<String> hostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }
    /**
     * IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     * 
     */
    @Export(name="iamInstanceProfile", refs={String.class}, tree="[0]")
    private Output<String> iamInstanceProfile;

    /**
     * @return IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     * 
     */
    public Output<String> iamInstanceProfile() {
        return this.iamInstanceProfile;
    }
    /**
     * Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     * 
     */
    @Export(name="instanceInitiatedShutdownBehavior", refs={String.class}, tree="[0]")
    private Output<String> instanceInitiatedShutdownBehavior;

    /**
     * @return Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     * 
     */
    public Output<String> instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }
    /**
     * The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
     * 
     */
    @Export(name="instanceInterruptionBehavior", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> instanceInterruptionBehavior;

    /**
     * @return The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
     * 
     */
    public Output<Optional<String>> instanceInterruptionBehavior() {
        return Codegen.optional(this.instanceInterruptionBehavior);
    }
    @Export(name="instanceState", refs={String.class}, tree="[0]")
    private Output<String> instanceState;

    public Output<String> instanceState() {
        return this.instanceState;
    }
    /**
     * Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     * 
     */
    @Export(name="instanceType", refs={String.class}, tree="[0]")
    private Output<String> instanceType;

    /**
     * @return Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     * 
     */
    public Output<String> instanceType() {
        return this.instanceType;
    }
    /**
     * Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     * 
     */
    @Export(name="ipv6AddressCount", refs={Integer.class}, tree="[0]")
    private Output<Integer> ipv6AddressCount;

    /**
     * @return Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     * 
     */
    public Output<Integer> ipv6AddressCount() {
        return this.ipv6AddressCount;
    }
    /**
     * Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     * 
     */
    @Export(name="ipv6Addresses", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> ipv6Addresses;

    /**
     * @return Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     * 
     */
    public Output<List<String>> ipv6Addresses() {
        return this.ipv6Addresses;
    }
    /**
     * Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     * 
     */
    @Export(name="keyName", refs={String.class}, tree="[0]")
    private Output<String> keyName;

    /**
     * @return Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     * 
     */
    public Output<String> keyName() {
        return this.keyName;
    }
    /**
     * A launch group is a group of spot instances that launch together and terminate together.
     * If left empty instances are launched and terminated individually.
     * 
     */
    @Export(name="launchGroup", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> launchGroup;

    /**
     * @return A launch group is a group of spot instances that launch together and terminate together.
     * If left empty instances are launched and terminated individually.
     * 
     */
    public Output<Optional<String>> launchGroup() {
        return Codegen.optional(this.launchGroup);
    }
    /**
     * Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     * 
     */
    @Export(name="launchTemplate", refs={SpotInstanceRequestLaunchTemplate.class}, tree="[0]")
    private Output</* @Nullable */ SpotInstanceRequestLaunchTemplate> launchTemplate;

    /**
     * @return Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     * 
     */
    public Output<Optional<SpotInstanceRequestLaunchTemplate>> launchTemplate() {
        return Codegen.optional(this.launchTemplate);
    }
    /**
     * Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     * 
     */
    @Export(name="maintenanceOptions", refs={SpotInstanceRequestMaintenanceOptions.class}, tree="[0]")
    private Output<SpotInstanceRequestMaintenanceOptions> maintenanceOptions;

    /**
     * @return Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     * 
     */
    public Output<SpotInstanceRequestMaintenanceOptions> maintenanceOptions() {
        return this.maintenanceOptions;
    }
    /**
     * Customize the metadata options of the instance. See Metadata Options below for more details.
     * 
     */
    @Export(name="metadataOptions", refs={SpotInstanceRequestMetadataOptions.class}, tree="[0]")
    private Output<SpotInstanceRequestMetadataOptions> metadataOptions;

    /**
     * @return Customize the metadata options of the instance. See Metadata Options below for more details.
     * 
     */
    public Output<SpotInstanceRequestMetadataOptions> metadataOptions() {
        return this.metadataOptions;
    }
    /**
     * If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     * 
     */
    @Export(name="monitoring", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> monitoring;

    /**
     * @return If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     * 
     */
    public Output<Boolean> monitoring() {
        return this.monitoring;
    }
    /**
     * Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     * 
     */
    @Export(name="networkInterfaces", refs={List.class,SpotInstanceRequestNetworkInterface.class}, tree="[0,1]")
    private Output<List<SpotInstanceRequestNetworkInterface>> networkInterfaces;

    /**
     * @return Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     * 
     */
    public Output<List<SpotInstanceRequestNetworkInterface>> networkInterfaces() {
        return this.networkInterfaces;
    }
    @Export(name="outpostArn", refs={String.class}, tree="[0]")
    private Output<String> outpostArn;

    public Output<String> outpostArn() {
        return this.outpostArn;
    }
    @Export(name="passwordData", refs={String.class}, tree="[0]")
    private Output<String> passwordData;

    public Output<String> passwordData() {
        return this.passwordData;
    }
    /**
     * Placement Group to start the instance in.
     * 
     */
    @Export(name="placementGroup", refs={String.class}, tree="[0]")
    private Output<String> placementGroup;

    /**
     * @return Placement Group to start the instance in.
     * 
     */
    public Output<String> placementGroup() {
        return this.placementGroup;
    }
    /**
     * Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource&#39;s `strategy` argument is set to `&#34;partition&#34;`.
     * 
     */
    @Export(name="placementPartitionNumber", refs={Integer.class}, tree="[0]")
    private Output<Integer> placementPartitionNumber;

    /**
     * @return Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource&#39;s `strategy` argument is set to `&#34;partition&#34;`.
     * 
     */
    public Output<Integer> placementPartitionNumber() {
        return this.placementPartitionNumber;
    }
    @Export(name="primaryNetworkInterfaceId", refs={String.class}, tree="[0]")
    private Output<String> primaryNetworkInterfaceId;

    public Output<String> primaryNetworkInterfaceId() {
        return this.primaryNetworkInterfaceId;
    }
    /**
     * The private DNS name assigned to the instance. Can only be
     * used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames
     * for your VPC
     * 
     */
    @Export(name="privateDns", refs={String.class}, tree="[0]")
    private Output<String> privateDns;

    /**
     * @return The private DNS name assigned to the instance. Can only be
     * used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames
     * for your VPC
     * 
     */
    public Output<String> privateDns() {
        return this.privateDns;
    }
    /**
     * Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    @Export(name="privateDnsNameOptions", refs={SpotInstanceRequestPrivateDnsNameOptions.class}, tree="[0]")
    private Output<SpotInstanceRequestPrivateDnsNameOptions> privateDnsNameOptions;

    /**
     * @return Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    public Output<SpotInstanceRequestPrivateDnsNameOptions> privateDnsNameOptions() {
        return this.privateDnsNameOptions;
    }
    /**
     * Private IP address to associate with the instance in a VPC.
     * 
     */
    @Export(name="privateIp", refs={String.class}, tree="[0]")
    private Output<String> privateIp;

    /**
     * @return Private IP address to associate with the instance in a VPC.
     * 
     */
    public Output<String> privateIp() {
        return this.privateIp;
    }
    /**
     * The public DNS name assigned to the instance. For EC2-VPC, this
     * is only available if you&#39;ve enabled DNS hostnames for your VPC
     * 
     */
    @Export(name="publicDns", refs={String.class}, tree="[0]")
    private Output<String> publicDns;

    /**
     * @return The public DNS name assigned to the instance. For EC2-VPC, this
     * is only available if you&#39;ve enabled DNS hostnames for your VPC
     * 
     */
    public Output<String> publicDns() {
        return this.publicDns;
    }
    /**
     * The public IP address assigned to the instance, if applicable.
     * 
     */
    @Export(name="publicIp", refs={String.class}, tree="[0]")
    private Output<String> publicIp;

    /**
     * @return The public IP address assigned to the instance, if applicable.
     * 
     */
    public Output<String> publicIp() {
        return this.publicIp;
    }
    /**
     * Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     * 
     */
    @Export(name="rootBlockDevice", refs={SpotInstanceRequestRootBlockDevice.class}, tree="[0]")
    private Output<SpotInstanceRequestRootBlockDevice> rootBlockDevice;

    /**
     * @return Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     * 
     */
    public Output<SpotInstanceRequestRootBlockDevice> rootBlockDevice() {
        return this.rootBlockDevice;
    }
    /**
     * List of secondary private IPv4 addresses to assign to the instance&#39;s primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     * 
     */
    @Export(name="secondaryPrivateIps", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> secondaryPrivateIps;

    /**
     * @return List of secondary private IPv4 addresses to assign to the instance&#39;s primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     * 
     */
    public Output<List<String>> secondaryPrivateIps() {
        return this.secondaryPrivateIps;
    }
    /**
     * List of security group names to associate with.
     * 
     * &gt; **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     * 
     */
    @Export(name="securityGroups", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> securityGroups;

    /**
     * @return List of security group names to associate with.
     * 
     * &gt; **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     * 
     */
    public Output<List<String>> securityGroups() {
        return this.securityGroups;
    }
    /**
     * Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     * 
     */
    @Export(name="sourceDestCheck", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> sourceDestCheck;

    /**
     * @return Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     * 
     */
    public Output<Optional<Boolean>> sourceDestCheck() {
        return Codegen.optional(this.sourceDestCheck);
    }
    /**
     * The current [bid
     * status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
     * of the Spot Instance Request.
     * 
     */
    @Export(name="spotBidStatus", refs={String.class}, tree="[0]")
    private Output<String> spotBidStatus;

    /**
     * @return The current [bid
     * status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
     * of the Spot Instance Request.
     * 
     */
    public Output<String> spotBidStatus() {
        return this.spotBidStatus;
    }
    /**
     * The Instance ID (if any) that is currently fulfilling
     * the Spot Instance request.
     * 
     */
    @Export(name="spotInstanceId", refs={String.class}, tree="[0]")
    private Output<String> spotInstanceId;

    /**
     * @return The Instance ID (if any) that is currently fulfilling
     * the Spot Instance request.
     * 
     */
    public Output<String> spotInstanceId() {
        return this.spotInstanceId;
    }
    /**
     * The maximum price to request on the spot market.
     * 
     */
    @Export(name="spotPrice", refs={String.class}, tree="[0]")
    private Output<String> spotPrice;

    /**
     * @return The maximum price to request on the spot market.
     * 
     */
    public Output<String> spotPrice() {
        return this.spotPrice;
    }
    /**
     * The current [request
     * state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
     * of the Spot Instance Request.
     * 
     */
    @Export(name="spotRequestState", refs={String.class}, tree="[0]")
    private Output<String> spotRequestState;

    /**
     * @return The current [request
     * state](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html#creating-spot-request-status)
     * of the Spot Instance Request.
     * 
     */
    public Output<String> spotRequestState() {
        return this.spotRequestState;
    }
    /**
     * If set to `one-time`, after
     * the instance is terminated, the spot request will be closed.
     * 
     */
    @Export(name="spotType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> spotType;

    /**
     * @return If set to `one-time`, after
     * the instance is terminated, the spot request will be closed.
     * 
     */
    public Output<Optional<String>> spotType() {
        return Codegen.optional(this.spotType);
    }
    /**
     * VPC Subnet ID to launch in.
     * 
     */
    @Export(name="subnetId", refs={String.class}, tree="[0]")
    private Output<String> subnetId;

    /**
     * @return VPC Subnet ID to launch in.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }
    /**
     * Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     * 
     */
    @Export(name="tenancy", refs={String.class}, tree="[0]")
    private Output<String> tenancy;

    /**
     * @return Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     * 
     */
    public Output<String> tenancy() {
        return this.tenancy;
    }
    /**
     * User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    @Export(name="userData", refs={String.class}, tree="[0]")
    private Output<String> userData;

    /**
     * @return User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    public Output<String> userData() {
        return this.userData;
    }
    /**
     * Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    @Export(name="userDataBase64", refs={String.class}, tree="[0]")
    private Output<String> userDataBase64;

    /**
     * @return Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    public Output<String> userDataBase64() {
        return this.userDataBase64;
    }
    /**
     * When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     * 
     */
    @Export(name="userDataReplaceOnChange", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> userDataReplaceOnChange;

    /**
     * @return When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     * 
     */
    public Output<Optional<Boolean>> userDataReplaceOnChange() {
        return Codegen.optional(this.userDataReplaceOnChange);
    }
    /**
     * The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     * 
     */
    @Export(name="validFrom", refs={String.class}, tree="[0]")
    private Output<String> validFrom;

    /**
     * @return The start date and time of the request, in UTC [RFC3339](https://tools.ietf.org/html/rfc3339#section-5.8) format(for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     * 
     */
    public Output<String> validFrom() {
        return this.validFrom;
    }
    /**
     * The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
     * 
     */
    @Export(name="validUntil", refs={String.class}, tree="[0]")
    private Output<String> validUntil;

    /**
     * @return The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
     * 
     */
    public Output<String> validUntil() {
        return this.validUntil;
    }
    /**
     * Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * 
     * &gt; **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     * 
     */
    @Export(name="volumeTags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> volumeTags;

    /**
     * @return Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * 
     * &gt; **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     * 
     */
    public Output<Optional<Map<String,String>>> volumeTags() {
        return Codegen.optional(this.volumeTags);
    }
    /**
     * List of security group IDs to associate with.
     * 
     */
    @Export(name="vpcSecurityGroupIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return List of security group IDs to associate with.
     * 
     */
    public Output<List<String>> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }
    /**
     * If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     * 
     */
    @Export(name="waitForFulfillment", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> waitForFulfillment;

    /**
     * @return If set, this provider will
     * wait for the Spot Request to be fulfilled, and will throw an error if the
     * timeout of 10m is reached.
     * 
     */
    public Output<Optional<Boolean>> waitForFulfillment() {
        return Codegen.optional(this.waitForFulfillment);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SpotInstanceRequest(String name) {
        this(name, SpotInstanceRequestArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SpotInstanceRequest(String name, @Nullable SpotInstanceRequestArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SpotInstanceRequest(String name, @Nullable SpotInstanceRequestArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/spotInstanceRequest:SpotInstanceRequest", name, args == null ? SpotInstanceRequestArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SpotInstanceRequest(String name, Output<String> id, @Nullable SpotInstanceRequestState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/spotInstanceRequest:SpotInstanceRequest", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SpotInstanceRequest get(String name, Output<String> id, @Nullable SpotInstanceRequestState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SpotInstanceRequest(name, id, state, options);
    }
}
