// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.SerialConsoleAccessArgs;
import com.pulumi.aws.ec2.inputs.SerialConsoleAccessState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage whether serial console access is enabled for your AWS account in the current AWS region.
 * 
 * &gt; **NOTE:** Removing this resource disables serial console access.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SerialConsoleAccess;
 * import com.pulumi.aws.ec2.SerialConsoleAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new SerialConsoleAccess(&#34;example&#34;, SerialConsoleAccessArgs.builder()        
 *             .enabled(true)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import serial console access state. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/serialConsoleAccess:SerialConsoleAccess example default
 * ```
 * 
 */
@ResourceType(type="aws:ec2/serialConsoleAccess:SerialConsoleAccess")
public class SerialConsoleAccess extends com.pulumi.resources.CustomResource {
    /**
     * Whether or not serial console access is enabled. Valid values are `true` or `false`. Defaults to `true`.
     * 
     */
    @Export(name="enabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enabled;

    /**
     * @return Whether or not serial console access is enabled. Valid values are `true` or `false`. Defaults to `true`.
     * 
     */
    public Output<Optional<Boolean>> enabled() {
        return Codegen.optional(this.enabled);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SerialConsoleAccess(String name) {
        this(name, SerialConsoleAccessArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SerialConsoleAccess(String name, @Nullable SerialConsoleAccessArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SerialConsoleAccess(String name, @Nullable SerialConsoleAccessArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/serialConsoleAccess:SerialConsoleAccess", name, args == null ? SerialConsoleAccessArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SerialConsoleAccess(String name, Output<String> id, @Nullable SerialConsoleAccessState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/serialConsoleAccess:SerialConsoleAccess", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SerialConsoleAccess get(String name, Output<String> id, @Nullable SerialConsoleAccessState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SerialConsoleAccess(name, id, state, options);
    }
}
