// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.NetworkInterfaceAttachmentArgs;
import com.pulumi.aws.ec2.inputs.NetworkInterfaceAttachmentState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Attach an Elastic network interface (ENI) resource with EC2 instance.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInterfaceAttachment;
 * import com.pulumi.aws.ec2.NetworkInterfaceAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new NetworkInterfaceAttachment(&#34;test&#34;, NetworkInterfaceAttachmentArgs.builder()        
 *             .instanceId(aws_instance.test().id())
 *             .networkInterfaceId(aws_network_interface.test().id())
 *             .deviceIndex(0)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Elastic network interface (ENI) Attachments using its Attachment ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment secondary_nic eni-attach-0a33842b4ec347c4c
 * ```
 * 
 */
@ResourceType(type="aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment")
public class NetworkInterfaceAttachment extends com.pulumi.resources.CustomResource {
    /**
     * The ENI Attachment ID.
     * 
     */
    @Export(name="attachmentId", refs={String.class}, tree="[0]")
    private Output<String> attachmentId;

    /**
     * @return The ENI Attachment ID.
     * 
     */
    public Output<String> attachmentId() {
        return this.attachmentId;
    }
    /**
     * Network interface index (int).
     * 
     */
    @Export(name="deviceIndex", refs={Integer.class}, tree="[0]")
    private Output<Integer> deviceIndex;

    /**
     * @return Network interface index (int).
     * 
     */
    public Output<Integer> deviceIndex() {
        return this.deviceIndex;
    }
    /**
     * Instance ID to attach.
     * 
     */
    @Export(name="instanceId", refs={String.class}, tree="[0]")
    private Output<String> instanceId;

    /**
     * @return Instance ID to attach.
     * 
     */
    public Output<String> instanceId() {
        return this.instanceId;
    }
    /**
     * ENI ID to attach.
     * 
     */
    @Export(name="networkInterfaceId", refs={String.class}, tree="[0]")
    private Output<String> networkInterfaceId;

    /**
     * @return ENI ID to attach.
     * 
     */
    public Output<String> networkInterfaceId() {
        return this.networkInterfaceId;
    }
    /**
     * The status of the Network Interface Attachment.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return The status of the Network Interface Attachment.
     * 
     */
    public Output<String> status() {
        return this.status;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public NetworkInterfaceAttachment(String name) {
        this(name, NetworkInterfaceAttachmentArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public NetworkInterfaceAttachment(String name, NetworkInterfaceAttachmentArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public NetworkInterfaceAttachment(String name, NetworkInterfaceAttachmentArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment", name, args == null ? NetworkInterfaceAttachmentArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private NetworkInterfaceAttachment(String name, Output<String> id, @Nullable NetworkInterfaceAttachmentState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/networkInterfaceAttachment:NetworkInterfaceAttachment", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static NetworkInterfaceAttachment get(String name, Output<String> id, @Nullable NetworkInterfaceAttachmentState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new NetworkInterfaceAttachment(name, id, state, options);
    }
}
