// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class NatGatewayArgs extends com.pulumi.resources.ResourceArgs {

    public static final NatGatewayArgs Empty = new NatGatewayArgs();

    /**
     * The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     * 
     */
    @Import(name="allocationId")
    private @Nullable Output<String> allocationId;

    /**
     * @return The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     * 
     */
    public Optional<Output<String>> allocationId() {
        return Optional.ofNullable(this.allocationId);
    }

    /**
     * Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     * 
     */
    @Import(name="connectivityType")
    private @Nullable Output<String> connectivityType;

    /**
     * @return Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     * 
     */
    public Optional<Output<String>> connectivityType() {
        return Optional.ofNullable(this.connectivityType);
    }

    /**
     * The private IPv4 address to assign to the NAT Gateway. If you don&#39;t provide an address, a private IPv4 address will be automatically assigned.
     * 
     */
    @Import(name="privateIp")
    private @Nullable Output<String> privateIp;

    /**
     * @return The private IPv4 address to assign to the NAT Gateway. If you don&#39;t provide an address, a private IPv4 address will be automatically assigned.
     * 
     */
    public Optional<Output<String>> privateIp() {
        return Optional.ofNullable(this.privateIp);
    }

    /**
     * A list of secondary allocation EIP IDs for this NAT Gateway.
     * 
     */
    @Import(name="secondaryAllocationIds")
    private @Nullable Output<List<String>> secondaryAllocationIds;

    /**
     * @return A list of secondary allocation EIP IDs for this NAT Gateway.
     * 
     */
    public Optional<Output<List<String>>> secondaryAllocationIds() {
        return Optional.ofNullable(this.secondaryAllocationIds);
    }

    /**
     * [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     * 
     */
    @Import(name="secondaryPrivateIpAddressCount")
    private @Nullable Output<Integer> secondaryPrivateIpAddressCount;

    /**
     * @return [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     * 
     */
    public Optional<Output<Integer>> secondaryPrivateIpAddressCount() {
        return Optional.ofNullable(this.secondaryPrivateIpAddressCount);
    }

    /**
     * A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     * 
     */
    @Import(name="secondaryPrivateIpAddresses")
    private @Nullable Output<List<String>> secondaryPrivateIpAddresses;

    /**
     * @return A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     * 
     */
    public Optional<Output<List<String>>> secondaryPrivateIpAddresses() {
        return Optional.ofNullable(this.secondaryPrivateIpAddresses);
    }

    /**
     * The Subnet ID of the subnet in which to place the NAT Gateway.
     * 
     */
    @Import(name="subnetId", required=true)
    private Output<String> subnetId;

    /**
     * @return The Subnet ID of the subnet in which to place the NAT Gateway.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private NatGatewayArgs() {}

    private NatGatewayArgs(NatGatewayArgs $) {
        this.allocationId = $.allocationId;
        this.connectivityType = $.connectivityType;
        this.privateIp = $.privateIp;
        this.secondaryAllocationIds = $.secondaryAllocationIds;
        this.secondaryPrivateIpAddressCount = $.secondaryPrivateIpAddressCount;
        this.secondaryPrivateIpAddresses = $.secondaryPrivateIpAddresses;
        this.subnetId = $.subnetId;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(NatGatewayArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private NatGatewayArgs $;

        public Builder() {
            $ = new NatGatewayArgs();
        }

        public Builder(NatGatewayArgs defaults) {
            $ = new NatGatewayArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allocationId The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
         * 
         * @return builder
         * 
         */
        public Builder allocationId(@Nullable Output<String> allocationId) {
            $.allocationId = allocationId;
            return this;
        }

        /**
         * @param allocationId The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
         * 
         * @return builder
         * 
         */
        public Builder allocationId(String allocationId) {
            return allocationId(Output.of(allocationId));
        }

        /**
         * @param connectivityType Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
         * 
         * @return builder
         * 
         */
        public Builder connectivityType(@Nullable Output<String> connectivityType) {
            $.connectivityType = connectivityType;
            return this;
        }

        /**
         * @param connectivityType Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
         * 
         * @return builder
         * 
         */
        public Builder connectivityType(String connectivityType) {
            return connectivityType(Output.of(connectivityType));
        }

        /**
         * @param privateIp The private IPv4 address to assign to the NAT Gateway. If you don&#39;t provide an address, a private IPv4 address will be automatically assigned.
         * 
         * @return builder
         * 
         */
        public Builder privateIp(@Nullable Output<String> privateIp) {
            $.privateIp = privateIp;
            return this;
        }

        /**
         * @param privateIp The private IPv4 address to assign to the NAT Gateway. If you don&#39;t provide an address, a private IPv4 address will be automatically assigned.
         * 
         * @return builder
         * 
         */
        public Builder privateIp(String privateIp) {
            return privateIp(Output.of(privateIp));
        }

        /**
         * @param secondaryAllocationIds A list of secondary allocation EIP IDs for this NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder secondaryAllocationIds(@Nullable Output<List<String>> secondaryAllocationIds) {
            $.secondaryAllocationIds = secondaryAllocationIds;
            return this;
        }

        /**
         * @param secondaryAllocationIds A list of secondary allocation EIP IDs for this NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder secondaryAllocationIds(List<String> secondaryAllocationIds) {
            return secondaryAllocationIds(Output.of(secondaryAllocationIds));
        }

        /**
         * @param secondaryAllocationIds A list of secondary allocation EIP IDs for this NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder secondaryAllocationIds(String... secondaryAllocationIds) {
            return secondaryAllocationIds(List.of(secondaryAllocationIds));
        }

        /**
         * @param secondaryPrivateIpAddressCount [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder secondaryPrivateIpAddressCount(@Nullable Output<Integer> secondaryPrivateIpAddressCount) {
            $.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        /**
         * @param secondaryPrivateIpAddressCount [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            return secondaryPrivateIpAddressCount(Output.of(secondaryPrivateIpAddressCount));
        }

        /**
         * @param secondaryPrivateIpAddresses A list of secondary private IPv4 addresses to assign to the NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder secondaryPrivateIpAddresses(@Nullable Output<List<String>> secondaryPrivateIpAddresses) {
            $.secondaryPrivateIpAddresses = secondaryPrivateIpAddresses;
            return this;
        }

        /**
         * @param secondaryPrivateIpAddresses A list of secondary private IPv4 addresses to assign to the NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder secondaryPrivateIpAddresses(List<String> secondaryPrivateIpAddresses) {
            return secondaryPrivateIpAddresses(Output.of(secondaryPrivateIpAddresses));
        }

        /**
         * @param secondaryPrivateIpAddresses A list of secondary private IPv4 addresses to assign to the NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder secondaryPrivateIpAddresses(String... secondaryPrivateIpAddresses) {
            return secondaryPrivateIpAddresses(List.of(secondaryPrivateIpAddresses));
        }

        /**
         * @param subnetId The Subnet ID of the subnet in which to place the NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId The Subnet ID of the subnet in which to place the NAT Gateway.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public NatGatewayArgs build() {
            $.subnetId = Objects.requireNonNull($.subnetId, "expected parameter 'subnetId' to be non-null");
            return $;
        }
    }

}
