// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.NatGatewayArgs;
import com.pulumi.aws.ec2.inputs.NatGatewayState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to create a VPC NAT Gateway.
 * 
 * ## Example Usage
 * ### Public NAT
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway(&#34;example&#34;, NatGatewayArgs.builder()        
 *             .allocationId(aws_eip.example().id())
 *             .subnetId(aws_subnet.example().id())
 *             .tags(Map.of(&#34;Name&#34;, &#34;gw NAT&#34;))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_internet_gateway.example())
 *                 .build());
 * 
 *     }
 * }
 * ```
 * ### Public NAT with Secondary Private IP Addresses
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway(&#34;example&#34;, NatGatewayArgs.builder()        
 *             .allocationId(aws_eip.example().id())
 *             .subnetId(aws_subnet.example().id())
 *             .secondaryAllocationIds(aws_eip.secondary().id())
 *             .secondaryPrivateIpAddresses(&#34;10.0.1.5&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Private NAT
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway(&#34;example&#34;, NatGatewayArgs.builder()        
 *             .connectivityType(&#34;private&#34;)
 *             .subnetId(aws_subnet.example().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Private NAT with Secondary Private IP Addresses
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NatGateway;
 * import com.pulumi.aws.ec2.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new NatGateway(&#34;example&#34;, NatGatewayArgs.builder()        
 *             .connectivityType(&#34;private&#34;)
 *             .subnetId(aws_subnet.example().id())
 *             .secondaryPrivateIpAddressCount(7)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import NAT Gateways using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/natGateway:NatGateway private_gw nat-05dba92075d71c408
 * ```
 * 
 */
@ResourceType(type="aws:ec2/natGateway:NatGateway")
public class NatGateway extends com.pulumi.resources.CustomResource {
    /**
     * The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     * 
     */
    @Export(name="allocationId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> allocationId;

    /**
     * @return The Allocation ID of the Elastic IP address for the NAT Gateway. Required for `connectivity_type` of `public`.
     * 
     */
    public Output<Optional<String>> allocationId() {
        return Codegen.optional(this.allocationId);
    }
    /**
     * The association ID of the Elastic IP address that&#39;s associated with the NAT Gateway. Only available when `connectivity_type` is `public`.
     * 
     */
    @Export(name="associationId", refs={String.class}, tree="[0]")
    private Output<String> associationId;

    /**
     * @return The association ID of the Elastic IP address that&#39;s associated with the NAT Gateway. Only available when `connectivity_type` is `public`.
     * 
     */
    public Output<String> associationId() {
        return this.associationId;
    }
    /**
     * Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     * 
     */
    @Export(name="connectivityType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> connectivityType;

    /**
     * @return Connectivity type for the NAT Gateway. Valid values are `private` and `public`. Defaults to `public`.
     * 
     */
    public Output<Optional<String>> connectivityType() {
        return Codegen.optional(this.connectivityType);
    }
    /**
     * The ID of the network interface associated with the NAT Gateway.
     * 
     */
    @Export(name="networkInterfaceId", refs={String.class}, tree="[0]")
    private Output<String> networkInterfaceId;

    /**
     * @return The ID of the network interface associated with the NAT Gateway.
     * 
     */
    public Output<String> networkInterfaceId() {
        return this.networkInterfaceId;
    }
    /**
     * The private IPv4 address to assign to the NAT Gateway. If you don&#39;t provide an address, a private IPv4 address will be automatically assigned.
     * 
     */
    @Export(name="privateIp", refs={String.class}, tree="[0]")
    private Output<String> privateIp;

    /**
     * @return The private IPv4 address to assign to the NAT Gateway. If you don&#39;t provide an address, a private IPv4 address will be automatically assigned.
     * 
     */
    public Output<String> privateIp() {
        return this.privateIp;
    }
    /**
     * The Elastic IP address associated with the NAT Gateway.
     * 
     */
    @Export(name="publicIp", refs={String.class}, tree="[0]")
    private Output<String> publicIp;

    /**
     * @return The Elastic IP address associated with the NAT Gateway.
     * 
     */
    public Output<String> publicIp() {
        return this.publicIp;
    }
    /**
     * A list of secondary allocation EIP IDs for this NAT Gateway.
     * 
     */
    @Export(name="secondaryAllocationIds", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> secondaryAllocationIds;

    /**
     * @return A list of secondary allocation EIP IDs for this NAT Gateway.
     * 
     */
    public Output<Optional<List<String>>> secondaryAllocationIds() {
        return Codegen.optional(this.secondaryAllocationIds);
    }
    /**
     * [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     * 
     */
    @Export(name="secondaryPrivateIpAddressCount", refs={Integer.class}, tree="[0]")
    private Output<Integer> secondaryPrivateIpAddressCount;

    /**
     * @return [Private NAT Gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT Gateway.
     * 
     */
    public Output<Integer> secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }
    /**
     * A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     * 
     */
    @Export(name="secondaryPrivateIpAddresses", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> secondaryPrivateIpAddresses;

    /**
     * @return A list of secondary private IPv4 addresses to assign to the NAT Gateway.
     * 
     */
    public Output<List<String>> secondaryPrivateIpAddresses() {
        return this.secondaryPrivateIpAddresses;
    }
    /**
     * The Subnet ID of the subnet in which to place the NAT Gateway.
     * 
     */
    @Export(name="subnetId", refs={String.class}, tree="[0]")
    private Output<String> subnetId;

    /**
     * @return The Subnet ID of the subnet in which to place the NAT Gateway.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }
    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public NatGateway(String name) {
        this(name, NatGatewayArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public NatGateway(String name, NatGatewayArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public NatGateway(String name, NatGatewayArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/natGateway:NatGateway", name, args == null ? NatGatewayArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private NatGateway(String name, Output<String> id, @Nullable NatGatewayState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/natGateway:NatGateway", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static NatGateway get(String name, Output<String> id, @Nullable NatGatewayState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new NatGateway(name, id, state, options);
    }
}
