// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.LocalGatewayRouteArgs;
import com.pulumi.aws.ec2.inputs.LocalGatewayRouteState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages an EC2 Local Gateway Route. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LocalGatewayRoute;
 * import com.pulumi.aws.ec2.LocalGatewayRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new LocalGatewayRoute(&#34;example&#34;, LocalGatewayRouteArgs.builder()        
 *             .destinationCidrBlock(&#34;172.16.0.0/16&#34;)
 *             .localGatewayRouteTableId(data.aws_ec2_local_gateway_route_table().example().id())
 *             .localGatewayVirtualInterfaceGroupId(data.aws_ec2_local_gateway_virtual_interface_group().example().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_ec2_local_gateway_route` using the EC2 Local Gateway Route Table identifier and destination CIDR block separated by underscores (`_`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/localGatewayRoute:LocalGatewayRoute example lgw-rtb-12345678_172.16.0.0/16
 * ```
 * 
 */
@ResourceType(type="aws:ec2/localGatewayRoute:LocalGatewayRoute")
public class LocalGatewayRoute extends com.pulumi.resources.CustomResource {
    /**
     * IPv4 CIDR range used for destination matches. Routing decisions are based on the most specific match.
     * 
     */
    @Export(name="destinationCidrBlock", refs={String.class}, tree="[0]")
    private Output<String> destinationCidrBlock;

    /**
     * @return IPv4 CIDR range used for destination matches. Routing decisions are based on the most specific match.
     * 
     */
    public Output<String> destinationCidrBlock() {
        return this.destinationCidrBlock;
    }
    /**
     * Identifier of EC2 Local Gateway Route Table.
     * 
     */
    @Export(name="localGatewayRouteTableId", refs={String.class}, tree="[0]")
    private Output<String> localGatewayRouteTableId;

    /**
     * @return Identifier of EC2 Local Gateway Route Table.
     * 
     */
    public Output<String> localGatewayRouteTableId() {
        return this.localGatewayRouteTableId;
    }
    /**
     * Identifier of EC2 Local Gateway Virtual Interface Group.
     * 
     */
    @Export(name="localGatewayVirtualInterfaceGroupId", refs={String.class}, tree="[0]")
    private Output<String> localGatewayVirtualInterfaceGroupId;

    /**
     * @return Identifier of EC2 Local Gateway Virtual Interface Group.
     * 
     */
    public Output<String> localGatewayVirtualInterfaceGroupId() {
        return this.localGatewayVirtualInterfaceGroupId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LocalGatewayRoute(String name) {
        this(name, LocalGatewayRouteArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LocalGatewayRoute(String name, LocalGatewayRouteArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LocalGatewayRoute(String name, LocalGatewayRouteArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/localGatewayRoute:LocalGatewayRoute", name, args == null ? LocalGatewayRouteArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LocalGatewayRoute(String name, Output<String> id, @Nullable LocalGatewayRouteState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/localGatewayRoute:LocalGatewayRoute", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LocalGatewayRoute get(String name, Output<String> id, @Nullable LocalGatewayRouteState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LocalGatewayRoute(name, id, state, options);
    }
}
