// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateCpuOptionsArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateCreditSpecificationArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateElasticGpuSpecificationArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateElasticInferenceAcceleratorArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateEnclaveOptionsArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateHibernationOptionsArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateIamInstanceProfileArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateLicenseSpecificationArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateMaintenanceOptionsArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateMetadataOptionsArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateMonitoringArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateNetworkInterfaceArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplatePlacementArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplatePrivateDnsNameOptionsArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateTagSpecificationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class LaunchTemplateArgs extends com.pulumi.resources.ResourceArgs {

    public static final LaunchTemplateArgs Empty = new LaunchTemplateArgs();

    /**
     * Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     * 
     */
    @Import(name="blockDeviceMappings")
    private @Nullable Output<List<LaunchTemplateBlockDeviceMappingArgs>> blockDeviceMappings;

    /**
     * @return Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     * 
     */
    public Optional<Output<List<LaunchTemplateBlockDeviceMappingArgs>>> blockDeviceMappings() {
        return Optional.ofNullable(this.blockDeviceMappings);
    }

    /**
     * Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
     * 
     */
    @Import(name="capacityReservationSpecification")
    private @Nullable Output<LaunchTemplateCapacityReservationSpecificationArgs> capacityReservationSpecification;

    /**
     * @return Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateCapacityReservationSpecificationArgs>> capacityReservationSpecification() {
        return Optional.ofNullable(this.capacityReservationSpecification);
    }

    /**
     * The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    @Import(name="cpuOptions")
    private @Nullable Output<LaunchTemplateCpuOptionsArgs> cpuOptions;

    /**
     * @return The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateCpuOptionsArgs>> cpuOptions() {
        return Optional.ofNullable(this.cpuOptions);
    }

    /**
     * Customize the credit specification of the instance. See Credit
     * Specification below for more details.
     * 
     */
    @Import(name="creditSpecification")
    private @Nullable Output<LaunchTemplateCreditSpecificationArgs> creditSpecification;

    /**
     * @return Customize the credit specification of the instance. See Credit
     * Specification below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateCreditSpecificationArgs>> creditSpecification() {
        return Optional.ofNullable(this.creditSpecification);
    }

    /**
     * Default Version of the launch template.
     * 
     */
    @Import(name="defaultVersion")
    private @Nullable Output<Integer> defaultVersion;

    /**
     * @return Default Version of the launch template.
     * 
     */
    public Optional<Output<Integer>> defaultVersion() {
        return Optional.ofNullable(this.defaultVersion);
    }

    /**
     * Description of the launch template.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return Description of the launch template.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    @Import(name="disableApiStop")
    private @Nullable Output<Boolean> disableApiStop;

    /**
     * @return If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    public Optional<Output<Boolean>> disableApiStop() {
        return Optional.ofNullable(this.disableApiStop);
    }

    /**
     * If `true`, enables [EC2 Instance
     * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination)
     * 
     */
    @Import(name="disableApiTermination")
    private @Nullable Output<Boolean> disableApiTermination;

    /**
     * @return If `true`, enables [EC2 Instance
     * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination)
     * 
     */
    public Optional<Output<Boolean>> disableApiTermination() {
        return Optional.ofNullable(this.disableApiTermination);
    }

    /**
     * If `true`, the launched EC2 instance will be EBS-optimized.
     * 
     */
    @Import(name="ebsOptimized")
    private @Nullable Output<String> ebsOptimized;

    /**
     * @return If `true`, the launched EC2 instance will be EBS-optimized.
     * 
     */
    public Optional<Output<String>> ebsOptimized() {
        return Optional.ofNullable(this.ebsOptimized);
    }

    /**
     * The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     * 
     */
    @Import(name="elasticGpuSpecifications")
    private @Nullable Output<List<LaunchTemplateElasticGpuSpecificationArgs>> elasticGpuSpecifications;

    /**
     * @return The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     * 
     */
    public Optional<Output<List<LaunchTemplateElasticGpuSpecificationArgs>>> elasticGpuSpecifications() {
        return Optional.ofNullable(this.elasticGpuSpecifications);
    }

    /**
     * Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
     * 
     */
    @Import(name="elasticInferenceAccelerator")
    private @Nullable Output<LaunchTemplateElasticInferenceAcceleratorArgs> elasticInferenceAccelerator;

    /**
     * @return Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateElasticInferenceAcceleratorArgs>> elasticInferenceAccelerator() {
        return Optional.ofNullable(this.elasticInferenceAccelerator);
    }

    /**
     * Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    @Import(name="enclaveOptions")
    private @Nullable Output<LaunchTemplateEnclaveOptionsArgs> enclaveOptions;

    /**
     * @return Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateEnclaveOptionsArgs>> enclaveOptions() {
        return Optional.ofNullable(this.enclaveOptions);
    }

    /**
     * The hibernation options for the instance. See Hibernation Options below for more details.
     * 
     */
    @Import(name="hibernationOptions")
    private @Nullable Output<LaunchTemplateHibernationOptionsArgs> hibernationOptions;

    /**
     * @return The hibernation options for the instance. See Hibernation Options below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateHibernationOptionsArgs>> hibernationOptions() {
        return Optional.ofNullable(this.hibernationOptions);
    }

    /**
     * The IAM Instance Profile to launch the instance with. See Instance Profile
     * below for more details.
     * 
     */
    @Import(name="iamInstanceProfile")
    private @Nullable Output<LaunchTemplateIamInstanceProfileArgs> iamInstanceProfile;

    /**
     * @return The IAM Instance Profile to launch the instance with. See Instance Profile
     * below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateIamInstanceProfileArgs>> iamInstanceProfile() {
        return Optional.ofNullable(this.iamInstanceProfile);
    }

    /**
     * The AMI from which to launch the instance.
     * 
     */
    @Import(name="imageId")
    private @Nullable Output<String> imageId;

    /**
     * @return The AMI from which to launch the instance.
     * 
     */
    public Optional<Output<String>> imageId() {
        return Optional.ofNullable(this.imageId);
    }

    /**
     * Shutdown behavior for the instance. Can be `stop` or `terminate`.
     * (Default: `stop`).
     * 
     */
    @Import(name="instanceInitiatedShutdownBehavior")
    private @Nullable Output<String> instanceInitiatedShutdownBehavior;

    /**
     * @return Shutdown behavior for the instance. Can be `stop` or `terminate`.
     * (Default: `stop`).
     * 
     */
    public Optional<Output<String>> instanceInitiatedShutdownBehavior() {
        return Optional.ofNullable(this.instanceInitiatedShutdownBehavior);
    }

    /**
     * The market (purchasing) option for the instance. See Market Options
     * below for details.
     * 
     */
    @Import(name="instanceMarketOptions")
    private @Nullable Output<LaunchTemplateInstanceMarketOptionsArgs> instanceMarketOptions;

    /**
     * @return The market (purchasing) option for the instance. See Market Options
     * below for details.
     * 
     */
    public Optional<Output<LaunchTemplateInstanceMarketOptionsArgs>> instanceMarketOptions() {
        return Optional.ofNullable(this.instanceMarketOptions);
    }

    /**
     * The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
     * 
     */
    @Import(name="instanceRequirements")
    private @Nullable Output<LaunchTemplateInstanceRequirementsArgs> instanceRequirements;

    /**
     * @return The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
     * 
     */
    public Optional<Output<LaunchTemplateInstanceRequirementsArgs>> instanceRequirements() {
        return Optional.ofNullable(this.instanceRequirements);
    }

    /**
     * The type of the instance. If present then `instance_requirements` cannot be present.
     * 
     */
    @Import(name="instanceType")
    private @Nullable Output<String> instanceType;

    /**
     * @return The type of the instance. If present then `instance_requirements` cannot be present.
     * 
     */
    public Optional<Output<String>> instanceType() {
        return Optional.ofNullable(this.instanceType);
    }

    /**
     * The kernel ID.
     * 
     */
    @Import(name="kernelId")
    private @Nullable Output<String> kernelId;

    /**
     * @return The kernel ID.
     * 
     */
    public Optional<Output<String>> kernelId() {
        return Optional.ofNullable(this.kernelId);
    }

    /**
     * The key name to use for the instance.
     * 
     */
    @Import(name="keyName")
    private @Nullable Output<String> keyName;

    /**
     * @return The key name to use for the instance.
     * 
     */
    public Optional<Output<String>> keyName() {
        return Optional.ofNullable(this.keyName);
    }

    /**
     * A list of license specifications to associate with. See License Specification below for more details.
     * 
     */
    @Import(name="licenseSpecifications")
    private @Nullable Output<List<LaunchTemplateLicenseSpecificationArgs>> licenseSpecifications;

    /**
     * @return A list of license specifications to associate with. See License Specification below for more details.
     * 
     */
    public Optional<Output<List<LaunchTemplateLicenseSpecificationArgs>>> licenseSpecifications() {
        return Optional.ofNullable(this.licenseSpecifications);
    }

    /**
     * The maintenance options for the instance. See Maintenance Options below for more details.
     * 
     */
    @Import(name="maintenanceOptions")
    private @Nullable Output<LaunchTemplateMaintenanceOptionsArgs> maintenanceOptions;

    /**
     * @return The maintenance options for the instance. See Maintenance Options below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateMaintenanceOptionsArgs>> maintenanceOptions() {
        return Optional.ofNullable(this.maintenanceOptions);
    }

    /**
     * Customize the metadata options for the instance. See Metadata Options below for more details.
     * 
     */
    @Import(name="metadataOptions")
    private @Nullable Output<LaunchTemplateMetadataOptionsArgs> metadataOptions;

    /**
     * @return Customize the metadata options for the instance. See Metadata Options below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateMetadataOptionsArgs>> metadataOptions() {
        return Optional.ofNullable(this.metadataOptions);
    }

    /**
     * The monitoring option for the instance. See Monitoring below for more details.
     * 
     */
    @Import(name="monitoring")
    private @Nullable Output<LaunchTemplateMonitoringArgs> monitoring;

    /**
     * @return The monitoring option for the instance. See Monitoring below for more details.
     * 
     */
    public Optional<Output<LaunchTemplateMonitoringArgs>> monitoring() {
        return Optional.ofNullable(this.monitoring);
    }

    /**
     * The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     * 
     */
    @Import(name="namePrefix")
    private @Nullable Output<String> namePrefix;

    /**
     * @return Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     * 
     */
    public Optional<Output<String>> namePrefix() {
        return Optional.ofNullable(this.namePrefix);
    }

    /**
     * Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     * 
     */
    @Import(name="networkInterfaces")
    private @Nullable Output<List<LaunchTemplateNetworkInterfaceArgs>> networkInterfaces;

    /**
     * @return Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     * 
     */
    public Optional<Output<List<LaunchTemplateNetworkInterfaceArgs>>> networkInterfaces() {
        return Optional.ofNullable(this.networkInterfaces);
    }

    /**
     * The placement of the instance. See Placement below for more details.
     * 
     */
    @Import(name="placement")
    private @Nullable Output<LaunchTemplatePlacementArgs> placement;

    /**
     * @return The placement of the instance. See Placement below for more details.
     * 
     */
    public Optional<Output<LaunchTemplatePlacementArgs>> placement() {
        return Optional.ofNullable(this.placement);
    }

    /**
     * The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    @Import(name="privateDnsNameOptions")
    private @Nullable Output<LaunchTemplatePrivateDnsNameOptionsArgs> privateDnsNameOptions;

    /**
     * @return The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    public Optional<Output<LaunchTemplatePrivateDnsNameOptionsArgs>> privateDnsNameOptions() {
        return Optional.ofNullable(this.privateDnsNameOptions);
    }

    /**
     * The ID of the RAM disk.
     * 
     */
    @Import(name="ramDiskId")
    private @Nullable Output<String> ramDiskId;

    /**
     * @return The ID of the RAM disk.
     * 
     */
    public Optional<Output<String>> ramDiskId() {
        return Optional.ofNullable(this.ramDiskId);
    }

    /**
     * A list of security group names to associate with. If you are creating Instances in a VPC, use
     * `vpc_security_group_ids` instead.
     * 
     */
    @Import(name="securityGroupNames")
    private @Nullable Output<List<String>> securityGroupNames;

    /**
     * @return A list of security group names to associate with. If you are creating Instances in a VPC, use
     * `vpc_security_group_ids` instead.
     * 
     */
    public Optional<Output<List<String>>> securityGroupNames() {
        return Optional.ofNullable(this.securityGroupNames);
    }

    /**
     * The tags to apply to the resources during launch. See Tag Specifications below for more details.
     * 
     */
    @Import(name="tagSpecifications")
    private @Nullable Output<List<LaunchTemplateTagSpecificationArgs>> tagSpecifications;

    /**
     * @return The tags to apply to the resources during launch. See Tag Specifications below for more details.
     * 
     */
    public Optional<Output<List<LaunchTemplateTagSpecificationArgs>>> tagSpecifications() {
        return Optional.ofNullable(this.tagSpecifications);
    }

    /**
     * A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Whether to update Default Version each update. Conflicts with `default_version`.
     * 
     */
    @Import(name="updateDefaultVersion")
    private @Nullable Output<Boolean> updateDefaultVersion;

    /**
     * @return Whether to update Default Version each update. Conflicts with `default_version`.
     * 
     */
    public Optional<Output<Boolean>> updateDefaultVersion() {
        return Optional.ofNullable(this.updateDefaultVersion);
    }

    /**
     * The base64-encoded user data to provide when launching the instance.
     * 
     */
    @Import(name="userData")
    private @Nullable Output<String> userData;

    /**
     * @return The base64-encoded user data to provide when launching the instance.
     * 
     */
    public Optional<Output<String>> userData() {
        return Optional.ofNullable(this.userData);
    }

    /**
     * A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
     * 
     */
    @Import(name="vpcSecurityGroupIds")
    private @Nullable Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
     * 
     */
    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    private LaunchTemplateArgs() {}

    private LaunchTemplateArgs(LaunchTemplateArgs $) {
        this.blockDeviceMappings = $.blockDeviceMappings;
        this.capacityReservationSpecification = $.capacityReservationSpecification;
        this.cpuOptions = $.cpuOptions;
        this.creditSpecification = $.creditSpecification;
        this.defaultVersion = $.defaultVersion;
        this.description = $.description;
        this.disableApiStop = $.disableApiStop;
        this.disableApiTermination = $.disableApiTermination;
        this.ebsOptimized = $.ebsOptimized;
        this.elasticGpuSpecifications = $.elasticGpuSpecifications;
        this.elasticInferenceAccelerator = $.elasticInferenceAccelerator;
        this.enclaveOptions = $.enclaveOptions;
        this.hibernationOptions = $.hibernationOptions;
        this.iamInstanceProfile = $.iamInstanceProfile;
        this.imageId = $.imageId;
        this.instanceInitiatedShutdownBehavior = $.instanceInitiatedShutdownBehavior;
        this.instanceMarketOptions = $.instanceMarketOptions;
        this.instanceRequirements = $.instanceRequirements;
        this.instanceType = $.instanceType;
        this.kernelId = $.kernelId;
        this.keyName = $.keyName;
        this.licenseSpecifications = $.licenseSpecifications;
        this.maintenanceOptions = $.maintenanceOptions;
        this.metadataOptions = $.metadataOptions;
        this.monitoring = $.monitoring;
        this.name = $.name;
        this.namePrefix = $.namePrefix;
        this.networkInterfaces = $.networkInterfaces;
        this.placement = $.placement;
        this.privateDnsNameOptions = $.privateDnsNameOptions;
        this.ramDiskId = $.ramDiskId;
        this.securityGroupNames = $.securityGroupNames;
        this.tagSpecifications = $.tagSpecifications;
        this.tags = $.tags;
        this.updateDefaultVersion = $.updateDefaultVersion;
        this.userData = $.userData;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(LaunchTemplateArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private LaunchTemplateArgs $;

        public Builder() {
            $ = new LaunchTemplateArgs();
        }

        public Builder(LaunchTemplateArgs defaults) {
            $ = new LaunchTemplateArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param blockDeviceMappings Specify volumes to attach to the instance besides the volumes specified by the AMI.
         * See Block Devices below for details.
         * 
         * @return builder
         * 
         */
        public Builder blockDeviceMappings(@Nullable Output<List<LaunchTemplateBlockDeviceMappingArgs>> blockDeviceMappings) {
            $.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * @param blockDeviceMappings Specify volumes to attach to the instance besides the volumes specified by the AMI.
         * See Block Devices below for details.
         * 
         * @return builder
         * 
         */
        public Builder blockDeviceMappings(List<LaunchTemplateBlockDeviceMappingArgs> blockDeviceMappings) {
            return blockDeviceMappings(Output.of(blockDeviceMappings));
        }

        /**
         * @param blockDeviceMappings Specify volumes to attach to the instance besides the volumes specified by the AMI.
         * See Block Devices below for details.
         * 
         * @return builder
         * 
         */
        public Builder blockDeviceMappings(LaunchTemplateBlockDeviceMappingArgs... blockDeviceMappings) {
            return blockDeviceMappings(List.of(blockDeviceMappings));
        }

        /**
         * @param capacityReservationSpecification Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
         * 
         * @return builder
         * 
         */
        public Builder capacityReservationSpecification(@Nullable Output<LaunchTemplateCapacityReservationSpecificationArgs> capacityReservationSpecification) {
            $.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        /**
         * @param capacityReservationSpecification Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
         * 
         * @return builder
         * 
         */
        public Builder capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationArgs capacityReservationSpecification) {
            return capacityReservationSpecification(Output.of(capacityReservationSpecification));
        }

        /**
         * @param cpuOptions The CPU options for the instance. See CPU Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder cpuOptions(@Nullable Output<LaunchTemplateCpuOptionsArgs> cpuOptions) {
            $.cpuOptions = cpuOptions;
            return this;
        }

        /**
         * @param cpuOptions The CPU options for the instance. See CPU Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder cpuOptions(LaunchTemplateCpuOptionsArgs cpuOptions) {
            return cpuOptions(Output.of(cpuOptions));
        }

        /**
         * @param creditSpecification Customize the credit specification of the instance. See Credit
         * Specification below for more details.
         * 
         * @return builder
         * 
         */
        public Builder creditSpecification(@Nullable Output<LaunchTemplateCreditSpecificationArgs> creditSpecification) {
            $.creditSpecification = creditSpecification;
            return this;
        }

        /**
         * @param creditSpecification Customize the credit specification of the instance. See Credit
         * Specification below for more details.
         * 
         * @return builder
         * 
         */
        public Builder creditSpecification(LaunchTemplateCreditSpecificationArgs creditSpecification) {
            return creditSpecification(Output.of(creditSpecification));
        }

        /**
         * @param defaultVersion Default Version of the launch template.
         * 
         * @return builder
         * 
         */
        public Builder defaultVersion(@Nullable Output<Integer> defaultVersion) {
            $.defaultVersion = defaultVersion;
            return this;
        }

        /**
         * @param defaultVersion Default Version of the launch template.
         * 
         * @return builder
         * 
         */
        public Builder defaultVersion(Integer defaultVersion) {
            return defaultVersion(Output.of(defaultVersion));
        }

        /**
         * @param description Description of the launch template.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description Description of the launch template.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param disableApiStop If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
         * 
         * @return builder
         * 
         */
        public Builder disableApiStop(@Nullable Output<Boolean> disableApiStop) {
            $.disableApiStop = disableApiStop;
            return this;
        }

        /**
         * @param disableApiStop If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
         * 
         * @return builder
         * 
         */
        public Builder disableApiStop(Boolean disableApiStop) {
            return disableApiStop(Output.of(disableApiStop));
        }

        /**
         * @param disableApiTermination If `true`, enables [EC2 Instance
         * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination)
         * 
         * @return builder
         * 
         */
        public Builder disableApiTermination(@Nullable Output<Boolean> disableApiTermination) {
            $.disableApiTermination = disableApiTermination;
            return this;
        }

        /**
         * @param disableApiTermination If `true`, enables [EC2 Instance
         * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination)
         * 
         * @return builder
         * 
         */
        public Builder disableApiTermination(Boolean disableApiTermination) {
            return disableApiTermination(Output.of(disableApiTermination));
        }

        /**
         * @param ebsOptimized If `true`, the launched EC2 instance will be EBS-optimized.
         * 
         * @return builder
         * 
         */
        public Builder ebsOptimized(@Nullable Output<String> ebsOptimized) {
            $.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * @param ebsOptimized If `true`, the launched EC2 instance will be EBS-optimized.
         * 
         * @return builder
         * 
         */
        public Builder ebsOptimized(String ebsOptimized) {
            return ebsOptimized(Output.of(ebsOptimized));
        }

        /**
         * @param elasticGpuSpecifications The elastic GPU to attach to the instance. See Elastic GPU
         * below for more details.
         * 
         * @return builder
         * 
         */
        public Builder elasticGpuSpecifications(@Nullable Output<List<LaunchTemplateElasticGpuSpecificationArgs>> elasticGpuSpecifications) {
            $.elasticGpuSpecifications = elasticGpuSpecifications;
            return this;
        }

        /**
         * @param elasticGpuSpecifications The elastic GPU to attach to the instance. See Elastic GPU
         * below for more details.
         * 
         * @return builder
         * 
         */
        public Builder elasticGpuSpecifications(List<LaunchTemplateElasticGpuSpecificationArgs> elasticGpuSpecifications) {
            return elasticGpuSpecifications(Output.of(elasticGpuSpecifications));
        }

        /**
         * @param elasticGpuSpecifications The elastic GPU to attach to the instance. See Elastic GPU
         * below for more details.
         * 
         * @return builder
         * 
         */
        public Builder elasticGpuSpecifications(LaunchTemplateElasticGpuSpecificationArgs... elasticGpuSpecifications) {
            return elasticGpuSpecifications(List.of(elasticGpuSpecifications));
        }

        /**
         * @param elasticInferenceAccelerator Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
         * 
         * @return builder
         * 
         */
        public Builder elasticInferenceAccelerator(@Nullable Output<LaunchTemplateElasticInferenceAcceleratorArgs> elasticInferenceAccelerator) {
            $.elasticInferenceAccelerator = elasticInferenceAccelerator;
            return this;
        }

        /**
         * @param elasticInferenceAccelerator Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
         * 
         * @return builder
         * 
         */
        public Builder elasticInferenceAccelerator(LaunchTemplateElasticInferenceAcceleratorArgs elasticInferenceAccelerator) {
            return elasticInferenceAccelerator(Output.of(elasticInferenceAccelerator));
        }

        /**
         * @param enclaveOptions Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder enclaveOptions(@Nullable Output<LaunchTemplateEnclaveOptionsArgs> enclaveOptions) {
            $.enclaveOptions = enclaveOptions;
            return this;
        }

        /**
         * @param enclaveOptions Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder enclaveOptions(LaunchTemplateEnclaveOptionsArgs enclaveOptions) {
            return enclaveOptions(Output.of(enclaveOptions));
        }

        /**
         * @param hibernationOptions The hibernation options for the instance. See Hibernation Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder hibernationOptions(@Nullable Output<LaunchTemplateHibernationOptionsArgs> hibernationOptions) {
            $.hibernationOptions = hibernationOptions;
            return this;
        }

        /**
         * @param hibernationOptions The hibernation options for the instance. See Hibernation Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder hibernationOptions(LaunchTemplateHibernationOptionsArgs hibernationOptions) {
            return hibernationOptions(Output.of(hibernationOptions));
        }

        /**
         * @param iamInstanceProfile The IAM Instance Profile to launch the instance with. See Instance Profile
         * below for more details.
         * 
         * @return builder
         * 
         */
        public Builder iamInstanceProfile(@Nullable Output<LaunchTemplateIamInstanceProfileArgs> iamInstanceProfile) {
            $.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        /**
         * @param iamInstanceProfile The IAM Instance Profile to launch the instance with. See Instance Profile
         * below for more details.
         * 
         * @return builder
         * 
         */
        public Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileArgs iamInstanceProfile) {
            return iamInstanceProfile(Output.of(iamInstanceProfile));
        }

        /**
         * @param imageId The AMI from which to launch the instance.
         * 
         * @return builder
         * 
         */
        public Builder imageId(@Nullable Output<String> imageId) {
            $.imageId = imageId;
            return this;
        }

        /**
         * @param imageId The AMI from which to launch the instance.
         * 
         * @return builder
         * 
         */
        public Builder imageId(String imageId) {
            return imageId(Output.of(imageId));
        }

        /**
         * @param instanceInitiatedShutdownBehavior Shutdown behavior for the instance. Can be `stop` or `terminate`.
         * (Default: `stop`).
         * 
         * @return builder
         * 
         */
        public Builder instanceInitiatedShutdownBehavior(@Nullable Output<String> instanceInitiatedShutdownBehavior) {
            $.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        /**
         * @param instanceInitiatedShutdownBehavior Shutdown behavior for the instance. Can be `stop` or `terminate`.
         * (Default: `stop`).
         * 
         * @return builder
         * 
         */
        public Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            return instanceInitiatedShutdownBehavior(Output.of(instanceInitiatedShutdownBehavior));
        }

        /**
         * @param instanceMarketOptions The market (purchasing) option for the instance. See Market Options
         * below for details.
         * 
         * @return builder
         * 
         */
        public Builder instanceMarketOptions(@Nullable Output<LaunchTemplateInstanceMarketOptionsArgs> instanceMarketOptions) {
            $.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        /**
         * @param instanceMarketOptions The market (purchasing) option for the instance. See Market Options
         * below for details.
         * 
         * @return builder
         * 
         */
        public Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptionsArgs instanceMarketOptions) {
            return instanceMarketOptions(Output.of(instanceMarketOptions));
        }

        /**
         * @param instanceRequirements The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
         * 
         * @return builder
         * 
         */
        public Builder instanceRequirements(@Nullable Output<LaunchTemplateInstanceRequirementsArgs> instanceRequirements) {
            $.instanceRequirements = instanceRequirements;
            return this;
        }

        /**
         * @param instanceRequirements The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
         * 
         * @return builder
         * 
         */
        public Builder instanceRequirements(LaunchTemplateInstanceRequirementsArgs instanceRequirements) {
            return instanceRequirements(Output.of(instanceRequirements));
        }

        /**
         * @param instanceType The type of the instance. If present then `instance_requirements` cannot be present.
         * 
         * @return builder
         * 
         */
        public Builder instanceType(@Nullable Output<String> instanceType) {
            $.instanceType = instanceType;
            return this;
        }

        /**
         * @param instanceType The type of the instance. If present then `instance_requirements` cannot be present.
         * 
         * @return builder
         * 
         */
        public Builder instanceType(String instanceType) {
            return instanceType(Output.of(instanceType));
        }

        /**
         * @param kernelId The kernel ID.
         * 
         * @return builder
         * 
         */
        public Builder kernelId(@Nullable Output<String> kernelId) {
            $.kernelId = kernelId;
            return this;
        }

        /**
         * @param kernelId The kernel ID.
         * 
         * @return builder
         * 
         */
        public Builder kernelId(String kernelId) {
            return kernelId(Output.of(kernelId));
        }

        /**
         * @param keyName The key name to use for the instance.
         * 
         * @return builder
         * 
         */
        public Builder keyName(@Nullable Output<String> keyName) {
            $.keyName = keyName;
            return this;
        }

        /**
         * @param keyName The key name to use for the instance.
         * 
         * @return builder
         * 
         */
        public Builder keyName(String keyName) {
            return keyName(Output.of(keyName));
        }

        /**
         * @param licenseSpecifications A list of license specifications to associate with. See License Specification below for more details.
         * 
         * @return builder
         * 
         */
        public Builder licenseSpecifications(@Nullable Output<List<LaunchTemplateLicenseSpecificationArgs>> licenseSpecifications) {
            $.licenseSpecifications = licenseSpecifications;
            return this;
        }

        /**
         * @param licenseSpecifications A list of license specifications to associate with. See License Specification below for more details.
         * 
         * @return builder
         * 
         */
        public Builder licenseSpecifications(List<LaunchTemplateLicenseSpecificationArgs> licenseSpecifications) {
            return licenseSpecifications(Output.of(licenseSpecifications));
        }

        /**
         * @param licenseSpecifications A list of license specifications to associate with. See License Specification below for more details.
         * 
         * @return builder
         * 
         */
        public Builder licenseSpecifications(LaunchTemplateLicenseSpecificationArgs... licenseSpecifications) {
            return licenseSpecifications(List.of(licenseSpecifications));
        }

        /**
         * @param maintenanceOptions The maintenance options for the instance. See Maintenance Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder maintenanceOptions(@Nullable Output<LaunchTemplateMaintenanceOptionsArgs> maintenanceOptions) {
            $.maintenanceOptions = maintenanceOptions;
            return this;
        }

        /**
         * @param maintenanceOptions The maintenance options for the instance. See Maintenance Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder maintenanceOptions(LaunchTemplateMaintenanceOptionsArgs maintenanceOptions) {
            return maintenanceOptions(Output.of(maintenanceOptions));
        }

        /**
         * @param metadataOptions Customize the metadata options for the instance. See Metadata Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder metadataOptions(@Nullable Output<LaunchTemplateMetadataOptionsArgs> metadataOptions) {
            $.metadataOptions = metadataOptions;
            return this;
        }

        /**
         * @param metadataOptions Customize the metadata options for the instance. See Metadata Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder metadataOptions(LaunchTemplateMetadataOptionsArgs metadataOptions) {
            return metadataOptions(Output.of(metadataOptions));
        }

        /**
         * @param monitoring The monitoring option for the instance. See Monitoring below for more details.
         * 
         * @return builder
         * 
         */
        public Builder monitoring(@Nullable Output<LaunchTemplateMonitoringArgs> monitoring) {
            $.monitoring = monitoring;
            return this;
        }

        /**
         * @param monitoring The monitoring option for the instance. See Monitoring below for more details.
         * 
         * @return builder
         * 
         */
        public Builder monitoring(LaunchTemplateMonitoringArgs monitoring) {
            return monitoring(Output.of(monitoring));
        }

        /**
         * @param name The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(@Nullable Output<String> namePrefix) {
            $.namePrefix = namePrefix;
            return this;
        }

        /**
         * @param namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
         * 
         * @return builder
         * 
         */
        public Builder namePrefix(String namePrefix) {
            return namePrefix(Output.of(namePrefix));
        }

        /**
         * @param networkInterfaces Customize network interfaces to be attached at instance boot time. See Network
         * Interfaces below for more details.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaces(@Nullable Output<List<LaunchTemplateNetworkInterfaceArgs>> networkInterfaces) {
            $.networkInterfaces = networkInterfaces;
            return this;
        }

        /**
         * @param networkInterfaces Customize network interfaces to be attached at instance boot time. See Network
         * Interfaces below for more details.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaces(List<LaunchTemplateNetworkInterfaceArgs> networkInterfaces) {
            return networkInterfaces(Output.of(networkInterfaces));
        }

        /**
         * @param networkInterfaces Customize network interfaces to be attached at instance boot time. See Network
         * Interfaces below for more details.
         * 
         * @return builder
         * 
         */
        public Builder networkInterfaces(LaunchTemplateNetworkInterfaceArgs... networkInterfaces) {
            return networkInterfaces(List.of(networkInterfaces));
        }

        /**
         * @param placement The placement of the instance. See Placement below for more details.
         * 
         * @return builder
         * 
         */
        public Builder placement(@Nullable Output<LaunchTemplatePlacementArgs> placement) {
            $.placement = placement;
            return this;
        }

        /**
         * @param placement The placement of the instance. See Placement below for more details.
         * 
         * @return builder
         * 
         */
        public Builder placement(LaunchTemplatePlacementArgs placement) {
            return placement(Output.of(placement));
        }

        /**
         * @param privateDnsNameOptions The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder privateDnsNameOptions(@Nullable Output<LaunchTemplatePrivateDnsNameOptionsArgs> privateDnsNameOptions) {
            $.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        /**
         * @param privateDnsNameOptions The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
         * 
         * @return builder
         * 
         */
        public Builder privateDnsNameOptions(LaunchTemplatePrivateDnsNameOptionsArgs privateDnsNameOptions) {
            return privateDnsNameOptions(Output.of(privateDnsNameOptions));
        }

        /**
         * @param ramDiskId The ID of the RAM disk.
         * 
         * @return builder
         * 
         */
        public Builder ramDiskId(@Nullable Output<String> ramDiskId) {
            $.ramDiskId = ramDiskId;
            return this;
        }

        /**
         * @param ramDiskId The ID of the RAM disk.
         * 
         * @return builder
         * 
         */
        public Builder ramDiskId(String ramDiskId) {
            return ramDiskId(Output.of(ramDiskId));
        }

        /**
         * @param securityGroupNames A list of security group names to associate with. If you are creating Instances in a VPC, use
         * `vpc_security_group_ids` instead.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupNames(@Nullable Output<List<String>> securityGroupNames) {
            $.securityGroupNames = securityGroupNames;
            return this;
        }

        /**
         * @param securityGroupNames A list of security group names to associate with. If you are creating Instances in a VPC, use
         * `vpc_security_group_ids` instead.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupNames(List<String> securityGroupNames) {
            return securityGroupNames(Output.of(securityGroupNames));
        }

        /**
         * @param securityGroupNames A list of security group names to associate with. If you are creating Instances in a VPC, use
         * `vpc_security_group_ids` instead.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupNames(String... securityGroupNames) {
            return securityGroupNames(List.of(securityGroupNames));
        }

        /**
         * @param tagSpecifications The tags to apply to the resources during launch. See Tag Specifications below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tagSpecifications(@Nullable Output<List<LaunchTemplateTagSpecificationArgs>> tagSpecifications) {
            $.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * @param tagSpecifications The tags to apply to the resources during launch. See Tag Specifications below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tagSpecifications(List<LaunchTemplateTagSpecificationArgs> tagSpecifications) {
            return tagSpecifications(Output.of(tagSpecifications));
        }

        /**
         * @param tagSpecifications The tags to apply to the resources during launch. See Tag Specifications below for more details.
         * 
         * @return builder
         * 
         */
        public Builder tagSpecifications(LaunchTemplateTagSpecificationArgs... tagSpecifications) {
            return tagSpecifications(List.of(tagSpecifications));
        }

        /**
         * @param tags A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param updateDefaultVersion Whether to update Default Version each update. Conflicts with `default_version`.
         * 
         * @return builder
         * 
         */
        public Builder updateDefaultVersion(@Nullable Output<Boolean> updateDefaultVersion) {
            $.updateDefaultVersion = updateDefaultVersion;
            return this;
        }

        /**
         * @param updateDefaultVersion Whether to update Default Version each update. Conflicts with `default_version`.
         * 
         * @return builder
         * 
         */
        public Builder updateDefaultVersion(Boolean updateDefaultVersion) {
            return updateDefaultVersion(Output.of(updateDefaultVersion));
        }

        /**
         * @param userData The base64-encoded user data to provide when launching the instance.
         * 
         * @return builder
         * 
         */
        public Builder userData(@Nullable Output<String> userData) {
            $.userData = userData;
            return this;
        }

        /**
         * @param userData The base64-encoded user data to provide when launching the instance.
         * 
         * @return builder
         * 
         */
        public Builder userData(String userData) {
            return userData(Output.of(userData));
        }

        /**
         * @param vpcSecurityGroupIds A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            $.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * @param vpcSecurityGroupIds A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(Output.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSecurityGroupIds A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        public LaunchTemplateArgs build() {
            return $;
        }
    }

}
