// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.LaunchTemplateArgs;
import com.pulumi.aws.ec2.inputs.LaunchTemplateState;
import com.pulumi.aws.ec2.outputs.LaunchTemplateBlockDeviceMapping;
import com.pulumi.aws.ec2.outputs.LaunchTemplateCapacityReservationSpecification;
import com.pulumi.aws.ec2.outputs.LaunchTemplateCpuOptions;
import com.pulumi.aws.ec2.outputs.LaunchTemplateCreditSpecification;
import com.pulumi.aws.ec2.outputs.LaunchTemplateElasticGpuSpecification;
import com.pulumi.aws.ec2.outputs.LaunchTemplateElasticInferenceAccelerator;
import com.pulumi.aws.ec2.outputs.LaunchTemplateEnclaveOptions;
import com.pulumi.aws.ec2.outputs.LaunchTemplateHibernationOptions;
import com.pulumi.aws.ec2.outputs.LaunchTemplateIamInstanceProfile;
import com.pulumi.aws.ec2.outputs.LaunchTemplateInstanceMarketOptions;
import com.pulumi.aws.ec2.outputs.LaunchTemplateInstanceRequirements;
import com.pulumi.aws.ec2.outputs.LaunchTemplateLicenseSpecification;
import com.pulumi.aws.ec2.outputs.LaunchTemplateMaintenanceOptions;
import com.pulumi.aws.ec2.outputs.LaunchTemplateMetadataOptions;
import com.pulumi.aws.ec2.outputs.LaunchTemplateMonitoring;
import com.pulumi.aws.ec2.outputs.LaunchTemplateNetworkInterface;
import com.pulumi.aws.ec2.outputs.LaunchTemplatePlacement;
import com.pulumi.aws.ec2.outputs.LaunchTemplatePrivateDnsNameOptions;
import com.pulumi.aws.ec2.outputs.LaunchTemplateTagSpecification;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an EC2 launch template resource. Can be used to create instances or auto scaling groups.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LaunchTemplate;
 * import com.pulumi.aws.ec2.LaunchTemplateArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingEbsArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateCpuOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateCreditSpecificationArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateElasticGpuSpecificationArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateElasticInferenceAcceleratorArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateIamInstanceProfileArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceMarketOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateLicenseSpecificationArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateMetadataOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateMonitoringArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateNetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplatePlacementArgs;
 * import com.pulumi.aws.ec2.inputs.LaunchTemplateTagSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var foo = new LaunchTemplate(&#34;foo&#34;, LaunchTemplateArgs.builder()        
 *             .blockDeviceMappings(LaunchTemplateBlockDeviceMappingArgs.builder()
 *                 .deviceName(&#34;/dev/sdf&#34;)
 *                 .ebs(LaunchTemplateBlockDeviceMappingEbsArgs.builder()
 *                     .volumeSize(20)
 *                     .build())
 *                 .build())
 *             .capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationArgs.builder()
 *                 .capacityReservationPreference(&#34;open&#34;)
 *                 .build())
 *             .cpuOptions(LaunchTemplateCpuOptionsArgs.builder()
 *                 .coreCount(4)
 *                 .threadsPerCore(2)
 *                 .build())
 *             .creditSpecification(LaunchTemplateCreditSpecificationArgs.builder()
 *                 .cpuCredits(&#34;standard&#34;)
 *                 .build())
 *             .disableApiStop(true)
 *             .disableApiTermination(true)
 *             .ebsOptimized(true)
 *             .elasticGpuSpecifications(LaunchTemplateElasticGpuSpecificationArgs.builder()
 *                 .type(&#34;test&#34;)
 *                 .build())
 *             .elasticInferenceAccelerator(LaunchTemplateElasticInferenceAcceleratorArgs.builder()
 *                 .type(&#34;eia1.medium&#34;)
 *                 .build())
 *             .iamInstanceProfile(LaunchTemplateIamInstanceProfileArgs.builder()
 *                 .name(&#34;test&#34;)
 *                 .build())
 *             .imageId(&#34;ami-test&#34;)
 *             .instanceInitiatedShutdownBehavior(&#34;terminate&#34;)
 *             .instanceMarketOptions(LaunchTemplateInstanceMarketOptionsArgs.builder()
 *                 .marketType(&#34;spot&#34;)
 *                 .build())
 *             .instanceType(&#34;t2.micro&#34;)
 *             .kernelId(&#34;test&#34;)
 *             .keyName(&#34;test&#34;)
 *             .licenseSpecifications(LaunchTemplateLicenseSpecificationArgs.builder()
 *                 .licenseConfigurationArn(&#34;arn:aws:license-manager:eu-west-1:123456789012:license-configuration:lic-0123456789abcdef0123456789abcdef&#34;)
 *                 .build())
 *             .metadataOptions(LaunchTemplateMetadataOptionsArgs.builder()
 *                 .httpEndpoint(&#34;enabled&#34;)
 *                 .httpTokens(&#34;required&#34;)
 *                 .httpPutResponseHopLimit(1)
 *                 .instanceMetadataTags(&#34;enabled&#34;)
 *                 .build())
 *             .monitoring(LaunchTemplateMonitoringArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .networkInterfaces(LaunchTemplateNetworkInterfaceArgs.builder()
 *                 .associatePublicIpAddress(true)
 *                 .build())
 *             .placement(LaunchTemplatePlacementArgs.builder()
 *                 .availabilityZone(&#34;us-west-2a&#34;)
 *                 .build())
 *             .ramDiskId(&#34;test&#34;)
 *             .vpcSecurityGroupIds(&#34;sg-12345678&#34;)
 *             .tagSpecifications(LaunchTemplateTagSpecificationArgs.builder()
 *                 .resourceType(&#34;instance&#34;)
 *                 .tags(Map.of(&#34;Name&#34;, &#34;test&#34;))
 *                 .build())
 *             .userData(Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get(String.format(&#34;%s/example.sh&#34;, path.module())))))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Launch Templates using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/launchTemplate:LaunchTemplate web lt-12345678
 * ```
 * 
 */
@ResourceType(type="aws:ec2/launchTemplate:LaunchTemplate")
public class LaunchTemplate extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the instance profile.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the instance profile.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     * 
     */
    @Export(name="blockDeviceMappings", refs={List.class,LaunchTemplateBlockDeviceMapping.class}, tree="[0,1]")
    private Output</* @Nullable */ List<LaunchTemplateBlockDeviceMapping>> blockDeviceMappings;

    /**
     * @return Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     * 
     */
    public Output<Optional<List<LaunchTemplateBlockDeviceMapping>>> blockDeviceMappings() {
        return Codegen.optional(this.blockDeviceMappings);
    }
    /**
     * Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
     * 
     */
    @Export(name="capacityReservationSpecification", refs={LaunchTemplateCapacityReservationSpecification.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateCapacityReservationSpecification> capacityReservationSpecification;

    /**
     * @return Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
     * 
     */
    public Output<Optional<LaunchTemplateCapacityReservationSpecification>> capacityReservationSpecification() {
        return Codegen.optional(this.capacityReservationSpecification);
    }
    /**
     * The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    @Export(name="cpuOptions", refs={LaunchTemplateCpuOptions.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateCpuOptions> cpuOptions;

    /**
     * @return The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    public Output<Optional<LaunchTemplateCpuOptions>> cpuOptions() {
        return Codegen.optional(this.cpuOptions);
    }
    /**
     * Customize the credit specification of the instance. See Credit
     * Specification below for more details.
     * 
     */
    @Export(name="creditSpecification", refs={LaunchTemplateCreditSpecification.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateCreditSpecification> creditSpecification;

    /**
     * @return Customize the credit specification of the instance. See Credit
     * Specification below for more details.
     * 
     */
    public Output<Optional<LaunchTemplateCreditSpecification>> creditSpecification() {
        return Codegen.optional(this.creditSpecification);
    }
    /**
     * Default Version of the launch template.
     * 
     */
    @Export(name="defaultVersion", refs={Integer.class}, tree="[0]")
    private Output<Integer> defaultVersion;

    /**
     * @return Default Version of the launch template.
     * 
     */
    public Output<Integer> defaultVersion() {
        return this.defaultVersion;
    }
    /**
     * Description of the launch template.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description of the launch template.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    @Export(name="disableApiStop", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> disableApiStop;

    /**
     * @return If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    public Output<Optional<Boolean>> disableApiStop() {
        return Codegen.optional(this.disableApiStop);
    }
    /**
     * If `true`, enables [EC2 Instance
     * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination)
     * 
     */
    @Export(name="disableApiTermination", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> disableApiTermination;

    /**
     * @return If `true`, enables [EC2 Instance
     * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination)
     * 
     */
    public Output<Optional<Boolean>> disableApiTermination() {
        return Codegen.optional(this.disableApiTermination);
    }
    /**
     * If `true`, the launched EC2 instance will be EBS-optimized.
     * 
     */
    @Export(name="ebsOptimized", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> ebsOptimized;

    /**
     * @return If `true`, the launched EC2 instance will be EBS-optimized.
     * 
     */
    public Output<Optional<String>> ebsOptimized() {
        return Codegen.optional(this.ebsOptimized);
    }
    /**
     * The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     * 
     */
    @Export(name="elasticGpuSpecifications", refs={List.class,LaunchTemplateElasticGpuSpecification.class}, tree="[0,1]")
    private Output</* @Nullable */ List<LaunchTemplateElasticGpuSpecification>> elasticGpuSpecifications;

    /**
     * @return The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     * 
     */
    public Output<Optional<List<LaunchTemplateElasticGpuSpecification>>> elasticGpuSpecifications() {
        return Codegen.optional(this.elasticGpuSpecifications);
    }
    /**
     * Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
     * 
     */
    @Export(name="elasticInferenceAccelerator", refs={LaunchTemplateElasticInferenceAccelerator.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerator;

    /**
     * @return Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
     * 
     */
    public Output<Optional<LaunchTemplateElasticInferenceAccelerator>> elasticInferenceAccelerator() {
        return Codegen.optional(this.elasticInferenceAccelerator);
    }
    /**
     * Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    @Export(name="enclaveOptions", refs={LaunchTemplateEnclaveOptions.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateEnclaveOptions> enclaveOptions;

    /**
     * @return Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    public Output<Optional<LaunchTemplateEnclaveOptions>> enclaveOptions() {
        return Codegen.optional(this.enclaveOptions);
    }
    /**
     * The hibernation options for the instance. See Hibernation Options below for more details.
     * 
     */
    @Export(name="hibernationOptions", refs={LaunchTemplateHibernationOptions.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateHibernationOptions> hibernationOptions;

    /**
     * @return The hibernation options for the instance. See Hibernation Options below for more details.
     * 
     */
    public Output<Optional<LaunchTemplateHibernationOptions>> hibernationOptions() {
        return Codegen.optional(this.hibernationOptions);
    }
    /**
     * The IAM Instance Profile to launch the instance with. See Instance Profile
     * below for more details.
     * 
     */
    @Export(name="iamInstanceProfile", refs={LaunchTemplateIamInstanceProfile.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateIamInstanceProfile> iamInstanceProfile;

    /**
     * @return The IAM Instance Profile to launch the instance with. See Instance Profile
     * below for more details.
     * 
     */
    public Output<Optional<LaunchTemplateIamInstanceProfile>> iamInstanceProfile() {
        return Codegen.optional(this.iamInstanceProfile);
    }
    /**
     * The AMI from which to launch the instance.
     * 
     */
    @Export(name="imageId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> imageId;

    /**
     * @return The AMI from which to launch the instance.
     * 
     */
    public Output<Optional<String>> imageId() {
        return Codegen.optional(this.imageId);
    }
    /**
     * Shutdown behavior for the instance. Can be `stop` or `terminate`.
     * (Default: `stop`).
     * 
     */
    @Export(name="instanceInitiatedShutdownBehavior", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> instanceInitiatedShutdownBehavior;

    /**
     * @return Shutdown behavior for the instance. Can be `stop` or `terminate`.
     * (Default: `stop`).
     * 
     */
    public Output<Optional<String>> instanceInitiatedShutdownBehavior() {
        return Codegen.optional(this.instanceInitiatedShutdownBehavior);
    }
    /**
     * The market (purchasing) option for the instance. See Market Options
     * below for details.
     * 
     */
    @Export(name="instanceMarketOptions", refs={LaunchTemplateInstanceMarketOptions.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateInstanceMarketOptions> instanceMarketOptions;

    /**
     * @return The market (purchasing) option for the instance. See Market Options
     * below for details.
     * 
     */
    public Output<Optional<LaunchTemplateInstanceMarketOptions>> instanceMarketOptions() {
        return Codegen.optional(this.instanceMarketOptions);
    }
    /**
     * The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
     * 
     */
    @Export(name="instanceRequirements", refs={LaunchTemplateInstanceRequirements.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateInstanceRequirements> instanceRequirements;

    /**
     * @return The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
     * 
     */
    public Output<Optional<LaunchTemplateInstanceRequirements>> instanceRequirements() {
        return Codegen.optional(this.instanceRequirements);
    }
    /**
     * The type of the instance. If present then `instance_requirements` cannot be present.
     * 
     */
    @Export(name="instanceType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> instanceType;

    /**
     * @return The type of the instance. If present then `instance_requirements` cannot be present.
     * 
     */
    public Output<Optional<String>> instanceType() {
        return Codegen.optional(this.instanceType);
    }
    /**
     * The kernel ID.
     * 
     */
    @Export(name="kernelId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> kernelId;

    /**
     * @return The kernel ID.
     * 
     */
    public Output<Optional<String>> kernelId() {
        return Codegen.optional(this.kernelId);
    }
    /**
     * The key name to use for the instance.
     * 
     */
    @Export(name="keyName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> keyName;

    /**
     * @return The key name to use for the instance.
     * 
     */
    public Output<Optional<String>> keyName() {
        return Codegen.optional(this.keyName);
    }
    /**
     * The latest version of the launch template.
     * 
     */
    @Export(name="latestVersion", refs={Integer.class}, tree="[0]")
    private Output<Integer> latestVersion;

    /**
     * @return The latest version of the launch template.
     * 
     */
    public Output<Integer> latestVersion() {
        return this.latestVersion;
    }
    /**
     * A list of license specifications to associate with. See License Specification below for more details.
     * 
     */
    @Export(name="licenseSpecifications", refs={List.class,LaunchTemplateLicenseSpecification.class}, tree="[0,1]")
    private Output</* @Nullable */ List<LaunchTemplateLicenseSpecification>> licenseSpecifications;

    /**
     * @return A list of license specifications to associate with. See License Specification below for more details.
     * 
     */
    public Output<Optional<List<LaunchTemplateLicenseSpecification>>> licenseSpecifications() {
        return Codegen.optional(this.licenseSpecifications);
    }
    /**
     * The maintenance options for the instance. See Maintenance Options below for more details.
     * 
     */
    @Export(name="maintenanceOptions", refs={LaunchTemplateMaintenanceOptions.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateMaintenanceOptions> maintenanceOptions;

    /**
     * @return The maintenance options for the instance. See Maintenance Options below for more details.
     * 
     */
    public Output<Optional<LaunchTemplateMaintenanceOptions>> maintenanceOptions() {
        return Codegen.optional(this.maintenanceOptions);
    }
    /**
     * Customize the metadata options for the instance. See Metadata Options below for more details.
     * 
     */
    @Export(name="metadataOptions", refs={LaunchTemplateMetadataOptions.class}, tree="[0]")
    private Output<LaunchTemplateMetadataOptions> metadataOptions;

    /**
     * @return Customize the metadata options for the instance. See Metadata Options below for more details.
     * 
     */
    public Output<LaunchTemplateMetadataOptions> metadataOptions() {
        return this.metadataOptions;
    }
    /**
     * The monitoring option for the instance. See Monitoring below for more details.
     * 
     */
    @Export(name="monitoring", refs={LaunchTemplateMonitoring.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplateMonitoring> monitoring;

    /**
     * @return The monitoring option for the instance. See Monitoring below for more details.
     * 
     */
    public Output<Optional<LaunchTemplateMonitoring>> monitoring() {
        return Codegen.optional(this.monitoring);
    }
    /**
     * The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     * 
     */
    @Export(name="namePrefix", refs={String.class}, tree="[0]")
    private Output<String> namePrefix;

    /**
     * @return Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     * 
     */
    public Output<String> namePrefix() {
        return this.namePrefix;
    }
    /**
     * Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     * 
     */
    @Export(name="networkInterfaces", refs={List.class,LaunchTemplateNetworkInterface.class}, tree="[0,1]")
    private Output</* @Nullable */ List<LaunchTemplateNetworkInterface>> networkInterfaces;

    /**
     * @return Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     * 
     */
    public Output<Optional<List<LaunchTemplateNetworkInterface>>> networkInterfaces() {
        return Codegen.optional(this.networkInterfaces);
    }
    /**
     * The placement of the instance. See Placement below for more details.
     * 
     */
    @Export(name="placement", refs={LaunchTemplatePlacement.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplatePlacement> placement;

    /**
     * @return The placement of the instance. See Placement below for more details.
     * 
     */
    public Output<Optional<LaunchTemplatePlacement>> placement() {
        return Codegen.optional(this.placement);
    }
    /**
     * The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    @Export(name="privateDnsNameOptions", refs={LaunchTemplatePrivateDnsNameOptions.class}, tree="[0]")
    private Output</* @Nullable */ LaunchTemplatePrivateDnsNameOptions> privateDnsNameOptions;

    /**
     * @return The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    public Output<Optional<LaunchTemplatePrivateDnsNameOptions>> privateDnsNameOptions() {
        return Codegen.optional(this.privateDnsNameOptions);
    }
    /**
     * The ID of the RAM disk.
     * 
     */
    @Export(name="ramDiskId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> ramDiskId;

    /**
     * @return The ID of the RAM disk.
     * 
     */
    public Output<Optional<String>> ramDiskId() {
        return Codegen.optional(this.ramDiskId);
    }
    /**
     * A list of security group names to associate with. If you are creating Instances in a VPC, use
     * `vpc_security_group_ids` instead.
     * 
     */
    @Export(name="securityGroupNames", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> securityGroupNames;

    /**
     * @return A list of security group names to associate with. If you are creating Instances in a VPC, use
     * `vpc_security_group_ids` instead.
     * 
     */
    public Output<Optional<List<String>>> securityGroupNames() {
        return Codegen.optional(this.securityGroupNames);
    }
    /**
     * The tags to apply to the resources during launch. See Tag Specifications below for more details.
     * 
     */
    @Export(name="tagSpecifications", refs={List.class,LaunchTemplateTagSpecification.class}, tree="[0,1]")
    private Output</* @Nullable */ List<LaunchTemplateTagSpecification>> tagSpecifications;

    /**
     * @return The tags to apply to the resources during launch. See Tag Specifications below for more details.
     * 
     */
    public Output<Optional<List<LaunchTemplateTagSpecification>>> tagSpecifications() {
        return Codegen.optional(this.tagSpecifications);
    }
    /**
     * A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Whether to update Default Version each update. Conflicts with `default_version`.
     * 
     */
    @Export(name="updateDefaultVersion", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> updateDefaultVersion;

    /**
     * @return Whether to update Default Version each update. Conflicts with `default_version`.
     * 
     */
    public Output<Optional<Boolean>> updateDefaultVersion() {
        return Codegen.optional(this.updateDefaultVersion);
    }
    /**
     * The base64-encoded user data to provide when launching the instance.
     * 
     */
    @Export(name="userData", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> userData;

    /**
     * @return The base64-encoded user data to provide when launching the instance.
     * 
     */
    public Output<Optional<String>> userData() {
        return Codegen.optional(this.userData);
    }
    /**
     * A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
     * 
     */
    @Export(name="vpcSecurityGroupIds", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> vpcSecurityGroupIds;

    /**
     * @return A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
     * 
     */
    public Output<Optional<List<String>>> vpcSecurityGroupIds() {
        return Codegen.optional(this.vpcSecurityGroupIds);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LaunchTemplate(String name) {
        this(name, LaunchTemplateArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LaunchTemplate(String name, @Nullable LaunchTemplateArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LaunchTemplate(String name, @Nullable LaunchTemplateArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/launchTemplate:LaunchTemplate", name, args == null ? LaunchTemplateArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LaunchTemplate(String name, Output<String> id, @Nullable LaunchTemplateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/launchTemplate:LaunchTemplate", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LaunchTemplate get(String name, Output<String> id, @Nullable LaunchTemplateState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LaunchTemplate(name, id, state, options);
    }
}
