// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.InstanceArgs;
import com.pulumi.aws.ec2.inputs.InstanceState;
import com.pulumi.aws.ec2.outputs.InstanceCapacityReservationSpecification;
import com.pulumi.aws.ec2.outputs.InstanceCpuOptions;
import com.pulumi.aws.ec2.outputs.InstanceCreditSpecification;
import com.pulumi.aws.ec2.outputs.InstanceEbsBlockDevice;
import com.pulumi.aws.ec2.outputs.InstanceEnclaveOptions;
import com.pulumi.aws.ec2.outputs.InstanceEphemeralBlockDevice;
import com.pulumi.aws.ec2.outputs.InstanceInstanceMarketOptions;
import com.pulumi.aws.ec2.outputs.InstanceLaunchTemplate;
import com.pulumi.aws.ec2.outputs.InstanceMaintenanceOptions;
import com.pulumi.aws.ec2.outputs.InstanceMetadataOptions;
import com.pulumi.aws.ec2.outputs.InstanceNetworkInterface;
import com.pulumi.aws.ec2.outputs.InstancePrivateDnsNameOptions;
import com.pulumi.aws.ec2.outputs.InstanceRootBlockDevice;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an EC2 instance resource. This allows instances to be created, updated, and deleted.
 * 
 * ## Example Usage
 * ### Basic example using AMI lookup
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var ubuntu = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .filters(            
 *                 GetAmiFilterArgs.builder()
 *                     .name(&#34;name&#34;)
 *                     .values(&#34;ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-*&#34;)
 *                     .build(),
 *                 GetAmiFilterArgs.builder()
 *                     .name(&#34;virtualization-type&#34;)
 *                     .values(&#34;hvm&#34;)
 *                     .build())
 *             .owners(&#34;099720109477&#34;)
 *             .build());
 * 
 *         var web = new Instance(&#34;web&#34;, InstanceArgs.builder()        
 *             .ami(ubuntu.applyValue(getAmiResult -&gt; getAmiResult.id()))
 *             .instanceType(&#34;t3.micro&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;HelloWorld&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Spot instance example
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsSpotOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var thisAmi = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners(&#34;amazon&#34;)
 *             .filters(            
 *                 GetAmiFilterArgs.builder()
 *                     .name(&#34;architecture&#34;)
 *                     .values(&#34;arm64&#34;)
 *                     .build(),
 *                 GetAmiFilterArgs.builder()
 *                     .name(&#34;name&#34;)
 *                     .values(&#34;al2023-ami-2023*&#34;)
 *                     .build())
 *             .build());
 * 
 *         var thisInstance = new Instance(&#34;thisInstance&#34;, InstanceArgs.builder()        
 *             .ami(thisAmi.applyValue(getAmiResult -&gt; getAmiResult.id()))
 *             .instanceMarketOptions(InstanceInstanceMarketOptionsArgs.builder()
 *                 .spotOptions(InstanceInstanceMarketOptionsSpotOptionsArgs.builder()
 *                     .maxPrice(0.0031)
 *                     .build())
 *                 .build())
 *             .instanceType(&#34;t4g.nano&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;test-spot&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Network and credit specification example
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.NetworkInterface;
 * import com.pulumi.aws.ec2.NetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceNetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceCreditSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myVpc = new Vpc(&#34;myVpc&#34;, VpcArgs.builder()        
 *             .cidrBlock(&#34;172.16.0.0/16&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;tf-example&#34;))
 *             .build());
 * 
 *         var mySubnet = new Subnet(&#34;mySubnet&#34;, SubnetArgs.builder()        
 *             .vpcId(myVpc.id())
 *             .cidrBlock(&#34;172.16.10.0/24&#34;)
 *             .availabilityZone(&#34;us-west-2a&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;tf-example&#34;))
 *             .build());
 * 
 *         var fooNetworkInterface = new NetworkInterface(&#34;fooNetworkInterface&#34;, NetworkInterfaceArgs.builder()        
 *             .subnetId(mySubnet.id())
 *             .privateIps(&#34;172.16.10.100&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;primary_network_interface&#34;))
 *             .build());
 * 
 *         var fooInstance = new Instance(&#34;fooInstance&#34;, InstanceArgs.builder()        
 *             .ami(&#34;ami-005e54dee72cc1d00&#34;)
 *             .instanceType(&#34;t2.micro&#34;)
 *             .networkInterfaces(InstanceNetworkInterfaceArgs.builder()
 *                 .networkInterfaceId(fooNetworkInterface.id())
 *                 .deviceIndex(0)
 *                 .build())
 *             .creditSpecification(InstanceCreditSpecificationArgs.builder()
 *                 .cpuCredits(&#34;unlimited&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### CPU options example
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceCpuOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc(&#34;exampleVpc&#34;, VpcArgs.builder()        
 *             .cidrBlock(&#34;172.16.0.0/16&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;tf-example&#34;))
 *             .build());
 * 
 *         var exampleSubnet = new Subnet(&#34;exampleSubnet&#34;, SubnetArgs.builder()        
 *             .vpcId(exampleVpc.id())
 *             .cidrBlock(&#34;172.16.10.0/24&#34;)
 *             .availabilityZone(&#34;us-east-2a&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;tf-example&#34;))
 *             .build());
 * 
 *         final var amzn-linux-2023-ami = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners(&#34;amazon&#34;)
 *             .filters(GetAmiFilterArgs.builder()
 *                 .name(&#34;name&#34;)
 *                 .values(&#34;al2023-ami-2023.*-x86_64&#34;)
 *                 .build())
 *             .build());
 * 
 *         var exampleInstance = new Instance(&#34;exampleInstance&#34;, InstanceArgs.builder()        
 *             .ami(amzn_linux_2023_ami.id())
 *             .instanceType(&#34;c6a.2xlarge&#34;)
 *             .subnetId(exampleSubnet.id())
 *             .cpuOptions(InstanceCpuOptionsArgs.builder()
 *                 .coreCount(2)
 *                 .threadsPerCore(2)
 *                 .build())
 *             .tags(Map.of(&#34;Name&#34;, &#34;tf-example&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Host resource group or Licence Manager registered AMI example
 * 
 * A host resource group is a collection of Dedicated Hosts that you can manage as a single entity. As you launch instances, License Manager allocates the hosts and launches instances on them based on the settings that you configured. You can add existing Dedicated Hosts to a host resource group and take advantage of automated host management through License Manager.
 * 
 * &gt; **NOTE:** A dedicated host is automatically associated with a License Manager host resource group if **Allocate hosts automatically** is enabled. Otherwise, use the `host_resource_group_arn` argument to explicitly associate the instance with the host resource group.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var this_ = new Instance(&#34;this&#34;, InstanceArgs.builder()        
 *             .ami(&#34;ami-0dcc1e21636832c5d&#34;)
 *             .hostResourceGroupArn(&#34;arn:aws:resource-groups:us-west-2:012345678901:group/win-testhost&#34;)
 *             .instanceType(&#34;m5.large&#34;)
 *             .tenancy(&#34;host&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import instances using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/instance:Instance web i-12345678
 * ```
 * 
 */
@ResourceType(type="aws:ec2/instance:Instance")
public class Instance extends com.pulumi.resources.CustomResource {
    /**
     * AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     * 
     */
    @Export(name="ami", refs={String.class}, tree="[0]")
    private Output<String> ami;

    /**
     * @return AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     * 
     */
    public Output<String> ami() {
        return this.ami;
    }
    /**
     * ARN of the instance.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the instance.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Whether to associate a public IP address with an instance in a VPC.
     * 
     */
    @Export(name="associatePublicIpAddress", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> associatePublicIpAddress;

    /**
     * @return Whether to associate a public IP address with an instance in a VPC.
     * 
     */
    public Output<Boolean> associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }
    /**
     * AZ to start the instance in.
     * 
     */
    @Export(name="availabilityZone", refs={String.class}, tree="[0]")
    private Output<String> availabilityZone;

    /**
     * @return AZ to start the instance in.
     * 
     */
    public Output<String> availabilityZone() {
        return this.availabilityZone;
    }
    /**
     * Describes an instance&#39;s Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * 
     * &gt; **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     * 
     */
    @Export(name="capacityReservationSpecification", refs={InstanceCapacityReservationSpecification.class}, tree="[0]")
    private Output<InstanceCapacityReservationSpecification> capacityReservationSpecification;

    /**
     * @return Describes an instance&#39;s Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * 
     * &gt; **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     * 
     */
    public Output<InstanceCapacityReservationSpecification> capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }
    /**
     * Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     * 
     * @deprecated
     * use &#39;cpu_options&#39; argument instead
     * 
     */
    @Deprecated /* use 'cpu_options' argument instead */
    @Export(name="cpuCoreCount", refs={Integer.class}, tree="[0]")
    private Output<Integer> cpuCoreCount;

    /**
     * @return Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     * 
     */
    public Output<Integer> cpuCoreCount() {
        return this.cpuCoreCount;
    }
    /**
     * The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    @Export(name="cpuOptions", refs={InstanceCpuOptions.class}, tree="[0]")
    private Output<InstanceCpuOptions> cpuOptions;

    /**
     * @return The CPU options for the instance. See CPU Options below for more details.
     * 
     */
    public Output<InstanceCpuOptions> cpuOptions() {
        return this.cpuOptions;
    }
    /**
     * If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     * 
     * @deprecated
     * use &#39;cpu_options&#39; argument instead
     * 
     */
    @Deprecated /* use 'cpu_options' argument instead */
    @Export(name="cpuThreadsPerCore", refs={Integer.class}, tree="[0]")
    private Output<Integer> cpuThreadsPerCore;

    /**
     * @return If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     * 
     */
    public Output<Integer> cpuThreadsPerCore() {
        return this.cpuThreadsPerCore;
    }
    /**
     * Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     * 
     */
    @Export(name="creditSpecification", refs={InstanceCreditSpecification.class}, tree="[0]")
    private Output</* @Nullable */ InstanceCreditSpecification> creditSpecification;

    /**
     * @return Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     * 
     */
    public Output<Optional<InstanceCreditSpecification>> creditSpecification() {
        return Codegen.optional(this.creditSpecification);
    }
    /**
     * If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    @Export(name="disableApiStop", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> disableApiStop;

    /**
     * @return If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     * 
     */
    public Output<Boolean> disableApiStop() {
        return this.disableApiStop;
    }
    /**
     * If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     * 
     */
    @Export(name="disableApiTermination", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> disableApiTermination;

    /**
     * @return If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     * 
     */
    public Output<Boolean> disableApiTermination() {
        return this.disableApiTermination;
    }
    /**
     * One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    @Export(name="ebsBlockDevices", refs={List.class,InstanceEbsBlockDevice.class}, tree="[0,1]")
    private Output<List<InstanceEbsBlockDevice>> ebsBlockDevices;

    /**
     * @return One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    public Output<List<InstanceEbsBlockDevice>> ebsBlockDevices() {
        return this.ebsBlockDevices;
    }
    /**
     * If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     * 
     */
    @Export(name="ebsOptimized", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> ebsOptimized;

    /**
     * @return If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     * 
     */
    public Output<Boolean> ebsOptimized() {
        return this.ebsOptimized;
    }
    /**
     * Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    @Export(name="enclaveOptions", refs={InstanceEnclaveOptions.class}, tree="[0]")
    private Output<InstanceEnclaveOptions> enclaveOptions;

    /**
     * @return Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     * 
     */
    public Output<InstanceEnclaveOptions> enclaveOptions() {
        return this.enclaveOptions;
    }
    /**
     * One or more configuration blocks to customize Ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    @Export(name="ephemeralBlockDevices", refs={List.class,InstanceEphemeralBlockDevice.class}, tree="[0,1]")
    private Output<List<InstanceEphemeralBlockDevice>> ephemeralBlockDevices;

    /**
     * @return One or more configuration blocks to customize Ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     * 
     */
    public Output<List<InstanceEphemeralBlockDevice>> ephemeralBlockDevices() {
        return this.ephemeralBlockDevices;
    }
    /**
     * If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    @Export(name="getPasswordData", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> getPasswordData;

    /**
     * @return If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    public Output<Optional<Boolean>> getPasswordData() {
        return Codegen.optional(this.getPasswordData);
    }
    /**
     * If true, the launched EC2 instance will support hibernation.
     * 
     */
    @Export(name="hibernation", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> hibernation;

    /**
     * @return If true, the launched EC2 instance will support hibernation.
     * 
     */
    public Output<Optional<Boolean>> hibernation() {
        return Codegen.optional(this.hibernation);
    }
    /**
     * ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     * 
     */
    @Export(name="hostId", refs={String.class}, tree="[0]")
    private Output<String> hostId;

    /**
     * @return ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     * 
     */
    public Output<String> hostId() {
        return this.hostId;
    }
    /**
     * ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     * 
     */
    @Export(name="hostResourceGroupArn", refs={String.class}, tree="[0]")
    private Output<String> hostResourceGroupArn;

    /**
     * @return ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     * 
     */
    public Output<String> hostResourceGroupArn() {
        return this.hostResourceGroupArn;
    }
    /**
     * IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     * 
     */
    @Export(name="iamInstanceProfile", refs={String.class}, tree="[0]")
    private Output<String> iamInstanceProfile;

    /**
     * @return IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     * 
     */
    public Output<String> iamInstanceProfile() {
        return this.iamInstanceProfile;
    }
    /**
     * Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     * 
     */
    @Export(name="instanceInitiatedShutdownBehavior", refs={String.class}, tree="[0]")
    private Output<String> instanceInitiatedShutdownBehavior;

    /**
     * @return Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     * 
     */
    public Output<String> instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }
    /**
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     * 
     */
    @Export(name="instanceLifecycle", refs={String.class}, tree="[0]")
    private Output<String> instanceLifecycle;

    /**
     * @return Indicates whether this is a Spot Instance or a Scheduled Instance.
     * 
     */
    public Output<String> instanceLifecycle() {
        return this.instanceLifecycle;
    }
    /**
     * Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
     * 
     */
    @Export(name="instanceMarketOptions", refs={InstanceInstanceMarketOptions.class}, tree="[0]")
    private Output<InstanceInstanceMarketOptions> instanceMarketOptions;

    /**
     * @return Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
     * 
     */
    public Output<InstanceInstanceMarketOptions> instanceMarketOptions() {
        return this.instanceMarketOptions;
    }
    /**
     * State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
     * 
     */
    @Export(name="instanceState", refs={String.class}, tree="[0]")
    private Output<String> instanceState;

    /**
     * @return State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
     * 
     */
    public Output<String> instanceState() {
        return this.instanceState;
    }
    /**
     * Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     * 
     */
    @Export(name="instanceType", refs={String.class}, tree="[0]")
    private Output<String> instanceType;

    /**
     * @return Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     * 
     */
    public Output<String> instanceType() {
        return this.instanceType;
    }
    /**
     * Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     * 
     */
    @Export(name="ipv6AddressCount", refs={Integer.class}, tree="[0]")
    private Output<Integer> ipv6AddressCount;

    /**
     * @return Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     * 
     */
    public Output<Integer> ipv6AddressCount() {
        return this.ipv6AddressCount;
    }
    /**
     * Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     * 
     */
    @Export(name="ipv6Addresses", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> ipv6Addresses;

    /**
     * @return Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     * 
     */
    public Output<List<String>> ipv6Addresses() {
        return this.ipv6Addresses;
    }
    /**
     * Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     * 
     */
    @Export(name="keyName", refs={String.class}, tree="[0]")
    private Output<String> keyName;

    /**
     * @return Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     * 
     */
    public Output<String> keyName() {
        return this.keyName;
    }
    /**
     * Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     * 
     */
    @Export(name="launchTemplate", refs={InstanceLaunchTemplate.class}, tree="[0]")
    private Output</* @Nullable */ InstanceLaunchTemplate> launchTemplate;

    /**
     * @return Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     * 
     */
    public Output<Optional<InstanceLaunchTemplate>> launchTemplate() {
        return Codegen.optional(this.launchTemplate);
    }
    /**
     * Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     * 
     */
    @Export(name="maintenanceOptions", refs={InstanceMaintenanceOptions.class}, tree="[0]")
    private Output<InstanceMaintenanceOptions> maintenanceOptions;

    /**
     * @return Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     * 
     */
    public Output<InstanceMaintenanceOptions> maintenanceOptions() {
        return this.maintenanceOptions;
    }
    /**
     * Customize the metadata options of the instance. See Metadata Options below for more details.
     * 
     */
    @Export(name="metadataOptions", refs={InstanceMetadataOptions.class}, tree="[0]")
    private Output<InstanceMetadataOptions> metadataOptions;

    /**
     * @return Customize the metadata options of the instance. See Metadata Options below for more details.
     * 
     */
    public Output<InstanceMetadataOptions> metadataOptions() {
        return this.metadataOptions;
    }
    /**
     * If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     * 
     */
    @Export(name="monitoring", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> monitoring;

    /**
     * @return If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     * 
     */
    public Output<Boolean> monitoring() {
        return this.monitoring;
    }
    /**
     * Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     * 
     */
    @Export(name="networkInterfaces", refs={List.class,InstanceNetworkInterface.class}, tree="[0,1]")
    private Output<List<InstanceNetworkInterface>> networkInterfaces;

    /**
     * @return Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     * 
     */
    public Output<List<InstanceNetworkInterface>> networkInterfaces() {
        return this.networkInterfaces;
    }
    /**
     * ARN of the Outpost the instance is assigned to.
     * 
     */
    @Export(name="outpostArn", refs={String.class}, tree="[0]")
    private Output<String> outpostArn;

    /**
     * @return ARN of the Outpost the instance is assigned to.
     * 
     */
    public Output<String> outpostArn() {
        return this.outpostArn;
    }
    /**
     * Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    @Export(name="passwordData", refs={String.class}, tree="[0]")
    private Output<String> passwordData;

    /**
     * @return Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * 
     */
    public Output<String> passwordData() {
        return this.passwordData;
    }
    /**
     * Placement Group to start the instance in.
     * 
     */
    @Export(name="placementGroup", refs={String.class}, tree="[0]")
    private Output<String> placementGroup;

    /**
     * @return Placement Group to start the instance in.
     * 
     */
    public Output<String> placementGroup() {
        return this.placementGroup;
    }
    /**
     * Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource&#39;s `strategy` argument is set to `&#34;partition&#34;`.
     * 
     */
    @Export(name="placementPartitionNumber", refs={Integer.class}, tree="[0]")
    private Output<Integer> placementPartitionNumber;

    /**
     * @return Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource&#39;s `strategy` argument is set to `&#34;partition&#34;`.
     * 
     */
    public Output<Integer> placementPartitionNumber() {
        return this.placementPartitionNumber;
    }
    /**
     * ID of the instance&#39;s primary network interface.
     * 
     */
    @Export(name="primaryNetworkInterfaceId", refs={String.class}, tree="[0]")
    private Output<String> primaryNetworkInterfaceId;

    /**
     * @return ID of the instance&#39;s primary network interface.
     * 
     */
    public Output<String> primaryNetworkInterfaceId() {
        return this.primaryNetworkInterfaceId;
    }
    /**
     * Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames for your VPC.
     * 
     */
    @Export(name="privateDns", refs={String.class}, tree="[0]")
    private Output<String> privateDns;

    /**
     * @return Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you&#39;ve enabled DNS hostnames for your VPC.
     * 
     */
    public Output<String> privateDns() {
        return this.privateDns;
    }
    /**
     * Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    @Export(name="privateDnsNameOptions", refs={InstancePrivateDnsNameOptions.class}, tree="[0]")
    private Output<InstancePrivateDnsNameOptions> privateDnsNameOptions;

    /**
     * @return Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     * 
     */
    public Output<InstancePrivateDnsNameOptions> privateDnsNameOptions() {
        return this.privateDnsNameOptions;
    }
    /**
     * Private IP address to associate with the instance in a VPC.
     * 
     */
    @Export(name="privateIp", refs={String.class}, tree="[0]")
    private Output<String> privateIp;

    /**
     * @return Private IP address to associate with the instance in a VPC.
     * 
     */
    public Output<String> privateIp() {
        return this.privateIp;
    }
    /**
     * Public DNS name assigned to the instance. For EC2-VPC, this is only available if you&#39;ve enabled DNS hostnames for your VPC.
     * 
     */
    @Export(name="publicDns", refs={String.class}, tree="[0]")
    private Output<String> publicDns;

    /**
     * @return Public DNS name assigned to the instance. For EC2-VPC, this is only available if you&#39;ve enabled DNS hostnames for your VPC.
     * 
     */
    public Output<String> publicDns() {
        return this.publicDns;
    }
    /**
     * Public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `aws.ec2.Eip` with your instance, you should refer to the EIP&#39;s address directly and not use `public_ip` as this field will change after the EIP is attached.
     * 
     */
    @Export(name="publicIp", refs={String.class}, tree="[0]")
    private Output<String> publicIp;

    /**
     * @return Public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `aws.ec2.Eip` with your instance, you should refer to the EIP&#39;s address directly and not use `public_ip` as this field will change after the EIP is attached.
     * 
     */
    public Output<String> publicIp() {
        return this.publicIp;
    }
    /**
     * Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     * 
     */
    @Export(name="rootBlockDevice", refs={InstanceRootBlockDevice.class}, tree="[0]")
    private Output<InstanceRootBlockDevice> rootBlockDevice;

    /**
     * @return Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     * 
     */
    public Output<InstanceRootBlockDevice> rootBlockDevice() {
        return this.rootBlockDevice;
    }
    /**
     * List of secondary private IPv4 addresses to assign to the instance&#39;s primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     * 
     */
    @Export(name="secondaryPrivateIps", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> secondaryPrivateIps;

    /**
     * @return List of secondary private IPv4 addresses to assign to the instance&#39;s primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     * 
     */
    public Output<List<String>> secondaryPrivateIps() {
        return this.secondaryPrivateIps;
    }
    /**
     * List of security group names to associate with.
     * 
     * &gt; **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     * 
     * @deprecated
     * Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates.
     * 
     */
    @Deprecated /* Use of `securityGroups` is discouraged as it does not allow for changes and will force your instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which allows for updates. */
    @Export(name="securityGroups", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> securityGroups;

    /**
     * @return List of security group names to associate with.
     * 
     * &gt; **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     * 
     */
    public Output<List<String>> securityGroups() {
        return this.securityGroups;
    }
    /**
     * Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     * 
     */
    @Export(name="sourceDestCheck", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> sourceDestCheck;

    /**
     * @return Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     * 
     */
    public Output<Optional<Boolean>> sourceDestCheck() {
        return Codegen.optional(this.sourceDestCheck);
    }
    /**
     * If the request is a Spot Instance request, the ID of the request.
     * 
     */
    @Export(name="spotInstanceRequestId", refs={String.class}, tree="[0]")
    private Output<String> spotInstanceRequestId;

    /**
     * @return If the request is a Spot Instance request, the ID of the request.
     * 
     */
    public Output<String> spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }
    /**
     * VPC Subnet ID to launch in.
     * 
     */
    @Export(name="subnetId", refs={String.class}, tree="[0]")
    private Output<String> subnetId;

    /**
     * @return VPC Subnet ID to launch in.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }
    /**
     * Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     * 
     */
    @Export(name="tenancy", refs={String.class}, tree="[0]")
    private Output<String> tenancy;

    /**
     * @return Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     * 
     */
    public Output<String> tenancy() {
        return this.tenancy;
    }
    /**
     * User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    @Export(name="userData", refs={String.class}, tree="[0]")
    private Output<String> userData;

    /**
     * @return User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    public Output<String> userData() {
        return this.userData;
    }
    /**
     * Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    @Export(name="userDataBase64", refs={String.class}, tree="[0]")
    private Output<String> userDataBase64;

    /**
     * @return Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     * 
     */
    public Output<String> userDataBase64() {
        return this.userDataBase64;
    }
    /**
     * When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     * 
     */
    @Export(name="userDataReplaceOnChange", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> userDataReplaceOnChange;

    /**
     * @return When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     * 
     */
    public Output<Optional<Boolean>> userDataReplaceOnChange() {
        return Codegen.optional(this.userDataReplaceOnChange);
    }
    /**
     * Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * 
     * &gt; **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     * 
     */
    @Export(name="volumeTags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> volumeTags;

    /**
     * @return Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * 
     * &gt; **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     * 
     */
    public Output<Optional<Map<String,String>>> volumeTags() {
        return Codegen.optional(this.volumeTags);
    }
    /**
     * List of security group IDs to associate with.
     * 
     */
    @Export(name="vpcSecurityGroupIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return List of security group IDs to associate with.
     * 
     */
    public Output<List<String>> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Instance(String name) {
        this(name, InstanceArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Instance(String name, @Nullable InstanceArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Instance(String name, @Nullable InstanceArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/instance:Instance", name, args == null ? InstanceArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Instance(String name, Output<String> id, @Nullable InstanceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/instance:Instance", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Instance get(String name, Output<String> id, @Nullable InstanceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Instance(name, id, state, options);
    }
}
