// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.DefaultVpcDhcpOptionsArgs;
import com.pulumi.aws.ec2.inputs.DefaultVpcDhcpOptionsState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage the [default AWS DHCP Options Set](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html#AmazonDNS)
 * in the current region.
 * 
 * Each AWS region comes with a default set of DHCP options.
 * **This is an advanced resource**, and has special caveats to be aware of when
 * using it. Please read this document in its entirety before using this resource.
 * 
 * The `aws.ec2.DefaultVpcDhcpOptions` behaves differently from normal resources, in that
 * this provider does not _create_ this resource, but instead &#34;adopts&#34; it
 * into management.
 * 
 * ## Example Usage
 * 
 * Basic usage with tags:
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultVpcDhcpOptions;
 * import com.pulumi.aws.ec2.DefaultVpcDhcpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var default_ = new DefaultVpcDhcpOptions(&#34;default&#34;, DefaultVpcDhcpOptionsArgs.builder()        
 *             .tags(Map.of(&#34;Name&#34;, &#34;Default DHCP Option Set&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import VPC DHCP Options using the DHCP Options `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/defaultVpcDhcpOptions:DefaultVpcDhcpOptions default_options dopt-d9070ebb
 * ```
 * 
 */
@ResourceType(type="aws:ec2/defaultVpcDhcpOptions:DefaultVpcDhcpOptions")
public class DefaultVpcDhcpOptions extends com.pulumi.resources.CustomResource {
    /**
     * The ARN of the DHCP Options Set.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the DHCP Options Set.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    @Export(name="domainName", refs={String.class}, tree="[0]")
    private Output<String> domainName;

    public Output<String> domainName() {
        return this.domainName;
    }
    @Export(name="domainNameServers", refs={String.class}, tree="[0]")
    private Output<String> domainNameServers;

    public Output<String> domainNameServers() {
        return this.domainNameServers;
    }
    /**
     * List of NETBIOS name servers.
     * 
     */
    @Export(name="netbiosNameServers", refs={String.class}, tree="[0]")
    private Output<String> netbiosNameServers;

    /**
     * @return List of NETBIOS name servers.
     * 
     */
    public Output<String> netbiosNameServers() {
        return this.netbiosNameServers;
    }
    /**
     * The NetBIOS node type (1, 2, 4, or 8). AWS recommends to specify 2 since broadcast and multicast are not supported in their network. For more information about these node types, see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
     * 
     */
    @Export(name="netbiosNodeType", refs={String.class}, tree="[0]")
    private Output<String> netbiosNodeType;

    /**
     * @return The NetBIOS node type (1, 2, 4, or 8). AWS recommends to specify 2 since broadcast and multicast are not supported in their network. For more information about these node types, see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
     * 
     */
    public Output<String> netbiosNodeType() {
        return this.netbiosNodeType;
    }
    @Export(name="ntpServers", refs={String.class}, tree="[0]")
    private Output<String> ntpServers;

    public Output<String> ntpServers() {
        return this.ntpServers;
    }
    /**
     * The ID of the AWS account that owns the DHCP options set.
     * 
     */
    @Export(name="ownerId", refs={String.class}, tree="[0]")
    private Output<String> ownerId;

    /**
     * @return The ID of the AWS account that owns the DHCP options set.
     * 
     */
    public Output<String> ownerId() {
        return this.ownerId;
    }
    /**
     * A map of tags to assign to the resource.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DefaultVpcDhcpOptions(String name) {
        this(name, DefaultVpcDhcpOptionsArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DefaultVpcDhcpOptions(String name, @Nullable DefaultVpcDhcpOptionsArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DefaultVpcDhcpOptions(String name, @Nullable DefaultVpcDhcpOptionsArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/defaultVpcDhcpOptions:DefaultVpcDhcpOptions", name, args == null ? DefaultVpcDhcpOptionsArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DefaultVpcDhcpOptions(String name, Output<String> id, @Nullable DefaultVpcDhcpOptionsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/defaultVpcDhcpOptions:DefaultVpcDhcpOptions", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DefaultVpcDhcpOptions get(String name, Output<String> id, @Nullable DefaultVpcDhcpOptionsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DefaultVpcDhcpOptions(name, id, state, options);
    }
}
