// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.DefaultVpcArgs;
import com.pulumi.aws.ec2.inputs.DefaultVpcState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage the [default AWS VPC](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html)
 * in the current AWS Region.
 * 
 * If you created your AWS account after 2013-12-04 you have a default VPC in each AWS Region.
 * 
 * **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.
 * 
 * The `aws.ec2.DefaultVpc` resource behaves differently from normal resources in that if a default VPC exists, this provider does not _create_ this resource, but instead &#34;adopts&#34; it into management.
 * If no default VPC exists, the provider creates a new default VPC, which leads to the implicit creation of [other resources](https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#default-vpc-components).
 * By default, `pulumi destroy` does not delete the default VPC but does remove the resource from the state.
 * Set the `force_destroy` argument to `true` to delete the default VPC.
 * 
 * ## Example Usage
 * 
 * Basic usage with tags:
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultVpc;
 * import com.pulumi.aws.ec2.DefaultVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var default_ = new DefaultVpc(&#34;default&#34;, DefaultVpcArgs.builder()        
 *             .tags(Map.of(&#34;Name&#34;, &#34;Default VPC&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Default VPCs using the VPC `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/defaultVpc:DefaultVpc default vpc-a01106c2
 * ```
 * 
 */
@ResourceType(type="aws:ec2/defaultVpc:DefaultVpc")
public class DefaultVpc extends com.pulumi.resources.CustomResource {
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    public Output<String> arn() {
        return this.arn;
    }
    @Export(name="assignGeneratedIpv6CidrBlock", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> assignGeneratedIpv6CidrBlock;

    public Output<Optional<Boolean>> assignGeneratedIpv6CidrBlock() {
        return Codegen.optional(this.assignGeneratedIpv6CidrBlock);
    }
    /**
     * The primary IPv4 CIDR block for the VPC
     * 
     */
    @Export(name="cidrBlock", refs={String.class}, tree="[0]")
    private Output<String> cidrBlock;

    /**
     * @return The primary IPv4 CIDR block for the VPC
     * 
     */
    public Output<String> cidrBlock() {
        return this.cidrBlock;
    }
    @Export(name="defaultNetworkAclId", refs={String.class}, tree="[0]")
    private Output<String> defaultNetworkAclId;

    public Output<String> defaultNetworkAclId() {
        return this.defaultNetworkAclId;
    }
    @Export(name="defaultRouteTableId", refs={String.class}, tree="[0]")
    private Output<String> defaultRouteTableId;

    public Output<String> defaultRouteTableId() {
        return this.defaultRouteTableId;
    }
    @Export(name="defaultSecurityGroupId", refs={String.class}, tree="[0]")
    private Output<String> defaultSecurityGroupId;

    public Output<String> defaultSecurityGroupId() {
        return this.defaultSecurityGroupId;
    }
    @Export(name="dhcpOptionsId", refs={String.class}, tree="[0]")
    private Output<String> dhcpOptionsId;

    public Output<String> dhcpOptionsId() {
        return this.dhcpOptionsId;
    }
    @Export(name="enableDnsHostnames", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enableDnsHostnames;

    public Output<Optional<Boolean>> enableDnsHostnames() {
        return Codegen.optional(this.enableDnsHostnames);
    }
    @Export(name="enableDnsSupport", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enableDnsSupport;

    public Output<Optional<Boolean>> enableDnsSupport() {
        return Codegen.optional(this.enableDnsSupport);
    }
    @Export(name="enableNetworkAddressUsageMetrics", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> enableNetworkAddressUsageMetrics;

    public Output<Boolean> enableNetworkAddressUsageMetrics() {
        return this.enableNetworkAddressUsageMetrics;
    }
    @Export(name="existingDefaultVpc", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> existingDefaultVpc;

    public Output<Boolean> existingDefaultVpc() {
        return this.existingDefaultVpc;
    }
    /**
     * Whether destroying the resource deletes the default VPC. Default: `false`
     * 
     */
    @Export(name="forceDestroy", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> forceDestroy;

    /**
     * @return Whether destroying the resource deletes the default VPC. Default: `false`
     * 
     */
    public Output<Optional<Boolean>> forceDestroy() {
        return Codegen.optional(this.forceDestroy);
    }
    /**
     * The allowed tenancy of instances launched into the VPC
     * 
     */
    @Export(name="instanceTenancy", refs={String.class}, tree="[0]")
    private Output<String> instanceTenancy;

    /**
     * @return The allowed tenancy of instances launched into the VPC
     * 
     */
    public Output<String> instanceTenancy() {
        return this.instanceTenancy;
    }
    @Export(name="ipv6AssociationId", refs={String.class}, tree="[0]")
    private Output<String> ipv6AssociationId;

    public Output<String> ipv6AssociationId() {
        return this.ipv6AssociationId;
    }
    @Export(name="ipv6CidrBlock", refs={String.class}, tree="[0]")
    private Output<String> ipv6CidrBlock;

    public Output<String> ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }
    @Export(name="ipv6CidrBlockNetworkBorderGroup", refs={String.class}, tree="[0]")
    private Output<String> ipv6CidrBlockNetworkBorderGroup;

    public Output<String> ipv6CidrBlockNetworkBorderGroup() {
        return this.ipv6CidrBlockNetworkBorderGroup;
    }
    @Export(name="ipv6IpamPoolId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> ipv6IpamPoolId;

    public Output<Optional<String>> ipv6IpamPoolId() {
        return Codegen.optional(this.ipv6IpamPoolId);
    }
    @Export(name="ipv6NetmaskLength", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> ipv6NetmaskLength;

    public Output<Optional<Integer>> ipv6NetmaskLength() {
        return Codegen.optional(this.ipv6NetmaskLength);
    }
    @Export(name="mainRouteTableId", refs={String.class}, tree="[0]")
    private Output<String> mainRouteTableId;

    public Output<String> mainRouteTableId() {
        return this.mainRouteTableId;
    }
    @Export(name="ownerId", refs={String.class}, tree="[0]")
    private Output<String> ownerId;

    public Output<String> ownerId() {
        return this.ownerId;
    }
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DefaultVpc(String name) {
        this(name, DefaultVpcArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DefaultVpc(String name, @Nullable DefaultVpcArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DefaultVpc(String name, @Nullable DefaultVpcArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/defaultVpc:DefaultVpc", name, args == null ? DefaultVpcArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DefaultVpc(String name, Output<String> id, @Nullable DefaultVpcState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/defaultVpc:DefaultVpc", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DefaultVpc get(String name, Output<String> id, @Nullable DefaultVpcState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DefaultVpc(name, id, state, options);
    }
}
