// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.DefaultSubnetArgs;
import com.pulumi.aws.ec2.inputs.DefaultSubnetState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage a [default subnet](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html#default-vpc-basics) in the current region.
 * 
 * **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.
 * 
 * The `aws.ec2.DefaultSubnet` resource behaves differently from normal resources in that if a default subnet exists in the specified Availability Zone, this provider does not _create_ this resource, but instead &#34;adopts&#34; it into management.
 * If no default subnet exists, this provider creates a new default subnet.
 * By default, `pulumi destroy` does not delete the default subnet but does remove the resource from the state.
 * Set the `force_destroy` argument to `true` to delete the default subnet.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultSubnet;
 * import com.pulumi.aws.ec2.DefaultSubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var defaultAz1 = new DefaultSubnet(&#34;defaultAz1&#34;, DefaultSubnetArgs.builder()        
 *             .availabilityZone(&#34;us-west-2a&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;Default subnet for us-west-2a&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import subnets using the subnet `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/defaultSubnet:DefaultSubnet public_subnet subnet-9d4a7b6c
 * ```
 * 
 */
@ResourceType(type="aws:ec2/defaultSubnet:DefaultSubnet")
public class DefaultSubnet extends com.pulumi.resources.CustomResource {
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    public Output<String> arn() {
        return this.arn;
    }
    @Export(name="assignIpv6AddressOnCreation", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> assignIpv6AddressOnCreation;

    public Output<Optional<Boolean>> assignIpv6AddressOnCreation() {
        return Codegen.optional(this.assignIpv6AddressOnCreation);
    }
    /**
     * is required
     * * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
     * * The default value for `map_public_ip_on_launch` is `true`
     * 
     * This resource supports the following additional arguments:
     * 
     */
    @Export(name="availabilityZone", refs={String.class}, tree="[0]")
    private Output<String> availabilityZone;

    /**
     * @return is required
     * * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
     * * The default value for `map_public_ip_on_launch` is `true`
     * 
     * This resource supports the following additional arguments:
     * 
     */
    public Output<String> availabilityZone() {
        return this.availabilityZone;
    }
    /**
     * The AZ ID of the subnet
     * 
     */
    @Export(name="availabilityZoneId", refs={String.class}, tree="[0]")
    private Output<String> availabilityZoneId;

    /**
     * @return The AZ ID of the subnet
     * 
     */
    public Output<String> availabilityZoneId() {
        return this.availabilityZoneId;
    }
    /**
     * The IPv4 CIDR block assigned to the subnet
     * 
     */
    @Export(name="cidrBlock", refs={String.class}, tree="[0]")
    private Output<String> cidrBlock;

    /**
     * @return The IPv4 CIDR block assigned to the subnet
     * 
     */
    public Output<String> cidrBlock() {
        return this.cidrBlock;
    }
    @Export(name="customerOwnedIpv4Pool", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> customerOwnedIpv4Pool;

    public Output<Optional<String>> customerOwnedIpv4Pool() {
        return Codegen.optional(this.customerOwnedIpv4Pool);
    }
    @Export(name="enableDns64", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enableDns64;

    public Output<Optional<Boolean>> enableDns64() {
        return Codegen.optional(this.enableDns64);
    }
    @Export(name="enableLniAtDeviceIndex", refs={Integer.class}, tree="[0]")
    private Output<Integer> enableLniAtDeviceIndex;

    public Output<Integer> enableLniAtDeviceIndex() {
        return this.enableLniAtDeviceIndex;
    }
    @Export(name="enableResourceNameDnsARecordOnLaunch", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enableResourceNameDnsARecordOnLaunch;

    public Output<Optional<Boolean>> enableResourceNameDnsARecordOnLaunch() {
        return Codegen.optional(this.enableResourceNameDnsARecordOnLaunch);
    }
    @Export(name="enableResourceNameDnsAaaaRecordOnLaunch", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enableResourceNameDnsAaaaRecordOnLaunch;

    public Output<Optional<Boolean>> enableResourceNameDnsAaaaRecordOnLaunch() {
        return Codegen.optional(this.enableResourceNameDnsAaaaRecordOnLaunch);
    }
    @Export(name="existingDefaultSubnet", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> existingDefaultSubnet;

    public Output<Boolean> existingDefaultSubnet() {
        return this.existingDefaultSubnet;
    }
    /**
     * Whether destroying the resource deletes the default subnet. Default: `false`
     * 
     */
    @Export(name="forceDestroy", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> forceDestroy;

    /**
     * @return Whether destroying the resource deletes the default subnet. Default: `false`
     * 
     */
    public Output<Optional<Boolean>> forceDestroy() {
        return Codegen.optional(this.forceDestroy);
    }
    @Export(name="ipv6CidrBlock", refs={String.class}, tree="[0]")
    private Output<String> ipv6CidrBlock;

    public Output<String> ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }
    @Export(name="ipv6CidrBlockAssociationId", refs={String.class}, tree="[0]")
    private Output<String> ipv6CidrBlockAssociationId;

    public Output<String> ipv6CidrBlockAssociationId() {
        return this.ipv6CidrBlockAssociationId;
    }
    @Export(name="ipv6Native", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> ipv6Native;

    public Output<Optional<Boolean>> ipv6Native() {
        return Codegen.optional(this.ipv6Native);
    }
    @Export(name="mapCustomerOwnedIpOnLaunch", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> mapCustomerOwnedIpOnLaunch;

    public Output<Optional<Boolean>> mapCustomerOwnedIpOnLaunch() {
        return Codegen.optional(this.mapCustomerOwnedIpOnLaunch);
    }
    @Export(name="mapPublicIpOnLaunch", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> mapPublicIpOnLaunch;

    public Output<Optional<Boolean>> mapPublicIpOnLaunch() {
        return Codegen.optional(this.mapPublicIpOnLaunch);
    }
    @Export(name="outpostArn", refs={String.class}, tree="[0]")
    private Output<String> outpostArn;

    public Output<String> outpostArn() {
        return this.outpostArn;
    }
    @Export(name="ownerId", refs={String.class}, tree="[0]")
    private Output<String> ownerId;

    public Output<String> ownerId() {
        return this.ownerId;
    }
    @Export(name="privateDnsHostnameTypeOnLaunch", refs={String.class}, tree="[0]")
    private Output<String> privateDnsHostnameTypeOnLaunch;

    public Output<String> privateDnsHostnameTypeOnLaunch() {
        return this.privateDnsHostnameTypeOnLaunch;
    }
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The ID of the VPC the subnet is in
     * 
     */
    @Export(name="vpcId", refs={String.class}, tree="[0]")
    private Output<String> vpcId;

    /**
     * @return The ID of the VPC the subnet is in
     * 
     */
    public Output<String> vpcId() {
        return this.vpcId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DefaultSubnet(String name) {
        this(name, DefaultSubnetArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DefaultSubnet(String name, DefaultSubnetArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DefaultSubnet(String name, DefaultSubnetArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/defaultSubnet:DefaultSubnet", name, args == null ? DefaultSubnetArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DefaultSubnet(String name, Output<String> id, @Nullable DefaultSubnetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/defaultSubnet:DefaultSubnet", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DefaultSubnet get(String name, Output<String> id, @Nullable DefaultSubnetState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DefaultSubnet(name, id, state, options);
    }
}
