// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.DefaultNetworkAclArgs;
import com.pulumi.aws.ec2.inputs.DefaultNetworkAclState;
import com.pulumi.aws.ec2.outputs.DefaultNetworkAclEgress;
import com.pulumi.aws.ec2.outputs.DefaultNetworkAclIngress;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage a VPC&#39;s default network ACL. This resource can manage the default network ACL of the default or a non-default VPC.
 * 
 * &gt; **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `aws.ec2.DefaultNetworkAcl` behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to &#34;adopt&#34; it into management.
 * 
 * Every VPC has a default network ACL that can be managed but not destroyed. When the provider first adopts the Default Network ACL, it **immediately removes all rules in the ACL**. It then proceeds to create any rules specified in the configuration. This step is required so that only the rules specified in the configuration are created.
 * 
 * This resource treats its inline rules as absolute; only the rules defined inline are created, and any additions/removals external to this resource will result in diffs being shown. For these reasons, this resource is incompatible with the `aws.ec2.NetworkAclRule` resource.
 * 
 * For more information about Network ACLs, see the AWS Documentation on [Network ACLs][aws-network-acls].
 * 
 * ## Example Usage
 * ### Example: Deny All Traffic To Any Subnet In The Default Network ACL
 * 
 * This config denies all traffic in the Default ACL. This can be useful if you want to lock down the VPC to force all resources to assign a non-default ACL.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.DefaultNetworkAcl;
 * import com.pulumi.aws.ec2.DefaultNetworkAclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var mainvpc = new Vpc(&#34;mainvpc&#34;, VpcArgs.builder()        
 *             .cidrBlock(&#34;10.1.0.0/16&#34;)
 *             .build());
 * 
 *         var default_ = new DefaultNetworkAcl(&#34;default&#34;, DefaultNetworkAclArgs.builder()        
 *             .defaultNetworkAclId(mainvpc.defaultNetworkAclId())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Managing Subnets In A Default Network ACL
 * 
 * Within a VPC, all Subnets must be associated with a Network ACL. In order to &#34;delete&#34; the association between a Subnet and a non-default Network ACL, the association is destroyed by replacing it with an association between the Subnet and the Default ACL instead.
 * 
 * When managing the Default Network ACL, you cannot &#34;remove&#34; Subnets. Instead, they must be reassigned to another Network ACL, or the Subnet itself must be destroyed. Because of these requirements, removing the `subnet_ids` attribute from the configuration of a `aws.ec2.DefaultNetworkAcl` resource may result in a reoccurring plan, until the Subnets are reassigned to another Network ACL or are destroyed.
 * 
 * Because Subnets are by default associated with the Default Network ACL, any non-explicit association will show up as a plan to remove the Subnet. For example: if you have a custom `aws.ec2.NetworkAcl` with two subnets attached, and you remove the `aws.ec2.NetworkAcl` resource, after successfully destroying this resource future plans will show a diff on the managed `aws.ec2.DefaultNetworkAcl`, as those two Subnets have been orphaned by the now destroyed network acl and thus adopted by the Default Network ACL. In order to avoid a reoccurring plan, they will need to be reassigned, destroyed, or added to the `subnet_ids` attribute of the `aws.ec2.DefaultNetworkAcl` entry.
 * 
 * As an alternative to the above, you can also specify the following lifecycle configuration in your `aws.ec2.DefaultNetworkAcl` resource:
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultNetworkAcl;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var default_ = new DefaultNetworkAcl(&#34;default&#34;);
 * 
 *     }
 * }
 * ```
 * ### Removing `aws.ec2.DefaultNetworkAcl` From Your Configuration
 * 
 * Each AWS VPC comes with a Default Network ACL that cannot be deleted. The `aws.ec2.DefaultNetworkAcl` allows you to manage this Network ACL, but the provider cannot destroy it. Removing this resource from your configuration will remove it from your statefile and management, **but will not destroy the Network ACL.** All Subnets associations and ingress or egress rules will be left as they are at the time of removal. You can resume managing them via the AWS Console.
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Default Network ACLs using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/defaultNetworkAcl:DefaultNetworkAcl sample acl-7aaabd18
 * ```
 * 
 */
@ResourceType(type="aws:ec2/defaultNetworkAcl:DefaultNetworkAcl")
public class DefaultNetworkAcl extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Default Network ACL
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Default Network ACL
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Network ACL ID to manage. This attribute is exported from `aws.ec2.Vpc`, or manually found via the AWS Console.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="defaultNetworkAclId", refs={String.class}, tree="[0]")
    private Output<String> defaultNetworkAclId;

    /**
     * @return Network ACL ID to manage. This attribute is exported from `aws.ec2.Vpc`, or manually found via the AWS Console.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> defaultNetworkAclId() {
        return this.defaultNetworkAclId;
    }
    /**
     * Configuration block for an egress rule. Detailed below.
     * 
     */
    @Export(name="egress", refs={List.class,DefaultNetworkAclEgress.class}, tree="[0,1]")
    private Output</* @Nullable */ List<DefaultNetworkAclEgress>> egress;

    /**
     * @return Configuration block for an egress rule. Detailed below.
     * 
     */
    public Output<Optional<List<DefaultNetworkAclEgress>>> egress() {
        return Codegen.optional(this.egress);
    }
    /**
     * Configuration block for an ingress rule. Detailed below.
     * 
     */
    @Export(name="ingress", refs={List.class,DefaultNetworkAclIngress.class}, tree="[0,1]")
    private Output</* @Nullable */ List<DefaultNetworkAclIngress>> ingress;

    /**
     * @return Configuration block for an ingress rule. Detailed below.
     * 
     */
    public Output<Optional<List<DefaultNetworkAclIngress>>> ingress() {
        return Codegen.optional(this.ingress);
    }
    /**
     * ID of the AWS account that owns the Default Network ACL
     * 
     */
    @Export(name="ownerId", refs={String.class}, tree="[0]")
    private Output<String> ownerId;

    /**
     * @return ID of the AWS account that owns the Default Network ACL
     * 
     */
    public Output<String> ownerId() {
        return this.ownerId;
    }
    /**
     * List of Subnet IDs to apply the ACL to. See the notes above on Managing Subnets in the Default Network ACL
     * 
     */
    @Export(name="subnetIds", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> subnetIds;

    /**
     * @return List of Subnet IDs to apply the ACL to. See the notes above on Managing Subnets in the Default Network ACL
     * 
     */
    public Output<Optional<List<String>>> subnetIds() {
        return Codegen.optional(this.subnetIds);
    }
    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * ID of the associated VPC
     * 
     */
    @Export(name="vpcId", refs={String.class}, tree="[0]")
    private Output<String> vpcId;

    /**
     * @return ID of the associated VPC
     * 
     */
    public Output<String> vpcId() {
        return this.vpcId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public DefaultNetworkAcl(String name) {
        this(name, DefaultNetworkAclArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public DefaultNetworkAcl(String name, DefaultNetworkAclArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public DefaultNetworkAcl(String name, DefaultNetworkAclArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/defaultNetworkAcl:DefaultNetworkAcl", name, args == null ? DefaultNetworkAclArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private DefaultNetworkAcl(String name, Output<String> id, @Nullable DefaultNetworkAclState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/defaultNetworkAcl:DefaultNetworkAcl", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static DefaultNetworkAcl get(String name, Output<String> id, @Nullable DefaultNetworkAclState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new DefaultNetworkAcl(name, id, state, options);
    }
}
