// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.AvailabilityZoneGroupArgs;
import com.pulumi.aws.ec2.inputs.AvailabilityZoneGroupState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages an EC2 Availability Zone Group, such as updating its opt-in status.
 * 
 * &gt; **NOTE:** This is an advanced resource. The provider will automatically assume management of the EC2 Availability Zone Group without import and perform no actions on removal from configuration.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AvailabilityZoneGroup;
 * import com.pulumi.aws.ec2.AvailabilityZoneGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new AvailabilityZoneGroup(&#34;example&#34;, AvailabilityZoneGroupArgs.builder()        
 *             .groupName(&#34;us-west-2-lax-1&#34;)
 *             .optInStatus(&#34;opted-in&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import EC2 Availability Zone Groups using the group name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/availabilityZoneGroup:AvailabilityZoneGroup example us-west-2-lax-1
 * ```
 * 
 */
@ResourceType(type="aws:ec2/availabilityZoneGroup:AvailabilityZoneGroup")
public class AvailabilityZoneGroup extends com.pulumi.resources.CustomResource {
    /**
     * Name of the Availability Zone Group.
     * 
     */
    @Export(name="groupName", refs={String.class}, tree="[0]")
    private Output<String> groupName;

    /**
     * @return Name of the Availability Zone Group.
     * 
     */
    public Output<String> groupName() {
        return this.groupName;
    }
    /**
     * Indicates whether to enable or disable Availability Zone Group. Valid values: `opted-in` or `not-opted-in`.
     * 
     */
    @Export(name="optInStatus", refs={String.class}, tree="[0]")
    private Output<String> optInStatus;

    /**
     * @return Indicates whether to enable or disable Availability Zone Group. Valid values: `opted-in` or `not-opted-in`.
     * 
     */
    public Output<String> optInStatus() {
        return this.optInStatus;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AvailabilityZoneGroup(String name) {
        this(name, AvailabilityZoneGroupArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AvailabilityZoneGroup(String name, AvailabilityZoneGroupArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AvailabilityZoneGroup(String name, AvailabilityZoneGroupArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/availabilityZoneGroup:AvailabilityZoneGroup", name, args == null ? AvailabilityZoneGroupArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AvailabilityZoneGroup(String name, Output<String> id, @Nullable AvailabilityZoneGroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/availabilityZoneGroup:AvailabilityZoneGroup", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AvailabilityZoneGroup get(String name, Output<String> id, @Nullable AvailabilityZoneGroupState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AvailabilityZoneGroup(name, id, state, options);
    }
}
