// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ec2;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
import com.pulumi.aws.ec2.inputs.AmiLaunchPermissionState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Adds a launch permission to an Amazon Machine Image (AMI).
 * 
 * ## Example Usage
 * ### AWS Account ID
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new AmiLaunchPermission(&#34;example&#34;, AmiLaunchPermissionArgs.builder()        
 *             .accountId(&#34;123456789012&#34;)
 *             .imageId(&#34;ami-12345678&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Public Access
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new AmiLaunchPermission(&#34;example&#34;, AmiLaunchPermissionArgs.builder()        
 *             .group(&#34;all&#34;)
 *             .imageId(&#34;ami-12345678&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Organization Access
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.OrganizationsFunctions;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var current = OrganizationsFunctions.getOrganization();
 * 
 *         var example = new AmiLaunchPermission(&#34;example&#34;, AmiLaunchPermissionArgs.builder()        
 *             .imageId(&#34;ami-12345678&#34;)
 *             .organizationArn(current.applyValue(getOrganizationResult -&gt; getOrganizationResult.arn()))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import AMI Launch Permissions using `[ACCOUNT-ID|GROUP-NAME|ORGANIZATION-ARN|ORGANIZATIONAL-UNIT-ARN]/IMAGE-ID`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ec2/amiLaunchPermission:AmiLaunchPermission example 123456789012/ami-12345678
 * ```
 * 
 */
@ResourceType(type="aws:ec2/amiLaunchPermission:AmiLaunchPermission")
public class AmiLaunchPermission extends com.pulumi.resources.CustomResource {
    /**
     * AWS account ID for the launch permission.
     * 
     */
    @Export(name="accountId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> accountId;

    /**
     * @return AWS account ID for the launch permission.
     * 
     */
    public Output<Optional<String>> accountId() {
        return Codegen.optional(this.accountId);
    }
    /**
     * Name of the group for the launch permission. Valid values: `&#34;all&#34;`.
     * 
     */
    @Export(name="group", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> group;

    /**
     * @return Name of the group for the launch permission. Valid values: `&#34;all&#34;`.
     * 
     */
    public Output<Optional<String>> group() {
        return Codegen.optional(this.group);
    }
    /**
     * ID of the AMI.
     * 
     */
    @Export(name="imageId", refs={String.class}, tree="[0]")
    private Output<String> imageId;

    /**
     * @return ID of the AMI.
     * 
     */
    public Output<String> imageId() {
        return this.imageId;
    }
    /**
     * ARN of an organization for the launch permission.
     * 
     */
    @Export(name="organizationArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> organizationArn;

    /**
     * @return ARN of an organization for the launch permission.
     * 
     */
    public Output<Optional<String>> organizationArn() {
        return Codegen.optional(this.organizationArn);
    }
    /**
     * ARN of an organizational unit for the launch permission.
     * 
     */
    @Export(name="organizationalUnitArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> organizationalUnitArn;

    /**
     * @return ARN of an organizational unit for the launch permission.
     * 
     */
    public Output<Optional<String>> organizationalUnitArn() {
        return Codegen.optional(this.organizationalUnitArn);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AmiLaunchPermission(String name) {
        this(name, AmiLaunchPermissionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AmiLaunchPermission(String name, AmiLaunchPermissionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AmiLaunchPermission(String name, AmiLaunchPermissionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/amiLaunchPermission:AmiLaunchPermission", name, args == null ? AmiLaunchPermissionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AmiLaunchPermission(String name, Output<String> id, @Nullable AmiLaunchPermissionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ec2/amiLaunchPermission:AmiLaunchPermission", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AmiLaunchPermission get(String name, Output<String> id, @Nullable AmiLaunchPermissionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AmiLaunchPermission(name, id, state, options);
    }
}
